"use strict";

/* jshint ignore:start */



/* jshint ignore:end */

define('cornerstone/adapters/cs-adapter-with-ids', ['exports', 'cornerstone/adapters/cs-adapter', 'npm:uuid'], function (exports, _cornerstoneAdaptersCsAdapter, _npmUuid) {
  exports['default'] = _cornerstoneAdaptersCsAdapter['default'].extend({

    generateIdForRecord: function generateIdForRecord() {
      return _npmUuid['default'].v4();
    }

  });
});
// import Ember from 'ember';
define('cornerstone/adapters/cs-adapter', ['exports', 'ember', 'ember-data/adapters/json-api'], function (exports, _ember, _emberDataAdaptersJsonApi) {
  // import { AdapterError, InvalidError } from 'ember-data/adapters/errors';

  exports['default'] = _emberDataAdaptersJsonApi['default'].extend({

    // http://emberjs.com/api/data/classes/DS.Adapter.html#method_findAll
    findAll: function findAll(store, type) {
      return this.get('csAjax').modelRequest(type.modelName);
    },

    // http://emberjs.com/api/data/classes/DS.Adapter.html#method_findRecord
    findRecord: function findRecord(store, type, id) {
      return this._request(type.modelName, {
        params: { query: { id: id }, single: true }
      });
    },

    // http://emberjs.com/api/data/classes/DS.Adapter.html#method_query
    query: function query(store, type, _query) {
      return this._request(type.modelName, {
        params: { query: _query }
      });
    },

    // should404: false,

    _request: function _request(type, request) {
      var _this = this;

      return new _ember['default'].RSVP.Promise(function (resolve, reject) {
        _this.get('csAjax').modelRequest(type, request).then(function (success) {

          var status = success.errors ? success.errors[0].status : 200;
          var response = _this.handleResponse(status, [], success, request);

          if (response.errors) {
            reject(response);
          } else {
            _ember['default'].run(function () {
              resolve(response);
            });
          }
        }, reject);
      });
    },

    //
    // Caching
    //

    // shouldReloadRecord(store, snapshot) {
    //   return false;
    // },

    // shouldBackgroundReloadRecord(store, snapshot) {
    //   console.log("Calling shouldBackgroundReloadRecord");
    //   const loadedAt = snapshot.record.get('loadedAt');

    //   // if it was loaded more than an hour ago
    //   if (Date.now() - loadedAt > 3600000) {
    //     return true;
    //   } else {
    //     return false;
    //   }
    // },

    createRecord: function createRecord(store, type, snapshot) {
      return this._updateRequest('create', store, type, snapshot);
    },

    updateRecord: function updateRecord(store, type, snapshot) {
      return this._updateRequest('update', store, type, snapshot);
    },

    deleteRecord: function deleteRecord(store, type, snapshot) {
      return this._updateRequest('delete', store, type, snapshot);
    },

    _updateRequest: function _updateRequest(action, store, type, snapshot) {
      return this.get('csAjax').request('adapter::' + type.modelName, {
        action: action,
        params: {
          model: this.serialize(snapshot, { includeId: true }),
          id: snapshot.id
        }
      });
    }

  });
});
define('cornerstone/adapters/cs-client-side-adapter', ['exports', 'ember', 'cornerstone/adapters/cs-read-only-adapter', 'npm:uuid'], function (exports, _ember, _cornerstoneAdaptersCsReadOnlyAdapter, _npmUuid) {
  exports['default'] = _cornerstoneAdaptersCsReadOnlyAdapter['default'].extend({

    firstLoad: false,
    generateIdForRecord: function generateIdForRecord() {
      return _npmUuid['default'].v4();
    },

    shouldBackgroundReloadAll: function shouldBackgroundReloadAll() {
      return false;
    },

    shouldReloadAll: function shouldReloadAll(store, snapshotArray) {
      return _ember['default'].isEmpty(_ember['default'].get(store.peekAll(snapshotArray.type.modelName), 'content'));
    },

    shouldReloadRecord: function shouldReloadRecord() {
      return false;
    },

    shouldBackgroundReloadRecord: function shouldBackgroundReloadRecord() {
      return false;
    }

  });
});
define('cornerstone/adapters/cs-longevity-adapter', ['exports', 'ember', 'cornerstone/adapters/cs-read-only-adapter'], function (exports, _ember, _cornerstoneAdaptersCsReadOnlyAdapter) {
  exports['default'] = _cornerstoneAdaptersCsReadOnlyAdapter['default'].extend({
    csBackgroundReloadRefreshRate: 300000,

    shouldReloadRecord: function shouldReloadRecord() {
      return false;
    },

    shouldBackgroundReloadRecord: function shouldBackgroundReloadRecord(store, snapshot) {

      var loadedAt = snapshot.record.get('loadedAt');
      var now = Date.now();
      if (now - loadedAt > this.csBackgroundReloadRefreshRate) {
        snapshot.record.set('loadedAt', now);
        _ember['default'].Logger.info('Background reloading ' + snapshot.modelName + ' ' + snapshot.id);
        return true;
      } else {
        return false;
      }
    }

  });
});
define('cornerstone/adapters/cs-option-list-adapter', ['exports', 'ember', 'ember-data/adapters/json-api', 'npm:uuid'], function (exports, _ember, _emberDataAdaptersJsonApi, _npmUuid) {
  exports['default'] = _emberDataAdaptersJsonApi['default'].extend({

    filterResponse: function filterResponse(store, type, response) {
      return response;
    },

    // Set this to the option model we're proxying through
    option: null,

    generateIdForRecord: function generateIdForRecord() {
      return _npmUuid['default'].v4();
    },

    // http://emberjs.com/api/data/classes/DS.Adapter.html#method_findAll
    findAll: function findAll(store, type) {
      var _this = this;

      return new _ember['default'].RSVP.Promise(function (resolve, reject) {
        store.findRecord('option', _this.get('option')).then(function (record) {
          resolve(_this.filterResponse(store, type, record.serialize().data.attributes.value));
        }, reject);
      });
    },

    // http://emberjs.com/api/data/classes/DS.Adapter.html#method_findRecord
    findRecord: function findRecord(store, type, id) {
      var _this2 = this;

      return new _ember['default'].RSVP.Promise(function (resolve, reject) {
        _this2.findAll(store).then(function () {
          resolve(store.peekRecord(type.modelName, id));
        }, reject);
      });
    },

    // http://emberjs.com/api/data/classes/DS.Adapter.html#method_query
    query: function query() {
      console.warn('This adapter does not support query');
    },

    shouldReloadRecord: function shouldReloadRecord() {
      return false;
    },

    shouldBackgroundReloadRecord: function shouldBackgroundReloadRecord() {
      return false;
    },

    createRecord: function createRecord(store, type, snapshot) {
      return this._updateRequest('create', store, type, snapshot);
    },

    updateRecord: function updateRecord(store, type, snapshot) {
      return this._updateRequest('update', store, type, snapshot);
    },

    deleteRecord: function deleteRecord(store, type, snapshot) {
      return this._updateRequest('delete', store, type, snapshot);
    },

    _updateRequest: function _updateRequest(action, store, type /*, snapshot */) {
      var _this3 = this;

      return new _ember['default'].RSVP.Promise(function (resolve, reject) {

        var option = store.peekRecord('option', _this3.get('option'));

        var value = store.peekAll(type.modelName).filter(function (record) {
          return !record.get('isDeleted');
        }).sortBy('order').map(function (record) {
          return record.serialize({ includeId: true });
        });

        option.set('value', value);

        option.save().then(function () {
          resolve();
        }, reject);
      });
    }

  });
});
define('cornerstone/adapters/cs-read-only-adapter', ['exports', 'ember', 'cornerstone/adapters/cs-adapter'], function (exports, _ember, _cornerstoneAdaptersCsAdapter) {
  exports['default'] = _cornerstoneAdaptersCsAdapter['default'].extend({

    //
    // Fake persistence
    //

    createRecord: function createRecord() {
      return new _ember['default'].RSVP.Promise(function (resolve) {
        return resolve(undefined);
      });
    },

    updateRecord: function updateRecord() {
      return new _ember['default'].RSVP.Promise(function (resolve) {
        return resolve(undefined);
      });
    },

    deleteRecord: function deleteRecord() {
      return new _ember['default'].RSVP.Promise(function (resolve) {
        return resolve(undefined);
      });
    }

  });
});
define('cornerstone/app', ['exports', 'ember', 'cornerstone/resolver', 'ember-load-initializers', 'cornerstone/config/environment'], function (exports, _ember, _cornerstoneResolver, _emberLoadInitializers, _cornerstoneConfigEnvironment) {

  var App = undefined;

  _ember['default'].MODEL_FACTORY_INJECTIONS = true;

  App = _ember['default'].Application.extend({
    modulePrefix: _cornerstoneConfigEnvironment['default'].modulePrefix,
    podModulePrefix: _cornerstoneConfigEnvironment['default'].podModulePrefix,
    Resolver: _cornerstoneResolver['default']
  });

  (0, _emberLoadInitializers['default'])(App, _cornerstoneConfigEnvironment['default'].modulePrefix);

  exports['default'] = App;
});
define('cornerstone/application/adapter', ['exports', 'cornerstone/adapters/cs-read-only-adapter'], function (exports, _cornerstoneAdaptersCsReadOnlyAdapter) {
  exports['default'] = _cornerstoneAdaptersCsReadOnlyAdapter['default'].extend({});
});
// import Ember from 'ember';
define('cornerstone/application/route', ['exports', 'ember', 'cornerstone/mixins/keyboard-shortcuts/route'], function (exports, _ember, _cornerstoneMixinsKeyboardShortcutsRoute) {
  exports['default'] = _ember['default'].Route.extend(_cornerstoneMixinsKeyboardShortcutsRoute['default'], {

    ui: _ember['default'].inject.service(),
    preview: _ember['default'].inject.service(),

    keyboardShortcuts: {
      'save': 'save',
      'delete-confirm': {
        action: 'deleteConfirm',
        global: false
      },
      'delete-release': 'deleteRelease',
      'esc': 'cancel'
    },

    shouldBindKeyboardShortcuts: _ember['default'].computed.not('preview.isPreview'),

    shouldLoadPreview: _ember['default'].observer('preview.ready', function () {
      if (this.get('preview.isPreview') && this.get('preview.ready')) {
        this.transitionTo(this.get('preview.initialRoute'));
      }
    }),

    init: function init() {
      this._super.apply(this, arguments);
      this.get('preview').setupPort();
    },

    setupController: function setupController(controller) {
      this._super.apply(this, arguments);
      controller.set('isPreview', this.get('preview.isPreview'));
    },

    actions: {

      save: function save() {
        // Prevent native browser save dialog when this event isn't handled by a child route
      },

      error: function error(_error, transition) {
        console.warn('Transition Error', _error, transition);
      },

      cancel: function cancel() {

        if (this.get('preview.isPreview')) {
          return;
        }

        var $focus = _ember['default'].$('<input type="text" style="opacity:0;position:absolute;">');
        _ember['default'].$('body').append($focus);
        $focus.focus();
        $focus.remove();
      },

      deleteConfirm: function deleteConfirm() {
        this.set('ui.deleteConfirm', true);
      },

      deleteRelease: function deleteRelease() {
        this.set('ui.deleteConfirm', false);
      },

      loading: function loading(transition /* , originRoute */) {
        this.set('ui.transitioning', true);
        transition.promise['finally']((function () {
          this.set('ui.transitioning', false);
        }).bind(this));
      },

      didTransition: function didTransition() {
        var _this = this;

        _ember['default'].run.next(this, function () {
          _this.set('ui.currentRouteName', _this.get('router.currentRouteName'));
        });
        return true;
      }

    }

  });
});
define('cornerstone/application/serializer', ['exports', 'ember-data/serializers/json-api'], function (exports, _emberDataSerializersJsonApi) {
  exports['default'] = _emberDataSerializersJsonApi['default'].extend({

    // normalizeFindRecordResponse(store, type, payload) {
    //   console.log(payload);
    //   return {
    //     data: {
    //       id: payload.id,
    //       type: type.modelName,
    //       attributes: {
    //         // name: payload.name,
    //         // publicRepos: payload.public_repos
    //       }
    //     }
    //   }
    // }
  });
});
define("cornerstone/application/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 3,
                  "column": 2
                },
                "end": {
                  "line": 5,
                  "column": 2
                }
              },
              "moduleName": "cornerstone/application/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("    ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "outlet", ["bar"], [], ["loc", [null, [4, 4], [4, 20]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child1 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 7,
                  "column": 2
                },
                "end": {
                  "line": 9,
                  "column": 2
                }
              },
              "moduleName": "cornerstone/application/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("    ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "common/tab-modal", [], ["panels", ["subexpr", "@mut", [["get", "ui.cheatsheetItems", ["loc", [null, [8, 30], [8, 48]]], 0, 0, 0, 0]], [], [], 0, 0], "active", ["subexpr", "@mut", [["get", "ui.showCheatsheet", ["loc", [null, [8, 56], [8, 73]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [8, 4], [8, 75]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 2,
                "column": 0
              },
              "end": {
                "line": 14,
                "column": 0
              }
            },
            "moduleName": "cornerstone/application/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("  ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("  ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n  ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n  ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n  ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(7);
            morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
            morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
            morphs[2] = dom.createMorphAt(fragment, 4, 4, contextualElement);
            morphs[3] = dom.createMorphAt(fragment, 6, 6, contextualElement);
            morphs[4] = dom.createMorphAt(fragment, 8, 8, contextualElement);
            morphs[5] = dom.createMorphAt(fragment, 10, 10, contextualElement);
            morphs[6] = dom.createMorphAt(fragment, 12, 12, contextualElement);
            dom.insertBoundary(fragment, 0);
            return morphs;
          },
          statements: [["block", "global/cs-bar", [], [], 0, null, ["loc", [null, [3, 2], [5, 20]]]], ["inline", "outlet", ["global"], [], ["loc", [null, [6, 2], [6, 21]]], 0, 0], ["block", "if", [["get", "ui.routeEnabledCheatsheet", ["loc", [null, [7, 8], [7, 33]]], 0, 0, 0, 0]], [], 1, null, ["loc", [null, [7, 2], [9, 9]]]], ["content", "global/notification-queue", ["loc", [null, [10, 2], [10, 31]]], 0, 0, 0, 0], ["inline", "common/confirm-modal", [], ["screen", "global"], ["loc", [null, [11, 2], [11, 42]]], 0, 0], ["inline", "global/progress-bar", [], ["saving", ["subexpr", "@mut", [["get", "ui.saving", ["loc", [null, [12, 31], [12, 40]]], 0, 0, 0, 0]], [], [], 0, 0], "transitioning", ["subexpr", "@mut", [["get", "ui.transitioning", ["loc", [null, [12, 55], [12, 71]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [12, 2], [12, 73]]], 0, 0], ["content", "cs-islands", ["loc", [null, [13, 2], [13, 16]]], 0, 0, 0, 0]],
          locals: [],
          templates: [child0, child1]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 16,
              "column": 0
            }
          },
          "moduleName": "cornerstone/application/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(2);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          morphs[1] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          dom.insertBoundary(fragment, 0);
          return morphs;
        },
        statements: [["block", "unless", [["get", "isPreview", ["loc", [null, [2, 10], [2, 19]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [2, 0], [14, 11]]]], ["content", "outlet", ["loc", [null, [15, 0], [15, 10]]], 0, 0, 0, 0]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 17,
            "column": 0
          }
        },
        "moduleName": "cornerstone/application/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["block", "global/top-level", [], [], 0, null, ["loc", [null, [1, 0], [16, 21]]]]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/app-version', ['exports', 'ember-cli-app-version/components/app-version', 'cornerstone/config/environment'], function (exports, _emberCliAppVersionComponentsAppVersion, _cornerstoneConfigEnvironment) {

  var name = _cornerstoneConfigEnvironment['default'].APP.name;
  var version = _cornerstoneConfigEnvironment['default'].APP.version;

  exports['default'] = _emberCliAppVersionComponentsAppVersion['default'].extend({
    version: version,
    name: name
  });
});
define('cornerstone/components/bars/region-manager/component', ['exports', 'ember'], function (exports, _ember) {

  function sortFilter(item) {
    return !(item.get('isDeleted') || item.get('parent.isDeleted'));
  }

  exports['default'] = _ember['default'].Component.extend({

    classNames: ['cs-hf-layout'],

    store: _ember['default'].inject.service(),

    orderSort: ['order'],
    filteredBars: _ember['default'].computed.filter('selectedRegion.children', sortFilter),
    filteredContainers: _ember['default'].computed.filter('selectedBar.children', sortFilter),
    filtered: _ember['default'].computed.filter('selectedContainer.children', sortFilter),
    sortedBars: _ember['default'].computed.sort('filteredBars', 'orderSort'),
    sortedContainers: _ember['default'].computed.sort('filteredContainers', 'orderSort'),
    sortedModules: _ember['default'].computed.sort('filtered', 'orderSort'),

    unsetSelectedContainer: _ember['default'].observer('selectedContainer.isDeleted', function () {
      if (this.get('selectedContainer.isDeleted')) {
        this.set('selectedContainer', null);
      }
    }),

    unsetSelectedBar: _ember['default'].observer('selectedBar.isDeleted', function () {
      if (this.get('selectedBar.isDeleted')) {
        this.set('selectedBar', null);
      }
    }),

    init: function init() {
      this._super.apply(this, arguments);
      this.firstOpen();
    },

    showRegionSelect: _ember['default'].computed.gt('regions.length', 1),

    singleBarRegions: _ember['default'].computed('regions.[]', function () {
      return this.get('regions').filter(function (region) {
        return _ember['default'].get(region, 'oneBar');
      }).map(function (region) {
        return region.value;
      });
    }),

    canAddBar: _ember['default'].computed('selectedRegion', 'sortedBars', 'singleBarRegions.[]', function () {
      return !(this.get('singleBarRegions').includes(this.get('selectedRegion.atts._region')) && this.get('sortedBars.length') > 0);
    }),

    maxBarsMessage: _ember['default'].computed('canAddBar', function () {
      return 'This region only supports a single bar.';
    }),

    moduleSelectorIsShowing: false,

    firstOpen: function firstOpen() {

      if (this.get('inspecting')) {
        this.send('selectModule', this.get('inspecting'));
        return;
      }

      this.sendAction('onFirstOpen');

      var first = this.get('activeRoot.children').find(function (item) {
        return item.get('children.length') > 0;
      });

      var defaultRegion = this.get('regions.firstObject.value');

      this.send('selectRegion', _ember['default'].isNone(first) ? defaultRegion : _ember['default'].getWithDefault(first, 'atts._region', defaultRegion));
    },

    actions: {

      _addAndSelect: function _addAndSelect(parentKey, type, sibling, after) {
        var _this = this;

        var atts = {
          title: this.get('i18n').t('app.new-at-index', {
            item: this.get('store').peekRecord('element/definition', type).get('title'),
            index: this.get(parentKey + '.children.length') + 1
          }).toString()
        };

        if (sibling) {
          this.send('_newModuleFromSibling', type, sibling, atts, after);
        } else {
          this.send('_newModule', this.get(parentKey), type, atts, null, function (module) {
            if (1 === _this.get(parentKey + '.children.length')) {
              _this.send('selectModule', module);
            }
          });
        }
      },

      _newModule: function _newModule(parent, type, atts, index, success) {
        var _this2 = this;

        var addChild = parent.get('addChild');

        if ('function' !== _ember['default'].typeOf(addChild)) {
          return;
        }

        var module = addChild(_ember['default'].merge(atts, {
          _type: type,
          _region: this.get('selectedRegion.atts._region')
        }), index);

        if (module) {
          module.then(function (record) {
            _this2.get('ui.preview.xfr').message('preview:new:element', record.get('id'));
            _this2.sendAction('onNewElement', record);
            if ('function' === _ember['default'].typeOf(success)) {
              success(record);
            }
          });
        }
      },

      _newModuleFromSibling: function _newModuleFromSibling(type, sibling, atts, after) {
        this.send('_newModule', sibling.get('parent'), type, atts, after ? sibling.get('order') + 1 : sibling.get('order'));
      },

      selectRegion: function selectRegion(region) {

        this.send('selectModule', this.get('activeRoot.children').filter(function (item) {
          return 'region' === item.get('atts._type') && item.get('atts._region') === region;
        }).get('firstObject'));
      },

      addBar: function addBar(sibling, after) {
        this.send('_addAndSelect', 'selectedRegion', 'bar', sibling, after);
      },

      addContainer: function addContainer(sibling, after) {
        this.send('_addAndSelect', 'selectedBar', 'container', sibling, after);
      },

      addModule: function addModule(sibling, after) {
        this.set('selectModuleCallback', (function (type) {
          if (sibling) {
            this.send('_newModuleFromSibling', type, sibling, {}, after);
          } else {
            this.send('_newModule', this.get('selectedContainer'), type, {});
          }
          this.set('moduleSelectorIsShowing', false);
        }).bind(this));
        this.set('moduleSelectorIsShowing', true);
      },

      moveModule: function moveModule(module, newIndex) {
        module.get('updatePosition')(newIndex);
      },

      selectModule: function selectModule(module) {
        var _this3 = this;

        var selectableTypes = ['region', 'bar', 'container'];

        // Look up or down to find a container
        function findDeepest(_x) {
          var _again = true;

          _function: while (_again) {
            var module = _x;
            _again = false;

            if (!module) {
              return false;
            }

            var type = _ember['default'].get(module, 'atts._type');

            if (type === 'container') {
              return module;
            }

            if (selectableTypes.includes(type)) {
              var children = _ember['default'].get(module, 'children');
              var child = children.sortBy('order').get('firstObject');
              if (child) {
                _x = child;
                _again = true;
                type = children = child = undefined;
                continue _function;
              } else {
                return module;
              }
            }

            if (module.get('parent.atts._type')) {
              _x = module.get('parent');
              _again = true;
              type = children = child = undefined;
              continue _function;
            }

            return false;
          }
        }

        function fillSelection(next) {
          var selection = {};
          while ('undefined' !== typeof next && selectableTypes.includes(next.get('atts._type'))) {
            selection[next.get('atts._type')] = next;
            next = next.get('parent');
          }
          return selection;
        }

        var container = findDeepest(module);
        if (!container) {
          console.warn('Could not make a layout selection.');
          return;
        }

        var selection = fillSelection(container);

        selectableTypes.forEach(function (item) {
          var path = _ember['default'].String.camelize('selected-' + item);
          if (_this3.get(path) !== selection[item]) {
            _this3.set(path, selection[item]);
          }
        });
      },

      inspectElement: function inspectElement(element) {
        this.sendAction('onInspect', element);
      },

      duplicateModule: function duplicateModule(module) {
        module.duplicate();
        this.sendAction('onDuplicateElement', module);
      },

      deleteModule: function deleteModule(module) {
        this.get('ui').confirm({
          screen: this.get('screen'),
          message: this.get('i18n').t('app.elements-confirm-delete'),
          accept: function accept() {
            module.selfDestruct();
          },
          acceptClass: 'sad'
        });
      },

      closeModuleSelection: function closeModuleSelection() {
        this.set('selectModuleCallback', null);
        this.set('moduleSelectorIsShowing', false);
      },

      chooseNewModuleType: function chooseNewModuleType(type) {
        this.sendAction('selectModuleCallback', type);
      },

      observeStart: function observeStart(element) {
        this.get('ui.preview.xfr').message('preview:observe-start', element.get('id'));
      },

      observeEnd: function observeEnd(element) {
        this.get('ui.preview.xfr').message('preview:observe-end', element.get('id'));
      }

    }
  });
});
define("cornerstone/components/bars/region-manager/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 8,
                "column": 4
              },
              "end": {
                "line": 10,
                "column": 4
              }
            },
            "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
          },
          isEmpty: false,
          arity: 1,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("      ");
            dom.appendChild(el0, el1);
            var el1 = dom.createElement("li");
            var el2 = dom.createElement("span");
            dom.appendChild(el1, el2);
            var el2 = dom.createComment("");
            dom.appendChild(el1, el2);
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var element5 = dom.childAt(fragment, [1]);
            var morphs = new Array(3);
            morphs[0] = dom.createAttrMorph(element5, 'class');
            morphs[1] = dom.createElementMorph(element5);
            morphs[2] = dom.createMorphAt(element5, 1, 1);
            return morphs;
          },
          statements: [["attribute", "class", ["concat", [["get", "region.value", ["loc", [null, [9, 58], [9, 70]]], 0, 0, 0, 0], " ", ["subexpr", "if", [["subexpr", "eq", [["get", "selectedRegion.atts._region", ["loc", [null, [9, 82], [9, 109]]], 0, 0, 0, 0], ["get", "region.value", ["loc", [null, [9, 110], [9, 122]]], 0, 0, 0, 0]], [], ["loc", [null, [9, 78], [9, 123]]], 0, 0], "cs-active"], [], ["loc", [null, [9, 73], [9, 137]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["selectRegion", ["get", "region.value", ["loc", [null, [9, 34], [9, 46]]], 0, 0, 0, 0]], [], ["loc", [null, [9, 10], [9, 48]]], 0, 0], ["content", "region.label", ["loc", [null, [9, 152], [9, 168]]], 0, 0, 0, 0]],
          locals: ["region"],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 5,
              "column": 0
            },
            "end": {
              "line": 13,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createElement("div");
          dom.setAttribute(el1, "class", "cs-hf-layout-item regions");
          var el2 = dom.createTextNode("\n  ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("ul");
          var el3 = dom.createTextNode("\n");
          dom.appendChild(el2, el3);
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          var el3 = dom.createTextNode("  ");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(dom.childAt(fragment, [0, 1]), 1, 1);
          return morphs;
        },
        statements: [["block", "each", [["get", "regions", ["loc", [null, [8, 12], [8, 19]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [8, 4], [10, 13]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    var child1 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          var child0 = (function () {
            var child0 = (function () {
              return {
                meta: {
                  "revision": "Ember@2.8.0",
                  "loc": {
                    "source": null,
                    "start": {
                      "line": 30,
                      "column": 14
                    },
                    "end": {
                      "line": 46,
                      "column": 14
                    }
                  },
                  "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
                },
                isEmpty: false,
                arity: 0,
                cachedFragment: null,
                hasRendered: false,
                buildFragment: function buildFragment(dom) {
                  var el0 = dom.createDocumentFragment();
                  var el1 = dom.createTextNode("                ");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createComment("");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createTextNode("\n");
                  dom.appendChild(el0, el1);
                  return el0;
                },
                buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                  var morphs = new Array(1);
                  morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                  return morphs;
                },
                statements: [["inline", "common/sortable-item", [], ["label", ["subexpr", "@mut", [["get", "bar.title", ["loc", [null, [32, 24], [32, 33]]], 0, 0, 0, 0]], [], [], 0, 0], "item", ["subexpr", "@mut", [["get", "bar", ["loc", [null, [33, 23], [33, 26]]], 0, 0, 0, 0]], [], [], 0, 0], "active", ["subexpr", "eq", [["get", "bar.id", ["loc", [null, [34, 29], [34, 35]]], 0, 0, 0, 0], ["get", "selectedBar.id", ["loc", [null, [34, 36], [34, 50]]], 0, 0, 0, 0]], [], ["loc", [null, [34, 25], [34, 51]]], 0, 0], "showAddAfter", ["subexpr", "eq", [["get", "bar.id", ["loc", [null, [35, 35], [35, 41]]], 0, 0, 0, 0], ["get", "sortedBars.lastObject.id", ["loc", [null, [35, 42], [35, 66]]], 0, 0, 0, 0]], [], ["loc", [null, [35, 31], [35, 67]]], 0, 0], "onDrop", ["subexpr", "action", ["moveModule"], [], ["loc", [null, [36, 25], [36, 47]]], 0, 0], "onAddBefore", ["subexpr", "action", ["addBar", ["get", "bar", ["loc", [null, [37, 47], [37, 50]]], 0, 0, 0, 0]], [], ["loc", [null, [37, 30], [37, 51]]], 0, 0], "onAddAfter", ["subexpr", "action", ["addBar", ["get", "bar", ["loc", [null, [38, 46], [38, 49]]], 0, 0, 0, 0], true], [], ["loc", [null, [38, 29], [38, 55]]], 0, 0], "onSelect", ["subexpr", "action", ["selectModule", ["get", "bar", ["loc", [null, [39, 50], [39, 53]]], 0, 0, 0, 0]], [], ["loc", [null, [39, 27], [39, 54]]], 0, 0], "onInspect", ["subexpr", "action", ["inspectElement", ["get", "bar", ["loc", [null, [40, 53], [40, 56]]], 0, 0, 0, 0]], [], ["loc", [null, [40, 28], [40, 57]]], 0, 0], "onDuplicate", ["subexpr", "action", ["duplicateModule", ["get", "bar", ["loc", [null, [41, 56], [41, 59]]], 0, 0, 0, 0]], [], ["loc", [null, [41, 30], [41, 60]]], 0, 0], "onDelete", ["subexpr", "action", ["deleteModule", ["get", "bar", ["loc", [null, [42, 50], [42, 53]]], 0, 0, 0, 0]], [], ["loc", [null, [42, 27], [42, 54]]], 0, 0], "onMouseEnter", ["subexpr", "action", ["observeStart", ["get", "bar", ["loc", [null, [43, 54], [43, 57]]], 0, 0, 0, 0]], [], ["loc", [null, [43, 31], [43, 58]]], 0, 0], "onMouseLeave", ["subexpr", "action", ["observeEnd", ["get", "bar", ["loc", [null, [44, 52], [44, 55]]], 0, 0, 0, 0]], [], ["loc", [null, [44, 31], [44, 56]]], 0, 0]], ["loc", [null, [31, 16], [45, 18]]], 0, 0]],
                locals: [],
                templates: []
              };
            })();
            var child1 = (function () {
              return {
                meta: {
                  "revision": "Ember@2.8.0",
                  "loc": {
                    "source": null,
                    "start": {
                      "line": 46,
                      "column": 14
                    },
                    "end": {
                      "line": 57,
                      "column": 14
                    }
                  },
                  "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
                },
                isEmpty: false,
                arity: 0,
                cachedFragment: null,
                hasRendered: false,
                buildFragment: function buildFragment(dom) {
                  var el0 = dom.createDocumentFragment();
                  var el1 = dom.createTextNode("                ");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createComment("");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createTextNode("\n");
                  dom.appendChild(el0, el1);
                  return el0;
                },
                buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                  var morphs = new Array(1);
                  morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                  return morphs;
                },
                statements: [["inline", "common/sortable-item", [], ["label", ["subexpr", "@mut", [["get", "bar.title", ["loc", [null, [48, 24], [48, 33]]], 0, 0, 0, 0]], [], [], 0, 0], "item", ["subexpr", "@mut", [["get", "bar", ["loc", [null, [49, 23], [49, 26]]], 0, 0, 0, 0]], [], [], 0, 0], "active", ["subexpr", "eq", [["get", "bar.id", ["loc", [null, [50, 29], [50, 35]]], 0, 0, 0, 0], ["get", "selectedBar.id", ["loc", [null, [50, 36], [50, 50]]], 0, 0, 0, 0]], [], ["loc", [null, [50, 25], [50, 51]]], 0, 0], "onDrop", ["subexpr", "action", ["moveModule"], [], ["loc", [null, [51, 25], [51, 46]]], 0, 0], "onInspect", ["subexpr", "action", ["inspectElement", ["get", "bar", ["loc", [null, [52, 53], [52, 56]]], 0, 0, 0, 0]], [], ["loc", [null, [52, 28], [52, 57]]], 0, 0], "onDelete", ["subexpr", "action", ["deleteModule", ["get", "bar", ["loc", [null, [53, 50], [53, 53]]], 0, 0, 0, 0]], [], ["loc", [null, [53, 27], [53, 54]]], 0, 0], "onMouseEnter", ["subexpr", "action", ["observeStart", ["get", "bar", ["loc", [null, [54, 54], [54, 57]]], 0, 0, 0, 0]], [], ["loc", [null, [54, 31], [54, 58]]], 0, 0], "onMouseLeave", ["subexpr", "action", ["observeEnd", ["get", "bar", ["loc", [null, [55, 52], [55, 55]]], 0, 0, 0, 0]], [], ["loc", [null, [55, 31], [55, 56]]], 0, 0]], ["loc", [null, [47, 16], [56, 18]]], 0, 0]],
                locals: [],
                templates: []
              };
            })();
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 29,
                    "column": 12
                  },
                  "end": {
                    "line": 58,
                    "column": 12
                  }
                },
                "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
              },
              isEmpty: false,
              arity: 1,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
                dom.insertBoundary(fragment, 0);
                dom.insertBoundary(fragment, null);
                return morphs;
              },
              statements: [["block", "if", [["get", "canAddBar", ["loc", [null, [30, 20], [30, 29]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [30, 14], [57, 21]]]]],
              locals: ["bar"],
              templates: [child0, child1]
            };
          })();
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 28,
                  "column": 10
                },
                "end": {
                  "line": 59,
                  "column": 10
                }
              },
              "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
              dom.insertBoundary(fragment, 0);
              dom.insertBoundary(fragment, null);
              return morphs;
            },
            statements: [["block", "each", [["get", "sortedBars", ["loc", [null, [29, 20], [29, 30]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [29, 12], [58, 21]]]]],
            locals: [],
            templates: [child0]
          };
        })();
        var child1 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 60,
                  "column": 10
                },
                "end": {
                  "line": 62,
                  "column": 10
                }
              },
              "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("            ");
              dom.appendChild(el0, el1);
              var el1 = dom.createElement("p");
              dom.setAttribute(el1, "class", "cs-hf-layout-max-bars-message");
              var el2 = dom.createElement("strong");
              var el3 = dom.createTextNode("Note:");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode(" ");
              dom.appendChild(el1, el2);
              var el2 = dom.createComment("");
              dom.appendChild(el1, el2);
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1]), 2, 2);
              return morphs;
            },
            statements: [["content", "maxBarsMessage", ["loc", [null, [61, 76], [61, 94]]], 0, 0, 0, 0]],
            locals: [],
            templates: []
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 21,
                "column": 4
              },
              "end": {
                "line": 66,
                "column": 4
              }
            },
            "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("\n      ");
            dom.appendChild(el0, el1);
            var el1 = dom.createElement("ul");
            dom.setAttribute(el1, "class", "cs-controls");
            var el2 = dom.createTextNode("\n        ");
            dom.appendChild(el1, el2);
            var el2 = dom.createElement("li");
            dom.setAttribute(el2, "class", "cs-control cs-control-sortable");
            var el3 = dom.createTextNode("\n          ");
            dom.appendChild(el2, el3);
            var el3 = dom.createElement("div");
            dom.setAttribute(el3, "class", "cs-control-header");
            var el4 = dom.createTextNode("\n            ");
            dom.appendChild(el3, el4);
            var el4 = dom.createElement("label");
            var el5 = dom.createTextNode("Bars");
            dom.appendChild(el4, el5);
            dom.appendChild(el3, el4);
            var el4 = dom.createTextNode("\n          ");
            dom.appendChild(el3, el4);
            dom.appendChild(el2, el3);
            var el3 = dom.createTextNode("\n");
            dom.appendChild(el2, el3);
            var el3 = dom.createComment("");
            dom.appendChild(el2, el3);
            var el3 = dom.createComment("");
            dom.appendChild(el2, el3);
            var el3 = dom.createTextNode("        ");
            dom.appendChild(el2, el3);
            dom.appendChild(el1, el2);
            var el2 = dom.createTextNode("\n      ");
            dom.appendChild(el1, el2);
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var element4 = dom.childAt(fragment, [1, 1]);
            var morphs = new Array(2);
            morphs[0] = dom.createMorphAt(element4, 3, 3);
            morphs[1] = dom.createMorphAt(element4, 4, 4);
            return morphs;
          },
          statements: [["block", "common/sortable-container", [], [], 0, null, ["loc", [null, [28, 10], [59, 40]]]], ["block", "unless", [["get", "canAddBar", ["loc", [null, [60, 20], [60, 29]]], 0, 0, 0, 0]], [], 1, null, ["loc", [null, [60, 10], [62, 21]]]]],
          locals: [],
          templates: [child0, child1]
        };
      })();
      var child1 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 66,
                "column": 4
              },
              "end": {
                "line": 73,
                "column": 4
              }
            },
            "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("\n      ");
            dom.appendChild(el0, el1);
            var el1 = dom.createElement("button");
            dom.setAttribute(el1, "class", "cs-hf-layout-add-first cs-hf-layout-add-first-bar");
            var el2 = dom.createTextNode("\n        ");
            dom.appendChild(el1, el2);
            var el2 = dom.createElement("i");
            dom.setAttribute(el2, "class", "cs-icon");
            var el3 = dom.createComment("");
            dom.appendChild(el2, el3);
            dom.appendChild(el1, el2);
            var el2 = dom.createTextNode("\n        ");
            dom.appendChild(el1, el2);
            var el2 = dom.createElement("span");
            var el3 = dom.createTextNode("Add a bar to get started.");
            dom.appendChild(el2, el3);
            dom.appendChild(el1, el2);
            var el2 = dom.createTextNode("\n      ");
            dom.appendChild(el1, el2);
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var element3 = dom.childAt(fragment, [1]);
            var morphs = new Array(2);
            morphs[0] = dom.createElementMorph(element3);
            morphs[1] = dom.createMorphAt(dom.childAt(element3, [1]), 0, 0);
            return morphs;
          },
          statements: [["element", "action", ["addBar"], [], ["loc", [null, [68, 72], [68, 91]]], 0, 0], ["inline", "fa-icon", ["plus-square"], [], ["loc", [null, [69, 27], [69, 52]]], 0, 0]],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 20,
              "column": 2
            },
            "end": {
              "line": 74,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "if", [["get", "sortedBars", ["loc", [null, [21, 10], [21, 20]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [21, 4], [73, 11]]]]],
        locals: [],
        templates: [child0, child1]
      };
    })();
    var child2 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          var child0 = (function () {
            var child0 = (function () {
              return {
                meta: {
                  "revision": "Ember@2.8.0",
                  "loc": {
                    "source": null,
                    "start": {
                      "line": 92,
                      "column": 14
                    },
                    "end": {
                      "line": 108,
                      "column": 14
                    }
                  },
                  "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
                },
                isEmpty: false,
                arity: 1,
                cachedFragment: null,
                hasRendered: false,
                buildFragment: function buildFragment(dom) {
                  var el0 = dom.createDocumentFragment();
                  var el1 = dom.createTextNode("                ");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createComment("");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createTextNode("\n");
                  dom.appendChild(el0, el1);
                  return el0;
                },
                buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                  var morphs = new Array(1);
                  morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                  return morphs;
                },
                statements: [["inline", "common/sortable-item", [], ["label", ["subexpr", "@mut", [["get", "container.title", ["loc", [null, [94, 24], [94, 39]]], 0, 0, 0, 0]], [], [], 0, 0], "item", ["subexpr", "@mut", [["get", "container", ["loc", [null, [95, 23], [95, 32]]], 0, 0, 0, 0]], [], [], 0, 0], "active", ["subexpr", "eq", [["get", "container.id", ["loc", [null, [96, 29], [96, 41]]], 0, 0, 0, 0], ["get", "selectedContainer.id", ["loc", [null, [96, 42], [96, 62]]], 0, 0, 0, 0]], [], ["loc", [null, [96, 25], [96, 63]]], 0, 0], "showAddAfter", ["subexpr", "eq", [["get", "container.id", ["loc", [null, [97, 35], [97, 47]]], 0, 0, 0, 0], ["get", "sortedContainers.lastObject.id", ["loc", [null, [97, 48], [97, 78]]], 0, 0, 0, 0]], [], ["loc", [null, [97, 31], [97, 79]]], 0, 0], "onDrop", ["subexpr", "action", ["moveModule"], [], ["loc", [null, [98, 25], [98, 47]]], 0, 0], "onAddBefore", ["subexpr", "action", ["addContainer", ["get", "container", ["loc", [null, [99, 53], [99, 62]]], 0, 0, 0, 0]], [], ["loc", [null, [99, 30], [99, 63]]], 0, 0], "onAddAfter", ["subexpr", "action", ["addContainer", ["get", "container", ["loc", [null, [100, 52], [100, 61]]], 0, 0, 0, 0], true], [], ["loc", [null, [100, 29], [100, 67]]], 0, 0], "onSelect", ["subexpr", "action", ["selectModule", ["get", "container", ["loc", [null, [101, 50], [101, 59]]], 0, 0, 0, 0]], [], ["loc", [null, [101, 27], [101, 60]]], 0, 0], "onInspect", ["subexpr", "action", ["inspectElement", ["get", "container", ["loc", [null, [102, 53], [102, 62]]], 0, 0, 0, 0]], [], ["loc", [null, [102, 28], [102, 63]]], 0, 0], "onDuplicate", ["subexpr", "action", ["duplicateModule", ["get", "container", ["loc", [null, [103, 56], [103, 65]]], 0, 0, 0, 0]], [], ["loc", [null, [103, 30], [103, 66]]], 0, 0], "onDelete", ["subexpr", "action", ["deleteModule", ["get", "container", ["loc", [null, [104, 50], [104, 59]]], 0, 0, 0, 0]], [], ["loc", [null, [104, 27], [104, 60]]], 0, 0], "onMouseEnter", ["subexpr", "action", ["observeStart", ["get", "container", ["loc", [null, [105, 54], [105, 63]]], 0, 0, 0, 0]], [], ["loc", [null, [105, 31], [105, 64]]], 0, 0], "onMouseLeave", ["subexpr", "action", ["observeEnd", ["get", "container", ["loc", [null, [106, 52], [106, 61]]], 0, 0, 0, 0]], [], ["loc", [null, [106, 31], [106, 62]]], 0, 0]], ["loc", [null, [93, 16], [107, 18]]], 0, 0]],
                locals: ["container"],
                templates: []
              };
            })();
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 91,
                    "column": 12
                  },
                  "end": {
                    "line": 109,
                    "column": 12
                  }
                },
                "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
                dom.insertBoundary(fragment, 0);
                dom.insertBoundary(fragment, null);
                return morphs;
              },
              statements: [["block", "each", [["get", "sortedContainers", ["loc", [null, [92, 22], [92, 38]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [92, 14], [108, 23]]]]],
              locals: [],
              templates: [child0]
            };
          })();
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 84,
                  "column": 6
                },
                "end": {
                  "line": 113,
                  "column": 6
                }
              },
              "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("\n        ");
              dom.appendChild(el0, el1);
              var el1 = dom.createElement("ul");
              dom.setAttribute(el1, "class", "cs-controls");
              var el2 = dom.createTextNode("\n          ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("li");
              dom.setAttribute(el2, "class", "cs-control cs-control-sortable");
              var el3 = dom.createTextNode("\n            ");
              dom.appendChild(el2, el3);
              var el3 = dom.createElement("div");
              dom.setAttribute(el3, "class", "cs-control-header");
              var el4 = dom.createTextNode("\n              ");
              dom.appendChild(el3, el4);
              var el4 = dom.createElement("label");
              var el5 = dom.createTextNode("Containers");
              dom.appendChild(el4, el5);
              dom.appendChild(el3, el4);
              var el4 = dom.createTextNode("\n            ");
              dom.appendChild(el3, el4);
              dom.appendChild(el2, el3);
              var el3 = dom.createTextNode("\n");
              dom.appendChild(el2, el3);
              var el3 = dom.createComment("");
              dom.appendChild(el2, el3);
              var el3 = dom.createTextNode("          ");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1, 1]), 3, 3);
              return morphs;
            },
            statements: [["block", "common/sortable-container", [], [], 0, null, ["loc", [null, [91, 12], [109, 42]]]]],
            locals: [],
            templates: [child0]
          };
        })();
        var child1 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 113,
                  "column": 6
                },
                "end": {
                  "line": 120,
                  "column": 6
                }
              },
              "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("\n        ");
              dom.appendChild(el0, el1);
              var el1 = dom.createElement("button");
              dom.setAttribute(el1, "class", "cs-hf-layout-add-first cs-hf-layout-add-first-container");
              var el2 = dom.createTextNode("\n          ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("i");
              dom.setAttribute(el2, "class", "cs-icon");
              var el3 = dom.createComment("");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n          ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("span");
              var el3 = dom.createTextNode("Add your first container to this bar.");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var element2 = dom.childAt(fragment, [1]);
              var morphs = new Array(2);
              morphs[0] = dom.createElementMorph(element2);
              morphs[1] = dom.createMorphAt(dom.childAt(element2, [1]), 0, 0);
              return morphs;
            },
            statements: [["element", "action", ["addContainer"], [], ["loc", [null, [115, 80], [115, 105]]], 0, 0], ["inline", "fa-icon", ["plus-square"], [], ["loc", [null, [116, 29], [116, 54]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 83,
                "column": 4
              },
              "end": {
                "line": 121,
                "column": 4
              }
            },
            "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
            dom.insertBoundary(fragment, 0);
            dom.insertBoundary(fragment, null);
            return morphs;
          },
          statements: [["block", "if", [["get", "sortedContainers", ["loc", [null, [84, 12], [84, 28]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [84, 6], [120, 13]]]]],
          locals: [],
          templates: [child0, child1]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 82,
              "column": 2
            },
            "end": {
              "line": 122,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "common/scroll-box", [], ["name", "containers", "resetScrollOn", ["subexpr", "@mut", [["get", "sortedContainers", ["loc", [null, [83, 57], [83, 73]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [83, 4], [121, 26]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    var child3 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          var child0 = (function () {
            var child0 = (function () {
              return {
                meta: {
                  "revision": "Ember@2.8.0",
                  "loc": {
                    "source": null,
                    "start": {
                      "line": 140,
                      "column": 14
                    },
                    "end": {
                      "line": 154,
                      "column": 14
                    }
                  },
                  "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
                },
                isEmpty: false,
                arity: 1,
                cachedFragment: null,
                hasRendered: false,
                buildFragment: function buildFragment(dom) {
                  var el0 = dom.createDocumentFragment();
                  var el1 = dom.createTextNode("                ");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createComment("");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createTextNode("\n");
                  dom.appendChild(el0, el1);
                  return el0;
                },
                buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                  var morphs = new Array(1);
                  morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                  return morphs;
                },
                statements: [["inline", "common/sortable-item", [], ["canEditLabel", false, "label", ["subexpr", "@mut", [["get", "module.title", ["loc", [null, [143, 24], [143, 36]]], 0, 0, 0, 0]], [], [], 0, 0], "item", ["subexpr", "@mut", [["get", "module", ["loc", [null, [144, 23], [144, 29]]], 0, 0, 0, 0]], [], [], 0, 0], "onDrop", ["subexpr", "action", ["moveModule"], [], ["loc", [null, [144, 37], [144, 59]]], 0, 0], "showAddAfter", ["subexpr", "eq", [["get", "module.id", ["loc", [null, [145, 35], [145, 44]]], 0, 0, 0, 0], ["get", "sortedModules.lastObject.id", ["loc", [null, [145, 45], [145, 72]]], 0, 0, 0, 0]], [], ["loc", [null, [145, 31], [145, 73]]], 0, 0], "onAddBefore", ["subexpr", "action", ["addModule", ["get", "module", ["loc", [null, [146, 50], [146, 56]]], 0, 0, 0, 0]], [], ["loc", [null, [146, 30], [146, 57]]], 0, 0], "onAddAfter", ["subexpr", "action", ["addModule", ["get", "module", ["loc", [null, [147, 49], [147, 55]]], 0, 0, 0, 0], true], [], ["loc", [null, [147, 29], [147, 61]]], 0, 0], "onInspect", ["subexpr", "action", ["inspectElement", ["get", "module", ["loc", [null, [148, 53], [148, 59]]], 0, 0, 0, 0]], [], ["loc", [null, [148, 28], [148, 60]]], 0, 0], "onDuplicate", ["subexpr", "action", ["duplicateModule", ["get", "module", ["loc", [null, [149, 56], [149, 62]]], 0, 0, 0, 0]], [], ["loc", [null, [149, 30], [149, 63]]], 0, 0], "onDelete", ["subexpr", "action", ["deleteModule", ["get", "module", ["loc", [null, [150, 50], [150, 56]]], 0, 0, 0, 0]], [], ["loc", [null, [150, 27], [150, 57]]], 0, 0], "onMouseEnter", ["subexpr", "action", ["observeStart", ["get", "module", ["loc", [null, [151, 54], [151, 60]]], 0, 0, 0, 0]], [], ["loc", [null, [151, 31], [151, 61]]], 0, 0], "onMouseLeave", ["subexpr", "action", ["observeEnd", ["get", "module", ["loc", [null, [152, 52], [152, 58]]], 0, 0, 0, 0]], [], ["loc", [null, [152, 31], [152, 59]]], 0, 0]], ["loc", [null, [141, 16], [153, 18]]], 0, 0]],
                locals: ["module"],
                templates: []
              };
            })();
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 139,
                    "column": 12
                  },
                  "end": {
                    "line": 155,
                    "column": 12
                  }
                },
                "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
                dom.insertBoundary(fragment, 0);
                dom.insertBoundary(fragment, null);
                return morphs;
              },
              statements: [["block", "each", [["get", "sortedModules", ["loc", [null, [140, 22], [140, 35]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [140, 14], [154, 23]]]]],
              locals: [],
              templates: [child0]
            };
          })();
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 132,
                  "column": 6
                },
                "end": {
                  "line": 159,
                  "column": 6
                }
              },
              "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("\n        ");
              dom.appendChild(el0, el1);
              var el1 = dom.createElement("ul");
              dom.setAttribute(el1, "class", "cs-controls");
              var el2 = dom.createTextNode("\n          ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("li");
              dom.setAttribute(el2, "class", "cs-control cs-control-sortable");
              var el3 = dom.createTextNode("\n            ");
              dom.appendChild(el2, el3);
              var el3 = dom.createElement("div");
              dom.setAttribute(el3, "class", "cs-control-header");
              var el4 = dom.createTextNode("\n              ");
              dom.appendChild(el3, el4);
              var el4 = dom.createElement("label");
              var el5 = dom.createTextNode("Elements");
              dom.appendChild(el4, el5);
              dom.appendChild(el3, el4);
              var el4 = dom.createTextNode("\n            ");
              dom.appendChild(el3, el4);
              dom.appendChild(el2, el3);
              var el3 = dom.createTextNode("\n");
              dom.appendChild(el2, el3);
              var el3 = dom.createComment("");
              dom.appendChild(el2, el3);
              var el3 = dom.createTextNode("          ");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1, 1]), 3, 3);
              return morphs;
            },
            statements: [["block", "common/sortable-container", [], [], 0, null, ["loc", [null, [139, 12], [155, 42]]]]],
            locals: [],
            templates: [child0]
          };
        })();
        var child1 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 159,
                  "column": 6
                },
                "end": {
                  "line": 166,
                  "column": 6
                }
              },
              "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("\n        ");
              dom.appendChild(el0, el1);
              var el1 = dom.createElement("button");
              dom.setAttribute(el1, "class", "cs-hf-layout-add-first cs-hf-layout-add-first-module");
              var el2 = dom.createTextNode("\n          ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("i");
              dom.setAttribute(el2, "class", "cs-icon");
              var el3 = dom.createComment("");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n          ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("span");
              var el3 = dom.createTextNode("Add your first module to this container.");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var element1 = dom.childAt(fragment, [1]);
              var morphs = new Array(2);
              morphs[0] = dom.createElementMorph(element1);
              morphs[1] = dom.createMorphAt(dom.childAt(element1, [1]), 0, 0);
              return morphs;
            },
            statements: [["element", "action", ["addModule"], [], ["loc", [null, [161, 77], [161, 99]]], 0, 0], ["inline", "fa-icon", ["plus-square"], [], ["loc", [null, [162, 29], [162, 54]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 131,
                "column": 4
              },
              "end": {
                "line": 167,
                "column": 4
              }
            },
            "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
            dom.insertBoundary(fragment, 0);
            dom.insertBoundary(fragment, null);
            return morphs;
          },
          statements: [["block", "if", [["get", "sortedModules", ["loc", [null, [132, 12], [132, 25]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [132, 6], [166, 13]]]]],
          locals: [],
          templates: [child0, child1]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 130,
              "column": 2
            },
            "end": {
              "line": 168,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "common/scroll-box", [], ["name", "modules", "resetScrollOn", ["subexpr", "@mut", [["get", "sortedModules", ["loc", [null, [131, 54], [131, 67]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [131, 4], [167, 26]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    var child4 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 181,
                "column": 10
              },
              "end": {
                "line": 186,
                "column": 10
              }
            },
            "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("            ");
            dom.appendChild(el0, el1);
            var el1 = dom.createElement("div");
            dom.setAttribute(el1, "class", "cs-hf-layout-module-selector-module");
            var el2 = dom.createTextNode("\n              ");
            dom.appendChild(el1, el2);
            var el2 = dom.createComment("");
            dom.appendChild(el1, el2);
            var el2 = dom.createTextNode("\n              ");
            dom.appendChild(el1, el2);
            var el2 = dom.createElement("span");
            var el3 = dom.createComment("");
            dom.appendChild(el2, el3);
            dom.appendChild(el1, el2);
            var el2 = dom.createTextNode("\n            ");
            dom.appendChild(el1, el2);
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var element0 = dom.childAt(fragment, [1]);
            var morphs = new Array(3);
            morphs[0] = dom.createElementMorph(element0);
            morphs[1] = dom.createMorphAt(element0, 1, 1);
            morphs[2] = dom.createMorphAt(dom.childAt(element0, [3]), 0, 0);
            return morphs;
          },
          statements: [["element", "action", ["chooseNewModuleType", ["get", "definition.id", ["loc", [null, [182, 48], [182, 61]]], 0, 0, 0, 0]], [], ["loc", [null, [182, 17], [182, 64]]], 0, 0], ["inline", "cs-icon", [["get", "definition.iconPath", ["loc", [null, [183, 24], [183, 43]]], 0, 0, 0, 0]], [], ["loc", [null, [183, 14], [183, 45]]], 0, 0], ["content", "definition.title", ["loc", [null, [184, 20], [184, 40]]], 0, 0, 0, 0]],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 180,
              "column": 8
            },
            "end": {
              "line": 187,
              "column": 8
            }
          },
          "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
        },
        isEmpty: false,
        arity: 1,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "if", [["get", "definition.isSelectable", ["loc", [null, [181, 16], [181, 39]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [181, 10], [186, 17]]]]],
        locals: ["definition"],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 193,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "cs-hf-layout-item bars");
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n\n\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "cs-hf-layout-item containers");
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n\n\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "cs-hf-layout-item modules");
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n\n\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("div");
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("button");
        dom.setAttribute(el2, "class", "cs-hf-layout-module-selector-close");
        var el3 = dom.createTextNode("×");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("div");
        dom.setAttribute(el2, "class", "cs-hf-layout-module-selector-content-outer");
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("div");
        dom.setAttribute(el3, "class", "cs-hf-layout-module-selector-content-inner");
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("div");
        dom.setAttribute(el4, "class", "cs-hf-layout-module-selector-modules");
        var el5 = dom.createTextNode("\n");
        dom.appendChild(el4, el5);
        var el5 = dom.createComment("");
        dom.appendChild(el4, el5);
        var el5 = dom.createTextNode("      ");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n    ");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n  ");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element6 = dom.childAt(fragment, [14]);
        var element7 = dom.childAt(element6, [1]);
        var morphs = new Array(8);
        morphs[0] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[1] = dom.createMorphAt(dom.childAt(fragment, [5]), 1, 1);
        morphs[2] = dom.createMorphAt(dom.childAt(fragment, [8]), 1, 1);
        morphs[3] = dom.createMorphAt(dom.childAt(fragment, [11]), 1, 1);
        morphs[4] = dom.createAttrMorph(element6, 'class');
        morphs[5] = dom.createElementMorph(element7);
        morphs[6] = dom.createMorphAt(dom.childAt(element6, [3, 1, 1]), 1, 1);
        morphs[7] = dom.createMorphAt(fragment, 16, 16, contextualElement);
        return morphs;
      },
      statements: [["block", "if", [["get", "showRegionSelect", ["loc", [null, [5, 6], [5, 22]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [5, 0], [13, 7]]]], ["block", "common/scroll-box", [], ["name", "bars", "resetScrollOn", ["subexpr", "@mut", [["get", "sortedBars", ["loc", [null, [20, 49], [20, 59]]], 0, 0, 0, 0]], [], [], 0, 0]], 1, null, ["loc", [null, [20, 2], [74, 24]]]], ["block", "if", [["get", "selectedBar", ["loc", [null, [82, 8], [82, 19]]], 0, 0, 0, 0]], [], 2, null, ["loc", [null, [82, 2], [122, 9]]]], ["block", "if", [["get", "selectedContainer", ["loc", [null, [130, 8], [130, 25]]], 0, 0, 0, 0]], [], 3, null, ["loc", [null, [130, 2], [168, 9]]]], ["attribute", "class", ["concat", ["cs-hf-layout-module-selector ", ["subexpr", "if", [["get", "moduleSelectorIsShowing", ["loc", [null, [175, 47], [175, 70]]], 0, 0, 0, 0], "cs-active"], [], ["loc", [null, [175, 41], [175, 84]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["closeModuleSelection"], [], ["loc", [null, [176, 10], [176, 43]]], 0, 0], ["block", "each", [["get", "moduleDefinitions", ["loc", [null, [180, 16], [180, 33]]], 0, 0, 0, 0]], [], 4, null, ["loc", [null, [180, 8], [187, 17]]]], ["content", "yield", ["loc", [null, [192, 0], [192, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0, child1, child2, child3, child4]
    };
  })());
});
define('cornerstone/components/builder/builder-shim/component', ['exports', 'ember', 'cornerstone/mixins/preview-listener'], function (exports, _ember, _cornerstoneMixinsPreviewListener) {
  exports['default'] = _ember['default'].Component.extend(_cornerstoneMixinsPreviewListener['default'], {

    ready: false,

    init: function init() {
      var _this = this;

      this._super.apply(this, arguments);
      this.listenTo('builder:shim', function (message) {
        return _this.sendAction('message', message);
      });
    },

    didInsertElement: function didInsertElement() {
      var _this2 = this;

      _ember['default'].run.scheduleOnce('afterRender', function () {
        _this2.set('ui.skeletonModeActive', false);
        _this2.set('ui.showPreviewSizer', false);
        _this2.set('ui.showCustomCSS', false);
        _this2.set('ui.showCustomJS', false);
        _this2.get('ui.isCollapsed', false);
        _this2.set('ready', true);
      });
    },

    observeSkeleton: _ember['default'].observer('ui.skeletonModeActive', function () {
      this.shimMessage('toggleSkeleton', this.get('ui.skeletonModeActive'));
    }),

    observeShowPreviewSizer: _ember['default'].observer('ui.showPreviewSizer', function () {
      this.shimMessage('togglePreviewSizer', this.get('ui.showPreviewSizer'));
    }),

    observeShowCustomCSS: _ember['default'].observer('ui.showCustomCSS', function () {
      this.shimMessage('toggleCustomCSS', this.get('ui.showCustomCSS'));
    }),

    observeShowCustomJS: _ember['default'].observer('ui.showCustomJS', function () {
      this.shimMessage('toggleCustomJS', this.get('ui.showCustomJS'));
    }),

    observeIsCollapsed: _ember['default'].observer('ui.isCollapsed', function () {
      this.shimMessage('toggleIsCollapsed', this.get('ui.isCollapsed'));
    }),

    shimMessage: function shimMessage(action, data) {
      if (this.get('ready')) {
        this.get('xfr').message(action, data);
      }
    }

  });
});
define("cornerstone/components/builder/builder-shim/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 2,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/builder/builder-shim/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["content", "yield", ["loc", [null, [1, 0], [1, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
define('cornerstone/components/click-outside', ['exports', 'ember-click-outside/components/click-outside'], function (exports, _emberClickOutsideComponentsClickOutside) {
  exports['default'] = _emberClickOutsideComponentsClickOutside['default'];
});
define('cornerstone/components/common/bread-crumbs/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    tagName: 'ul',

    classNames: ['cs-bread-crumbs'],
    labelKey: 'title',

    breadcrumbs: _ember['default'].computed('items.[]', 'labelKey', 'activeItem', function () {
      var labelKey = this.get('labelKey');
      var activeItem = this.get('activeItem');
      return this.getWithDefault('items', []).map(function (item) {
        return {
          entity: item,
          label: item.get(labelKey),
          active: item === activeItem
        };
      });
    }),

    isVisible: _ember['default'].computed('activeItem', 'breadcrumbs.[]', function () {
      return this.get('activeItem') && this.get('breadcrumbs').length > 0;
    }),

    actions: {
      navigate: function navigate(entity) {
        this.sendAction('onNavigate', entity);
      },
      mouseEnter: function mouseEnter(item) {
        this.sendAction('onMouseEnter', item);
      },
      mouseLeave: function mouseLeave(item) {
        this.sendAction('onMouseLeave', item);
      }
    }
  });
});
define("cornerstone/components/common/bread-crumbs/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 7,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/common/bread-crumbs/template.hbs"
        },
        isEmpty: false,
        arity: 1,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("li");
          var el2 = dom.createTextNode("\n    ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("a");
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element0 = dom.childAt(fragment, [1, 1]);
          var morphs = new Array(5);
          morphs[0] = dom.createAttrMorph(element0, 'onmouseenter');
          morphs[1] = dom.createAttrMorph(element0, 'onmouseleave');
          morphs[2] = dom.createAttrMorph(element0, 'class');
          morphs[3] = dom.createElementMorph(element0);
          morphs[4] = dom.createMorphAt(element0, 0, 0);
          return morphs;
        },
        statements: [["attribute", "onmouseenter", ["subexpr", "action", ["mouseEnter", ["get", "breadcrumb", ["loc", [null, [4, 39], [4, 49]]], 0, 0, 0, 0]], [], ["loc", [null, [null, null], [4, 51]]], 0, 0], 0, 0, 0, 0], ["attribute", "onmouseleave", ["subexpr", "action", ["mouseLeave", ["get", "breadcrumb", ["loc", [null, [5, 39], [5, 49]]], 0, 0, 0, 0]], [], ["loc", [null, [null, null], [5, 51]]], 0, 0], 0, 0, 0, 0], ["attribute", "class", ["concat", [["subexpr", "if", [["get", "breadcrumb.active", ["loc", [null, [6, 16], [6, 33]]], 0, 0, 0, 0], "cs-active"], [], ["loc", [null, [6, 11], [6, 47]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["navigate", ["get", "breadcrumb.entity", ["loc", [null, [3, 27], [3, 44]]], 0, 0, 0, 0]], [], ["loc", [null, [3, 7], [3, 46]]], 0, 0], ["content", "breadcrumb.label", ["loc", [null, [6, 49], [6, 69]]], 0, 0, 0, 0]],
        locals: ["breadcrumb"],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 9,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/common/bread-crumbs/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(2);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 1, 1, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["block", "each", [["get", "breadcrumbs", ["loc", [null, [1, 8], [1, 19]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [1, 0], [7, 9]]]], ["content", "yield", ["loc", [null, [8, 0], [8, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/common/confirm-modal/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({

    active: false,
    classNames: ['cs-action-modal-outer'],
    classNameBindings: ['screenClass', 'active:cs-active'],

    screenClass: _ember['default'].computed('screen', function () {
      var screen = this.get('screen');
      if (!screen) {
        return '';
      }
      return 'cs-action-modal-' + _ember['default'].String.dasherize(this.get('screen'));
    }),

    init: function init() {

      this._super.apply(this, arguments);
      var screen = this.get('screen');

      if (!screen) {
        console.warn('Confirm modals need an assigned screen');
      }

      this.set('ui.confirmHandlers.' + screen, this.confirm.bind(this));
    },

    confirm: function confirm(params) {

      params = _ember['default'].merge({

        // Callbacks. Null will always close the modal
        accept: null,
        decline: null,

        message: '',
        'class': '',
        acceptBtn: this.get('i18n').t('app.confirm-yep'),
        declineBtn: this.get('i18n').t('app.confirm-nope'),
        back: false,
        backBtn: this.get('i18n').t('app.confirm-back'),
        backBtnClass: '',
        acceptClass: '',
        declineClass: ''
      }, params);

      if (params.screen !== this.get('screen')) {
        return;
      }

      if (params.back) {
        params.declineBtn = params.backBtn;
        params.declineClass = params.backClass;
      }

      this.setProperties({
        message: params.message,
        acceptCallback: params.accept,
        declineCallback: params.decline,
        showAcceptBtn: !!params.accept,
        acceptBtn: params.acceptBtn,
        declineBtn: params.declineBtn,
        acceptClass: params.acceptClass,
        declineClass: params.declineClass
      });

      this.set('active', true);
    },

    actions: {
      accept: function accept() {
        var cb = this.get('acceptCallback');
        if ('function' === _ember['default'].typeOf(cb)) {
          cb();
        }
        this.set('active', false);
      },
      decline: function decline() {
        var cb = this.get('declineCallback');
        if ('function' === _ember['default'].typeOf(cb)) {
          cb();
        }
        this.set('active', false);
      }
    }

  });
});
define("cornerstone/components/common/confirm-modal/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 5,
              "column": 6
            },
            "end": {
              "line": 7,
              "column": 6
            }
          },
          "moduleName": "cornerstone/components/common/confirm-modal/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("        ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("button");
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element0 = dom.childAt(fragment, [1]);
          var morphs = new Array(3);
          morphs[0] = dom.createAttrMorph(element0, 'class');
          morphs[1] = dom.createElementMorph(element0);
          morphs[2] = dom.createMorphAt(element0, 0, 0);
          return morphs;
        },
        statements: [["attribute", "class", ["concat", [["get", "acceptClass", ["loc", [null, [6, 25], [6, 36]]], 0, 0, 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["accept"], [], ["loc", [null, [6, 40], [6, 59]]], 0, 0], ["content", "acceptBtn", ["loc", [null, [6, 60], [6, 73]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 12,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/common/confirm-modal/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "cs-action-modal-inner");
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("div");
        dom.setAttribute(el2, "class", "cs-action-modal-content");
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("div");
        dom.setAttribute(el3, "class", "cs-action-modal-message");
        var el4 = dom.createComment("");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("div");
        dom.setAttribute(el3, "class", "cs-action-modal-actions");
        var el4 = dom.createTextNode("\n");
        dom.appendChild(el3, el4);
        var el4 = dom.createComment("");
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("button");
        var el5 = dom.createComment("");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n    ");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n  ");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element1 = dom.childAt(fragment, [0, 1]);
        var element2 = dom.childAt(element1, [3]);
        var element3 = dom.childAt(element2, [3]);
        var morphs = new Array(5);
        morphs[0] = dom.createMorphAt(dom.childAt(element1, [1]), 0, 0);
        morphs[1] = dom.createMorphAt(element2, 1, 1);
        morphs[2] = dom.createAttrMorph(element3, 'class');
        morphs[3] = dom.createElementMorph(element3);
        morphs[4] = dom.createMorphAt(element3, 0, 0);
        return morphs;
      },
      statements: [["content", "message", ["loc", [null, [3, 41], [3, 52]]], 0, 0, 0, 0], ["block", "if", [["get", "showAcceptBtn", ["loc", [null, [5, 12], [5, 25]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [5, 6], [7, 13]]]], ["attribute", "class", ["concat", [["get", "declineClass", ["loc", [null, [8, 23], [8, 35]]], 0, 0, 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["decline"], [], ["loc", [null, [8, 39], [8, 59]]], 0, 0], ["content", "declineBtn", ["loc", [null, [8, 60], [8, 74]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/common/control-box/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({

    classNames: ['cs-control cs-control-box'],

    showHeader: _ember['default'].computed('label', function () {
      return _ember['default'].isPresent(this.get('label'));
    })

  });
});
define("cornerstone/components/common/control-box/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 5,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/common/control-box/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "cs-control-input");
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(2);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(dom.childAt(fragment, [2]), 1, 1);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", ["partials/controls/control-header"], [], ["loc", [null, [1, 0], [1, 46]]], 0, 0], ["content", "yield", ["loc", [null, [3, 2], [3, 11]]], 0, 0, 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
define('cornerstone/components/common/control-list/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    classNames: ['cs-controls'],
    actions: {
      searchNav: function searchNav(control) {
        this.sendAction('onSearchNavigate', control);
      }
    }
  });
});
define("cornerstone/components/common/control-list/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          var child0 = (function () {
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 5,
                    "column": 4
                  },
                  "end": {
                    "line": 7,
                    "column": 4
                  }
                },
                "moduleName": "cornerstone/components/common/control-list/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("      ");
                dom.appendChild(el0, el1);
                var el1 = dom.createElement("a");
                dom.setAttribute(el1, "class", "cs-control-nav");
                var el2 = dom.createComment("");
                dom.appendChild(el1, el2);
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var element0 = dom.childAt(fragment, [1]);
                var morphs = new Array(2);
                morphs[0] = dom.createElementMorph(element0);
                morphs[1] = dom.createMorphAt(element0, 0, 0);
                return morphs;
              },
              statements: [["element", "action", ["searchNav", ["get", "control", ["loc", [null, [6, 53], [6, 60]]], 0, 0, 0, 0]], [], ["loc", [null, [6, 32], [6, 63]]], 0, 0], ["inline", "fa-icon", ["search-plus"], [], ["loc", [null, [6, 64], [6, 89]]], 0, 0]],
              locals: [],
              templates: []
            };
          })();
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 4,
                  "column": 2
                },
                "end": {
                  "line": 8,
                  "column": 2
                }
              },
              "moduleName": "cornerstone/components/common/control-list/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
              dom.insertBoundary(fragment, 0);
              dom.insertBoundary(fragment, null);
              return morphs;
            },
            statements: [["block", "if", [["get", "isSearching", ["loc", [null, [5, 10], [5, 21]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [5, 4], [7, 11]]]]],
            locals: [],
            templates: [child0]
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 3,
                "column": 2
              },
              "end": {
                "line": 9,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/common/control-list/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
            dom.insertBoundary(fragment, 0);
            dom.insertBoundary(fragment, null);
            return morphs;
          },
          statements: [["block", "component", [["subexpr", "locate-component", [["subexpr", "concat", ["controls/control-", ["get", "control.type", ["loc", [null, [4, 61], [4, 73]]], 0, 0, 0, 0]], [], ["loc", [null, [4, 33], [4, 75]]], 0, 0], "controls/control-base"], [], ["loc", [null, [4, 15], [4, 101]]], 0, 0]], ["control", ["subexpr", "@mut", [["get", "control", ["loc", [null, [4, 110], [4, 117]]], 0, 0, 0, 0]], [], [], 0, 0], "hidden", ["subexpr", "or", [["subexpr", "contains", [["get", "control.id", ["loc", [null, [4, 139], [4, 149]]], 0, 0, 0, 0], ["get", "hiddenControls", ["loc", [null, [4, 150], [4, 164]]], 0, 0, 0, 0]], [], ["loc", [null, [4, 129], [4, 165]]], 0, 0], ["get", "control.isHidden", ["loc", [null, [4, 166], [4, 182]]], 0, 0, 0, 0]], [], ["loc", [null, [4, 125], [4, 183]]], 0, 0]], 0, null, ["loc", [null, [4, 2], [8, 16]]]]],
          locals: [],
          templates: [child0]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 10,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/common/control-list/template.hbs"
        },
        isEmpty: false,
        arity: 1,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "unless", [["subexpr", "contains", [["get", "control.id", ["loc", [null, [3, 22], [3, 32]]], 0, 0, 0, 0], ["get", "hiddenControls", ["loc", [null, [3, 33], [3, 47]]], 0, 0, 0, 0]], [], ["loc", [null, [3, 12], [3, 48]]], 0, 0]], [], 0, null, ["loc", [null, [3, 2], [9, 13]]]]],
        locals: ["control"],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 11,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/common/control-list/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(2);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["content", "yield", ["loc", [null, [1, 0], [1, 9]]], 0, 0, 0, 0], ["block", "each", [["get", "controls", ["loc", [null, [2, 8], [2, 16]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [2, 0], [10, 9]]]]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/common/cs-picker/component', ['exports', 'ember', 'jquery'], function (exports, _ember, _jquery) {
  exports['default'] = _ember['default'].Component.extend({

    rootSelector: '.cs-app',
    modalInPosition: false,

    classNames: ['cs-picker'],
    classNameBindings: ['class', 'open:cs-active'],
    floatingSide: 'right',
    scrollEvent: 'ps-y-reach-start ps-scroll-y ps-y-reach-end ps-x-reach-start ps-scroll-x ps-x-reach-end',
    modalMode: 'hide',

    attrModalClass: _ember['default'].computed('modalClass', function () {
      return 'cs-picker-modal ' + this.get('modalClass');
    }),

    canDisplayModal: _ember['default'].computed('modalInPosition', 'modalMode', function () {
      if ('hide' === this.get('modalMode')) {
        return true;
      }
      return this.get('modalInPosition');
    }),

    onInit: _ember['default'].on('init', function () {
      this.triggerExternalOpen();
    }),

    observeExternalOpen: _ember['default'].observer('externalOpen', function () {
      this.triggerExternalOpen();
    }),

    triggerExternalOpen: function triggerExternalOpen() {
      if (this.get('externalOpen')) {
        this.set('open', true);
      }
    },

    didInsertElement: function didInsertElement() {
      this.$modal = this.$('.cs-picker-modal');
      this.set('hasRendered', true);
      this.updatePositioning();
      // if ( this.get('debug') ) {
      //   document.addEventListener('mousemove', (e) => {
      //     this.$('.cs-picker-swatch').css({
      //       position: 'fixed',
      //       width: '200px',
      //       left: e.clientX - 50,
      //       top: e.clientY - 25
      //     });
      //     this.updatePositioning();
      //   });
      // }
    },

    observeState: _ember['default'].observer('open', function () {
      this.updatePositioning();
    }),

    updatePositioning: function updatePositioning() {
      var _this = this;

      if (!this.get('hasRendered')) {
        this.set('modalInPosition', false);
        return;
      }

      var $body = (0, _jquery['default'])('body');
      var $window = (0, _jquery['default'])(window);
      var $scrollContainer = $window;
      var $swatch = this.$('.cs-picker-swatch');
      var $el = this.$();

      var loseFocus = function loseFocus(e) {

        if ($el[0] === e.currentTarget || _this.$modal[0] === e.currentTarget || _jquery['default'].contains($el[0], e.currentTarget) || !_jquery['default'].contains(_this.get('ui.topLevelEl'), e.currentTarget) || _jquery['default'].contains(_this.$modal[0], e.currentTarget)) {
          e.stopPropagation();
          return;
        }

        $body.off('focus', '*', loseFocus);
        $body.off('click', '*', loseFocus);

        if (!_this.isDestroyed) {
          _this.set('open', false);
          _this.sendAction('onStateChange', false);
        }
      };

      var move = function move() {

        var s = $swatch[0].getBoundingClientRect();
        var m = _this.$modal[0].getBoundingClientRect();

        var offsets = {
          t: s.top - m.height,
          b: $window.height() - (s.top + m.height),
          l: s.left - m.width,
          r: $window.width() - (s.right + m.width)
        };

        var h = false;
        var v = true;

        if (offsets.t < 0) {
          v = offsets.b < 0 ? offsets.b < offsets.t : false;
        }

        if (offsets.r < 0) {
          h = offsets.l < 0 ? offsets.l > offsets.r : true;
        }

        _this.$modal.removeClass('cs-picker-floating-left huebert-floating-right').addClass(h ? 'cs-picker-floating-left' : 'cs-picker-floating-right').css({
          top: v ? s.bottom - m.height : s.top,
          left: h ? s.left - m.width : s.right
        });

        if (!_this.$modal.hasClass('cs-picker-floating')) {
          $scrollContainer.off(_this.get('scrollEvent'), move);
          $window.off('resize', move);
        }
      };

      if (this.get('open')) {

        this.$modal.detach().appendTo(this.get('rootSelector'));
        this.$modal.css('visibility', 'hidden').addClass('cs-picker-floating');
        this.$modal.removeAttr('style');
        move();

        $scrollContainer.on(this.get('scrollEvent'), move);
        $window.on('resize', move);
        $body.on('focus', '*', loseFocus);
        $body.on('click', '*', loseFocus);
        this.set('modalInPosition', true);
      } else {
        this.$modal.removeClass('cs-picker-floating cs-picker-floating-left cs-picker-floating-right');
        this.set('modalInPosition', false);
        this.$modal.detach().appendTo(this.$());
      }
    },

    willDestroy: function willDestroy() {
      this._super.apply(this, arguments);
      this.set('false');
      this.$modal.remove();
    },

    actions: {
      toggle: function toggle() {
        this.set('open', !this.get('open'));
        this.sendAction('onStateChange', this.get('open'));
      }
    }
  });
});
define("cornerstone/components/common/cs-picker/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 2
            },
            "end": {
              "line": 4,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/common/cs-picker/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("span");
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createUnsafeMorphAt(dom.childAt(fragment, [1]), 0, 0);
          return morphs;
        },
        statements: [["content", "label", ["loc", [null, [3, 10], [3, 21]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 6,
              "column": 2
            },
            "end": {
              "line": 8,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/common/cs-picker/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "component", [["get", "contentComponent", ["loc", [null, [7, 16], [7, 32]]], 0, 0, 0, 0]], [], ["loc", [null, [7, 4], [7, 34]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child2 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 12,
              "column": 2
            },
            "end": {
              "line": 14,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/common/cs-picker/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "yield", [["subexpr", "hash", [], ["open", ["get", "open", ["loc", [null, [13, 23], [13, 27]]], 0, 0, 0, 0]], ["loc", [null, [13, 12], [13, 28]]], 0, 0]], [], ["loc", [null, [13, 4], [13, 30]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 16,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/common/cs-picker/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "cs-picker-swatch");
        dom.setAttribute(el1, "tabindex", "-1");
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("div");
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element0 = dom.childAt(fragment, [0]);
        var element1 = dom.childAt(fragment, [2]);
        var morphs = new Array(6);
        morphs[0] = dom.createElementMorph(element0);
        morphs[1] = dom.createMorphAt(element0, 1, 1);
        morphs[2] = dom.createMorphAt(element0, 3, 3);
        morphs[3] = dom.createMorphAt(element0, 5, 5);
        morphs[4] = dom.createAttrMorph(element1, 'class');
        morphs[5] = dom.createMorphAt(element1, 1, 1);
        return morphs;
      },
      statements: [["element", "action", ["toggle"], [], ["loc", [null, [1, 44], [1, 63]]], 0, 0], ["block", "if", [["get", "label", ["loc", [null, [2, 8], [2, 13]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [2, 2], [4, 9]]]], ["content", "content", ["loc", [null, [5, 2], [5, 13]]], 0, 0, 0, 0], ["block", "if", [["get", "contentComponent", ["loc", [null, [6, 8], [6, 24]]], 0, 0, 0, 0]], [], 1, null, ["loc", [null, [6, 2], [8, 9]]]], ["attribute", "class", ["get", "attrModalClass", ["loc", [null, [11, 13], [11, 27]]], 0, 0, 0, 0], 0, 0, 0, 0], ["block", "if", [["get", "canDisplayModal", ["loc", [null, [12, 8], [12, 23]]], 0, 0, 0, 0]], [], 2, null, ["loc", [null, [12, 2], [14, 9]]]]],
      locals: [],
      templates: [child0, child1, child2]
    };
  })());
});
define('cornerstone/components/common/defer-view/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    classNameBindings: ['class'],
    enabled: true,
    ready: false,
    defer: true,

    show: _ember['default'].computed('ready', 'hide', function () {
      return this.get('ready') && !this.get('hide');
    }),

    didReceiveAttrs: function didReceiveAttrs() {
      if (!this.get('defer')) {
        this.set('ready', true);
      }
    },

    didInsertElement: function didInsertElement() {
      var _this = this;

      if (this.get('ready')) {
        return;
      }

      _ember['default'].run.scheduleOnce('afterRender', function () {

        var scrollBoxRect = _this.$().closest('.cs-scroll-box')[0].getBoundingClientRect();
        var myRect = _this.get('element').getBoundingClientRect();

        if (myRect.top <= scrollBoxRect.bottom && myRect.right >= scrollBoxRect.left && myRect.bottom >= scrollBoxRect.top && myRect.left <= scrollBoxRect.right) {
          _this.set('ready', true);
        } else {
          _ember['default'].run.later('afterRender', function () {
            _this.set('ready', true);
          }, 10);
        }
      });
    }

  });
});
define("cornerstone/components/common/defer-view/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 3,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/common/defer-view/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["content", "yield", ["loc", [null, [2, 2], [2, 11]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 4,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/common/defer-view/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["block", "if", [["get", "show", ["loc", [null, [1, 6], [1, 10]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [1, 0], [3, 7]]]]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/common/file-upload/component', ['exports', 'ember', 'npm:dropzone'], function (exports, _ember, _npmDropzone) {
  exports['default'] = _ember['default'].Component.extend({
    classNames: ['cs-file-upload', 'dropzone'],
    maxFiles: 1,

    didInsertElement: function didInsertElement() {

      var $blankState = this.$('[data-dropzone-template="blank-state"]');
      var $preview = this.$('[data-dropzone-template="preview"]');

      this.dropzone = new _npmDropzone['default'](this.get('element'), {
        url: 'na',
        dictDefaultMessage: $blankState.html(),
        previewTemplate: $preview.html(),
        maxFiles: this.get('maxFiles'),
        accept: function accept(file, done) {
          // if (file.name === "justinbieber.jpg") {
          //   done("Naha, you don't.");
          // }
          // else { done(); }
          done();
        }
      });

      $blankState.remove();
      $preview.remove();
    }

  });
});
define("cornerstone/components/common/file-upload/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 26,
              "column": 2
            },
            "end": {
              "line": 28,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/common/file-upload/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["content", "yield", ["loc", [null, [27, 4], [27, 13]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 28,
              "column": 2
            },
            "end": {
              "line": 35,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/common/file-upload/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("div");
          dom.setAttribute(el1, "class", "cs-file-upload-import-welcome");
          var el2 = dom.createTextNode("\n      ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("div");
          dom.setAttribute(el2, "class", "cs-file-upload-import-welcome-icon");
          var el3 = dom.createTextNode("\n        ");
          dom.appendChild(el2, el3);
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          var el3 = dom.createTextNode("\n      ");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n      ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("div");
          dom.setAttribute(el2, "class", "cs-file-upload-import-welcome-text");
          var el3 = dom.createElement("strong");
          var el4 = dom.createTextNode("Choose a header data file");
          dom.appendChild(el3, el4);
          dom.appendChild(el2, el3);
          var el3 = dom.createTextNode(" or drag it here to import.");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n    ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1, 1]), 1, 1);
          return morphs;
        },
        statements: [["inline", "cs-icon", ["interface/index-choice-import"], [], ["loc", [null, [31, 8], [31, 51]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 36,
            "column": 6
          }
        },
        "moduleName": "cornerstone/components/common/file-upload/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "data-dropzone-template", "preview");
        dom.setAttribute(el1, "style", "display: none;");
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("div");
        dom.setAttribute(el2, "class", "dz-preview dz-file-preview");
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("div");
        dom.setAttribute(el3, "class", "dz-details");
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("div");
        dom.setAttribute(el4, "class", "dz-filename");
        var el5 = dom.createTextNode("\n        ");
        dom.appendChild(el4, el5);
        var el5 = dom.createElement("span");
        dom.setAttribute(el5, "data-dz-name", "");
        dom.appendChild(el4, el5);
        var el5 = dom.createTextNode("\n      ");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("div");
        dom.setAttribute(el4, "class", "dz-size");
        dom.setAttribute(el4, "data-dz-size", "");
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("img");
        dom.setAttribute(el4, "data-dz-thumbnail", "");
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n    ");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("div");
        dom.setAttribute(el3, "class", "dz-progress");
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("span");
        dom.setAttribute(el4, "class", "dz-upload");
        dom.setAttribute(el4, "data-dz-uploadprogress", "");
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n    ");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("div");
        dom.setAttribute(el3, "class", "dz-success-mark");
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("span");
        var el5 = dom.createTextNode("✔");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n    ");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("div");
        dom.setAttribute(el3, "class", "dz-error-mark");
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("span");
        var el5 = dom.createTextNode("✘");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n    ");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("div");
        dom.setAttribute(el3, "class", "dz-error-message");
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("span");
        dom.setAttribute(el4, "data-dz-errormessage", "");
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n    ");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n  ");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "data-dropzone-template", "blank-state");
        dom.setAttribute(el1, "style", "display: none;");
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(dom.childAt(fragment, [2]), 1, 1);
        return morphs;
      },
      statements: [["block", "if", [["get", "hasBlock", ["loc", [null, [26, 8], [26, 16]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [26, 2], [35, 9]]]]],
      locals: [],
      templates: [child0, child1]
    };
  })());
});
define('cornerstone/components/common/floating-container/component', ['exports', 'ember', 'ember-click-outside/mixins/click-outside', 'ember-runloop'], function (exports, _ember, _emberClickOutsideMixinsClickOutside, _emberRunloop) {
  exports['default'] = _ember['default'].Component.extend(_emberClickOutsideMixinsClickOutside['default'], {

    classNameBindings: ['class', 'open:cs-active'],
    listening: false,

    listenWhenOpen: _ember['default'].observer('open', function () {
      this.toggleListeners(this.get('open'));
    }),

    clickOutside: function clickOutside() /* e */{
      this.sendAction('outsideClick');
    },

    toggleListeners: function toggleListeners(state) {
      var listening = this.get('listening');
      if (!state && listening) {
        //remove
        (0, _emberRunloop.cancel)(this._cancelListener);
        this.removeClickOutsideListener();
        this.set('listening', false);
      }
      if (state && !listening) {
        //add
        this._cancelListener = (0, _emberRunloop.next)(this, this.addClickOutsideListener);
        this.set('listening', true);
      }
    },

    didInsertElement: function didInsertElement() {
      this.toggleListeners(this.get('open'));
    },

    willDestroyElement: function willDestroyElement() {
      this.toggleListeners(false);
    }

  });
});
define("cornerstone/components/common/floating-container/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 2,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/common/floating-container/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["content", "yield", ["loc", [null, [1, 0], [1, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
define('cornerstone/components/common/in-view/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    classNameBindings: ['class'],
    enabled: true,

    ready: _ember['default'].computed('viewed', 'enabled', function () {
      if (!this.get('enabled')) {
        return true;
      }
      return this.get('viewed');
    }),

    init: function init() {
      this._super.apply(this, arguments);
      this.set('onScroll', this.onScroll.bind(this));
    },

    didInsertElement: function didInsertElement() {
      var _this = this;

      _ember['default'].run.scheduleOnce('afterRender', function () {
        _this.onScroll();
        if (!_this.get('ready')) {
          _this.addEventListeners();
        }
      });
    },

    addEventListeners: function addEventListeners() {
      _ember['default'].$(document).on('ps-scroll-x ps-scroll-y', this.onScroll);
      _ember['default'].$(document.body).on('scroll', this.onScroll);
    },

    removeEventListeners: function removeEventListeners() {
      _ember['default'].$(document).off('ps-scroll-x ps-scroll-y', this.onScroll);
      _ember['default'].$(document.body).off('scroll', this.onScroll);
    },

    onScroll: function onScroll() {
      this.detectScrollbox();
      var myRect = this.get('element').getBoundingClientRect();

      var scrollBoxRect = this.scrollBox.getBoundingClientRect();
      if (myRect.top <= scrollBoxRect.bottom && myRect.right >= scrollBoxRect.left && myRect.bottom >= scrollBoxRect.top && myRect.left <= scrollBoxRect.right) {
        this.set('ready', true);
        this.removeEventListeners();
      }
    },

    detectScrollbox: function detectScrollbox() {
      if (!this.scrollBox) {
        this.scrollBox = this.$().closest('.cs-scroll-box')[0];
      }
    },

    willDestroyElement: function willDestroyElement() {
      this.removeEventListeners();
    }

  });
});
define("cornerstone/components/common/in-view/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 3,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/common/in-view/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["content", "yield", ["loc", [null, [2, 2], [2, 11]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 3,
              "column": 0
            },
            "end": {
              "line": 5,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/common/in-view/template.hbs"
        },
        isEmpty: true,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          return el0;
        },
        buildRenderNodes: function buildRenderNodes() {
          return [];
        },
        statements: [],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 5,
            "column": 7
          }
        },
        "moduleName": "cornerstone/components/common/in-view/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["block", "if", [["get", "ready", ["loc", [null, [1, 6], [1, 11]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [1, 0], [5, 7]]]]],
      locals: [],
      templates: [child0, child1]
    };
  })());
});
define('cornerstone/components/common/index-entry/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({

    classNames: ['cs-index-entry'],
    classNameBindings: ['selected:cs-active', 'isNew:cs-new'],

    click: function click() {
      this.sendAction();
    },

    actions: {
      titleUpdate: function titleUpdate() {
        this.sendAction('titleUpdate');
      }
    }

  });
});
define("cornerstone/components/common/index-entry/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 2
            },
            "end": {
              "line": 4,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/common/index-entry/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("div");
          dom.setAttribute(el1, "class", "cs-index-entry-info-meta");
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createUnsafeMorphAt(dom.childAt(fragment, [1]), 0, 0);
          return morphs;
        },
        statements: [["content", "meta", ["loc", [null, [3, 40], [3, 50]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 10,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/common/index-entry/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "cs-index-entry-info");
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("h2");
        dom.setAttribute(el2, "class", "cs-index-entry-info-title");
        var el3 = dom.createComment("");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "cs-index-entry-actions");
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element0 = dom.childAt(fragment, [0]);
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(element0, 1, 1);
        morphs[1] = dom.createMorphAt(dom.childAt(element0, [3]), 0, 0);
        morphs[2] = dom.createMorphAt(dom.childAt(fragment, [2]), 1, 1);
        return morphs;
      },
      statements: [["block", "if", [["get", "meta", ["loc", [null, [2, 8], [2, 12]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [2, 2], [4, 9]]]], ["inline", "forms/inline-edit", [], ["value", ["subexpr", "@mut", [["get", "title", ["loc", [null, [5, 66], [5, 71]]], 0, 0, 0, 0]], [], [], 0, 0], "action", ["subexpr", "action", ["titleUpdate"], [], ["loc", [null, [5, 79], [5, 101]]], 0, 0]], ["loc", [null, [5, 40], [5, 103]]], 0, 0], ["content", "yield", ["loc", [null, [8, 2], [8, 11]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/common/link-out/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    tagName: 'a',
    classNameBindings: ['class'],
    attributeBindings: ['href'],
    output: _ember['default'].computed('content', function () {
      return _ember['default'].String.htmlSafe(this.get('content'));
    }),

    click: function click(e) {
      var _this = this;

      if (this.get('ui.unsavedData')) {

        e.preventDefault();
        this.get('ui').confirm({
          noSkip: true,
          message: this.get('i18n').t('app.unsaved-warning'),
          accept: function accept() {
            window.location = _this.get('href');
          },
          acceptClass: 'sad'
        });
      }
    }
  });
});
define("cornerstone/components/common/link-out/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 3,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/common/link-out/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["content", "yield", ["loc", [null, [2, 2], [2, 11]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 3,
              "column": 0
            },
            "end": {
              "line": 5,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/common/link-out/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createUnsafeMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["content", "output", ["loc", [null, [4, 2], [4, 14]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 6,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/common/link-out/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["block", "if", [["get", "hasBlock", ["loc", [null, [1, 6], [1, 14]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [1, 0], [5, 7]]]]],
      locals: [],
      templates: [child0, child1]
    };
  })());
});
define('cornerstone/components/common/loading-indicator/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    classNames: ['cs-loading-indicator'],
    attributeBindings: ['style:safeStyle'],
    safeStyle: _ember['default'].computed('style', function () {
      return _ember['default'].String.htmlSafe(this.get('style'));
    })
  });
});
define("cornerstone/components/common/loading-indicator/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 1,
            "column": 10
          }
        },
        "moduleName": "cornerstone/components/common/loading-indicator/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createTextNode("Loading...");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes() {
        return [];
      },
      statements: [],
      locals: [],
      templates: []
    };
  })());
});
define('cornerstone/components/common/preview-frame/component', ['exports', 'ember', 'cornerstone/mixins/hover-state', 'cornerstone/xfr/mixins/agent', 'cornerstone/mixins/preview-listener', 'npm:url-parse', 'npm:js-base64'], function (exports, _ember, _cornerstoneMixinsHoverState, _cornerstoneXfrMixinsAgent, _cornerstoneMixinsPreviewListener, _npmUrlParse, _npmJsBase64) {
  var Base64 = _npmJsBase64['default'].Base64;

  exports['default'] = _ember['default'].Component.extend(_cornerstoneMixinsPreviewListener['default'], _cornerstoneXfrMixinsAgent['default'], _cornerstoneMixinsHoverState['default'], {

    xfrOrigin: 'app',

    config: _ember['default'].inject.service(),
    radio: _ember['default'].inject.service('global/radio'),

    ui: _ember['default'].inject.service(),
    debugLogging: _ember['default'].computed.alias('ui.debugEnabled'),

    ready: false,
    showAsLoading: true,
    loadedOnce: false,
    loadError: false,
    allowPreviewSizer: true,
    usePreloader: true,
    canResize: true,
    state: {},
    name: 'generic',
    content: 'default',
    showStatusIndicator: false,
    statusIndicatorMode: 'loading',

    classNames: ['cs-preview-frame'],

    clientShowPreloader: true,
    preLoaderComplete: _ember['default'].computed('ready', 'clientShowPreloader', function () {
      return this.get('ready') && !this.get('clientShowPreloader');
    }),

    previewSizeClass: _ember['default'].computed('canResize', 'ui.previewSize', function () {
      if (!this.get('canResize')) {
        return;
      }
      return 'cs-preview-size-' + this.get('ui.previewSize');
    }),

    showPreviewSizer: _ember['default'].computed('allowPreviewSizer', 'ui.routeEnabledPreviewSizer', function () {
      return this.get('allowPreviewSizer') && this.get('ui.routeEnabledPreviewSizer');
    }),

    encodedState: _ember['default'].computed('state.inc', function () {
      return Base64.encode(JSON.stringify(this.get('state')));
    }),

    detectStateChange: _ember['default'].observer('src', 'state.inc', function () {
      this.generateIframeDebounce();
    }),

    generateIframeDebounce: function generateIframeDebounce() {
      _ember['default'].run.debounce(this, this.generateIframe, 215);
    },

    init: function init() {
      var _this = this;

      this._super.apply(this, arguments);

      this.componentListenTo('navigate', function (params) {
        return _this.sendAction('navigate', params);
      });

      this.componentListenTo('status-indicator', function (_ref) {
        var show = _ref.show;
        var mode = _ref.mode;

        _this.set('showStatusIndicator', show);
        _this.set('statusIndicatorMode', mode);
      });

      this.componentListenTo('pre-loader-state', function (_ref2) {
        var show = _ref2.show;

        if (!show) {
          _ember['default'].run.cancel(_this.waitForClientPreloader);
        }
        _this.set('clientShowPreloader', show);
      });

      this.componentListenTo('preview:package:setup', function (data, resolve) {
        _this.set('canUpdatePackage', true);
        resolve(_this.get('package'));
      });

      // These listeners don't need to be in the frame component
      this.componentListenTo('preview:event-propagation', function (_ref3) {
        var event = _ref3.event;
        return _this.synthesizeEvent(event);
      });
      this.componentListenTo('preview:action-propagation', function (_ref4) {
        var action = _ref4.action;
        return _this.get('ui.primaryRoute').send(action);
      });

      this.componentListenTo('preview:error-message', function (_ref5) {
        var key = _ref5.key;

        console.log('preview-error.' + key);
        _this.get('ui').notify({
          type: 'error',
          message: _this.get('i18n').t('app.preview-error.' + key),
          timeout: 15000,
          extendedTimeout: 650
        });
      });
    },

    didInsertElement: function didInsertElement() {
      this.set('rendered', true);
      this.generateIframeDebounce();
    },

    packageChange: _ember['default'].observer('package', function () {
      if (!this.get('canUpdatePackage')) {
        return;
      }
      this.message('preview:package:update', this.get('package'));
    }),

    generateIframe: function generateIframe() {
      var _this2 = this;

      if (!this.get('rendered') || this.isDestroyed) {
        return;
      }

      this.set('showAsLoading', true);
      this.set('ready', false);

      var loadFailure = function loadFailure(cb) {
        _this2.set('loadError', true);
        _this2.set('ready', true);
        if ('function' === typeof cb) {
          cb.call(_this2);
        }
      };

      this.requestHTML(_ember['default'].copy(this.get('state'))).then(function (_ref6) {
        var html = _ref6.html;
        var state = _ref6.state;

        if (_this2.isDestroyed) {
          return;
        }

        _ember['default'].run.cancel(_this2.scheduledUpdate);
        _this2.scheduledUpdate = _ember['default'].run.scheduleOnce('afterRender', function () {
          if (_this2.isDestroyed) {
            return;
          }
          var $newFrame = _ember['default'].$('<iframe />');
          _this2.$('.cs-preview-frame-container').append($newFrame);

          var frameWindow = $newFrame[0].contentWindow;

          frameWindow.document.open();
          frameWindow.document.write(html);
          frameWindow.document.close();

          // $newFrame[0].contentDocument.title = `Cornerstone Preview (${state.timestamp})`;
          _ember['default'].run.cancel(_this2.loadTimeout);
          _this2.loadTimeout = _ember['default'].run.later(function () {
            if (_this2.isDestroyed) {
              return;
            }
            loadFailure(function () {
              _this2.$('iframe').not($newFrame).remove();
              _this2.get('ui').incrementProperty('previewDelayed');
              console.warn('Preview timeout');
            });
          }, (_this2.get('ui.previewDelayed') + 1) * 15000);

          _this2.initFrame($newFrame[0], state.timestamp, function () {

            // We know the iframe has booted the preview
            _this2.$('iframe').not($newFrame).remove();
            _ember['default'].run.cancel(_this2.loadTimeout);
            _this2.set('loadError', false);
            _this2.set('ready', true);

            _this2.waitForClientPreloader = _ember['default'].run.later(function () {
              if (!_this2.isDestroyed && _this2.get('clientShowPreloader') && _this2.get('usePreloader')) {
                console.warn('The preview booted, but never requested the loader be removed.', _this2.get('ui.previewDelayed'));
                _this2.set('loadError', true);
                _this2.get('ui').incrementProperty('previewDelayed');
              }
            }, (_this2.get('ui.previewDelayed') + 1) * 15000);
          });
        });
      }, function (reason) {

        _ember['default'].Logger.warn('preview-frame::update-aborted', reason);

        if (!reason || false !== reason.error) {
          loadFailure();
        }
      });
    },

    requestHTML: function requestHTML(state) {
      var _this3 = this;

      return new _ember['default'].RSVP.Promise(function (resolve, reject) {

        var parsed = (0, _npmUrlParse['default'])(_this3.get('src'), true);
        var url = '' + parsed.origin + parsed.pathname;

        if ('/' !== url.charAt(url.length - 1)) {
          url += '/';
        }

        var timestamp = Date.now();
        state.timestamp = 't-' + timestamp; // Use a string to prevent rounding across systems.

        var data = _ember['default'].assign({}, {
          _cs_nonce: _this3.get('config.global._cs_nonce'),
          cs_preview_state: Base64.encode(JSON.stringify(state))
        }, _this3.getWithDefault('requestParams', {}), parsed.query);

        if (_this3.get('debugLogging')) {
          console.log('Requesting iFrame HTML', url, data);
        }

        _ember['default'].$.ajax({ type: 'POST', url: url, data: data }).done(function (r, textStatus, jqXHR) {

          if (_this3.get('lastUpdate') > timestamp) {
            reject({ error: false, message: 'updated since request' });
            return;
          }
          _this3.get('lastUpdate', timestamp);

          var response = jqXHR.responseText;
          var signature = 'CORNERSTONE_FRAME';

          if (_this3.get('debugLogging')) {
            console.log('Receiving iFrame HTML', jqXHR);
          }

          var index = response.lastIndexOf(signature);
          if (-1 === index || index < response.lastIndexOf('</html>')) {
            reject({ error: true, message: 'incomplete', response: response });
            return;
          }

          var html = response.slice(0, index) + response.slice(index + signature.length);
          resolve({ html: html, state: state });
        }).fail(function (jqXHR) {
          return reject(jqXHR);
        });
      });
    },

    initFrame: function initFrame(frame, time, callback) {
      var _this4 = this;

      this.closeChannel();
      var channel = new MessageChannel();
      channel.port1.addEventListener('message', this.get('xfrOnMessage'), false);
      channel.port1.start();
      this.set('messageChannel', channel);
      this.set('xfrMessagePort', channel.port1);
      // console.log('CHANNEL SETUP');

      this.set('boundiFrameLoaded', function (e) {

        if (_this4.get('debugLogging')) {
          console.log('Preview frame [' + time + '] recieving message', e);
        }

        if ('cs-preview-port-request::' + time === e.data) {
          frame.contentWindow.postMessage('cs-preview-port', '*', [channel.port2]);
          callback();
        }
      });

      window.addEventListener('message', this.get('boundiFrameLoaded'), false);
    },

    willDestroyElement: function willDestroyElement() {
      //console.log('Destroying frame');
      this.get('radio').off('outgoing:message', this.get('boundOutgoingMessage'));
      this.closeChannel();
    },

    closeChannel: function closeChannel() {
      window.removeEventListener('message', this.get('boundiFrameLoaded'), false);
      var channel = this.get('messageChannel');
      if (channel) {
        channel.port1.removeEventListener('message', this.get('xfrOnMessage'), false);
        channel.port1.close();
      }
    },

    synthesizeEvent: function synthesizeEvent(event) {

      if (['mousedown', 'mouseup', 'click'].includes(event.type)) {
        dispatchMouseEvent(event.type, event);
      } else if (['keydown', 'keypress', 'keyup'].includes(event.type)) {
        dispatchKeyboardEvent(event.type, event);
      }

      function dispatchMouseEvent(type, args) {

        var init = _ember['default'].assign({}, args, {
          'view': window,
          'bubbles': true,
          'cancelable': true
        });
        delete init.type;

        var event = new MouseEvent(type, init);

        return !!window.dispatchEvent(event);
      }

      function dispatchKeyboardEvent(type, args) {

        var init = _ember['default'].assign({}, args, {
          'view': window,
          'bubbles': true,
          'cancelable': true
        });

        delete init.type;

        var event = new KeyboardEvent(type, init);
        event.synthesizedWhich = args.which;
        return !!document.body.dispatchEvent(event);
      }
    },

    actions: {
      closeLoader: function closeLoader() {
        this.set('loadedOnce', true);
        this.set('showAsLoading', false);
      },
      reloadAfterTimeout: function reloadAfterTimeout() {
        this.set('showAsLoading', true);
        this.set('loadError', false);
        this.set('ready', false);
        this.generateIframeDebounce();
      }
    }

  });
});

// import queryString from 'npm:query-string';
define('cornerstone/components/common/preview-frame/overlay-action/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    classNames: ['cs-preview-frame-overlay-action'],
    attributeBindings: ['ui.scrollBarWidthRightStyle:style']
  });
});
define("cornerstone/components/common/preview-frame/overlay-action/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 2,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/common/preview-frame/overlay-action/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["content", "yield", ["loc", [null, [1, 0], [1, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
define('cornerstone/components/common/preview-frame/pre-loader/component', ['exports', 'ember', 'cornerstone/mixins/fadeable'], function (exports, _ember, _cornerstoneMixinsFadeable) {
  exports['default'] = _ember['default'].Component.extend(_cornerstoneMixinsFadeable['default'], {
    classNames: ['cs-pre-loader'],
    classNameBindings: ['incomplete:cs-active', 'refreshing:cs-pre-loader-semi-transparent'],
    content: 'default',
    contentPartial: _ember['default'].computed('content', function () {
      return 'iframe-loaders/' + this.get('content');
    })
  });
});
define("cornerstone/components/common/preview-frame/pre-loader/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 2,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/common/preview-frame/pre-loader/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "contentPartial", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
define('cornerstone/components/common/preview-frame/preview-sizer/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({

    classNames: ['cs-preview-sizer'],
    classNameBindings: ['sizeClass', 'active:cs-active'],

    active: _ember['default'].computed.alias('ui.showPreviewSizer'),
    size: _ember['default'].computed.alias('ui.previewSize'),

    init: function init() {
      this._super.apply(this, arguments);
      var i18n = this.get('i18n');
      var sizes = ['xl', 'lg', 'md', 'sm', 'xs'];
      var icons = {};

      sizes.forEach(function (s) {
        icons[s] = {
          icon: 'interface/preview-sizer-' + s,
          abbr: i18n.t('app.preview-sizer-abbr-' + s),
          desc: i18n.t('app.preview-sizer-desc-' + s)
        };
      });

      this.set('icons', icons);
    },

    sizeClass: _ember['default'].computed('size', function () {
      return 'cs-preview-sizer-' + this.get('size');
    }),

    actions: {
      selectSize: function selectSize(size) {
        this.set('size', size);
      }
    }

  });
});
define("cornerstone/components/common/preview-frame/preview-sizer/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 7,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/common/preview-frame/preview-sizer/template.hbs"
        },
        isEmpty: false,
        arity: 2,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("button");
          var el2 = dom.createTextNode("\n    ");
          dom.appendChild(el1, el2);
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n    ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("span");
          dom.setAttribute(el2, "class", "cs-preview-sizer-abbr");
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n    ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("span");
          dom.setAttribute(el2, "class", "cs-preview-sizer-desc");
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n  ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element0 = dom.childAt(fragment, [1]);
          var morphs = new Array(5);
          morphs[0] = dom.createAttrMorph(element0, 'class');
          morphs[1] = dom.createElementMorph(element0);
          morphs[2] = dom.createMorphAt(element0, 1, 1);
          morphs[3] = dom.createMorphAt(dom.childAt(element0, [3]), 0, 0);
          morphs[4] = dom.createMorphAt(dom.childAt(element0, [5]), 0, 0);
          return morphs;
        },
        statements: [["attribute", "class", ["concat", [["subexpr", "if", [["subexpr", "eq", [["get", "sz", ["loc", [null, [2, 26], [2, 28]]], 0, 0, 0, 0], ["get", "size", ["loc", [null, [2, 29], [2, 33]]], 0, 0, 0, 0]], [], ["loc", [null, [2, 22], [2, 34]]], 0, 0], "cs-active"], [], ["loc", [null, [2, 17], [2, 48]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["selectSize", ["get", "sz", ["loc", [null, [2, 72], [2, 74]]], 0, 0, 0, 0]], [], ["loc", [null, [2, 50], [2, 76]]], 0, 0], ["inline", "cs-icon", [["get", "item.icon", ["loc", [null, [3, 14], [3, 23]]], 0, 0, 0, 0]], [], ["loc", [null, [3, 4], [3, 25]]], 0, 0], ["content", "item.abbr", ["loc", [null, [4, 40], [4, 53]]], 0, 0, 0, 0], ["content", "item.desc", ["loc", [null, [5, 40], [5, 53]]], 0, 0, 0, 0]],
        locals: ["sz", "item"],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 7,
            "column": 12
          }
        },
        "moduleName": "cornerstone/components/common/preview-frame/preview-sizer/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["block", "each-in", [["get", "icons", ["loc", [null, [1, 11], [1, 16]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [1, 0], [7, 12]]]]],
      locals: [],
      templates: [child0]
    };
  })());
});
define("cornerstone/components/common/preview-frame/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 3,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/common/preview-frame/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["content", "common/preview-frame/preview-sizer", ["loc", [null, [2, 2], [2, 40]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 7,
                "column": 4
              },
              "end": {
                "line": 14,
                "column": 4
              }
            },
            "moduleName": "cornerstone/components/common/preview-frame/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("      ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            return morphs;
          },
          statements: [["inline", "common/preview-frame/pre-loader", [], ["refreshing", ["subexpr", "@mut", [["get", "loadedOnce", ["loc", [null, [9, 19], [9, 29]]], 0, 0, 0, 0]], [], [], 0, 0], "complete", ["subexpr", "@mut", [["get", "preLoaderComplete", ["loc", [null, [10, 17], [10, 34]]], 0, 0, 0, 0]], [], [], 0, 0], "onComplete", ["subexpr", "action", ["closeLoader"], [], ["loc", [null, [11, 19], [11, 41]]], 0, 0], "content", ["subexpr", "@mut", [["get", "preloader", ["loc", [null, [12, 16], [12, 25]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [8, 6], [13, 8]]], 0, 0]],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 6,
              "column": 2
            },
            "end": {
              "line": 15,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/common/preview-frame/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "if", [["get", "showAsLoading", ["loc", [null, [7, 10], [7, 23]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [7, 4], [14, 11]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    var child2 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 16,
              "column": 2
            },
            "end": {
              "line": 29,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/common/preview-frame/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("div");
          dom.setAttribute(el1, "class", "cs-preview-load-error-outer cs-active");
          var el2 = dom.createTextNode("\n      ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("div");
          dom.setAttribute(el2, "class", "cs-preview-load-error-inner");
          var el3 = dom.createTextNode("\n        ");
          dom.appendChild(el2, el3);
          var el3 = dom.createElement("div");
          dom.setAttribute(el3, "class", "cs-action-modal-content");
          var el4 = dom.createTextNode("\n          ");
          dom.appendChild(el3, el4);
          var el4 = dom.createElement("div");
          dom.setAttribute(el4, "class", "cs-action-modal-message");
          var el5 = dom.createTextNode("\n            ");
          dom.appendChild(el4, el5);
          var el5 = dom.createElement("p");
          var el6 = dom.createTextNode("A conflict on the front end of your site has prevented the preview from loading.");
          dom.appendChild(el5, el6);
          dom.appendChild(el4, el5);
          var el5 = dom.createTextNode("\n          ");
          dom.appendChild(el4, el5);
          dom.appendChild(el3, el4);
          var el4 = dom.createTextNode("\n          ");
          dom.appendChild(el3, el4);
          var el4 = dom.createElement("div");
          dom.setAttribute(el4, "class", "cs-action-modal-actions");
          var el5 = dom.createTextNode("\n            ");
          dom.appendChild(el4, el5);
          var el5 = dom.createElement("button");
          var el6 = dom.createTextNode("Try again");
          dom.appendChild(el5, el6);
          dom.appendChild(el4, el5);
          var el5 = dom.createTextNode("\n          ");
          dom.appendChild(el4, el5);
          dom.appendChild(el3, el4);
          var el4 = dom.createTextNode("\n        ");
          dom.appendChild(el3, el4);
          dom.appendChild(el2, el3);
          var el3 = dom.createTextNode("\n      ");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n    ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element0 = dom.childAt(fragment, [1, 1, 1, 3, 1]);
          var morphs = new Array(1);
          morphs[0] = dom.createElementMorph(element0);
          return morphs;
        },
        statements: [["element", "action", ["reloadAfterTimeout"], [], ["loc", [null, [24, 20], [24, 51]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 32,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/common/preview-frame/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("div");
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element1 = dom.childAt(fragment, [3]);
        var morphs = new Array(6);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 1, 1, contextualElement);
        morphs[2] = dom.createAttrMorph(element1, 'class');
        morphs[3] = dom.createMorphAt(element1, 1, 1);
        morphs[4] = dom.createMorphAt(element1, 2, 2);
        morphs[5] = dom.createMorphAt(element1, 4, 4);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["block", "if", [["get", "showPreviewSizer", ["loc", [null, [1, 6], [1, 22]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [1, 0], [3, 7]]]], ["inline", "common/status-indicator", [], ["active", ["subexpr", "@mut", [["get", "showStatusIndicator", ["loc", [null, [4, 33], [4, 52]]], 0, 0, 0, 0]], [], [], 0, 0], "mode", ["subexpr", "@mut", [["get", "statusIndicatorMode", ["loc", [null, [4, 58], [4, 77]]], 0, 0, 0, 0]], [], [], 0, 0], "style", ["subexpr", "@mut", [["get", "ui.scrollBarWidthRightStyle", ["loc", [null, [4, 84], [4, 111]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [4, 0], [4, 113]]], 0, 0], ["attribute", "class", ["concat", ["cs-preview-frame-container ", ["get", "previewSizeClass", ["loc", [null, [5, 41], [5, 57]]], 0, 0, 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["block", "if", [["get", "usePreloader", ["loc", [null, [6, 8], [6, 20]]], 0, 0, 0, 0]], [], 1, null, ["loc", [null, [6, 2], [15, 9]]]], ["block", "if", [["get", "loadError", ["loc", [null, [16, 8], [16, 17]]], 0, 0, 0, 0]], [], 2, null, ["loc", [null, [16, 2], [29, 9]]]], ["content", "yield", ["loc", [null, [30, 2], [30, 11]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0, child1, child2]
    };
  })());
});
define('cornerstone/components/common/scroll-box/component', ['exports', 'ember', 'npm:perfect-scrollbar'], function (exports, _ember, _npmPerfectScrollbar) {
  exports['default'] = _ember['default'].Component.extend({

    classNameBindings: ['enabled:cs-scroll-box:cs-scroll-box-disabled', 'name'],
    enabled: true,
    ready: false,
    initialized: false,
    autoRefresh: false, // 150,
    scrollEvents: ['ps-scroll-y', 'ps-y-reach-start', 'ps-y-reach-end', 'ps-scroll-x', 'ps-x-reach-start', 'ps-x-reach-end'],

    horizontalScrollSupport: _ember['default'].computed.alias('ui.horizontalScrollSupport'),

    configChange: _ember['default'].observer('horizontalScrollSupport', function () {
      this.psInit();
    }),

    psInit: function psInit() {

      var el = this.get('element');
      var useBothWheelAxes = !this.get('horizontalScrollSupport');

      el.removeEventListener('wheel', this.get('wheelCheck'));
      if (useBothWheelAxes) {
        el.addEventListener('wheel', this.get('wheelCheck'));
      }

      _npmPerfectScrollbar['default'].destroy(el);
      _npmPerfectScrollbar['default'].initialize(el, {
        wheelSpeed: 2,
        scrollYMarginOffset: 0,
        scrollXMarginOffset: 0,
        wheelPropagation: false,
        swipePropagation: false,
        useBothWheelAxes: useBothWheelAxes,
        minScrollbarLength: 20
      });
    },

    wheelCheck: function wheelCheck(e) {
      if (Math.abs(e.deltaX) > 0) {
        this.set('ui.horizontalScrollSupport', true);
      }
    },

    init: function init() {
      this._super.apply(this, arguments);
      this.set('scrollHander', this.get('scrollHander').bind(this));
      this.set('wheelCheck', this.get('wheelCheck').bind(this));
      this.get('searchTarget');
    },

    scrollHander: function scrollHander(e) {

      if (e.target !== this.get('element')) {
        return;
      }

      // Note: improper use of run.debounce
      _ember['default'].run.debounce(this, function () {
        this.sendAction('onScroll', this, this.get('element'), e.type);
      }, 25);
    },

    setupTeardown: _ember['default'].observer('ready', function () {
      if (!this.get('ready')) {
        _ember['default'].run.cancel(this.autoRefreshSchedule);
      }

      this.refresh();
    }),

    enabledChanged: _ember['default'].observer('enabled', function () {

      if (!this.get('ready')) {
        return;
      }

      _ember['default'].run(this, this.refresh);
    }),

    refresh: function refresh() {

      if (this.get('enabled')) {

        if (this.get('initialized')) {

          _npmPerfectScrollbar['default'].update(this.get('element'));
        } else {

          this.psInit();

          this.get('scrollEvents').forEach((function (event) {
            document.addEventListener(event, this.get('scrollHander'));
          }).bind(this));

          this.set('initialized', true);
          var _scrollTo = this.get('scrollTo');
          if (_scrollTo) {
            this.updateScrollTo(_scrollTo);
          }
        }

        if (this.get('autoRefresh')) {
          this.autoRefreshSchedule = _ember['default'].run.later(this, this.refresh, this.get('autoRefresh'));
        }
      } else if (this.get('element') && this.get('initialized')) {
        this.tearDown();
      }
    },

    tearDown: function tearDown() {
      _npmPerfectScrollbar['default'].destroy(this.get('element'));
      this.set('initialized', false);
    },

    didInsertElement: function didInsertElement() {
      this._super.apply(this, arguments);
      this.set('ready', true);
    },

    willDestroyElement: function willDestroyElement() {
      this.set('ready', false);
      if (this.get('initialized')) {
        this.tearDown();
      }

      this.get('element').removeEventListener('wheel', this.get('wheelCheck'));
      this.get('scrollEvents').forEach((function (event) {
        document.removeEventListener(event, this.get('scrollHander'));
      }).bind(this));
    },

    scrollToObserver: _ember['default'].observer('scrollTo', function () {
      this.updateScrollTo(this.get('scrollTo'));
    }),

    updateScrollTo: function updateScrollTo(params) {

      var el = this.get('element');
      if (!this.get('initialized') || !el) {
        return;
      }

      var left = 0;
      var top = 0;

      if (!params.start) {
        var $scrollTo = params.$el ? params.$el : this.$(params.selector).first();

        if ($scrollTo.length > 0) {
          left = $scrollTo.position().left + el.scrollLeft;
          top = $scrollTo.position().top + el.scrollTop;
        }
      }

      var offset = isNaN(params.offset) ? 0 : params.offset;
      var atts = params.horizontal ? { scrollLeft: left + offset } : { scrollTop: top + offset };

      this.set('isScrollingTo', true);

      this.$().animate(atts, {
        duration: isNaN(params.duration) ? 450 : params.duration,
        //easing: 'easeOutExpo',
        complete: (function () {
          if (!this.isDestroyed) {
            _npmPerfectScrollbar['default'].update(el);
            this.set('isScrollingTo', false);
            if (params.reset) {
              _npmPerfectScrollbar['default'].update(el);
            }
            if ('function' === _ember['default'].typeOf(params.after)) {
              params.after();
            }
          }
        }).bind(this)
      });
    },

    search: _ember['default'].inject.service(),
    searchTarget: _ember['default'].computed('linkedSearch', function () {
      return this.get('search').getTarget(this.get('linkedSearch'));
    }),

    resetScroll: _ember['default'].observer('searchTarget.query', 'resetScrollOn', 'resetScrollOn.[]', function () {

      var el = this.get('element');

      // Note: improper use of run.debounce
      _ember['default'].run.debounce(this, function () {

        _ember['default'].run.scheduleOnce('afterRender', function () {
          el.scrollTop = 0;
          el.scrollLeft = 0;
          _npmPerfectScrollbar['default'].update(el);
        });
      }, 25);
    })

  });
});
define("cornerstone/components/common/scroll-box/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 1,
            "column": 9
          }
        },
        "moduleName": "cornerstone/components/common/scroll-box/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["content", "yield", ["loc", [null, [1, 0], [1, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
define('cornerstone/components/common/search-bar/component', ['exports', 'ember', 'cornerstone/mixins/keyboard-shortcuts/component'], function (exports, _ember, _cornerstoneMixinsKeyboardShortcutsComponent) {
  exports['default'] = _ember['default'].Component.extend(_cornerstoneMixinsKeyboardShortcutsComponent['default'], {
    classNameBindings: ['customClass'],
    customClass: 'cs-search-bar',

    keyboardShortcuts: {
      'esc': 'clear',
      'find': 'focus'
    },

    focusOnShortcut: true,
    autoFocus: false,
    showIcon: true,

    search: _ember['default'].inject.service(),
    searchTarget: _ember['default'].computed('target', function () {
      return this.get('search').getTarget(this.get('target'));
    }),

    isSearching: _ember['default'].computed.alias('query', function () {
      return !!this.get('query');
    }),

    init: function init() {
      this._super.apply(this, arguments);

      if (_ember['default'].isNone(this.get('query'))) {
        _ember['default'].defineProperty(this, 'query', _ember['default'].computed.alias('searchTarget.query'));
        this.get('searchTarget');
      }
    },

    didInsertElement: function didInsertElement() {
      this.updateInput();
      if (this.get('autoFocus')) {
        this.$('input[type=search]').focus();
      }
    },

    updateQuery: _ember['default'].observer('query', function () {

      if (this.get('query') !== this.$('input[type=search]').val()) {
        this.updateInput();
      }
    }),

    updateInput: function updateInput() {
      this.$('input[type=search]').val(this.get('query'));
    },

    keyUp: function keyUp() {
      this.set('query', this.$('input[type=search]').val());
    },

    actions: {
      clear: function clear() {
        this.set('query', '');
      },
      focus: function focus() {
        if (this.get('focusOnShortcut')) {
          this.$('input[type=search]').focus();
        }
      }
    }

  });
});
define("cornerstone/components/common/search-bar/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 2,
              "column": 49
            }
          },
          "moduleName": "cornerstone/components/common/search-bar/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createElement("span");
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(dom.childAt(fragment, [0]), 0, 0);
          return morphs;
        },
        statements: [["inline", "fa-icon", ["search"], [], ["loc", [null, [2, 22], [2, 42]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 3,
              "column": 0
            },
            "end": {
              "line": 3,
              "column": 86
            }
          },
          "moduleName": "cornerstone/components/common/search-bar/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createElement("span");
          dom.setAttribute(el1, "class", "cs-clear");
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element0 = dom.childAt(fragment, [0]);
          var morphs = new Array(2);
          morphs[0] = dom.createElementMorph(element0);
          morphs[1] = dom.createMorphAt(element0, 0, 0);
          return morphs;
        },
        statements: [["element", "action", ["clear"], [], ["loc", [null, [3, 41], [3, 59]]], 0, 0], ["inline", "fa-icon", ["close"], [], ["loc", [null, [3, 60], [3, 79]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 3,
            "column": 93
          }
        },
        "moduleName": "cornerstone/components/common/search-bar/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("input");
        dom.setAttribute(el1, "type", "search");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element1 = dom.childAt(fragment, [0]);
        var morphs = new Array(4);
        morphs[0] = dom.createAttrMorph(element1, 'class');
        morphs[1] = dom.createAttrMorph(element1, 'placeholder');
        morphs[2] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[3] = dom.createMorphAt(fragment, 4, 4, contextualElement);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["attribute", "class", ["concat", [["subexpr", "if", [["get", "noFocus", ["loc", [null, [1, 19], [1, 26]]], 0, 0, 0, 0], "cs-no-input-focus"], [], ["loc", [null, [1, 14], [1, 48]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["attribute", "placeholder", ["concat", [["get", "placeholder", ["loc", [null, [1, 79], [1, 90]]], 0, 0, 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["block", "if", [["get", "showIcon", ["loc", [null, [2, 6], [2, 14]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [2, 0], [2, 56]]]], ["block", "if", [["get", "isSearching", ["loc", [null, [3, 6], [3, 17]]], 0, 0, 0, 0]], [], 1, null, ["loc", [null, [3, 0], [3, 93]]]]],
      locals: [],
      templates: [child0, child1]
    };
  })());
});
define('cornerstone/components/common/sortable-container/component', ['exports', 'ember', 'cornerstone/vendor/dragula/dragula'], function (exports, _ember, _cornerstoneVendorDragulaDragula) {
  exports['default'] = _ember['default'].Component.extend({
    tagName: 'ul',
    classNames: ['cs-sortable'],
    classNameBindings: ['isDragging:cs-sorting', 'condensed:cs-sortable-condensed'],
    condensed: true,
    isDragging: false,
    didInsertElement: function didInsertElement() {

      var drake = (0, _cornerstoneVendorDragulaDragula['default'])({
        offset: function offset(_offset, e, item) {
          _offset.y = window.jQuery(item).height() / 2; // snap to vertical center
          return _offset;
        },
        revertOnSpill: true,
        mirrorContainer: this.get('element')
      });

      drake.containers.push(this.get('element'));
      var self = this;

      drake.on('drag', function () /* el */{
        self.set('isDragging', true);
      });

      drake.on('dragend', function () /* el */{
        self.set('isDragging', false);
      });

      drake.on('drop', function (el, target, source, sibling) {
        window.jQuery(el).trigger('dragula:drop', window.jQuery(sibling).index() - 1);
      });
    }
  });
});
define("cornerstone/components/common/sortable-container/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 2,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/common/sortable-container/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["content", "yield", ["loc", [null, [1, 0], [1, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
define('cornerstone/components/common/sortable-item/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({

    tagName: 'li',
    classNames: ['sortable-item'],
    classNameBindings: ['active:cs-active', 'isHovering:cs-hover'],

    canEditLabel: true,
    canQuickDelete: true,
    showAddAfter: false,

    deleteConfirm: _ember['default'].computed('ui.deleteConfirm', function () {
      return this.get('canQuickDelete') && this.get('ui.deleteConfirm');
    }),

    canShowAddAfter: _ember['default'].computed('showAddAfter', 'onAddAfter', function () {
      return this.get('showAddAfter') && this.get('onAddAfter');
    }),

    didInsertElement: function didInsertElement() {
      var _this = this;

      this.$().on('dragula:drop', (function (e, index) {
        this.sendAction('onDrop', this.get('item'), index, e);
      }).bind(this));

      this.$().on('mouseenter', '.handle, .controls', function () {
        _this.set('isHovering', true);
        _this.sendAction('onMouseEnter');
      }).on('mouseleave', '.handle, .controls', function () {
        _this.set('isHovering', false);
        _this.sendAction('onMouseLeave');
      });
    },

    actions: {
      select: function select() {
        this.sendAction('onSelect');
      },
      inspect: function inspect() {
        this.sendAction('onInspect');
      },
      duplicate: function duplicate() {
        this.sendAction('onDuplicate');
      },
      'delete': function _delete() {
        this.sendAction('onDelete');
      },
      addBefore: function addBefore() {
        this.sendAction('onAddBefore');
      },
      addAfter: function addAfter() {
        this.sendAction('onAddAfter');
      }
    }
  });
});
define("cornerstone/components/common/sortable-item/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 3,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/common/sortable-item/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("button");
          dom.setAttribute(el1, "class", "cs-add-sortable-item-inline");
          var el2 = dom.createElement("span");
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          var el3 = dom.createTextNode(" Add");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element4 = dom.childAt(fragment, [1]);
          var morphs = new Array(2);
          morphs[0] = dom.createElementMorph(element4);
          morphs[1] = dom.createMorphAt(dom.childAt(element4, [0]), 0, 0);
          return morphs;
        },
        statements: [["element", "action", ["addBefore"], [], ["loc", [null, [2, 10], [2, 32]]], 0, 0], ["inline", "fa-icon", ["plus"], [], ["loc", [null, [2, 75], [2, 93]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 14,
              "column": 2
            },
            "end": {
              "line": 16,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/common/sortable-item/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("button");
          dom.setAttribute(el1, "class", "cs-icon");
          dom.setAttribute(el1, "title", "Inspect");
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element3 = dom.childAt(fragment, [1]);
          var morphs = new Array(2);
          morphs[0] = dom.createElementMorph(element3);
          morphs[1] = dom.createMorphAt(element3, 0, 0);
          return morphs;
        },
        statements: [["element", "action", ["inspect"], [], ["loc", [null, [15, 12], [15, 32]]], 0, 0], ["inline", "fa-icon", ["search"], [], ["loc", [null, [15, 65], [15, 85]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child2 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 17,
              "column": 2
            },
            "end": {
              "line": 19,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/common/sortable-item/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("button");
          dom.setAttribute(el1, "class", "cs-icon");
          dom.setAttribute(el1, "title", "Duplicate");
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element2 = dom.childAt(fragment, [1]);
          var morphs = new Array(2);
          morphs[0] = dom.createElementMorph(element2);
          morphs[1] = dom.createMorphAt(element2, 0, 0);
          return morphs;
        },
        statements: [["element", "action", ["duplicate"], [], ["loc", [null, [18, 12], [18, 34]]], 0, 0], ["inline", "fa-icon", ["copy"], [], ["loc", [null, [18, 69], [18, 87]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child3 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 20,
              "column": 2
            },
            "end": {
              "line": 22,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/common/sortable-item/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("button");
          dom.setAttribute(el1, "title", "Delete");
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element1 = dom.childAt(fragment, [1]);
          var morphs = new Array(3);
          morphs[0] = dom.createAttrMorph(element1, 'class');
          morphs[1] = dom.createElementMorph(element1);
          morphs[2] = dom.createMorphAt(element1, 0, 0);
          return morphs;
        },
        statements: [["attribute", "class", ["concat", ["cs-icon ", ["subexpr", "if", [["get", "deleteConfirm", ["loc", [null, [21, 73], [21, 86]]], 0, 0, 0, 0], "cs-danger"], [], ["loc", [null, [21, 67], [21, 100]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["delete"], ["allowedKeys", "shift"], ["loc", [null, [21, 12], [21, 51]]], 0, 0], ["inline", "fa-icon", ["trash-o"], [], ["loc", [null, [21, 117], [21, 138]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child4 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 25,
              "column": 0
            },
            "end": {
              "line": 27,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/common/sortable-item/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("button");
          dom.setAttribute(el1, "class", "cs-add-sortable-item-inline bottom");
          var el2 = dom.createElement("span");
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          var el3 = dom.createTextNode(" Add");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element0 = dom.childAt(fragment, [1]);
          var morphs = new Array(2);
          morphs[0] = dom.createElementMorph(element0);
          morphs[1] = dom.createMorphAt(dom.childAt(element0, [0]), 0, 0);
          return morphs;
        },
        statements: [["element", "action", ["addAfter"], [], ["loc", [null, [26, 10], [26, 31]]], 0, 0], ["inline", "fa-icon", ["plus"], [], ["loc", [null, [26, 81], [26, 99]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 28,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/common/sortable-item/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("span");
        dom.setAttribute(el1, "class", "handle");
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "controls");
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element5 = dom.childAt(fragment, [1]);
        var element6 = dom.childAt(fragment, [3]);
        var morphs = new Array(8);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createElementMorph(element5);
        morphs[2] = dom.createMorphAt(element5, 1, 1);
        morphs[3] = dom.createMorphAt(element6, 1, 1);
        morphs[4] = dom.createMorphAt(element6, 2, 2);
        morphs[5] = dom.createMorphAt(element6, 3, 3);
        morphs[6] = dom.createMorphAt(element6, 5, 5);
        morphs[7] = dom.createMorphAt(fragment, 5, 5, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["block", "if", [["get", "onAddBefore", ["loc", [null, [1, 6], [1, 17]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [1, 0], [3, 7]]]], ["element", "action", ["select"], [], ["loc", [null, [4, 21], [4, 40]]], 0, 0], ["inline", "forms/inline-edit", [], ["class", "label", "value", ["subexpr", "@mut", [["get", "label", ["loc", [null, [7, 10], [7, 15]]], 0, 0, 0, 0]], [], [], 0, 0], "enabled", ["subexpr", "@mut", [["get", "canEditLabel", ["loc", [null, [8, 12], [8, 24]]], 0, 0, 0, 0]], [], [], 0, 0], "placeholder", ["subexpr", "@mut", [["get", "labelPlaceholder", ["loc", [null, [9, 16], [9, 32]]], 0, 0, 0, 0]], [], [], 0, 0], "invalid", ["subexpr", "@mut", [["get", "labelInvalid", ["loc", [null, [10, 12], [10, 24]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [5, 2], [11, 4]]], 0, 0], ["block", "if", [["get", "onInspect", ["loc", [null, [14, 8], [14, 17]]], 0, 0, 0, 0]], [], 1, null, ["loc", [null, [14, 2], [16, 9]]]], ["block", "if", [["get", "onDuplicate", ["loc", [null, [17, 8], [17, 19]]], 0, 0, 0, 0]], [], 2, null, ["loc", [null, [17, 2], [19, 9]]]], ["block", "if", [["get", "onDelete", ["loc", [null, [20, 8], [20, 16]]], 0, 0, 0, 0]], [], 3, null, ["loc", [null, [20, 2], [22, 9]]]], ["content", "yield", ["loc", [null, [23, 2], [23, 11]]], 0, 0, 0, 0], ["block", "if", [["get", "canShowAddAfter", ["loc", [null, [25, 6], [25, 21]]], 0, 0, 0, 0]], [], 4, null, ["loc", [null, [25, 0], [27, 7]]]]],
      locals: [],
      templates: [child0, child1, child2, child3, child4]
    };
  })());
});
define('cornerstone/components/common/status-indicator/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    classNames: ['cs-status-indicator'],
    classNameBindings: ['active:cs-active', 'mode'],
    attributeBindings: ['style']
  });
});
define("cornerstone/components/common/status-indicator/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 1,
            "column": 28
          }
        },
        "moduleName": "cornerstone/components/common/status-indicator/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["content", "common/loading-indicator", ["loc", [null, [1, 0], [1, 28]]], 0, 0, 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
define('cornerstone/components/common/tab-modal/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    classNames: ['cs-tab-modal'],
    classNameBindings: ['active:cs-active'],

    selectedTab: false,

    activeTab: _ember['default'].computed('selectedTab', 'panels', function () {

      var panels = this.get('panels');
      var selectedTab = this.get('selectedTab');

      var filtered = panels.filter(function (item) {
        return item.name === selectedTab;
      });

      if (_ember['default'].isEmpty(filtered)) {
        filtered = panels;
      }

      return filtered.get('firstObject').name;
    }),

    activeLabel: _ember['default'].computed('activeTab', function () {

      var activeTab = this.get('activeTab');

      return this.get('navItems').filter(function (item) {
        return item.name === activeTab;
      }).get('firstObject.label');
    }),

    activeContent: _ember['default'].computed('activeTab', 'panels', function () {

      var activeTab = this.get('activeTab');

      return this.get('panels').filter(function (item) {
        return item.name === activeTab;
      }).get('firstObject.content');
    }),

    actions: {
      close: function close() {
        this.set('active', false);
      },
      nav: function nav(tab) {
        this.set('selectedTab', tab);
      }
    }
  });
});
define("cornerstone/components/common/tab-modal/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 8,
              "column": 8
            },
            "end": {
              "line": 10,
              "column": 8
            }
          },
          "moduleName": "cornerstone/components/common/tab-modal/template.hbs"
        },
        isEmpty: false,
        arity: 1,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("          ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("button");
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element0 = dom.childAt(fragment, [1]);
          var morphs = new Array(3);
          morphs[0] = dom.createAttrMorph(element0, 'class');
          morphs[1] = dom.createElementMorph(element0);
          morphs[2] = dom.createMorphAt(element0, 0, 0);
          return morphs;
        },
        statements: [["attribute", "class", ["concat", [["subexpr", "if", [["subexpr", "eq", [["get", "activeTab", ["loc", [null, [9, 60], [9, 69]]], 0, 0, 0, 0], ["get", "nav.name", ["loc", [null, [9, 70], [9, 78]]], 0, 0, 0, 0]], [], ["loc", [null, [9, 56], [9, 79]]], 0, 0], "cs-active"], [], ["loc", [null, [9, 51], [9, 93]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["nav", ["get", "nav.name", ["loc", [null, [9, 33], [9, 41]]], 0, 0, 0, 0]], [], ["loc", [null, [9, 18], [9, 43]]], 0, 0], ["content", "nav.label", ["loc", [null, [9, 95], [9, 108]]], 0, 0, 0, 0]],
        locals: ["nav"],
        templates: []
      };
    })();
    var child1 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 14,
                "column": 10
              },
              "end": {
                "line": 16,
                "column": 10
              }
            },
            "moduleName": "cornerstone/components/common/tab-modal/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("            ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            return morphs;
          },
          statements: [["inline", "yield", [["subexpr", "hash", [], ["activeTab", ["get", "activeTab", ["loc", [null, [15, 36], [15, 45]]], 0, 0, 0, 0]], ["loc", [null, [15, 20], [15, 46]]], 0, 0]], [], ["loc", [null, [15, 12], [15, 48]]], 0, 0]],
          locals: [],
          templates: []
        };
      })();
      var child1 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 16,
                "column": 10
              },
              "end": {
                "line": 18,
                "column": 10
              }
            },
            "moduleName": "cornerstone/components/common/tab-modal/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("            ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createUnsafeMorphAt(fragment, 1, 1, contextualElement);
            return morphs;
          },
          statements: [["content", "activeContent", ["loc", [null, [17, 12], [17, 31]]], 0, 0, 0, 0]],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 13,
              "column": 8
            },
            "end": {
              "line": 19,
              "column": 8
            }
          },
          "moduleName": "cornerstone/components/common/tab-modal/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "if", [["get", "hasBlock", ["loc", [null, [14, 16], [14, 24]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [14, 10], [18, 17]]]]],
        locals: [],
        templates: [child0, child1]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 24,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/common/tab-modal/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("button");
        dom.setAttribute(el1, "class", "cs-tab-modal-close");
        dom.setAttribute(el1, "aria-label", "Close");
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("span");
        var el3 = dom.createTextNode("×");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "cs-tab-modal-content-outer");
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("div");
        dom.setAttribute(el2, "class", "cs-tab-modal-content-inner");
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("div");
        dom.setAttribute(el3, "class", "cs-tab-modal-content");
        dom.setAttribute(el3, "role", "document");
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("nav");
        var el5 = dom.createTextNode("\n");
        dom.appendChild(el4, el5);
        var el5 = dom.createComment("");
        dom.appendChild(el4, el5);
        var el5 = dom.createTextNode("      ");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("article");
        var el5 = dom.createTextNode("\n");
        dom.appendChild(el4, el5);
        var el5 = dom.createComment("");
        dom.appendChild(el4, el5);
        var el5 = dom.createTextNode("      ");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n    ");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n  ");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element1 = dom.childAt(fragment, [0]);
        var element2 = dom.childAt(fragment, [2, 1, 1]);
        var morphs = new Array(3);
        morphs[0] = dom.createElementMorph(element1);
        morphs[1] = dom.createMorphAt(dom.childAt(element2, [1]), 1, 1);
        morphs[2] = dom.createMorphAt(dom.childAt(element2, [3]), 1, 1);
        return morphs;
      },
      statements: [["element", "action", ["close"], [], ["loc", [null, [1, 8], [1, 26]]], 0, 0], ["block", "each", [["get", "panels", ["loc", [null, [8, 16], [8, 22]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [8, 8], [10, 17]]]], ["block", "common/scroll-box", [], [], 1, null, ["loc", [null, [13, 8], [19, 30]]]]],
      locals: [],
      templates: [child0, child1]
    };
  })());
});
define('cornerstone/components/common/welcome-message/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    classNames: ['cs-welcome']
  });
});
define("cornerstone/components/common/welcome-message/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 3,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/common/welcome-message/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("h3");
          dom.setAttribute(el1, "class", "cs-welcome-title");
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1]), 0, 0);
          return morphs;
        },
        statements: [["content", "title", ["loc", [null, [2, 31], [2, 40]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 5,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/common/welcome-message/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(2);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 1, 1, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["block", "if", [["get", "title", ["loc", [null, [1, 6], [1, 11]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [1, 0], [3, 7]]]], ["content", "yield", ["loc", [null, [4, 0], [4, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-base/component', ['exports', 'ember', 'cornerstone/util/deep-assign'], function (exports, _ember, _cornerstoneUtilDeepAssign) {

  var ControlBase = _ember['default'].Component.extend({

    level: 1,
    firstLevel: _ember['default'].computed.equal('level', 1),
    deeplyNested: _ember['default'].computed.gt('level', 2),

    headerTemplate: _ember['default'].computed('level', function () {
      return this.get('firstLevel') ? 'partials/controls/control-header' : 'partials/controls/input-list-item-header';
    }),

    classNameBindings: ['baseClasses', 'isHidden:cs-hide', 'class'],
    attributeBindings: ['groupName:data-cs-control-group-name', 'control.id:data-cs-control-id'],
    groupName: _ember['default'].computed.alias('control.group'),

    containerClass: _ember['default'].computed(function () {

      var classes = [];

      if (!this.get('firstLevel')) {

        classes.push('cs-control-input-list-input');
        // classes.push( `cs-control-input-list-input-${this.get('level')}`);

        var height = undefined;
        var defaultHeight = this.get('defaultHeight');
        var mappedHeight = this.get('control.options.height');

        if (_ember['default'].isPresent(defaultHeight)) {
          height = defaultHeight;
        }

        if (_ember['default'].isPresent(mappedHeight)) {
          height = mappedHeight;
        }

        if (_ember['default'].isPresent(height)) {
          classes.push('cs-control-input-list-input-height-' + height);
        }
      } else {
        classes.push('cs-control-input');
      }

      return classes.join(' ');
    }),

    // Todo: Stop using these aliases since we're moving into control aggregates which have variable keys

    options: _ember['default'].computed.alias('control.options'),
    value: _ember['default'].computed.alias('control.keyValue'),

    service: _ember['default'].inject.service('controls'),

    baseClasses: _ember['default'].computed('control.type', 'control.originalType', function () {

      var levelClass = this.get('firstLevel') ? 'cs-control' : 'cs-control-input-list-item';

      var type = this.get('control.type');

      var originalType = this.get('control.originalType');
      if (_ember['default'].isPresent(originalType)) {
        type += '-' + originalType;
      }

      return levelClass + ' ' + levelClass + '-' + type;
    }),

    isHidden: _ember['default'].computed('hidden', 'control.excluded', function () {
      return this.get('hidden') || this.get('control.excluded');
    }),

    showHeader: _ember['default'].computed('control.label', function () {
      return _ember['default'].isPresent(this.get('control.label'));
    }),

    label: _ember['default'].computed('control.label', function () {
      var label = this.get('control.label');
      return _ember['default'].isPresent(label) ? label : '&nbsp;';
    })

  });

  ControlBase.isKeyMapped = function (key) {
    return _ember['default'].computed(function () {
      return _ember['default'].isPresent(this.get('control.keys.' + key));
    });
  };

  ControlBase.subOptions = function (key, defaults, transform) {
    var optionPath = 'control.options.' + key;
    return _ember['default'].computed(optionPath, function () {
      var options = (0, _cornerstoneUtilDeepAssign['default'])(_ember['default'].isNone(defaults) ? {} : _ember['default'].copy(defaults, true), this.getWithDefault(optionPath, {}));
      if ('function' === typeof transform) {
        options = transform.call(this, options);
      }
      return options;
    });
  };

  exports['default'] = ControlBase;
});
define("cornerstone/components/controls/control-base/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 4,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-base/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment(" Undefined Control ");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes() {
          return [];
        },
        statements: [],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 6,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-base/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [4, 22]]]], ["content", "yield", ["loc", [null, [5, 0], [5, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-border/component', ['exports', 'ember', 'cornerstone/components/controls/control-base/component', 'cornerstone/mixins/controls/placeholder', 'cornerstone/util/split-on-whitespace'], function (exports, _ember, _cornerstoneComponentsControlsControlBaseComponent, _cornerstoneMixinsControlsPlaceholder, _cornerstoneUtilSplitOnWhitespace) {

  var sides = ['top', 'right', 'bottom', 'left'];

  function linkedKey(prop, fallback) {
    return _ember['default'].computed(prop, 'activeSide', {
      get: function get() {
        return valueForSide(this.getWithDefault(prop, ''), this.get('activeSide'), fallback);
      },
      set: function set(key, value) {

        value = value.replace(/\ /g, '');

        if (this.get('linked')) {
          this.set(prop, value);
        } else {
          var update = {};
          update[this.get('activeSide')] = value;
          this.set(prop, unlinkedValue(this.getWithDefault(prop, ''), fallback, update));
        }

        return value;
      }
    });
  }

  function valueForSide(combined, side, fallback) {
    var index = sides.indexOf(side);

    var parts = (0, _cornerstoneUtilSplitOnWhitespace['default'])(combined);
    return _ember['default'].isNone(parts[index]) ? fallback : parts[index];
  }

  function unlinkedValue(combined, fallback, update) {

    var parts = (0, _cornerstoneUtilSplitOnWhitespace['default'])(combined);
    var updated = [];

    if (1 === parts.length) {
      parts[1] = parts[0];
      parts[2] = parts[0];
      parts[3] = parts[0];
    }

    sides.forEach(function (item, index) {

      if (_ember['default'].isNone(parts[index])) {
        parts[index] = fallback;
      }

      updated.push(parts[index]);
    });

    if (update) {
      for (var side in update) {
        var index = sides.indexOf(side);
        if (-1 !== index) {
          updated[index] = update[side];
        }
      }
    }

    return updated.join(' ');
  }

  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend(_cornerstoneMixinsControlsPlaceholder['default'], {

    showColor: _cornerstoneComponentsControlsControlBaseComponent['default'].isKeyMapped('color'),
    showAltColor: _cornerstoneComponentsControlsControlBaseComponent['default'].isKeyMapped('alt_color'),

    init: function init() {
      this._super.apply(this, arguments);
      if (this.get('options.always_linked')) {
        this.set('alwaysLinked', true);
        this.set('linked', true);
      } else {
        this.set('linked', (0, _cornerstoneUtilSplitOnWhitespace['default'])(this.getWithDefault('control.keyStyle', '')).length <= 1);
      }
    },

    linkedObserver: _ember['default'].observer('linked', function () {

      var activeStyle = this.get('activeStyle');
      this.set('activeStyle', activeStyle);
      this.set('activeWidth', this.get('activeWidth'));

      if (this.get('showColor')) {
        this.set('activeColor', this.get('activeColor'));
      }

      if (this.get('showAltColor')) {
        this.set('activeAltColor', this.get('activeAltColor'));
      }
    }),

    activeSide: _ember['default'].computed({
      get: function get() {
        return 'top';
      },
      set: function set(key, value) {
        return value;
      }
    }),

    activeStyle: linkedKey('control.keyStyle', 'none'),
    activeWidth: linkedKey('control.keyWidth', '0px'),
    activeColor: linkedKey('control.keyColor', 'transparent'),
    activeAltColor: linkedKey('control.keyAltColor', 'transparent'),

    widthOptions: _cornerstoneComponentsControlsControlBaseComponent['default'].subOptions('width', {
      available_units: ['px', 'em', 'rem'],
      ranges: {
        px: { min: 0, max: 25, step: 1 },
        em: { min: 0, max: 2.5, step: 0.001 },
        rem: { min: 0, max: 2.5, step: 0.001 }
      }
    }),

    colorOptions: _cornerstoneComponentsControlsControlBaseComponent['default'].subOptions('color'),
    altColorOptions: _ember['default'].computed('colorOptions', function () {
      var options = _ember['default'].copy(this.get('colorOptions'));
      if (options.alt_label) {
        options.label = options.alt_label;
      }
      return options;
    })

  });
});
define("cornerstone/components/controls/control-border/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          var child0 = (function () {
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 6,
                    "column": 6
                  },
                  "end": {
                    "line": 9,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/controls/control-border/template.hbs"
              },
              isEmpty: false,
              arity: 1,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(2);
                morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
                return morphs;
              },
              statements: [["inline", "forms/choose-choice", [], ["choose", ["subexpr", "@mut", [["get", "choose", ["loc", [null, [7, 37], [7, 43]]], 0, 0, 0, 0]], [], [], 0, 0], "value", false, "icon", "unlink", "tooltip", "Unlinked"], ["loc", [null, [7, 8], [7, 90]]], 0, 0], ["inline", "forms/choose-choice", [], ["choose", ["subexpr", "@mut", [["get", "choose", ["loc", [null, [8, 37], [8, 43]]], 0, 0, 0, 0]], [], [], 0, 0], "value", true, "icon", "link", "tooltip", "Linked"], ["loc", [null, [8, 8], [8, 85]]], 0, 0]],
              locals: ["choose"],
              templates: []
            };
          })();
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 5,
                  "column": 4
                },
                "end": {
                  "line": 10,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-border/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
              dom.insertBoundary(fragment, 0);
              dom.insertBoundary(fragment, null);
              return morphs;
            },
            statements: [["block", "forms/choose-single", [], ["value", ["subexpr", "@mut", [["get", "linked", ["loc", [null, [6, 35], [6, 41]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [6, 6], [9, 30]]]]],
            locals: [],
            templates: [child0]
          };
        })();
        var child1 = (function () {
          var child0 = (function () {
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 13,
                    "column": 6
                  },
                  "end": {
                    "line": 18,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/controls/control-border/template.hbs"
              },
              isEmpty: false,
              arity: 1,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(4);
                morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
                morphs[2] = dom.createMorphAt(fragment, 5, 5, contextualElement);
                morphs[3] = dom.createMorphAt(fragment, 7, 7, contextualElement);
                return morphs;
              },
              statements: [["inline", "forms/choose-choice", [], ["class", "cs-choice-top", "choose", ["subexpr", "@mut", [["get", "choose", ["loc", [null, [14, 59], [14, 65]]], 0, 0, 0, 0]], [], [], 0, 0], "value", "top", "tooltip", "Top"], ["loc", [null, [14, 8], [14, 93]]], 0, 0], ["inline", "forms/choose-choice", [], ["class", "cs-choice-right", "choose", ["subexpr", "@mut", [["get", "choose", ["loc", [null, [15, 61], [15, 67]]], 0, 0, 0, 0]], [], [], 0, 0], "value", "right", "tooltip", "Right"], ["loc", [null, [15, 8], [15, 99]]], 0, 0], ["inline", "forms/choose-choice", [], ["class", "cs-choice-bottom", "choose", ["subexpr", "@mut", [["get", "choose", ["loc", [null, [16, 62], [16, 68]]], 0, 0, 0, 0]], [], [], 0, 0], "value", "bottom", "tooltip", "Bottom"], ["loc", [null, [16, 8], [16, 102]]], 0, 0], ["inline", "forms/choose-choice", [], ["class", "cs-choice-left", "choose", ["subexpr", "@mut", [["get", "choose", ["loc", [null, [17, 60], [17, 66]]], 0, 0, 0, 0]], [], [], 0, 0], "value", "left", "tooltip", "Left"], ["loc", [null, [17, 8], [17, 96]]], 0, 0]],
              locals: ["choose"],
              templates: []
            };
          })();
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 12,
                  "column": 4
                },
                "end": {
                  "line": 19,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-border/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
              dom.insertBoundary(fragment, 0);
              dom.insertBoundary(fragment, null);
              return morphs;
            },
            statements: [["block", "forms/choose-single", [], ["value", ["subexpr", "@mut", [["get", "activeSide", ["loc", [null, [13, 35], [13, 45]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [13, 6], [18, 30]]]]],
            locals: [],
            templates: [child0]
          };
        })();
        var child2 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 21,
                  "column": 4
                },
                "end": {
                  "line": 36,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-border/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "forms/styled-select", [], ["value", ["subexpr", "@mut", [["get", "activeStyle", ["loc", [null, [23, 14], [23, 25]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "array", [["subexpr", "hash", [], ["value", "none", "label", "None"], ["loc", [null, [25, 10], [25, 42]]], 0, 0], ["subexpr", "hash", [], ["value", "solid", "label", "Solid"], ["loc", [null, [26, 10], [26, 44]]], 0, 0], ["subexpr", "hash", [], ["value", "dotted", "label", "Dotted"], ["loc", [null, [27, 10], [27, 46]]], 0, 0], ["subexpr", "hash", [], ["value", "dashed", "label", "Dashed"], ["loc", [null, [28, 10], [28, 46]]], 0, 0], ["subexpr", "hash", [], ["value", "double", "label", "Double"], ["loc", [null, [29, 10], [29, 46]]], 0, 0], ["subexpr", "hash", [], ["value", "groove", "label", "Groove"], ["loc", [null, [30, 10], [30, 46]]], 0, 0], ["subexpr", "hash", [], ["value", "ridge", "label", "Ridge"], ["loc", [null, [31, 10], [31, 44]]], 0, 0], ["subexpr", "hash", [], ["value", "inset", "label", "Inset"], ["loc", [null, [32, 10], [32, 44]]], 0, 0], ["subexpr", "hash", [], ["value", "outset", "label", "Outset"], ["loc", [null, [33, 10], [33, 46]]], 0, 0]], [], ["loc", [null, [24, 16], [34, 9]]], 0, 0]], ["loc", [null, [22, 6], [35, 8]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child3 = (function () {
          var child0 = (function () {
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 39,
                    "column": 6
                  },
                  "end": {
                    "line": 41,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/controls/control-border/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                return morphs;
              },
              statements: [["inline", "forms/unit-slider", [], ["value", ["subexpr", "@mut", [["get", "activeWidth", ["loc", [null, [40, 34], [40, 45]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "widthOptions", ["loc", [null, [40, 54], [40, 66]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [40, 8], [40, 68]]], 0, 0]],
              locals: [],
              templates: []
            };
          })();
          var child1 = (function () {
            var child0 = (function () {
              var child0 = (function () {
                return {
                  meta: {
                    "revision": "Ember@2.8.0",
                    "loc": {
                      "source": null,
                      "start": {
                        "line": 46,
                        "column": 10
                      },
                      "end": {
                        "line": 48,
                        "column": 10
                      }
                    },
                    "moduleName": "cornerstone/components/controls/control-border/template.hbs"
                  },
                  isEmpty: false,
                  arity: 0,
                  cachedFragment: null,
                  hasRendered: false,
                  buildFragment: function buildFragment(dom) {
                    var el0 = dom.createDocumentFragment();
                    var el1 = dom.createTextNode("            ");
                    dom.appendChild(el0, el1);
                    var el1 = dom.createComment("");
                    dom.appendChild(el0, el1);
                    var el1 = dom.createTextNode("\n");
                    dom.appendChild(el0, el1);
                    return el0;
                  },
                  buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                    var morphs = new Array(1);
                    morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                    return morphs;
                  },
                  statements: [["inline", "forms/color-picker", [], ["value", ["subexpr", "@mut", [["get", "activeAltColor", ["loc", [null, [47, 39], [47, 53]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "altColorOptions", ["loc", [null, [47, 62], [47, 77]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [47, 12], [47, 79]]], 0, 0]],
                  locals: [],
                  templates: []
                };
              })();
              return {
                meta: {
                  "revision": "Ember@2.8.0",
                  "loc": {
                    "source": null,
                    "start": {
                      "line": 44,
                      "column": 8
                    },
                    "end": {
                      "line": 49,
                      "column": 8
                    }
                  },
                  "moduleName": "cornerstone/components/controls/control-border/template.hbs"
                },
                isEmpty: false,
                arity: 0,
                cachedFragment: null,
                hasRendered: false,
                buildFragment: function buildFragment(dom) {
                  var el0 = dom.createDocumentFragment();
                  var el1 = dom.createTextNode("          ");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createComment("");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createTextNode("\n");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createComment("");
                  dom.appendChild(el0, el1);
                  return el0;
                },
                buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                  var morphs = new Array(2);
                  morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                  morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
                  dom.insertBoundary(fragment, null);
                  return morphs;
                },
                statements: [["inline", "forms/color-picker", [], ["value", ["subexpr", "@mut", [["get", "activeColor", ["loc", [null, [45, 37], [45, 48]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "colorOptions", ["loc", [null, [45, 57], [45, 69]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [45, 10], [45, 71]]], 0, 0], ["block", "if", [["get", "showAltColor", ["loc", [null, [46, 16], [46, 28]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [46, 10], [48, 17]]]]],
                locals: [],
                templates: [child0]
              };
            })();
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 43,
                    "column": 6
                  },
                  "end": {
                    "line": 50,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/controls/control-border/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
                dom.insertBoundary(fragment, 0);
                dom.insertBoundary(fragment, null);
                return morphs;
              },
              statements: [["block", "controls/input-list-item", [], ["label", "Color"], 0, null, ["loc", [null, [44, 8], [49, 37]]]]],
              locals: [],
              templates: [child0]
            };
          })();
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 38,
                  "column": 4
                },
                "end": {
                  "line": 51,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-border/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(2);
              morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
              morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
              dom.insertBoundary(fragment, 0);
              dom.insertBoundary(fragment, null);
              return morphs;
            },
            statements: [["block", "controls/input-list-item", [], ["label", "Width"], 0, null, ["loc", [null, [39, 6], [41, 35]]]], ["block", "if", [["get", "showColor", ["loc", [null, [43, 12], [43, 21]]], 0, 0, 0, 0]], [], 1, null, ["loc", [null, [43, 6], [50, 13]]]]],
            locals: [],
            templates: [child0, child1]
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 3,
                "column": 2
              },
              "end": {
                "line": 53,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/controls/control-border/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(4);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
            morphs[2] = dom.createMorphAt(fragment, 5, 5, contextualElement);
            morphs[3] = dom.createMorphAt(fragment, 7, 7, contextualElement);
            return morphs;
          },
          statements: [["block", "controls/input-list-item", [], ["label", "Link Sides", "isVisible", ["subexpr", "not", [["get", "alwaysLinked", ["loc", [null, [5, 66], [5, 78]]], 0, 0, 0, 0]], [], ["loc", [null, [5, 61], [5, 79]]], 0, 0]], 0, null, ["loc", [null, [5, 4], [10, 33]]]], ["block", "controls/input-list-item", [], ["label", "Side", "isVisible", ["subexpr", "not", [["get", "linked", ["loc", [null, [12, 60], [12, 66]]], 0, 0, 0, 0]], [], ["loc", [null, [12, 55], [12, 67]]], 0, 0]], 1, null, ["loc", [null, [12, 4], [19, 33]]]], ["block", "controls/input-list-item", [], ["label", "Style"], 2, null, ["loc", [null, [21, 4], [36, 33]]]], ["block", "unless", [["subexpr", "eq", [["get", "activeStyle", ["loc", [null, [38, 18], [38, 29]]], 0, 0, 0, 0], "none"], [], ["loc", [null, [38, 14], [38, 37]]], 0, 0]], [], 3, null, ["loc", [null, [38, 4], [51, 15]]]]],
          locals: [],
          templates: [child0, child1, child2, child3]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 55,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-border/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          return morphs;
        },
        statements: [["block", "controls/input-list", [], [], 0, null, ["loc", [null, [3, 2], [53, 26]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 57,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-border/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [55, 22]]]], ["content", "yield", ["loc", [null, [56, 0], [56, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-box-shadow/component', ['exports', 'ember', 'cornerstone/components/controls/control-base/component', 'cornerstone/mixins/controls/placeholder', 'cornerstone/util/split-on-whitespace'], function (exports, _ember, _cornerstoneComponentsControlsControlBaseComponent, _cornerstoneMixinsControlsPlaceholder, _cornerstoneUtilSplitOnWhitespace) {

  function composedValue(name) {
    return _ember['default'].computed('value', {
      get: function get() {
        return this.destruct()[name];
      },
      set: function set(key, value) {
        var update = {};
        update[name] = value;
        this.set('value', this.reconstitute(update));
        return value;
      }
    });
  }

  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend(_cornerstoneMixinsControlsPlaceholder['default'], {

    reconstitute: function reconstitute(updates) {

      var data = this.destruct();

      for (var key in updates) {
        data[key] = updates[key];
      }

      return '' + (data.inset ? 'inset ' : '') + data.xOffset + ' ' + data.yOffset + ' ' + data.blur + ' ' + data.spread;
    },

    destruct: function destruct() {

      var parts = (0, _cornerstoneUtilSplitOnWhitespace['default'])(this.getWithDefault('value', ''));
      var inset = 'inset' === parts[0];

      if (inset) {
        parts.shift();
      }

      var data = {
        xOffset: _ember['default'].isPresent(parts[0]) ? parts[0] : '0px',
        yOffset: _ember['default'].isPresent(parts[1]) ? parts[1] : '0px',
        blur: _ember['default'].isPresent(parts[2]) ? parts[2] : '0px',
        spread: _ember['default'].isPresent(parts[3]) ? parts[3] : '0px',
        inset: inset
      };

      // debugger;
      return data;
    },

    inset: composedValue('inset'),
    xOffset: composedValue('xOffset'),
    yOffset: composedValue('yOffset'),
    blur: composedValue('blur'),
    spread: composedValue('spread'),

    showColor: _cornerstoneComponentsControlsControlBaseComponent['default'].isKeyMapped('color'),
    showAltColor: _cornerstoneComponentsControlsControlBaseComponent['default'].isKeyMapped('alt_color'),

    xOffsetOptions: _cornerstoneComponentsControlsControlBaseComponent['default'].subOptions('x_offset', {
      available_units: ['px', 'em', 'rem'],
      ranges: {
        px: { min: -50, max: 50, step: 1 },
        em: { min: -1, max: 1, step: 0.001 },
        rem: { min: -1, max: 1, step: 0.001 }
      }
    }),

    yOffsetOptions: _cornerstoneComponentsControlsControlBaseComponent['default'].subOptions('y_offset', {
      available_units: ['px', 'em', 'rem'],
      ranges: {
        px: { min: -50, max: 50, step: 1 },
        em: { min: -1, max: 1, step: 0.001 },
        rem: { min: -1, max: 1, step: 0.001 }
      }
    }),

    blurOptions: _cornerstoneComponentsControlsControlBaseComponent['default'].subOptions('blur', {
      available_units: ['px', 'em', 'rem'],
      ranges: {
        px: { min: 0, max: 100, step: 1 },
        em: { min: 0, max: 5, step: 0.001 },
        rem: { min: 0, max: 5, step: 0.001 }
      }
    }),

    spreadOptions: _cornerstoneComponentsControlsControlBaseComponent['default'].subOptions('blur', {
      available_units: ['px', 'em', 'rem']
    }),

    colorOptions: _cornerstoneComponentsControlsControlBaseComponent['default'].subOptions('color'),
    altColorOptions: _ember['default'].computed('colorOptions', function () {
      var options = _ember['default'].copy(this.get('colorOptions'));
      if (options.alt_label) {
        options.label = options.alt_label;
      }
      return options;
    })
  });
});
define("cornerstone/components/controls/control-box-shadow/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 5,
                  "column": 4
                },
                "end": {
                  "line": 7,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-box-shadow/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "forms/unit-slider", [], ["value", ["subexpr", "@mut", [["get", "xOffset", ["loc", [null, [6, 32], [6, 39]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "xOffsetOptions", ["loc", [null, [6, 48], [6, 62]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [6, 6], [6, 64]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child1 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 9,
                  "column": 4
                },
                "end": {
                  "line": 11,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-box-shadow/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "forms/unit-slider", [], ["value", ["subexpr", "@mut", [["get", "yOffset", ["loc", [null, [10, 32], [10, 39]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "yOffsetOptions", ["loc", [null, [10, 48], [10, 62]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [10, 6], [10, 64]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child2 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 13,
                  "column": 4
                },
                "end": {
                  "line": 15,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-box-shadow/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "forms/unit-slider", [], ["value", ["subexpr", "@mut", [["get", "blur", ["loc", [null, [14, 32], [14, 36]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "blurOptions", ["loc", [null, [14, 45], [14, 56]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [14, 6], [14, 59]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child3 = (function () {
          var child0 = (function () {
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 23,
                    "column": 10
                  },
                  "end": {
                    "line": 26,
                    "column": 10
                  }
                },
                "moduleName": "cornerstone/components/controls/control-box-shadow/template.hbs"
              },
              isEmpty: false,
              arity: 1,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("            ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n            ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(2);
                morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
                return morphs;
              },
              statements: [["inline", "forms/choose-choice", [], ["choose", ["subexpr", "@mut", [["get", "choose", ["loc", [null, [24, 41], [24, 47]]], 0, 0, 0, 0]], [], [], 0, 0], "value", false, "icon", "sign-out"], ["loc", [null, [24, 12], [24, 77]]], 0, 0], ["inline", "forms/choose-choice", [], ["choose", ["subexpr", "@mut", [["get", "choose", ["loc", [null, [25, 41], [25, 47]]], 0, 0, 0, 0]], [], [], 0, 0], "value", true, "icon", "sign-in"], ["loc", [null, [25, 12], [25, 75]]], 0, 0]],
              locals: ["choose"],
              templates: []
            };
          })();
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 17,
                  "column": 4
                },
                "end": {
                  "line": 29,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-box-shadow/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createElement("ul");
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("li");
              dom.setAttribute(el2, "style", "-webkit-flex: 0 0 48%; flex: 0 0 48%;");
              var el3 = dom.createTextNode("\n          ");
              dom.appendChild(el2, el3);
              var el3 = dom.createComment("");
              dom.appendChild(el2, el3);
              var el3 = dom.createTextNode("\n        ");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("li");
              dom.setAttribute(el2, "style", "-webkit-flex: 0 0 48%; flex: 0 0 48%;");
              var el3 = dom.createTextNode("\n");
              dom.appendChild(el2, el3);
              var el3 = dom.createComment("");
              dom.appendChild(el2, el3);
              var el3 = dom.createTextNode("        ");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n      ");
              dom.appendChild(el1, el2);
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var element0 = dom.childAt(fragment, [1]);
              var morphs = new Array(2);
              morphs[0] = dom.createMorphAt(dom.childAt(element0, [1]), 1, 1);
              morphs[1] = dom.createMorphAt(dom.childAt(element0, [3]), 1, 1);
              return morphs;
            },
            statements: [["inline", "forms/unit-input", [], ["value", ["subexpr", "@mut", [["get", "spread", ["loc", [null, [20, 35], [20, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "spreadOptions", ["loc", [null, [20, 50], [20, 63]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [20, 10], [20, 65]]], 0, 0], ["block", "forms/choose-single", [], ["value", ["subexpr", "@mut", [["get", "inset", ["loc", [null, [23, 39], [23, 44]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [23, 10], [26, 34]]]]],
            locals: [],
            templates: [child0]
          };
        })();
        var child4 = (function () {
          var child0 = (function () {
            var child0 = (function () {
              return {
                meta: {
                  "revision": "Ember@2.8.0",
                  "loc": {
                    "source": null,
                    "start": {
                      "line": 34,
                      "column": 8
                    },
                    "end": {
                      "line": 36,
                      "column": 8
                    }
                  },
                  "moduleName": "cornerstone/components/controls/control-box-shadow/template.hbs"
                },
                isEmpty: false,
                arity: 0,
                cachedFragment: null,
                hasRendered: false,
                buildFragment: function buildFragment(dom) {
                  var el0 = dom.createDocumentFragment();
                  var el1 = dom.createTextNode("          ");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createComment("");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createTextNode("\n");
                  dom.appendChild(el0, el1);
                  return el0;
                },
                buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                  var morphs = new Array(1);
                  morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                  return morphs;
                },
                statements: [["inline", "forms/color-picker", [], ["value", ["subexpr", "@mut", [["get", "control.keyAltColor", ["loc", [null, [35, 37], [35, 56]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "altColorOptions", ["loc", [null, [35, 65], [35, 80]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [35, 10], [35, 82]]], 0, 0]],
                locals: [],
                templates: []
              };
            })();
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 32,
                    "column": 6
                  },
                  "end": {
                    "line": 37,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/controls/control-box-shadow/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(2);
                morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
                dom.insertBoundary(fragment, null);
                return morphs;
              },
              statements: [["inline", "forms/color-picker", [], ["value", ["subexpr", "@mut", [["get", "control.keyColor", ["loc", [null, [33, 35], [33, 51]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "colorOptions", ["loc", [null, [33, 60], [33, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [33, 8], [33, 74]]], 0, 0], ["block", "if", [["get", "showAltColor", ["loc", [null, [34, 14], [34, 26]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [34, 8], [36, 15]]]]],
              locals: [],
              templates: [child0]
            };
          })();
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 31,
                  "column": 4
                },
                "end": {
                  "line": 38,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-box-shadow/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
              dom.insertBoundary(fragment, 0);
              dom.insertBoundary(fragment, null);
              return morphs;
            },
            statements: [["block", "controls/input-list-item", [], ["label", "Color"], 0, null, ["loc", [null, [32, 6], [37, 35]]]]],
            locals: [],
            templates: [child0]
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 3,
                "column": 2
              },
              "end": {
                "line": 40,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/controls/control-box-shadow/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(5);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
            morphs[2] = dom.createMorphAt(fragment, 5, 5, contextualElement);
            morphs[3] = dom.createMorphAt(fragment, 7, 7, contextualElement);
            morphs[4] = dom.createMorphAt(fragment, 9, 9, contextualElement);
            return morphs;
          },
          statements: [["block", "controls/input-list-item", [], ["label", "X-Offset"], 0, null, ["loc", [null, [5, 4], [7, 33]]]], ["block", "controls/input-list-item", [], ["label", "Y-Offset"], 1, null, ["loc", [null, [9, 4], [11, 33]]]], ["block", "controls/input-list-item", [], ["label", "Blur"], 2, null, ["loc", [null, [13, 4], [15, 33]]]], ["block", "controls/input-list-item", [], ["label", "Spread &amp;<br>Position"], 3, null, ["loc", [null, [17, 4], [29, 33]]]], ["block", "if", [["get", "showColor", ["loc", [null, [31, 10], [31, 19]]], 0, 0, 0, 0]], [], 4, null, ["loc", [null, [31, 4], [38, 11]]]]],
          locals: [],
          templates: [child0, child1, child2, child3, child4]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 41,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-box-shadow/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "controls/input-list", [], [], 0, null, ["loc", [null, [3, 2], [40, 26]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 43,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-box-shadow/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [41, 22]]]], ["content", "yield", ["loc", [null, [42, 0], [42, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-breakpoints/component', ['exports', 'ember', 'npm:nouislider', 'cornerstone/components/controls/control-base/component'], function (exports, _ember, _npmNouislider, _cornerstoneComponentsControlsControlBaseComponent) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend({

    didInsertElement: function didInsertElement() {

      _ember['default'].run.scheduleOnce('afterRender', (function () {

        _npmNouislider['default'].create(this.$('.cs-bp-slider-xs .cs-unit-slider-target')[0], {
          start: 300,
          step: 1,
          connect: 'lower',
          range: {
            'min': 0,
            'max': 1500
          }
        });

        _npmNouislider['default'].create(this.$('.cs-bp-slider-sm .cs-unit-slider-target')[0], {
          start: [301, 600],
          step: 1,
          connect: true,
          range: {
            'min': 0,
            'max': 1500
          }
        });

        _npmNouislider['default'].create(this.$('.cs-bp-slider-md .cs-unit-slider-target')[0], {
          start: [601, 900],
          step: 1,
          connect: true,
          range: {
            'min': 0,
            'max': 1500
          }
        });

        _npmNouislider['default'].create(this.$('.cs-bp-slider-lg .cs-unit-slider-target')[0], {
          start: [901, 1200],
          step: 1,
          connect: true,
          range: {
            'min': 0,
            'max': 1500
          }
        });

        _npmNouislider['default'].create(this.$('.cs-bp-slider-xl .cs-unit-slider-target')[0], {
          start: 1201,
          step: 1,
          connect: 'upper',
          range: {
            'min': 0,
            'max': 1500
          }
        });
      }).bind(this));
    }

  });
});
define("cornerstone/components/controls/control-breakpoints/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 5,
                  "column": 4
                },
                "end": {
                  "line": 12,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-breakpoints/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createElement("div");
              dom.setAttribute(el1, "class", "cs-unit-slider cs-bp-slider-xs");
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("div");
              dom.setAttribute(el2, "class", "cs-unit-slider-target-container");
              var el3 = dom.createTextNode("\n          ");
              dom.appendChild(el2, el3);
              var el3 = dom.createElement("div");
              dom.setAttribute(el3, "class", "cs-unit-slider-target");
              dom.appendChild(el2, el3);
              var el3 = dom.createTextNode("\n        ");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("span");
              var el3 = dom.createElement("strong");
              var el4 = dom.createTextNode("XS");
              dom.appendChild(el3, el4);
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n      ");
              dom.appendChild(el1, el2);
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes() {
              return [];
            },
            statements: [],
            locals: [],
            templates: []
          };
        })();
        var child1 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 14,
                  "column": 4
                },
                "end": {
                  "line": 21,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-breakpoints/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createElement("div");
              dom.setAttribute(el1, "class", "cs-unit-slider cs-bp-slider-sm");
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("div");
              dom.setAttribute(el2, "class", "cs-unit-slider-target-container");
              var el3 = dom.createTextNode("\n          ");
              dom.appendChild(el2, el3);
              var el3 = dom.createElement("div");
              dom.setAttribute(el3, "class", "cs-unit-slider-target");
              dom.appendChild(el2, el3);
              var el3 = dom.createTextNode("\n        ");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("span");
              var el3 = dom.createElement("strong");
              var el4 = dom.createTextNode("SM");
              dom.appendChild(el3, el4);
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n      ");
              dom.appendChild(el1, el2);
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes() {
              return [];
            },
            statements: [],
            locals: [],
            templates: []
          };
        })();
        var child2 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 23,
                  "column": 4
                },
                "end": {
                  "line": 30,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-breakpoints/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createElement("div");
              dom.setAttribute(el1, "class", "cs-unit-slider cs-bp-slider-md");
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("div");
              dom.setAttribute(el2, "class", "cs-unit-slider-target-container");
              var el3 = dom.createTextNode("\n          ");
              dom.appendChild(el2, el3);
              var el3 = dom.createElement("div");
              dom.setAttribute(el3, "class", "cs-unit-slider-target");
              dom.appendChild(el2, el3);
              var el3 = dom.createTextNode("\n        ");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("span");
              var el3 = dom.createElement("strong");
              var el4 = dom.createTextNode("MD");
              dom.appendChild(el3, el4);
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n      ");
              dom.appendChild(el1, el2);
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes() {
              return [];
            },
            statements: [],
            locals: [],
            templates: []
          };
        })();
        var child3 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 32,
                  "column": 4
                },
                "end": {
                  "line": 39,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-breakpoints/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createElement("div");
              dom.setAttribute(el1, "class", "cs-unit-slider cs-bp-slider-lg");
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("div");
              dom.setAttribute(el2, "class", "cs-unit-slider-target-container");
              var el3 = dom.createTextNode("\n          ");
              dom.appendChild(el2, el3);
              var el3 = dom.createElement("div");
              dom.setAttribute(el3, "class", "cs-unit-slider-target");
              dom.appendChild(el2, el3);
              var el3 = dom.createTextNode("\n        ");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("span");
              var el3 = dom.createElement("strong");
              var el4 = dom.createTextNode("LG");
              dom.appendChild(el3, el4);
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n      ");
              dom.appendChild(el1, el2);
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes() {
              return [];
            },
            statements: [],
            locals: [],
            templates: []
          };
        })();
        var child4 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 41,
                  "column": 4
                },
                "end": {
                  "line": 48,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-breakpoints/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createElement("div");
              dom.setAttribute(el1, "class", "cs-unit-slider cs-bp-slider-xl");
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("div");
              dom.setAttribute(el2, "class", "cs-unit-slider-target-container");
              var el3 = dom.createTextNode("\n          ");
              dom.appendChild(el2, el3);
              var el3 = dom.createElement("div");
              dom.setAttribute(el3, "class", "cs-unit-slider-target");
              dom.appendChild(el2, el3);
              var el3 = dom.createTextNode("\n        ");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("span");
              var el3 = dom.createElement("strong");
              var el4 = dom.createTextNode("XL");
              dom.appendChild(el3, el4);
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n      ");
              dom.appendChild(el1, el2);
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes() {
              return [];
            },
            statements: [],
            locals: [],
            templates: []
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 3,
                "column": 2
              },
              "end": {
                "line": 50,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/controls/control-breakpoints/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(5);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
            morphs[2] = dom.createMorphAt(fragment, 5, 5, contextualElement);
            morphs[3] = dom.createMorphAt(fragment, 7, 7, contextualElement);
            morphs[4] = dom.createMorphAt(fragment, 9, 9, contextualElement);
            return morphs;
          },
          statements: [["block", "controls/input-list-item", [], ["label", "<strong>300px</strong> &amp;<br>Below"], 0, null, ["loc", [null, [5, 4], [12, 33]]]], ["block", "controls/input-list-item", [], ["label", "<strong>301px</strong> to<br><strong>600px</strong>"], 1, null, ["loc", [null, [14, 4], [21, 33]]]], ["block", "controls/input-list-item", [], ["label", "<strong>601px</strong> to<br><strong>900px</strong>"], 2, null, ["loc", [null, [23, 4], [30, 33]]]], ["block", "controls/input-list-item", [], ["label", "<strong>901px</strong> to<br><strong>1200px</strong>"], 3, null, ["loc", [null, [32, 4], [39, 33]]]], ["block", "controls/input-list-item", [], ["label", "<strong>1201px</strong> &amp;<br>Above"], 4, null, ["loc", [null, [41, 4], [48, 33]]]]],
          locals: [],
          templates: [child0, child1, child2, child3, child4]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 52,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-breakpoints/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          return morphs;
        },
        statements: [["block", "controls/input-list", [], [], 0, null, ["loc", [null, [3, 2], [50, 26]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 54,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-breakpoints/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [52, 22]]]], ["content", "yield", ["loc", [null, [53, 0], [53, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-checkbox-list/component', ['exports', 'ember', 'cornerstone/components/controls/input-list-item/component'], function (exports, _ember, _cornerstoneComponentsControlsInputListItemComponent) {
  exports['default'] = _cornerstoneComponentsControlsInputListItemComponent['default'].extend({
    checkboxes: _ember['default'].computed('control.options.list', function () {

      var cbs = this.get('control.options.list');
      if (!_ember['default'].isArray(cbs)) {
        return _ember['default'].A();
      }

      return cbs.map(function (cb) {
        cb.keyPath = _ember['default'].String.camelize('key-' + cb.key);
        return cb;
      });
    })
  });
});
define("cornerstone/components/controls/control-checkbox-list/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 5,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-checkbox-list/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(2);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
          return morphs;
        },
        statements: [["inline", "forms/checkbox-list", [], ["checkboxes", ["subexpr", "@mut", [["get", "checkboxes", ["loc", [null, [3, 35], [3, 45]]], 0, 0, 0, 0]], [], [], 0, 0], "proxy", ["subexpr", "@mut", [["get", "control", ["loc", [null, [3, 52], [3, 59]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [3, 2], [3, 61]]], 0, 0], ["content", "yield", ["loc", [null, [4, 2], [4, 11]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 6,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-checkbox-list/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(2);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [5, 22]]]]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-choose-multi/component', ['exports', 'cornerstone/components/controls/control-base/component', 'cornerstone/mixins/controls/placeholder'], function (exports, _cornerstoneComponentsControlsControlBaseComponent, _cornerstoneMixinsControlsPlaceholder) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend(_cornerstoneMixinsControlsPlaceholder['default'], {});
});
// import Ember from 'ember';
define("cornerstone/components/controls/control-choose-multi/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 10,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-choose-multi/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "forms/choose-multi", [], ["visibilityObservation", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [4, 26], [4, 34]]], 0, 0, 0, 0]], [], [], 0, 0], "choices", ["subexpr", "@mut", [["get", "control.options.choices", ["loc", [null, [5, 12], [5, 35]]], 0, 0, 0, 0]], [], [], 0, 0], "offValue", ["subexpr", "@mut", [["get", "options.off_value", ["loc", [null, [6, 13], [6, 30]]], 0, 0, 0, 0]], [], [], 0, 0], "delimiter", ["subexpr", "@mut", [["get", "options.delimiter", ["loc", [null, [7, 14], [7, 31]]], 0, 0, 0, 0]], [], [], 0, 0], "value", ["subexpr", "@mut", [["get", "value", ["loc", [null, [8, 10], [8, 15]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [3, 2], [9, 4]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 12,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-choose-multi/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [10, 22]]]], ["content", "yield", ["loc", [null, [11, 0], [11, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-choose-single/component', ['exports', 'cornerstone/components/controls/control-base/component', 'cornerstone/mixins/controls/placeholder'], function (exports, _cornerstoneComponentsControlsControlBaseComponent, _cornerstoneMixinsControlsPlaceholder) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend(_cornerstoneMixinsControlsPlaceholder['default'], {});
});
// import Ember from 'ember';
define("cornerstone/components/controls/control-choose-single/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 4,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-choose-single/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "forms/choose-single", [], ["visibilityObservation", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [3, 46], [3, 54]]], 0, 0, 0, 0]], [], [], 0, 0], "choices", ["subexpr", "@mut", [["get", "control.options.choices", ["loc", [null, [3, 63], [3, 86]]], 0, 0, 0, 0]], [], [], 0, 0], "offValue", ["subexpr", "@mut", [["get", "options.off_value", ["loc", [null, [3, 96], [3, 113]]], 0, 0, 0, 0]], [], [], 0, 0], "value", ["subexpr", "@mut", [["get", "value", ["loc", [null, [3, 120], [3, 125]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [3, 2], [3, 127]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 6,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-choose-single/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [4, 22]]]], ["content", "yield", ["loc", [null, [5, 0], [5, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-color/component', ['exports', 'ember', 'cornerstone/components/controls/control-base/component'], function (exports, _ember, _cornerstoneComponentsControlsControlBaseComponent) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend({

    showAlt: _cornerstoneComponentsControlsControlBaseComponent['default'].isKeyMapped('alt'),

    colorValue: _ember['default'].computed.alias('value'),
    altColorValue: _ember['default'].computed.alias('control.keyAlt'),

    baseOptions: _ember['default'].computed.alias('control.options'),
    altOptions: _ember['default'].computed('baseOptions', function () {
      var options = _ember['default'].merge({}, this.get('baseOptions'));
      if (options.alt_label) {
        options.label = options.alt_label;
      }
      return options;
    })

  });
});
define("cornerstone/components/controls/control-color/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 5,
                "column": 2
              },
              "end": {
                "line": 7,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/controls/control-color/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("    ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            return morphs;
          },
          statements: [["inline", "forms/color-picker", [], ["value", ["subexpr", "@mut", [["get", "control.keyAlt", ["loc", [null, [6, 31], [6, 45]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "altOptions", ["loc", [null, [6, 54], [6, 64]]], 0, 0, 0, 0]], [], [], 0, 0], "usePalette", true], ["loc", [null, [6, 4], [6, 82]]], 0, 0]],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 8,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-color/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("\n  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(2);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["inline", "forms/color-picker", [], ["value", ["subexpr", "@mut", [["get", "value", ["loc", [null, [4, 29], [4, 34]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "baseOptions", ["loc", [null, [4, 43], [4, 54]]], 0, 0, 0, 0]], [], [], 0, 0], "usePalette", true], ["loc", [null, [4, 2], [4, 72]]], 0, 0], ["block", "if", [["get", "showAlt", ["loc", [null, [5, 8], [5, 15]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [5, 2], [7, 9]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 10,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-color/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [8, 22]]]], ["content", "yield", ["loc", [null, [9, 0], [9, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-dimensions/component', ['exports', 'ember', 'cornerstone/components/controls/control-base/component', 'cornerstone/mixins/controls/placeholder', 'cornerstone/util/split-on-whitespace'], function (exports, _ember, _cornerstoneComponentsControlsControlBaseComponent, _cornerstoneMixinsControlsPlaceholder, _cornerstoneUtilSplitOnWhitespace) {

  var dims = ['top', 'right', 'bottom', 'left'];

  function dimensionOptions(dim) {
    return _cornerstoneComponentsControlsControlBaseComponent['default'].subOptions(dim, {
      available_units: ['px', 'em', 'rem', '%'],
      ranges: {
        px: { min: 0, max: 100, step: 1 },
        em: { min: 0, max: 2.5, step: 0.001 },
        rem: { min: 0, max: 2.5, step: 0.001 },
        '%': { min: 0, max: 100, step: 0.1 }
      }
    }, function (options) {
      if (options.disabled && options.hasOwnProperty('fallback_value')) {
        options.unlinkedState = options.fallback_value;
      }
      return options;
    });
  }

  function dimensionProperty(dim) {

    return _ember['default'].computed('expandedValue', {
      get: function get() {
        return this.getWithDefault(dim + 'Options.unlinkedState', (0, _cornerstoneUtilSplitOnWhitespace['default'])(this.getWithDefault('expandedValue', ''))[dims.indexOf(dim)]);
      },
      set: function set(key, value) {

        var parts = (0, _cornerstoneUtilSplitOnWhitespace['default'])(this.getWithDefault('expandedValue', ''));

        if (this.get('linked')) {
          dims.forEach((function (side, index) {
            var unlinked = this.get(side + 'Options.unlinkedState');
            parts[index] = _ember['default'].isNone(unlinked) ? value : unlinked;
          }).bind(this));
        } else {
          parts[dims.indexOf(dim)] = value;
        }

        this.set('expandedValue', parts.join(' '));
        this.set('recentlyChanged', dim);
        return value;
      }
    });
  }

  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend(_cornerstoneMixinsControlsPlaceholder['default'], {

    init: function init() {

      this._super.apply(this, arguments);

      // Linked detection
      var value = (0, _cornerstoneUtilSplitOnWhitespace['default'])(this.getWithDefault('value', ''));
      var linked = false;

      if (1 === value.length) {
        linked = true;
      } else {
        linked = 1 === dims.filter((function (dim) {
          return _ember['default'].isNone(this.get(dim + 'Options.unlinkedState'));
        }).bind(this)).map(function (dim) {
          return value[dims.indexOf(dim)];
        }).uniq().length;
      }

      if (linked) {
        this.set('linked', true);
      }
    },

    expandedValue: _ember['default'].computed('value', {
      get: function get() {
        var value = this.getWithDefault('value', '');

        if (1 === (0, _cornerstoneUtilSplitOnWhitespace['default'])(value).length) {
          return [value, value, value, value].join(' ');
        }

        return value;
      },
      set: function set(key, value) {
        var a = _ember['default'].A((0, _cornerstoneUtilSplitOnWhitespace['default'])(value));
        this.set('value', 1 === a.uniq().length ? a.get('firstObject') : value);
        return value;
      }
    }),

    labels: _ember['default'].computed('control.options.labels', function () {

      var labels = {};
      var defaults = {
        top: 'Top',
        right: 'Right',
        bottom: 'Bottom',
        left: 'Left'
      };

      var mappedLabels = this.getWithDefault('control.options.labels', {});
      Object.keys(defaults).forEach(function (label) {
        labels[label] = _ember['default'].isPresent(mappedLabels[label]) ? mappedLabels[label] : defaults[label];
      });

      return labels;
    }),

    linked: false,

    top: dimensionProperty('top'),
    right: dimensionProperty('right'),
    bottom: dimensionProperty('bottom'),
    left: dimensionProperty('left'),

    topOptions: dimensionOptions('top'),
    rightOptions: dimensionOptions('right'),
    bottomOptions: dimensionOptions('bottom'),
    leftOptions: dimensionOptions('left'),

    observeRecentDimension: _ember['default'].observer('linked', function () {

      if (!this.get('linked')) {
        return;
      }

      var recent = this.get('recentlyChanged');

      if (!recent) {
        recent = 'top';
      }

      this.set(recent, this.get(recent));
    })
  });
});
define("cornerstone/components/controls/control-dimensions/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          var child0 = (function () {
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 5,
                    "column": 6
                  },
                  "end": {
                    "line": 18,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/controls/control-dimensions/template.hbs"
              },
              isEmpty: false,
              arity: 1,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(2);
                morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
                return morphs;
              },
              statements: [["inline", "forms/choose-choice", [], ["choose", ["subexpr", "@mut", [["get", "choose", ["loc", [null, [7, 17], [7, 23]]], 0, 0, 0, 0]], [], [], 0, 0], "value", false, "icon", "unlink", "tooltip", "Unlinked"], ["loc", [null, [6, 8], [11, 10]]], 0, 0], ["inline", "forms/choose-choice", [], ["choose", ["subexpr", "@mut", [["get", "choose", ["loc", [null, [13, 17], [13, 23]]], 0, 0, 0, 0]], [], [], 0, 0], "value", true, "icon", "link", "tooltip", "Linked"], ["loc", [null, [12, 8], [17, 10]]], 0, 0]],
              locals: ["choose"],
              templates: []
            };
          })();
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 4,
                  "column": 4
                },
                "end": {
                  "line": 19,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-dimensions/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
              dom.insertBoundary(fragment, 0);
              dom.insertBoundary(fragment, null);
              return morphs;
            },
            statements: [["block", "forms/choose-single", [], ["choices", ["subexpr", "@mut", [["get", "linkedChoices", ["loc", [null, [5, 37], [5, 50]]], 0, 0, 0, 0]], [], [], 0, 0], "value", ["subexpr", "@mut", [["get", "linked", ["loc", [null, [5, 57], [5, 63]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [5, 6], [18, 30]]]]],
            locals: [],
            templates: [child0]
          };
        })();
        var child1 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 21,
                  "column": 4
                },
                "end": {
                  "line": 23,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-dimensions/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "forms/unit-slider", [], ["value", ["subexpr", "@mut", [["get", "top", ["loc", [null, [22, 32], [22, 35]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "topOptions", ["loc", [null, [22, 44], [22, 54]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [22, 6], [22, 56]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child2 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 25,
                  "column": 4
                },
                "end": {
                  "line": 27,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-dimensions/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "forms/unit-slider", [], ["value", ["subexpr", "@mut", [["get", "right", ["loc", [null, [26, 32], [26, 37]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "rightOptions", ["loc", [null, [26, 46], [26, 58]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [26, 6], [26, 60]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child3 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 29,
                  "column": 4
                },
                "end": {
                  "line": 31,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-dimensions/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "forms/unit-slider", [], ["value", ["subexpr", "@mut", [["get", "bottom", ["loc", [null, [30, 32], [30, 38]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "bottomOptions", ["loc", [null, [30, 47], [30, 60]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [30, 6], [30, 62]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child4 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 33,
                  "column": 4
                },
                "end": {
                  "line": 35,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-dimensions/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "forms/unit-slider", [], ["value", ["subexpr", "@mut", [["get", "left", ["loc", [null, [34, 32], [34, 36]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "leftOptions", ["loc", [null, [34, 45], [34, 56]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [34, 6], [34, 58]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 3,
                "column": 2
              },
              "end": {
                "line": 37,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/controls/control-dimensions/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(5);
            morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
            morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
            morphs[2] = dom.createMorphAt(fragment, 4, 4, contextualElement);
            morphs[3] = dom.createMorphAt(fragment, 6, 6, contextualElement);
            morphs[4] = dom.createMorphAt(fragment, 8, 8, contextualElement);
            dom.insertBoundary(fragment, 0);
            return morphs;
          },
          statements: [["block", "controls/input-list-item", [], ["label", "Link Sides"], 0, null, ["loc", [null, [4, 4], [19, 33]]]], ["block", "controls/input-list-item", [], ["label", ["subexpr", "@mut", [["get", "labels.top", ["loc", [null, [21, 38], [21, 48]]], 0, 0, 0, 0]], [], [], 0, 0]], 1, null, ["loc", [null, [21, 4], [23, 33]]]], ["block", "controls/input-list-item", [], ["label", ["subexpr", "@mut", [["get", "labels.right", ["loc", [null, [25, 38], [25, 50]]], 0, 0, 0, 0]], [], [], 0, 0]], 2, null, ["loc", [null, [25, 4], [27, 33]]]], ["block", "controls/input-list-item", [], ["label", ["subexpr", "@mut", [["get", "labels.bottom", ["loc", [null, [29, 38], [29, 51]]], 0, 0, 0, 0]], [], [], 0, 0]], 3, null, ["loc", [null, [29, 4], [31, 33]]]], ["block", "controls/input-list-item", [], ["label", ["subexpr", "@mut", [["get", "labels.left", ["loc", [null, [33, 38], [33, 49]]], 0, 0, 0, 0]], [], [], 0, 0]], 4, null, ["loc", [null, [33, 4], [35, 33]]]]],
          locals: [],
          templates: [child0, child1, child2, child3, child4]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 39,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-dimensions/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          return morphs;
        },
        statements: [["block", "controls/input-list", [], [], 0, null, ["loc", [null, [3, 2], [37, 26]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 41,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-dimensions/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [39, 22]]]], ["content", "yield", ["loc", [null, [40, 0], [40, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-flex-layout-attr/component', ['exports', 'ember', 'cornerstone/components/controls/control-base/component', 'cornerstone/mixins/controls/placeholder', 'cornerstone/util/split-on-whitespace'], function (exports, _ember, _cornerstoneComponentsControlsControlBaseComponent, _cornerstoneMixinsControlsPlaceholder, _cornerstoneUtilSplitOnWhitespace) {

  var linkedProperyKeys = ['flexDirection', 'reverseLayout', 'wrapChildren', 'horizontal', 'vertical'];

  function linkedProperty(key, parser) {

    if ('horizontal' === key) {
      parser = function (value) {
        return linkedAxis(value, 1);
      };
    }

    if ('vertical' === key) {
      parser = function (value) {
        return linkedAxis(value, 0);
      };
    }

    function linkedAxis(value, index) {
      var side = (value[1] || '').split('-')[index];
      return _ember['default'].isPresent(side) ? side.replace('top', 'start').replace('left', 'start').replace('right', 'end').replace('bottom', 'end') : 'start';
    }

    return _ember['default'].computed.apply(_ember['default'], ['value', {
      get: function get() {
        // if ( linkedProperty )
        return parser((0, _cornerstoneUtilSplitOnWhitespace['default'])(this.getWithDefault('value', '')));
      },
      set: function set(key, value) {

        var otherKeys = linkedProperyKeys.filter(function (otherKey) {
          return key !== otherKey;
        });

        var args = this.getProperties(otherKeys);
        args[key] = value;

        var isRow = 'row' === args.flexDirection;
        var layout = isRow ? 'row' : 'col';

        if (args.wrapChildren) {
          layout += 's';
        }

        var map = {
          vertical: {
            start: 'top',
            end: 'bottom'
          },
          horizontal: {
            start: 'left',
            end: 'right'
          }
        };

        var vertical = map.vertical[args.vertical] ? map.vertical[args.vertical] : args.vertical;
        var horizontal = map.horizontal[args.horizontal] ? map.horizontal[args.horizontal] : args.horizontal;

        var reverse = args.reverseLayout ? ' rev' : '';

        // console.log(`${layout} ${vertical}-${horizontal}${reverse}`);

        this.set('value', layout + ' ' + vertical + '-' + horizontal + reverse);
        return value;
      }
    }]);
  }

  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend(_cornerstoneMixinsControlsPlaceholder['default'], {

    flexDirection: linkedProperty('flexDirection', function (value) {
      return ['col', 'cols'].includes(value[0]) ? 'col' : 'row';
    }),

    reverseLayout: linkedProperty('reverseLayout', function (value) {
      return 'rev' === value[2];
    }),

    wrapChildren: linkedProperty('wrapChildren', function (value) {
      return ['rows', 'cols'].includes(value[0]);
    }),

    horizontal: linkedProperty('horizontal'),

    vertical: linkedProperty('vertical'),

    baseOptions: [{ value: 'start', label: 'Start' }, { value: 'center', label: 'Center' }, { value: 'end', label: 'End' }],

    mainAxisOptions: [{ value: 'justify', label: 'Space Between' }, { value: 'spread', label: 'Space Around' }],

    crossAxisOptions: [{ value: 'stretch', label: 'Stretch' }],

    horizontalOptions: _ember['default'].computed('flexDirection', function () {
      return _ember['default'].A('row' === this.get('flexDirection') ? this.get('baseOptions').concat(this.get('mainAxisOptions')) : this.get('baseOptions').concat(this.get('crossAxisOptions')));
    }),

    verticalOptions: _ember['default'].computed('flexDirection', function () {
      return _ember['default'].A('row' === this.get('flexDirection') ? this.get('baseOptions').concat(this.get('crossAxisOptions')) : this.get('baseOptions').concat(this.get('mainAxisOptions')));
    }),

    horizontalOptionObserver: _ember['default'].observer('horizontalOptions', function () {

      var current = this.get('horizontal');

      if (!_ember['default'].isNone(this.get('horizontalOptions').find(function (opt) {
        return opt.value === current;
      }))) {
        return;
      }

      var fallback = 'start';

      if ('row' === this.get('flexDirection')) {
        if ('stretch' === current) {
          fallback = 'spread';
        }
      } else {
        if ('spread' === current) {
          fallback = 'stretch';
        }
      }

      this.set('horizontal', fallback);
    }),

    verticalOptionObserver: _ember['default'].observer('verticalOptions', function () {

      var current = this.get('vertical');

      if (!_ember['default'].isNone(this.get('verticalOptions').find(function (opt) {
        return opt.value === current;
      }))) {
        return;
      }

      var fallback = 'start';

      if ('row' === this.get('flexDirection')) {
        if ('spread' === current) {
          fallback = 'stretch';
        }
      } else {
        if ('stretch' === current) {
          fallback = 'spread';
        }
      }

      this.set('vertical', fallback);
    })

  });
});
define("cornerstone/components/controls/control-flex-layout-attr/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          var child0 = (function () {
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 6,
                    "column": 6
                  },
                  "end": {
                    "line": 9,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/controls/control-flex-layout-attr/template.hbs"
              },
              isEmpty: false,
              arity: 1,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(2);
                morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
                return morphs;
              },
              statements: [["inline", "forms/choose-choice", [], ["choose", ["subexpr", "@mut", [["get", "choose", ["loc", [null, [7, 37], [7, 43]]], 0, 0, 0, 0]], [], [], 0, 0], "value", "row", "label", "Row"], ["loc", [null, [7, 8], [7, 69]]], 0, 0], ["inline", "forms/choose-choice", [], ["choose", ["subexpr", "@mut", [["get", "choose", ["loc", [null, [8, 37], [8, 43]]], 0, 0, 0, 0]], [], [], 0, 0], "value", "col", "label", "Column"], ["loc", [null, [8, 8], [8, 72]]], 0, 0]],
              locals: ["choose"],
              templates: []
            };
          })();
          var child1 = (function () {
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 11,
                    "column": 6
                  },
                  "end": {
                    "line": 13,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/controls/control-flex-layout-attr/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                return morphs;
              },
              statements: [["inline", "forms/rc-choice", [], ["value", ["subexpr", "@mut", [["get", "wrapChildren", ["loc", [null, [12, 32], [12, 44]]], 0, 0, 0, 0]], [], [], 0, 0], "label", "Wrap Children", "wide", true], ["loc", [null, [12, 8], [12, 78]]], 0, 0]],
              locals: [],
              templates: []
            };
          })();
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 5,
                  "column": 4
                },
                "end": {
                  "line": 14,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-flex-layout-attr/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(3);
              morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
              morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
              morphs[2] = dom.createMorphAt(fragment, 4, 4, contextualElement);
              dom.insertBoundary(fragment, 0);
              dom.insertBoundary(fragment, null);
              return morphs;
            },
            statements: [["block", "forms/choose-single", [], ["value", ["subexpr", "@mut", [["get", "flexDirection", ["loc", [null, [6, 35], [6, 48]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [6, 6], [9, 30]]]], ["inline", "forms/rc-choice", [], ["value", ["subexpr", "@mut", [["get", "reverseLayout", ["loc", [null, [10, 30], [10, 43]]], 0, 0, 0, 0]], [], [], 0, 0], "label", "Reverse Layout", "wide", true], ["loc", [null, [10, 6], [10, 78]]], 0, 0], ["block", "if", [["get", "control.options.allow_wrap", ["loc", [null, [11, 12], [11, 38]]], 0, 0, 0, 0]], [], 1, null, ["loc", [null, [11, 6], [13, 13]]]]],
            locals: [],
            templates: [child0, child1]
          };
        })();
        var child1 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 16,
                  "column": 4
                },
                "end": {
                  "line": 18,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-flex-layout-attr/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "forms/styled-select", [], ["value", ["subexpr", "@mut", [["get", "horizontal", ["loc", [null, [17, 34], [17, 44]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "horizontalOptions", ["loc", [null, [17, 53], [17, 70]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [17, 6], [17, 73]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child2 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 20,
                  "column": 4
                },
                "end": {
                  "line": 22,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-flex-layout-attr/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "forms/styled-select", [], ["value", ["subexpr", "@mut", [["get", "vertical", ["loc", [null, [21, 34], [21, 42]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "verticalOptions", ["loc", [null, [21, 51], [21, 66]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [21, 6], [21, 69]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 3,
                "column": 2
              },
              "end": {
                "line": 24,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/controls/control-flex-layout-attr/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(3);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
            morphs[2] = dom.createMorphAt(fragment, 5, 5, contextualElement);
            return morphs;
          },
          statements: [["block", "controls/input-list-item", [], ["label", "Layout"], 0, null, ["loc", [null, [5, 4], [14, 33]]]], ["block", "controls/input-list-item", [], ["label", "Horizontal"], 1, null, ["loc", [null, [16, 4], [18, 33]]]], ["block", "controls/input-list-item", [], ["label", "Vertical"], 2, null, ["loc", [null, [20, 4], [22, 33]]]]],
          locals: [],
          templates: [child0, child1, child2]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 26,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-flex-layout-attr/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          return morphs;
        },
        statements: [["block", "controls/input-list", [], [], 0, null, ["loc", [null, [3, 2], [24, 26]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 28,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-flex-layout-attr/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [26, 22]]]], ["content", "yield", ["loc", [null, [27, 0], [27, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-flex-layout/component', ['exports', 'ember', 'cornerstone/components/controls/control-base/component', 'cornerstone/mixins/controls/placeholder'], function (exports, _ember, _cornerstoneComponentsControlsControlBaseComponent, _cornerstoneMixinsControlsPlaceholder) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend(_cornerstoneMixinsControlsPlaceholder['default'], {

    canWrap: _cornerstoneComponentsControlsControlBaseComponent['default'].isKeyMapped('wrap'),
    canReverse: _ember['default'].computed('control.options.allow_reverse', function () {
      return false !== this.get('control.options.allow_reverse');
    }),

    wrapChildren: _ember['default'].computed.alias('control.keyWrap'),
    // wrapChildren: Ember.computed('control.keyWrap', {
    //   get() {
    //     return 'wrap' === this.get('control.keyWrap');
    //   },
    //   set(key,value) {
    //     this.set('control.keyWrap', value ? 'wrap' : '');
    //     return value;
    //   }
    // }),

    directionUpdated: 0,
    didReceiveAttrs: function didReceiveAttrs() {
      var direction = this.get('flexDirection');
      this.set('previousDirection', this.get('flexDirection'));
      this.set('isRow', 'row' === direction);
    },

    directionChange: _ember['default'].observer('flexDirection', function () {
      var previousDirection = this.get('previousDirection');
      var direction = this.get('flexDirection');
      if (direction !== previousDirection) {

        var align = this.get('control.keyAlign');
        var justify = this.get('control.keyJustify');
        this.set('control.keyAlign', justify);
        this.set('control.keyJustify', align);

        this.set('isRow', 'row' === direction);
        this.incrementProperty('directionUpdated');
        this.set('previousDirection', direction);
      }
    }),

    flexDirection: _ember['default'].computed('control.keyDirection', {
      get: function get() {
        return this.getWithDefault('control.keyDirection', 'row').split('-')[0];
      },

      set: function set(key, value) {
        var direction = value;
        if (this.get('canReverse') && this.get('reverseLayout')) {
          direction += '-reverse';
        }
        this.set('control.keyDirection', direction);
        return value;
      }
    }),

    reverseLayout: _ember['default'].computed('control.keyDirection', {
      get: function get() {
        return this.getWithDefault('control.keyDirection', 'row').includes('reverse');
      },

      set: function set(key, value) {
        var direction = this.getWithDefault('control.keyDirection', 'row').split('-')[0];
        if (value) {
          direction += '-reverse';
        }
        this.set('control.keyDirection', direction);
        return value;
      }
    }),

    flexDir: _ember['default'].computed.alias('flexDirection'),

    horizontalPath: _ember['default'].computed('flexDirection', function () {
      return 'row' === this.get('flexDirection') ? 'control.keyJustify' : 'control.keyAlign';
    }),

    verticalPath: _ember['default'].computed('flexDirection', function () {
      return 'row' === this.get('flexDirection') ? 'control.keyAlign' : 'control.keyJustify';
    }),

    baseOptions: [{ value: 'flex-start', label: 'Start' }, { value: 'center', label: 'Center' }, { value: 'flex-end', label: 'End' }],

    mainAxisOptions: [{ value: 'space-between', label: 'Space Between' }, { value: 'space-around', label: 'Space Around' }],

    crossAxisOptions: [{ value: 'stretch', label: 'Stretch' }],

    horizontalOptions: _ember['default'].computed('directionUpdated', function () {
      // console.log('option update', this.get('flexDirection') );
      return _ember['default'].A('row' === this.get('flexDirection') ? this.get('baseOptions').concat(this.get('mainAxisOptions')) : this.get('baseOptions').concat(this.get('crossAxisOptions')));
    }),

    verticalOptions: _ember['default'].computed('directionUpdated', function () {

      return _ember['default'].A('row' === this.get('flexDirection') ? this.get('baseOptions').concat(this.get('crossAxisOptions')) : this.get('baseOptions').concat(this.get('mainAxisOptions')));
    }),

    horizontalOptionObserver: _ember['default'].observer('horizontalOptions', function () {
      var isRow = this.get('isRow');
      var key = isRow ? 'control.keyJustify' : 'control.keyAlign';
      var current = this.get(key);

      if (!_ember['default'].isNone(this.get('horizontalOptions').find(function (opt) {
        return opt.value === current;
      }))) {
        return;
      }

      var fallback = 'flex-start';

      if (isRow) {
        if ('stretch' === current) {
          fallback = 'space-around';
        }
      } else {
        if ('space-around' === current) {
          fallback = 'stretch';
        }
      }

      this.set(key, fallback);
    }),

    verticalOptionObserver: _ember['default'].observer('verticalOptions', function () {

      var isRow = this.get('isRow');
      var key = isRow ? 'control.keyAlign' : 'control.keyJustify';
      var current = this.get(key);

      if (!_ember['default'].isNone(this.get('verticalOptions').find(function (opt) {
        return opt.value === current;
      }))) {
        return;
      }

      var fallback = 'flex-start';

      if ('row' === this.get('flexDirection')) {
        if ('space-around' === current) {
          fallback = 'stretch';
        }
      } else {
        if ('stretch' === current) {
          fallback = 'space-around';
        }
      }

      this.set(key, fallback);
    })

  });
});
define("cornerstone/components/controls/control-flex-layout/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          var child0 = (function () {
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 6,
                    "column": 6
                  },
                  "end": {
                    "line": 9,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/controls/control-flex-layout/template.hbs"
              },
              isEmpty: false,
              arity: 1,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(2);
                morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
                return morphs;
              },
              statements: [["inline", "forms/choose-choice", [], ["choose", ["subexpr", "@mut", [["get", "choose", ["loc", [null, [7, 37], [7, 43]]], 0, 0, 0, 0]], [], [], 0, 0], "value", "row", "label", "Row"], ["loc", [null, [7, 8], [7, 69]]], 0, 0], ["inline", "forms/choose-choice", [], ["choose", ["subexpr", "@mut", [["get", "choose", ["loc", [null, [8, 37], [8, 43]]], 0, 0, 0, 0]], [], [], 0, 0], "value", "column", "label", "Column"], ["loc", [null, [8, 8], [8, 75]]], 0, 0]],
              locals: ["choose"],
              templates: []
            };
          })();
          var child1 = (function () {
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 10,
                    "column": 6
                  },
                  "end": {
                    "line": 12,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/controls/control-flex-layout/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                return morphs;
              },
              statements: [["inline", "forms/rc-choice", [], ["value", ["subexpr", "@mut", [["get", "reverseLayout", ["loc", [null, [11, 32], [11, 45]]], 0, 0, 0, 0]], [], [], 0, 0], "label", "Reverse Layout", "wide", true], ["loc", [null, [11, 8], [11, 80]]], 0, 0]],
              locals: [],
              templates: []
            };
          })();
          var child2 = (function () {
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 13,
                    "column": 6
                  },
                  "end": {
                    "line": 15,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/controls/control-flex-layout/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                return morphs;
              },
              statements: [["inline", "forms/rc-choice", [], ["value", ["subexpr", "@mut", [["get", "wrapChildren", ["loc", [null, [14, 32], [14, 44]]], 0, 0, 0, 0]], [], [], 0, 0], "label", "Wrap Children", "wide", true], ["loc", [null, [14, 8], [14, 78]]], 0, 0]],
              locals: [],
              templates: []
            };
          })();
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 5,
                  "column": 4
                },
                "end": {
                  "line": 16,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-flex-layout/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(3);
              morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
              morphs[1] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              morphs[2] = dom.createMorphAt(fragment, 2, 2, contextualElement);
              dom.insertBoundary(fragment, 0);
              dom.insertBoundary(fragment, null);
              return morphs;
            },
            statements: [["block", "forms/choose-single", [], ["value", ["subexpr", "@mut", [["get", "flexDirection", ["loc", [null, [6, 35], [6, 48]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [6, 6], [9, 30]]]], ["block", "if", [["get", "canReverse", ["loc", [null, [10, 12], [10, 22]]], 0, 0, 0, 0]], [], 1, null, ["loc", [null, [10, 6], [12, 13]]]], ["block", "if", [["get", "canWrap", ["loc", [null, [13, 12], [13, 19]]], 0, 0, 0, 0]], [], 2, null, ["loc", [null, [13, 6], [15, 13]]]]],
            locals: [],
            templates: [child0, child1, child2]
          };
        })();
        var child1 = (function () {
          var child0 = (function () {
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 19,
                    "column": 6
                  },
                  "end": {
                    "line": 21,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/controls/control-flex-layout/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                return morphs;
              },
              statements: [["inline", "forms/styled-select", [], ["value", ["subexpr", "@mut", [["get", "control.keyJustify", ["loc", [null, [20, 36], [20, 54]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "horizontalOptions", ["loc", [null, [20, 63], [20, 80]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [20, 8], [20, 83]]], 0, 0]],
              locals: [],
              templates: []
            };
          })();
          var child1 = (function () {
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 21,
                    "column": 6
                  },
                  "end": {
                    "line": 23,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/controls/control-flex-layout/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                return morphs;
              },
              statements: [["inline", "forms/styled-select", [], ["value", ["subexpr", "@mut", [["get", "control.keyAlign", ["loc", [null, [22, 36], [22, 52]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "horizontalOptions", ["loc", [null, [22, 61], [22, 78]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [22, 8], [22, 81]]], 0, 0]],
              locals: [],
              templates: []
            };
          })();
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 18,
                  "column": 4
                },
                "end": {
                  "line": 24,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-flex-layout/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
              dom.insertBoundary(fragment, 0);
              dom.insertBoundary(fragment, null);
              return morphs;
            },
            statements: [["block", "if", [["get", "isRow", ["loc", [null, [19, 12], [19, 17]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [19, 6], [23, 13]]]]],
            locals: [],
            templates: [child0, child1]
          };
        })();
        var child2 = (function () {
          var child0 = (function () {
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 27,
                    "column": 6
                  },
                  "end": {
                    "line": 29,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/controls/control-flex-layout/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                return morphs;
              },
              statements: [["inline", "forms/styled-select", [], ["value", ["subexpr", "@mut", [["get", "control.keyAlign", ["loc", [null, [28, 36], [28, 52]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "verticalOptions", ["loc", [null, [28, 61], [28, 76]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [28, 8], [28, 79]]], 0, 0]],
              locals: [],
              templates: []
            };
          })();
          var child1 = (function () {
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 29,
                    "column": 6
                  },
                  "end": {
                    "line": 31,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/controls/control-flex-layout/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                return morphs;
              },
              statements: [["inline", "forms/styled-select", [], ["value", ["subexpr", "@mut", [["get", "control.keyJustify", ["loc", [null, [30, 36], [30, 54]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "verticalOptions", ["loc", [null, [30, 63], [30, 78]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [30, 8], [30, 81]]], 0, 0]],
              locals: [],
              templates: []
            };
          })();
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 26,
                  "column": 4
                },
                "end": {
                  "line": 32,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-flex-layout/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
              dom.insertBoundary(fragment, 0);
              dom.insertBoundary(fragment, null);
              return morphs;
            },
            statements: [["block", "if", [["get", "isRow", ["loc", [null, [27, 12], [27, 17]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [27, 6], [31, 13]]]]],
            locals: [],
            templates: [child0, child1]
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 3,
                "column": 2
              },
              "end": {
                "line": 34,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/controls/control-flex-layout/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(3);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
            morphs[2] = dom.createMorphAt(fragment, 5, 5, contextualElement);
            return morphs;
          },
          statements: [["block", "controls/input-list-item", [], ["label", "Layout"], 0, null, ["loc", [null, [5, 4], [16, 33]]]], ["block", "controls/input-list-item", [], ["label", "Horizontal"], 1, null, ["loc", [null, [18, 4], [24, 33]]]], ["block", "controls/input-list-item", [], ["label", "Vertical"], 2, null, ["loc", [null, [26, 4], [32, 33]]]]],
          locals: [],
          templates: [child0, child1, child2]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 36,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-flex-layout/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          return morphs;
        },
        statements: [["block", "controls/input-list", [], [], 0, null, ["loc", [null, [3, 2], [34, 26]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 38,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-flex-layout/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [36, 22]]]], ["content", "yield", ["loc", [null, [37, 0], [37, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-flex/component', ['exports', 'ember', 'cornerstone/components/controls/control-base/component', 'cornerstone/mixins/controls/placeholder', 'cornerstone/util/split-on-whitespace'], function (exports, _ember, _cornerstoneComponentsControlsControlBaseComponent, _cornerstoneMixinsControlsPlaceholder, _cornerstoneUtilSplitOnWhitespace) {

  function composedValue(name) {
    return _ember['default'].computed('value', {
      get: function get() {
        return this.destruct()[name];
      },
      set: function set(key, value) {
        var update = {};
        update[name] = value;
        this.set('value', this.reconstitute(update));
        return value;
      }
    });
  }

  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend(_cornerstoneMixinsControlsPlaceholder['default'], {

    presetChoices: _ember['default'].A([{
      label: 'Standard',
      value: '0 1 auto'
    }, {
      label: 'No Shrink',
      value: '0 0 auto'
    }, {
      label: 'Fill Space',
      value: '1 0 auto'
    }, {
      label: 'Fill Space Equally',
      value: '1 0 0%'
    }]),

    flexGrow: composedValue('flexGrow'),
    flexShrink: composedValue('flexShrink'),
    flexBasis: composedValue('flexBasis'),

    reconstitute: function reconstitute(updates) {

      var data = this.destruct();

      for (var key in updates) {
        data[key] = updates[key];
      }

      return data.flexGrow + ' ' + data.flexShrink + ' ' + data.flexBasis;
    },

    destruct: function destruct() {

      var parts = (0, _cornerstoneUtilSplitOnWhitespace['default'])(this.getWithDefault('value', ''));

      return {
        flexGrow: _ember['default'].isPresent(parts[0]) ? parts[0] : '0',
        flexShrink: _ember['default'].isPresent(parts[1]) ? parts[1] : '01',
        flexBasis: _ember['default'].isPresent(parts[2]) ? parts[2] : 'auto'
      };
    },

    init: function init() {
      this._super.apply(this, arguments);
      this.detectMode();
      this.set('mode', _ember['default'].isNone(this.detectMode()) ? 'custom' : 'presets');
      window.tester = this;
    },

    detectMode: function detectMode() {

      var value = this.get('value');
      return this.get('presetChoices').find(function (preset) {
        return preset.value === value;
      });
    }

  });
});
define("cornerstone/components/controls/control-flex/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 5,
                  "column": 4
                },
                "end": {
                  "line": 7,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-flex/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "forms/styled-select", [], ["value", ["subexpr", "@mut", [["get", "value", ["loc", [null, [6, 34], [6, 39]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "presetChoices", ["loc", [null, [6, 48], [6, 61]]], 0, 0, 0, 0]], [], [], 0, 0], "placeholder", "Custom"], ["loc", [null, [6, 6], [6, 85]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child1 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 8,
                  "column": 4
                },
                "end": {
                  "line": 10,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-flex/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "input", [], ["value", ["subexpr", "@mut", [["get", "flexGrow", ["loc", [null, [9, 20], [9, 28]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [9, 6], [9, 30]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child2 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 11,
                  "column": 4
                },
                "end": {
                  "line": 13,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-flex/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "input", [], ["value", ["subexpr", "@mut", [["get", "flexShrink", ["loc", [null, [12, 20], [12, 30]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [12, 6], [12, 32]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child3 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 14,
                  "column": 4
                },
                "end": {
                  "line": 16,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-flex/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "input", [], ["value", ["subexpr", "@mut", [["get", "flexBasis", ["loc", [null, [15, 20], [15, 29]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [15, 6], [15, 31]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 3,
                "column": 2
              },
              "end": {
                "line": 18,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/controls/control-flex/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(4);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
            morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
            morphs[3] = dom.createMorphAt(fragment, 4, 4, contextualElement);
            return morphs;
          },
          statements: [["block", "controls/input-list-item", [], ["label", "Preset"], 0, null, ["loc", [null, [5, 4], [7, 33]]]], ["block", "controls/input-list-item", [], ["label", "Flex<br>Grow"], 1, null, ["loc", [null, [8, 4], [10, 33]]]], ["block", "controls/input-list-item", [], ["label", "Flex<br>Shrink"], 2, null, ["loc", [null, [11, 4], [13, 33]]]], ["block", "controls/input-list-item", [], ["label", "Flex<br>Basis"], 3, null, ["loc", [null, [14, 4], [16, 33]]]]],
          locals: [],
          templates: [child0, child1, child2, child3]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 20,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-flex/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          return morphs;
        },
        statements: [["block", "controls/input-list", [], [], 0, null, ["loc", [null, [3, 2], [18, 26]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 22,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-flex/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [20, 22]]]], ["content", "yield", ["loc", [null, [21, 0], [21, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-font-family/component', ['exports', 'ember', 'cornerstone/components/controls/control-base/component'], function (exports, _ember, _cornerstoneComponentsControlsControlBaseComponent) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend({
    fonts: _ember['default'].inject.service('templates/fonts')
  });
});
define("cornerstone/components/controls/control-font-family/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 8,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-font-family/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "forms/styled-select", [], ["value", ["subexpr", "@mut", [["get", "value", ["loc", [null, [4, 10], [4, 15]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "fonts.fontFamilyOptions", ["loc", [null, [5, 12], [5, 35]]], 0, 0, 0, 0]], [], [], 0, 0], "visibilityObservation", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [6, 26], [6, 34]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [3, 2], [7, 4]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 10,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-font-family/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [8, 22]]]], ["content", "yield", ["loc", [null, [9, 0], [9, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-font-weight/component', ['exports', 'ember', 'cornerstone/components/controls/control-base/component'], function (exports, _ember, _cornerstoneComponentsControlsControlBaseComponent) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend({

    store: _ember['default'].inject.service(),
    fonts: _ember['default'].inject.service('templates/fonts'),

    fontWeightOptions: _ember['default'].computed('control.keyFontFamily', function () {
      var _this = this;

      var selectionID = this.get('control.keyFontFamily');

      var fontSelection = this.get('store').peekAll('templates/fonts/selection').find(function (choice) {
        return selectionID === choice.get('_id');
      });

      if ('inherit' === selectionID) {
        fontSelection = _ember['default'].Object.create({
          _id: 'inherit',
          weights: this.get('fonts.allWeights')
        });
      }

      var weights = _ember['default'].isNone(fontSelection) ? _ember['default'].A() : fontSelection.get('weights');
      var _idPrefix = _ember['default'].isNone(fontSelection) ? '' : fontSelection.get('_id') + ':';
      weights.sort();

      return weights.reduce(function (choices, weight) {
        if (!weight.includes('i')) {
          choices.push({
            value: '' + _idPrefix + weight,
            label: _this.get('i18n').t('app.font-weight.' + weight)
          });
        }
        return choices;
      }, _ember['default'].A());
    }),

    determineNewWeight: _ember['default'].computed(function () {

      var getWeight = (function (val) {
        return this.get('fonts').normalizeWeight(val).split(':')[1];
      }).bind(this);

      return function (newValue, oldValue) {
        return getWeight(newValue) === getWeight(oldValue.value ? oldValue.value : oldValue);
      };
    })

  });
});
define("cornerstone/components/controls/control-font-weight/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 8,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-font-weight/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "forms/styled-select", [], ["value", ["subexpr", "@mut", [["get", "value", ["loc", [null, [4, 10], [4, 15]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "fontWeightOptions", ["loc", [null, [5, 12], [5, 29]]], 0, 0, 0, 0]], [], [], 0, 0], "assignDefaultLocator", ["subexpr", "@mut", [["get", "determineNewWeight", ["loc", [null, [6, 25], [6, 43]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [3, 2], [7, 4]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 10,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-font-weight/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [8, 22]]]], ["content", "yield", ["loc", [null, [9, 0], [9, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-gradient/component', ['exports', 'cornerstone/components/controls/control-base/component', 'cornerstone/mixins/controls/placeholder'], function (exports, _cornerstoneComponentsControlsControlBaseComponent, _cornerstoneMixinsControlsPlaceholder) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend(_cornerstoneMixinsControlsPlaceholder['default'], {

    gradientState: 'linear-gradient',

    actions: {
      openLG: function openLG() {
        this.set('gradientState', 'linear-gradient');
      },
      openRLG: function openRLG() {
        this.set('gradientState', 'repeating-linear-gradient');
      },
      openRG: function openRG() {
        this.set('gradientState', 'radial-gradient');
      },
      openRRG: function openRRG() {
        this.set('gradientState', 'repeating-radial-gradient');
      }
    }

  });
});
// import Ember from 'ember';
define("cornerstone/components/controls/control-gradient/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 5,
                  "column": 4
                },
                "end": {
                  "line": 12,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-gradient/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createElement("ul");
              dom.setAttribute(el1, "class", "cs-choose cs-choose-condensed cols-4");
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("li");
              var el3 = dom.createComment("");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("li");
              var el3 = dom.createComment("");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("li");
              var el3 = dom.createComment("");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("li");
              var el3 = dom.createComment("");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n      ");
              dom.appendChild(el1, el2);
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var element0 = dom.childAt(fragment, [1]);
              var element1 = dom.childAt(element0, [1]);
              var element2 = dom.childAt(element0, [3]);
              var element3 = dom.childAt(element0, [5]);
              var element4 = dom.childAt(element0, [7]);
              var morphs = new Array(12);
              morphs[0] = dom.createAttrMorph(element1, 'class');
              morphs[1] = dom.createElementMorph(element1);
              morphs[2] = dom.createMorphAt(element1, 0, 0);
              morphs[3] = dom.createAttrMorph(element2, 'class');
              morphs[4] = dom.createElementMorph(element2);
              morphs[5] = dom.createMorphAt(element2, 0, 0);
              morphs[6] = dom.createAttrMorph(element3, 'class');
              morphs[7] = dom.createElementMorph(element3);
              morphs[8] = dom.createMorphAt(element3, 0, 0);
              morphs[9] = dom.createAttrMorph(element4, 'class');
              morphs[10] = dom.createElementMorph(element4);
              morphs[11] = dom.createMorphAt(element4, 0, 0);
              return morphs;
            },
            statements: [["attribute", "class", ["concat", [["subexpr", "if", [["subexpr", "eq", [["get", "gradientState", ["loc", [null, [7, 28], [7, 41]]], 0, 0, 0, 0], "linear-gradient"], [], ["loc", [null, [7, 24], [7, 60]]], 0, 0], "cs-active"], [], ["loc", [null, [7, 19], [7, 74]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["openLG"], [], ["loc", [null, [7, 76], [7, 95]]], 0, 0], ["inline", "fa-icon", ["minus"], [], ["loc", [null, [7, 96], [7, 115]]], 0, 0], ["attribute", "class", ["concat", [["subexpr", "if", [["subexpr", "eq", [["get", "gradientState", ["loc", [null, [8, 28], [8, 41]]], 0, 0, 0, 0], "repeating-linear-gradient"], [], ["loc", [null, [8, 24], [8, 70]]], 0, 0], "cs-active"], [], ["loc", [null, [8, 19], [8, 84]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["openRLG"], [], ["loc", [null, [8, 86], [8, 106]]], 0, 0], ["inline", "fa-icon", ["ellipsis-h"], [], ["loc", [null, [8, 107], [8, 131]]], 0, 0], ["attribute", "class", ["concat", [["subexpr", "if", [["subexpr", "eq", [["get", "gradientState", ["loc", [null, [9, 28], [9, 41]]], 0, 0, 0, 0], "radial-gradient"], [], ["loc", [null, [9, 24], [9, 60]]], 0, 0], "cs-active"], [], ["loc", [null, [9, 19], [9, 74]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["openRG"], [], ["loc", [null, [9, 76], [9, 95]]], 0, 0], ["inline", "fa-icon", ["circle-thin"], [], ["loc", [null, [9, 96], [9, 121]]], 0, 0], ["attribute", "class", ["concat", [["subexpr", "if", [["subexpr", "eq", [["get", "gradientState", ["loc", [null, [10, 28], [10, 41]]], 0, 0, 0, 0], "repeating-radial-gradient"], [], ["loc", [null, [10, 24], [10, 70]]], 0, 0], "cs-active"], [], ["loc", [null, [10, 19], [10, 84]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["openRRG"], [], ["loc", [null, [10, 86], [10, 106]]], 0, 0], ["inline", "fa-icon", ["bullseye"], [], ["loc", [null, [10, 107], [10, 129]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child1 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 14,
                  "column": 4
                },
                "end": {
                  "line": 34,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-gradient/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createElement("select");
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("option");
              var el3 = dom.createTextNode("0deg");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("option");
              var el3 = dom.createTextNode("90deg");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("option");
              var el3 = dom.createTextNode("180deg");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("option");
              var el3 = dom.createTextNode("360deg");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("option");
              var el3 = dom.createTextNode("to top");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("option");
              var el3 = dom.createTextNode("to left");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("option");
              var el3 = dom.createTextNode("to right");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("option");
              var el3 = dom.createTextNode("to bottom");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("option");
              var el3 = dom.createTextNode("to bottom left");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("option");
              var el3 = dom.createTextNode("circle");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("option");
              var el3 = dom.createTextNode("circle at top right");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("option");
              var el3 = dom.createTextNode("circle closest-side");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("option");
              var el3 = dom.createTextNode("circle closest-corner");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("option");
              var el3 = dom.createTextNode("circle farthest-side");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("option");
              var el3 = dom.createTextNode("circle farthest-corner");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("option");
              var el3 = dom.createTextNode("ellipsis");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("option");
              var el3 = dom.createTextNode("ellipsis farthest-side at right");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n      ");
              dom.appendChild(el1, el2);
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes() {
              return [];
            },
            statements: [],
            locals: [],
            templates: []
          };
        })();
        var child2 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 36,
                  "column": 4
                },
                "end": {
                  "line": 38,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-gradient/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "input", [], ["class", "cs-gradient-color", "value", ["subexpr", "@mut", [["get", "value", ["loc", [null, [37, 46], [37, 51]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [37, 6], [37, 53]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 3,
                "column": 2
              },
              "end": {
                "line": 40,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/controls/control-gradient/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(3);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
            morphs[2] = dom.createMorphAt(fragment, 5, 5, contextualElement);
            return morphs;
          },
          statements: [["block", "controls/input-list-item", [], ["label", "Type"], 0, null, ["loc", [null, [5, 4], [12, 33]]]], ["block", "controls/input-list-item", [], ["label", "Style"], 1, null, ["loc", [null, [14, 4], [34, 33]]]], ["block", "controls/input-list-item", [], ["label", "Colors"], 2, null, ["loc", [null, [36, 4], [38, 33]]]]],
          locals: [],
          templates: [child0, child1, child2]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 42,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-gradient/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          return morphs;
        },
        statements: [["block", "controls/input-list", [], [], 0, null, ["loc", [null, [3, 2], [40, 26]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 44,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-gradient/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [42, 22]]]], ["content", "yield", ["loc", [null, [43, 0], [43, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-group/component', ['exports', 'cornerstone/components/controls/control-base/component'], function (exports, _cornerstoneComponentsControlsControlBaseComponent) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend({});
});
// import Ember from 'ember';
define("cornerstone/components/controls/control-group/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 4,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-group/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "controls/input-list", [], ["controls", ["subexpr", "@mut", [["get", "control.controls", ["loc", [null, [3, 33], [3, 49]]], 0, 0, 0, 0]], [], [], 0, 0], "parentLevel", ["subexpr", "@mut", [["get", "level", ["loc", [null, [3, 62], [3, 67]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [3, 2], [3, 69]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 6,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-group/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [4, 22]]]], ["content", "yield", ["loc", [null, [5, 0], [5, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-icon/component', ['exports', 'ember', 'cornerstone/components/controls/control-base/component'], function (exports, _ember, _cornerstoneComponentsControlsControlBaseComponent) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend({
    showAlt: _cornerstoneComponentsControlsControlBaseComponent['default'].isKeyMapped('alt'),
    baseOptions: _ember['default'].computed.alias('control.options'),
    altOptions: _ember['default'].computed('baseOptions', function () {
      var options = _ember['default'].merge({}, this.get('baseOptions'));
      if (options.alt_label) {
        options.label = options.alt_label;
      }
      return options;
    })
  });
});
define("cornerstone/components/controls/control-icon/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 4,
                "column": 2
              },
              "end": {
                "line": 6,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/controls/control-icon/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("    ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            return morphs;
          },
          statements: [["inline", "forms/icon-picker", [], ["value", ["subexpr", "@mut", [["get", "control.keyAlt", ["loc", [null, [5, 30], [5, 44]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "altOptions", ["loc", [null, [5, 53], [5, 63]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [5, 4], [5, 65]]], 0, 0]],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 7,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-icon/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(2);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["inline", "forms/icon-picker", [], ["value", ["subexpr", "@mut", [["get", "value", ["loc", [null, [3, 28], [3, 33]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "baseOptions", ["loc", [null, [3, 42], [3, 53]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [3, 2], [3, 55]]], 0, 0], ["block", "if", [["get", "showAlt", ["loc", [null, [4, 8], [4, 15]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [4, 2], [6, 9]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 9,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-icon/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [7, 22]]]], ["content", "yield", ["loc", [null, [8, 0], [8, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-image-source/component', ['exports', 'cornerstone/components/controls/control-base/component', 'cornerstone/mixins/controls/placeholder'], function (exports, _cornerstoneComponentsControlsControlBaseComponent, _cornerstoneMixinsControlsPlaceholder) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend(_cornerstoneMixinsControlsPlaceholder['default'], {});
});
// import Ember from 'ember';
define("cornerstone/components/controls/control-image-source/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 4,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-image-source/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "forms/image-upload", [], ["value", ["subexpr", "@mut", [["get", "control.keyValue", ["loc", [null, [3, 29], [3, 45]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [3, 2], [3, 47]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 6,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-image-source/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [4, 22]]]], ["content", "yield", ["loc", [null, [5, 0], [5, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-image/component', ['exports', 'ember', 'cornerstone/components/controls/control-base/component'], function (exports, _ember, _cornerstoneComponentsControlsControlBaseComponent) {

  function dimensionPreview(dimensionKey) {

    return _ember['default'].computed(dimensionKey, 'control.keyIsRetina', function () {

      var dim = this.get(dimensionKey);

      if (!dim || isNaN(dim)) {
        return '';
      }

      if (this.get('control.keyIsRetina')) {
        return Math.round(dim / 2); // (dim / 2).toFixed(4).replace(/\.?0+$/,'');
      }

      return dim;
    });
  }

  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend({
    defaultHeight: 2,

    useWidth: _cornerstoneComponentsControlsControlBaseComponent['default'].isKeyMapped('width'),
    useHeight: _cornerstoneComponentsControlsControlBaseComponent['default'].isKeyMapped('height'),
    useImgSource: _cornerstoneComponentsControlsControlBaseComponent['default'].isKeyMapped('img_source'),
    showLink: _cornerstoneComponentsControlsControlBaseComponent['default'].isKeyMapped('has_link'),
    showInfo: _cornerstoneComponentsControlsControlBaseComponent['default'].isKeyMapped('has_info'),
    showRetinaReady: _cornerstoneComponentsControlsControlBaseComponent['default'].isKeyMapped('is_retina'),
    showAltText: _cornerstoneComponentsControlsControlBaseComponent['default'].isKeyMapped('alt_text'),

    showDimensionPreview: _ember['default'].computed('useWidth', 'useHeight', function () {
      return this.get('useWidth') && this.get('useHeight');
    }),

    widthPreview: dimensionPreview('control.keyWidth'),
    heightPreview: dimensionPreview('control.keyHeight'),

    showDisplayFunction: _ember['default'].computed('showLink', 'showInfo', function () {
      return this.get('showLink') || this.get('showInfo');
    }),

    detectedHeight: _ember['default'].computed('showDimensionPreview', 'showAltText', 'showLink', 'showInfo', function () {

      var cols = Math.floor([{
        key: 'showAltText',
        weight: 1
      }, {
        key: 'showLink',
        weight: 0.5
      }, {
        key: 'showInfo',
        weight: 0.5
      }, {
        key: 'showDimensionPreview',
        weight: 1
      }].reduce((function (memo, item) {
        if (this.get(item.key)) {
          memo -= item.weight;
        }
        return memo;
      }).bind(this), 5));

      return cols;
    }),

    altTextPlaceholder: _ember['default'].computed('control.options', function () {
      var placeholder = this.get('control.options.alt_text_placeholder');
      return placeholder ? placeholder : 'Describe Your Image Here';
    }),

    actions: {
      toggleRetinaReady: function toggleRetinaReady() {
        this.set('control.keyIsRetina', !this.get('control.keyIsRetina'));
      },
      dimensionChange: function dimensionChange(_ref) {
        var width = _ref.width;
        var height = _ref.height;

        this.set('control.keyWidth', width ? width : 48);
        this.set('control.keyHeight', height ? height : 48);
      }
    }

  });
});
define("cornerstone/components/controls/control-image/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 4,
                  "column": 4
                },
                "end": {
                  "line": 6,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-image/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "forms/image-upload", [], ["value", ["subexpr", "@mut", [["get", "control.keyImgSource", ["loc", [null, [5, 33], [5, 53]]], 0, 0, 0, 0]], [], [], 0, 0], "onDimensionChange", ["subexpr", "action", ["dimensionChange"], [], ["loc", [null, [5, 72], [5, 98]]], 0, 0]], ["loc", [null, [5, 6], [5, 101]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child1 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 6,
                  "column": 4
                },
                "end": {
                  "line": 8,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-image/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "forms/image-upload", [], ["value", ["subexpr", "@mut", [["get", "control.keyValue", ["loc", [null, [7, 33], [7, 49]]], 0, 0, 0, 0]], [], [], 0, 0], "onDimensionChange", ["subexpr", "action", ["dimensionChange"], [], ["loc", [null, [7, 68], [7, 94]]], 0, 0]], ["loc", [null, [7, 6], [7, 97]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 3,
                "column": 2
              },
              "end": {
                "line": 9,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/controls/control-image/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
            dom.insertBoundary(fragment, 0);
            dom.insertBoundary(fragment, null);
            return morphs;
          },
          statements: [["block", "if", [["get", "useImgSource", ["loc", [null, [4, 10], [4, 22]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [4, 4], [8, 11]]]]],
          locals: [],
          templates: [child0, child1]
        };
      })();
      var child1 = (function () {
        var child0 = (function () {
          var child0 = (function () {
            var child0 = (function () {
              return {
                meta: {
                  "revision": "Ember@2.8.0",
                  "loc": {
                    "source": null,
                    "start": {
                      "line": 17,
                      "column": 10
                    },
                    "end": {
                      "line": 19,
                      "column": 10
                    }
                  },
                  "moduleName": "cornerstone/components/controls/control-image/template.hbs"
                },
                isEmpty: false,
                arity: 0,
                cachedFragment: null,
                hasRendered: false,
                buildFragment: function buildFragment(dom) {
                  var el0 = dom.createDocumentFragment();
                  var el1 = dom.createTextNode("            ");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createElement("button");
                  var el2 = dom.createComment("");
                  dom.appendChild(el1, el2);
                  dom.appendChild(el0, el1);
                  var el1 = dom.createTextNode("\n");
                  dom.appendChild(el0, el1);
                  return el0;
                },
                buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                  var element0 = dom.childAt(fragment, [1]);
                  var morphs = new Array(3);
                  morphs[0] = dom.createAttrMorph(element0, 'class');
                  morphs[1] = dom.createElementMorph(element0);
                  morphs[2] = dom.createMorphAt(element0, 0, 0);
                  return morphs;
                },
                statements: [["attribute", "class", ["concat", [["subexpr", "if", [["get", "control.keyIsRetina", ["loc", [null, [18, 32], [18, 51]]], 0, 0, 0, 0], "cs-active"], [], ["loc", [null, [18, 27], [18, 65]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["toggleRetinaReady"], [], ["loc", [null, [18, 67], [18, 97]]], 0, 0], ["inline", "fa-icon", ["eye"], [], ["loc", [null, [18, 98], [18, 115]]], 0, 0]],
                locals: [],
                templates: []
              };
            })();
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 13,
                    "column": 8
                  },
                  "end": {
                    "line": 28,
                    "column": 8
                  }
                },
                "moduleName": "cornerstone/components/controls/control-image/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("          ");
                dom.appendChild(el0, el1);
                var el1 = dom.createElement("div");
                var el2 = dom.createTextNode("\n            ");
                dom.appendChild(el1, el2);
                var el2 = dom.createElement("span");
                var el3 = dom.createTextNode("W");
                dom.appendChild(el2, el3);
                dom.appendChild(el1, el2);
                var el2 = dom.createTextNode("\n            ");
                dom.appendChild(el1, el2);
                var el2 = dom.createComment("");
                dom.appendChild(el1, el2);
                var el2 = dom.createTextNode("\n          ");
                dom.appendChild(el1, el2);
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n          ");
                dom.appendChild(el0, el1);
                var el1 = dom.createElement("div");
                var el2 = dom.createTextNode("\n            ");
                dom.appendChild(el1, el2);
                var el2 = dom.createElement("span");
                var el3 = dom.createTextNode("H");
                dom.appendChild(el2, el3);
                dom.appendChild(el1, el2);
                var el2 = dom.createTextNode("\n            ");
                dom.appendChild(el1, el2);
                var el2 = dom.createComment("");
                dom.appendChild(el1, el2);
                var el2 = dom.createTextNode("\n          ");
                dom.appendChild(el1, el2);
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(3);
                morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
                morphs[1] = dom.createMorphAt(dom.childAt(fragment, [2]), 3, 3);
                morphs[2] = dom.createMorphAt(dom.childAt(fragment, [4]), 3, 3);
                dom.insertBoundary(fragment, 0);
                return morphs;
              },
              statements: [["block", "if", [["get", "showRetinaReady", ["loc", [null, [17, 16], [17, 31]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [17, 10], [19, 17]]]], ["inline", "input", [], ["disabled", true, "value", ["subexpr", "@mut", [["get", "widthPreview", ["loc", [null, [22, 40], [22, 52]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [22, 12], [22, 54]]], 0, 0], ["inline", "input", [], ["disabled", true, "value", ["subexpr", "@mut", [["get", "heightPreview", ["loc", [null, [26, 40], [26, 53]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [26, 12], [26, 55]]], 0, 0]],
              locals: [],
              templates: [child0]
            };
          })();
          var child1 = (function () {
            var child0 = (function () {
              return {
                meta: {
                  "revision": "Ember@2.8.0",
                  "loc": {
                    "source": null,
                    "start": {
                      "line": 32,
                      "column": 8
                    },
                    "end": {
                      "line": 34,
                      "column": 8
                    }
                  },
                  "moduleName": "cornerstone/components/controls/control-image/template.hbs"
                },
                isEmpty: false,
                arity: 0,
                cachedFragment: null,
                hasRendered: false,
                buildFragment: function buildFragment(dom) {
                  var el0 = dom.createDocumentFragment();
                  var el1 = dom.createTextNode("          ");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createComment("");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createTextNode("\n");
                  dom.appendChild(el0, el1);
                  return el0;
                },
                buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                  var morphs = new Array(1);
                  morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                  return morphs;
                },
                statements: [["inline", "forms/image-upload", [], ["value", ["subexpr", "@mut", [["get", "control.keyImgSource", ["loc", [null, [33, 37], [33, 57]]], 0, 0, 0, 0]], [], [], 0, 0], "onDimensionChange", ["subexpr", "action", ["dimensionChange"], [], ["loc", [null, [33, 76], [33, 102]]], 0, 0]], ["loc", [null, [33, 10], [33, 105]]], 0, 0]],
                locals: [],
                templates: []
              };
            })();
            var child1 = (function () {
              return {
                meta: {
                  "revision": "Ember@2.8.0",
                  "loc": {
                    "source": null,
                    "start": {
                      "line": 34,
                      "column": 8
                    },
                    "end": {
                      "line": 36,
                      "column": 8
                    }
                  },
                  "moduleName": "cornerstone/components/controls/control-image/template.hbs"
                },
                isEmpty: false,
                arity: 0,
                cachedFragment: null,
                hasRendered: false,
                buildFragment: function buildFragment(dom) {
                  var el0 = dom.createDocumentFragment();
                  var el1 = dom.createTextNode("          ");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createComment("");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createTextNode("\n");
                  dom.appendChild(el0, el1);
                  return el0;
                },
                buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                  var morphs = new Array(1);
                  morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                  return morphs;
                },
                statements: [["inline", "forms/image-upload", [], ["value", ["subexpr", "@mut", [["get", "control.keyValue", ["loc", [null, [35, 37], [35, 53]]], 0, 0, 0, 0]], [], [], 0, 0], "onDimensionChange", ["subexpr", "action", ["dimensionChange"], [], ["loc", [null, [35, 72], [35, 98]]], 0, 0]], ["loc", [null, [35, 10], [35, 101]]], 0, 0]],
                locals: [],
                templates: []
              };
            })();
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 31,
                    "column": 6
                  },
                  "end": {
                    "line": 37,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/controls/control-image/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
                dom.insertBoundary(fragment, 0);
                dom.insertBoundary(fragment, null);
                return morphs;
              },
              statements: [["block", "if", [["get", "useImgSource", ["loc", [null, [32, 14], [32, 26]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [32, 8], [36, 15]]]]],
              locals: [],
              templates: [child0, child1]
            };
          })();
          var child2 = (function () {
            var child0 = (function () {
              var child0 = (function () {
                return {
                  meta: {
                    "revision": "Ember@2.8.0",
                    "loc": {
                      "source": null,
                      "start": {
                        "line": 41,
                        "column": 10
                      },
                      "end": {
                        "line": 43,
                        "column": 10
                      }
                    },
                    "moduleName": "cornerstone/components/controls/control-image/template.hbs"
                  },
                  isEmpty: false,
                  arity: 0,
                  cachedFragment: null,
                  hasRendered: false,
                  buildFragment: function buildFragment(dom) {
                    var el0 = dom.createDocumentFragment();
                    var el1 = dom.createTextNode("            ");
                    dom.appendChild(el0, el1);
                    var el1 = dom.createComment("");
                    dom.appendChild(el0, el1);
                    var el1 = dom.createTextNode("\n");
                    dom.appendChild(el0, el1);
                    return el0;
                  },
                  buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                    var morphs = new Array(1);
                    morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                    return morphs;
                  },
                  statements: [["inline", "forms/rc-choice", [], ["value", ["subexpr", "@mut", [["get", "control.keyHasLink", ["loc", [null, [42, 36], [42, 54]]], 0, 0, 0, 0]], [], [], 0, 0], "label", "Link", "half", true], ["loc", [null, [42, 12], [42, 79]]], 0, 0]],
                  locals: [],
                  templates: []
                };
              })();
              var child1 = (function () {
                return {
                  meta: {
                    "revision": "Ember@2.8.0",
                    "loc": {
                      "source": null,
                      "start": {
                        "line": 44,
                        "column": 10
                      },
                      "end": {
                        "line": 46,
                        "column": 10
                      }
                    },
                    "moduleName": "cornerstone/components/controls/control-image/template.hbs"
                  },
                  isEmpty: false,
                  arity: 0,
                  cachedFragment: null,
                  hasRendered: false,
                  buildFragment: function buildFragment(dom) {
                    var el0 = dom.createDocumentFragment();
                    var el1 = dom.createTextNode("            ");
                    dom.appendChild(el0, el1);
                    var el1 = dom.createComment("");
                    dom.appendChild(el0, el1);
                    var el1 = dom.createTextNode("\n");
                    dom.appendChild(el0, el1);
                    return el0;
                  },
                  buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                    var morphs = new Array(1);
                    morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                    return morphs;
                  },
                  statements: [["inline", "forms/rc-choice", [], ["value", ["subexpr", "@mut", [["get", "control.keyHasInfo", ["loc", [null, [45, 36], [45, 54]]], 0, 0, 0, 0]], [], [], 0, 0], "label", "Info", "half", true], ["loc", [null, [45, 12], [45, 79]]], 0, 0]],
                  locals: [],
                  templates: []
                };
              })();
              return {
                meta: {
                  "revision": "Ember@2.8.0",
                  "loc": {
                    "source": null,
                    "start": {
                      "line": 40,
                      "column": 8
                    },
                    "end": {
                      "line": 50,
                      "column": 8
                    }
                  },
                  "moduleName": "cornerstone/components/controls/control-image/template.hbs"
                },
                isEmpty: false,
                arity: 0,
                cachedFragment: null,
                hasRendered: false,
                buildFragment: function buildFragment(dom) {
                  var el0 = dom.createDocumentFragment();
                  var el1 = dom.createComment("");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createComment("");
                  dom.appendChild(el0, el1);
                  return el0;
                },
                buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                  var morphs = new Array(2);
                  morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
                  morphs[1] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                  dom.insertBoundary(fragment, 0);
                  dom.insertBoundary(fragment, null);
                  return morphs;
                },
                statements: [["block", "if", [["get", "showLink", ["loc", [null, [41, 16], [41, 24]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [41, 10], [43, 17]]]], ["block", "if", [["get", "showInfo", ["loc", [null, [44, 16], [44, 24]]], 0, 0, 0, 0]], [], 1, null, ["loc", [null, [44, 10], [46, 17]]]]],
                locals: [],
                templates: [child0, child1]
              };
            })();
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 39,
                    "column": 6
                  },
                  "end": {
                    "line": 51,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/controls/control-image/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
                dom.insertBoundary(fragment, 0);
                dom.insertBoundary(fragment, null);
                return morphs;
              },
              statements: [["block", "controls/input-list-item", [], [], 0, null, ["loc", [null, [40, 8], [50, 37]]]]],
              locals: [],
              templates: [child0]
            };
          })();
          var child3 = (function () {
            var child0 = (function () {
              return {
                meta: {
                  "revision": "Ember@2.8.0",
                  "loc": {
                    "source": null,
                    "start": {
                      "line": 54,
                      "column": 8
                    },
                    "end": {
                      "line": 56,
                      "column": 8
                    }
                  },
                  "moduleName": "cornerstone/components/controls/control-image/template.hbs"
                },
                isEmpty: false,
                arity: 0,
                cachedFragment: null,
                hasRendered: false,
                buildFragment: function buildFragment(dom) {
                  var el0 = dom.createDocumentFragment();
                  var el1 = dom.createTextNode("          ");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createComment("");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createTextNode("\n");
                  dom.appendChild(el0, el1);
                  return el0;
                },
                buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                  var morphs = new Array(1);
                  morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                  return morphs;
                },
                statements: [["inline", "input", [], ["type", "text", "placeholder", ["subexpr", "@mut", [["get", "altTextPlaceholder", ["loc", [null, [55, 42], [55, 60]]], 0, 0, 0, 0]], [], [], 0, 0], "value", ["subexpr", "@mut", [["get", "control.keyAltText", ["loc", [null, [55, 67], [55, 85]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [55, 10], [55, 87]]], 0, 0]],
                locals: [],
                templates: []
              };
            })();
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 53,
                    "column": 6
                  },
                  "end": {
                    "line": 57,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/controls/control-image/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
                dom.insertBoundary(fragment, 0);
                dom.insertBoundary(fragment, null);
                return morphs;
              },
              statements: [["block", "controls/input-list-item", [], ["label", "Alt Text"], 0, null, ["loc", [null, [54, 8], [56, 37]]]]],
              locals: [],
              templates: [child0]
            };
          })();
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 10,
                  "column": 4
                },
                "end": {
                  "line": 59,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-image/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(4);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
              morphs[2] = dom.createMorphAt(fragment, 5, 5, contextualElement);
              morphs[3] = dom.createMorphAt(fragment, 7, 7, contextualElement);
              return morphs;
            },
            statements: [["block", "controls/input-list-item", [], ["label", ["subexpr", "if", [["get", "showRetinaReady", ["loc", [null, [14, 20], [14, 35]]], 0, 0, 0, 0], "Retina & Dimensions", "Dimensions Preview"], [], ["loc", [null, [14, 16], [14, 80]]], 0, 0], "class", "cs-input-list-image-dimensions"], 0, null, ["loc", [null, [13, 8], [28, 37]]]], ["block", "controls/input-list-item", [], ["label", "Source", "defaultHeight", ["subexpr", "@mut", [["get", "detectedHeight", ["loc", [null, [31, 63], [31, 77]]], 0, 0, 0, 0]], [], [], 0, 0]], 1, null, ["loc", [null, [31, 6], [37, 35]]]], ["block", "if", [["get", "showDisplayFunction", ["loc", [null, [39, 12], [39, 31]]], 0, 0, 0, 0]], [], 2, null, ["loc", [null, [39, 6], [51, 13]]]], ["block", "if", [["get", "showAltText", ["loc", [null, [53, 12], [53, 23]]], 0, 0, 0, 0]], [], 3, null, ["loc", [null, [53, 6], [57, 13]]]]],
            locals: [],
            templates: [child0, child1, child2, child3]
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 9,
                "column": 2
              },
              "end": {
                "line": 60,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/controls/control-image/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
            dom.insertBoundary(fragment, 0);
            dom.insertBoundary(fragment, null);
            return morphs;
          },
          statements: [["block", "controls/input-list", [], [], 0, null, ["loc", [null, [10, 4], [59, 28]]]]],
          locals: [],
          templates: [child0]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 62,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-image/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          return morphs;
        },
        statements: [["block", "unless", [["get", "firstLevel", ["loc", [null, [3, 12], [3, 22]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [3, 2], [60, 13]]]]],
        locals: [],
        templates: [child0, child1]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 64,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-image/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [62, 22]]]], ["content", "yield", ["loc", [null, [63, 0], [63, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-link/component', ['exports', 'ember', 'cornerstone/components/controls/control-base/component', 'cornerstone/mixins/controls/placeholder'], function (exports, _ember, _cornerstoneComponentsControlsControlBaseComponent, _cornerstoneMixinsControlsPlaceholder) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend(_cornerstoneMixinsControlsPlaceholder['default'], {

    // Cache old URL, update preview immediately
    typeChoices: [{ value: 'url', icon: 'link', tooltip: 'URL' }, { value: 'email', icon: 'envelope', tooltip: 'Email' }, { value: 'tel', icon: 'phone', tooltip: 'Phone' }],

    showContent: _cornerstoneComponentsControlsControlBaseComponent['default'].isKeyMapped('content'),
    showNewTab: _cornerstoneComponentsControlsControlBaseComponent['default'].isKeyMapped('new_tab'),
    showNofollow: _cornerstoneComponentsControlsControlBaseComponent['default'].isKeyMapped('nofollow'),

    showURL: _ember['default'].computed.equal('linkType', 'url'),
    showEmail: _ember['default'].computed.equal('linkType', 'email'),
    showPhone: _ember['default'].computed.equal('linkType', 'tel'),

    linkPreview: _ember['default'].computed('control.keyUrl', 'linkType', function () {
      switch (this.get('linkType')) {
        case 'email':
          {
            var subject = this.get('emailSubject');
            subject = subject ? '?subject=' + encodeURI(subject) : '';
            return 'mailto:' + this.get('emailAddress') + subject;
          }
        case 'tel':
          {
            return 'tel:' + encodeURI(this.get('phoneNumber'));
          }
      }

      return this.get('control.keyUrl');
    }),

    linkType: _ember['default'].computed('control.keyUrl', {
      get: function get() {

        var current = this.get('control.keyUrl') || '';

        if (current.match(/mailto:/)) {
          return 'email';
        }

        if (current.match(/tel:/)) {
          return 'tel';
        }

        return 'url';
      },
      set: function set(key, value) {
        return value;
      }
    }),

    emailAddress: _ember['default'].computed('control.keyUrl', {
      get: function get() {

        var current = this.get('control.keyUrl') || '';

        if (!current.match(/mailto:/)) {
          return '';
        }

        return current.replace(/mailto:(?:\/\/)?/g, '').replace(/\?.*/g, '');
      },
      set: function set(key, value) {
        var subject = this.get('emailSubject');
        subject = subject ? '?subject=' + encodeURI(subject) : '';
        value = value.replace(/mailto:(?:\/\/)?/g, '').replace(/\?.*/g, '');
        this.set('control.keyUrl', 'mailto:' + value + subject);

        return value;
      }
    }),

    emailSubject: _ember['default'].computed('control.keyUrl', {
      get: function get() {
        var current = this.get('control.keyUrl') || '';

        if (!current.match(/mailto:/)) {
          return '';
        }

        var matches = current.match(/\?subject=(.*)/) || '';
        if (!matches && !matches[1]) {
          return '';
        }
        return decodeURI(matches[1]);
      },
      set: function set(key, value) {

        var mailto = (this.get('control.keyUrl') || '').replace(/\?.*/g, '');
        var subject = value.length > 0 ? '?subject=' + encodeURI(value) : '';

        this.set('control.keyUrl', '' + mailto + subject);

        return value;
      }
    }),

    phoneNumber: _ember['default'].computed('control.keyUrl', {
      get: function get() {
        var current = this.get('control.keyUrl') || '';
        if (!current.match(/tel:/)) {
          return '';
        }
        return decodeURI(current.replace(/tel:(?:\/\/)?/g, ''));
      },
      set: function set(key, value) {
        this.set('control.keyUrl', '' === value ? '' : 'tel:' + encodeURI(value));
        return value;
      }
    })

  });
});
define("cornerstone/components/controls/control-link/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 5,
                  "column": 4
                },
                "end": {
                  "line": 7,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-link/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "input", [], ["value", ["subexpr", "@mut", [["get", "linkPreview", ["loc", [null, [6, 20], [6, 31]]], 0, 0, 0, 0]], [], [], 0, 0], "disabled", "true"], ["loc", [null, [6, 6], [6, 49]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child1 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 9,
                  "column": 4
                },
                "end": {
                  "line": 11,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-link/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "forms/choose-single", [], ["choices", ["subexpr", "@mut", [["get", "typeChoices", ["loc", [null, [10, 36], [10, 47]]], 0, 0, 0, 0]], [], [], 0, 0], "value", ["subexpr", "@mut", [["get", "linkType", ["loc", [null, [10, 54], [10, 62]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [10, 6], [10, 64]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child2 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 13,
                  "column": 4
                },
                "end": {
                  "line": 15,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-link/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "input", [], ["value", ["subexpr", "@mut", [["get", "control.keyContent", ["loc", [null, [14, 20], [14, 38]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [14, 6], [14, 40]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child3 = (function () {
          var child0 = (function () {
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 19,
                    "column": 6
                  },
                  "end": {
                    "line": 21,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/controls/control-link/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                return morphs;
              },
              statements: [["inline", "forms/rc-choice", [], ["value", ["subexpr", "@mut", [["get", "control.keyNewTab", ["loc", [null, [20, 32], [20, 49]]], 0, 0, 0, 0]], [], [], 0, 0], "label", "New Tab", "half", true], ["loc", [null, [20, 8], [20, 77]]], 0, 0]],
              locals: [],
              templates: []
            };
          })();
          var child1 = (function () {
            var child0 = (function () {
              return {
                meta: {
                  "revision": "Ember@2.8.0",
                  "loc": {
                    "source": null,
                    "start": {
                      "line": 23,
                      "column": 8
                    },
                    "end": {
                      "line": 25,
                      "column": 8
                    }
                  },
                  "moduleName": "cornerstone/components/controls/control-link/template.hbs"
                },
                isEmpty: false,
                arity: 0,
                cachedFragment: null,
                hasRendered: false,
                buildFragment: function buildFragment(dom) {
                  var el0 = dom.createDocumentFragment();
                  var el1 = dom.createTextNode("          ");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createElement("code");
                  var el2 = dom.createTextNode("nofollow");
                  dom.appendChild(el1, el2);
                  dom.appendChild(el0, el1);
                  var el1 = dom.createTextNode("\n");
                  dom.appendChild(el0, el1);
                  return el0;
                },
                buildRenderNodes: function buildRenderNodes() {
                  return [];
                },
                statements: [],
                locals: [],
                templates: []
              };
            })();
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 22,
                    "column": 6
                  },
                  "end": {
                    "line": 26,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/controls/control-link/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
                dom.insertBoundary(fragment, 0);
                dom.insertBoundary(fragment, null);
                return morphs;
              },
              statements: [["block", "forms/rc-choice", [], ["value", ["subexpr", "@mut", [["get", "control.keyNofollow", ["loc", [null, [23, 33], [23, 52]]], 0, 0, 0, 0]], [], [], 0, 0], "half", true], 0, null, ["loc", [null, [23, 8], [25, 28]]]]],
              locals: [],
              templates: [child0]
            };
          })();
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 17,
                  "column": 4
                },
                "end": {
                  "line": 27,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-link/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(3);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
              morphs[2] = dom.createMorphAt(fragment, 4, 4, contextualElement);
              dom.insertBoundary(fragment, null);
              return morphs;
            },
            statements: [["inline", "input", [], ["value", ["subexpr", "@mut", [["get", "control.keyUrl", ["loc", [null, [18, 20], [18, 34]]], 0, 0, 0, 0]], [], [], 0, 0], "placeholder", "e.g. http://theme.co/"], ["loc", [null, [18, 6], [18, 72]]], 0, 0], ["block", "if", [["get", "showNewTab", ["loc", [null, [19, 12], [19, 22]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [19, 6], [21, 13]]]], ["block", "if", [["get", "showNofollow", ["loc", [null, [22, 12], [22, 24]]], 0, 0, 0, 0]], [], 1, null, ["loc", [null, [22, 6], [26, 13]]]]],
            locals: [],
            templates: [child0, child1]
          };
        })();
        var child4 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 29,
                  "column": 4
                },
                "end": {
                  "line": 31,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-link/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "input", [], ["value", ["subexpr", "@mut", [["get", "emailAddress", ["loc", [null, [30, 20], [30, 32]]], 0, 0, 0, 0]], [], [], 0, 0], "placeholder", "e.g. hello@example.com"], ["loc", [null, [30, 6], [30, 71]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child5 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 33,
                  "column": 4
                },
                "end": {
                  "line": 35,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-link/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "input", [], ["value", ["subexpr", "@mut", [["get", "emailSubject", ["loc", [null, [34, 20], [34, 32]]], 0, 0, 0, 0]], [], [], 0, 0], "placeholder", "e.g. Howdy!"], ["loc", [null, [34, 6], [34, 60]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child6 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 37,
                  "column": 4
                },
                "end": {
                  "line": 39,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-link/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "input", [], ["value", ["subexpr", "@mut", [["get", "phoneNumber", ["loc", [null, [38, 20], [38, 31]]], 0, 0, 0, 0]], [], [], 0, 0], "placeholder", "e.g. 18885551234"], ["loc", [null, [38, 6], [38, 64]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 3,
                "column": 2
              },
              "end": {
                "line": 41,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/controls/control-link/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(7);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
            morphs[2] = dom.createMorphAt(fragment, 5, 5, contextualElement);
            morphs[3] = dom.createMorphAt(fragment, 7, 7, contextualElement);
            morphs[4] = dom.createMorphAt(fragment, 9, 9, contextualElement);
            morphs[5] = dom.createMorphAt(fragment, 11, 11, contextualElement);
            morphs[6] = dom.createMorphAt(fragment, 13, 13, contextualElement);
            return morphs;
          },
          statements: [["block", "controls/input-list-item", [], ["label", "Preview"], 0, null, ["loc", [null, [5, 4], [7, 33]]]], ["block", "controls/input-list-item", [], ["label", "Type"], 1, null, ["loc", [null, [9, 4], [11, 33]]]], ["block", "controls/input-list-item", [], ["label", "Content", "isVisible", ["subexpr", "@mut", [["get", "showContent", ["loc", [null, [13, 58], [13, 69]]], 0, 0, 0, 0]], [], [], 0, 0]], 2, null, ["loc", [null, [13, 4], [15, 33]]]], ["block", "controls/input-list-item", [], ["label", "URL", "isVisible", ["subexpr", "@mut", [["get", "showURL", ["loc", [null, [17, 54], [17, 61]]], 0, 0, 0, 0]], [], [], 0, 0]], 3, null, ["loc", [null, [17, 4], [27, 33]]]], ["block", "controls/input-list-item", [], ["label", "Email", "isVisible", ["subexpr", "@mut", [["get", "showEmail", ["loc", [null, [29, 56], [29, 65]]], 0, 0, 0, 0]], [], [], 0, 0]], 4, null, ["loc", [null, [29, 4], [31, 33]]]], ["block", "controls/input-list-item", [], ["label", "Subject", "isVisible", ["subexpr", "@mut", [["get", "showEmail", ["loc", [null, [33, 58], [33, 67]]], 0, 0, 0, 0]], [], [], 0, 0]], 5, null, ["loc", [null, [33, 4], [35, 33]]]], ["block", "controls/input-list-item", [], ["label", "Phone", "isVisible", ["subexpr", "@mut", [["get", "showPhone", ["loc", [null, [37, 56], [37, 65]]], 0, 0, 0, 0]], [], [], 0, 0]], 6, null, ["loc", [null, [37, 4], [39, 33]]]]],
          locals: [],
          templates: [child0, child1, child2, child3, child4, child5, child6]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 43,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-link/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          return morphs;
        },
        statements: [["block", "controls/input-list", [], [], 0, null, ["loc", [null, [3, 2], [41, 26]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 45,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-link/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [43, 22]]]], ["content", "yield", ["loc", [null, [44, 0], [44, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-number/component', ['exports', 'cornerstone/components/controls/control-base/component', 'cornerstone/mixins/controls/placeholder'], function (exports, _cornerstoneComponentsControlsControlBaseComponent, _cornerstoneMixinsControlsPlaceholder) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend(_cornerstoneMixinsControlsPlaceholder['default'], {});
});
// import Ember from 'ember';
define("cornerstone/components/controls/control-number/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 4,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-number/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "input", [], ["value", ["subexpr", "@mut", [["get", "value", ["loc", [null, [3, 16], [3, 21]]], 0, 0, 0, 0]], [], [], 0, 0], "placeholder", ["subexpr", "@mut", [["get", "placeholder", ["loc", [null, [3, 34], [3, 45]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [3, 2], [3, 47]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 6,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-number/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [4, 22]]]], ["content", "yield", ["loc", [null, [5, 0], [5, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-ratio/component', ['exports', 'cornerstone/components/controls/control-base/component', 'cornerstone/mixins/controls/placeholder'], function (exports, _cornerstoneComponentsControlsControlBaseComponent, _cornerstoneMixinsControlsPlaceholder) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend(_cornerstoneMixinsControlsPlaceholder['default'], {
    classNameBindings: ['monospace:cs-monospace-input']
  });
});
// import Ember from 'ember';
define("cornerstone/components/controls/control-ratio/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 4,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-ratio/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "forms/ratio-input", [], ["value", ["subexpr", "@mut", [["get", "control.keyValue", ["loc", [null, [3, 28], [3, 44]]], 0, 0, 0, 0]], [], [], 0, 0], "placeholder", ["subexpr", "@mut", [["get", "placeholder", ["loc", [null, [3, 57], [3, 68]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [3, 2], [3, 70]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 6,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-ratio/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [4, 22]]]], ["content", "yield", ["loc", [null, [5, 0], [5, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-select/component', ['exports', 'ember', 'cornerstone/components/controls/control-base/component'], function (exports, _ember, _cornerstoneComponentsControlsControlBaseComponent) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend({

    service: _ember['default'].inject.service('controls'),
    store: _ember['default'].inject.service(),

    choices: _ember['default'].computed('control.choices.[]', 'control.options.choices.[]', function () {

      var choices = this.getWithDefault('control.choices', this.getWithDefault('control.options.choices', _ember['default'].A()));

      if ('list:fonts' === choices) {
        return this.get('service').getOptionList('fonts');
      }

      if ('list:font-weights' === choices) {
        return this.get('service').getOptionList('font-weights');
      }

      if ('string' === typeof choices && 0 === choices.indexOf('dynamic:')) {
        return choices.replace('dynamic:', '');
      }

      return _ember['default'].isArray(choices) ? choices : _ember['default'].A();
    })

  });
});
define("cornerstone/components/controls/control-select/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 4,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-select/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "forms/styled-select", [], ["value", ["subexpr", "@mut", [["get", "value", ["loc", [null, [3, 30], [3, 35]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "choices", ["loc", [null, [3, 44], [3, 51]]], 0, 0, 0, 0]], [], [], 0, 0], "visibilityObservation", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [3, 74], [3, 82]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [3, 2], [3, 85]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 6,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-select/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [4, 22]]]], ["content", "yield", ["loc", [null, [5, 0], [5, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-text-editor/component', ['exports', 'cornerstone/components/controls/control-base/component', 'cornerstone/mixins/controls/placeholder'], function (exports, _cornerstoneComponentsControlsControlBaseComponent, _cornerstoneMixinsControlsPlaceholder) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend(_cornerstoneMixinsControlsPlaceholder['default'], {});
});
// import Ember from 'ember';
define("cornerstone/components/controls/control-text-editor/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 8,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-text-editor/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "forms/expandable-text-editor", [], ["placeholder", ["subexpr", "@mut", [["get", "placeholder", ["loc", [null, [4, 16], [4, 27]]], 0, 0, 0, 0]], [], [], 0, 0], "value", ["subexpr", "@mut", [["get", "value", ["loc", [null, [5, 10], [5, 15]]], 0, 0, 0, 0]], [], [], 0, 0], "mode", ["subexpr", "@mut", [["get", "control.options.mode", ["loc", [null, [6, 9], [6, 29]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [3, 2], [7, 4]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 10,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-text-editor/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [8, 22]]]], ["content", "yield", ["loc", [null, [9, 0], [9, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-text-shadow/component', ['exports', 'ember', 'cornerstone/components/controls/control-base/component', 'cornerstone/mixins/controls/placeholder', 'cornerstone/util/split-on-whitespace'], function (exports, _ember, _cornerstoneComponentsControlsControlBaseComponent, _cornerstoneMixinsControlsPlaceholder, _cornerstoneUtilSplitOnWhitespace) {

  function composedValue(name) {
    return _ember['default'].computed('value', {
      get: function get() {
        return this.destruct()[name];
      },
      set: function set(key, value) {
        var update = {};
        update[name] = value;
        this.set('value', this.reconstitute(update));
        return value;
      }
    });
  }

  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend(_cornerstoneMixinsControlsPlaceholder['default'], {

    reconstitute: function reconstitute(updates) {

      var data = this.destruct();

      for (var key in updates) {
        data[key] = updates[key];
      }

      return data.xOffset + ' ' + data.yOffset + ' ' + data.blur;
    },

    destruct: function destruct() {

      var parts = (0, _cornerstoneUtilSplitOnWhitespace['default'])(this.getWithDefault('value', ''));

      var data = {
        xOffset: _ember['default'].isPresent(parts[0]) ? parts[0] : '0px',
        yOffset: _ember['default'].isPresent(parts[1]) ? parts[1] : '0px',
        blur: _ember['default'].isPresent(parts[2]) ? parts[2] : '0px'
      };

      return data;
    },

    xOffset: composedValue('xOffset'),
    yOffset: composedValue('yOffset'),
    blur: composedValue('blur'),
    showColor: _cornerstoneComponentsControlsControlBaseComponent['default'].isKeyMapped('color'),
    showAltColor: _cornerstoneComponentsControlsControlBaseComponent['default'].isKeyMapped('alt_color'),

    xOffsetOptions: _cornerstoneComponentsControlsControlBaseComponent['default'].subOptions('x_offset', {
      available_units: ['px', 'em', 'rem'],
      ranges: {
        px: { min: -50, max: 50, step: 1 },
        em: { min: -1, max: 1, step: 0.001 },
        rem: { min: -1, max: 1, step: 0.001 }
      }
    }),

    yOffsetOptions: _cornerstoneComponentsControlsControlBaseComponent['default'].subOptions('y_offset', {
      available_units: ['px', 'em', 'rem'],
      ranges: {
        px: { min: -50, max: 50, step: 1 },
        em: { min: -1, max: 1, step: 0.001 },
        rem: { min: -1, max: 1, step: 0.001 }
      }
    }),

    blurOptions: _cornerstoneComponentsControlsControlBaseComponent['default'].subOptions('blur', {
      available_units: ['px', 'em', 'rem'],
      ranges: {
        px: { min: 0, max: 50, step: 1 },
        em: { min: 0, max: 2.5, step: 0.001 },
        rem: { min: 0, max: 2.5, step: 0.001 }
      }
    }),

    colorOptions: _cornerstoneComponentsControlsControlBaseComponent['default'].subOptions('color'),
    altColorOptions: _ember['default'].computed('colorOptions', function () {
      var options = _ember['default'].copy(this.get('colorOptions'));
      if (options.alt_label) {
        options.label = options.alt_label;
      }
      return options;
    })
  });
});
define("cornerstone/components/controls/control-text-shadow/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 5,
                  "column": 4
                },
                "end": {
                  "line": 7,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-text-shadow/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "forms/unit-slider", [], ["value", ["subexpr", "@mut", [["get", "xOffset", ["loc", [null, [6, 32], [6, 39]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "xOffsetOptions", ["loc", [null, [6, 48], [6, 62]]], 0, 0, 0, 0]], [], [], 0, 0], "debug", true], ["loc", [null, [6, 6], [6, 75]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child1 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 9,
                  "column": 4
                },
                "end": {
                  "line": 11,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-text-shadow/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "forms/unit-slider", [], ["value", ["subexpr", "@mut", [["get", "yOffset", ["loc", [null, [10, 32], [10, 39]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "yOffsetOptions", ["loc", [null, [10, 48], [10, 62]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [10, 6], [10, 65]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child2 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 13,
                  "column": 4
                },
                "end": {
                  "line": 15,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-text-shadow/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "forms/unit-slider", [], ["value", ["subexpr", "@mut", [["get", "blur", ["loc", [null, [14, 32], [14, 36]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "blurOptions", ["loc", [null, [14, 45], [14, 56]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [14, 6], [14, 58]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child3 = (function () {
          var child0 = (function () {
            var child0 = (function () {
              return {
                meta: {
                  "revision": "Ember@2.8.0",
                  "loc": {
                    "source": null,
                    "start": {
                      "line": 20,
                      "column": 8
                    },
                    "end": {
                      "line": 22,
                      "column": 8
                    }
                  },
                  "moduleName": "cornerstone/components/controls/control-text-shadow/template.hbs"
                },
                isEmpty: false,
                arity: 0,
                cachedFragment: null,
                hasRendered: false,
                buildFragment: function buildFragment(dom) {
                  var el0 = dom.createDocumentFragment();
                  var el1 = dom.createTextNode("          ");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createComment("");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createTextNode("\n");
                  dom.appendChild(el0, el1);
                  return el0;
                },
                buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                  var morphs = new Array(1);
                  morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                  return morphs;
                },
                statements: [["inline", "forms/color-picker", [], ["value", ["subexpr", "@mut", [["get", "control.keyAltColor", ["loc", [null, [21, 37], [21, 56]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "altColorOptions", ["loc", [null, [21, 65], [21, 80]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [21, 10], [21, 82]]], 0, 0]],
                locals: [],
                templates: []
              };
            })();
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 18,
                    "column": 6
                  },
                  "end": {
                    "line": 23,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/controls/control-text-shadow/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(2);
                morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
                dom.insertBoundary(fragment, null);
                return morphs;
              },
              statements: [["inline", "forms/color-picker", [], ["value", ["subexpr", "@mut", [["get", "control.keyColor", ["loc", [null, [19, 35], [19, 51]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "colorOptions", ["loc", [null, [19, 60], [19, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [19, 8], [19, 74]]], 0, 0], ["block", "if", [["get", "showAltColor", ["loc", [null, [20, 14], [20, 26]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [20, 8], [22, 15]]]]],
              locals: [],
              templates: [child0]
            };
          })();
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 17,
                  "column": 4
                },
                "end": {
                  "line": 24,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-text-shadow/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
              dom.insertBoundary(fragment, 0);
              dom.insertBoundary(fragment, null);
              return morphs;
            },
            statements: [["block", "controls/input-list-item", [], ["label", "Color"], 0, null, ["loc", [null, [18, 6], [23, 35]]]]],
            locals: [],
            templates: [child0]
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 3,
                "column": 2
              },
              "end": {
                "line": 26,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/controls/control-text-shadow/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(4);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
            morphs[2] = dom.createMorphAt(fragment, 5, 5, contextualElement);
            morphs[3] = dom.createMorphAt(fragment, 7, 7, contextualElement);
            return morphs;
          },
          statements: [["block", "controls/input-list-item", [], ["label", "X-Offset"], 0, null, ["loc", [null, [5, 4], [7, 33]]]], ["block", "controls/input-list-item", [], ["label", "Y-Offset"], 1, null, ["loc", [null, [9, 4], [11, 33]]]], ["block", "controls/input-list-item", [], ["label", "Blur"], 2, null, ["loc", [null, [13, 4], [15, 33]]]], ["block", "if", [["get", "showColor", ["loc", [null, [17, 10], [17, 19]]], 0, 0, 0, 0]], [], 3, null, ["loc", [null, [17, 4], [24, 11]]]]],
          locals: [],
          templates: [child0, child1, child2, child3]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 27,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-text-shadow/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "controls/input-list", [], [], 0, null, ["loc", [null, [3, 2], [26, 26]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 29,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-text-shadow/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [27, 22]]]], ["content", "yield", ["loc", [null, [28, 0], [28, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-text/component', ['exports', 'cornerstone/components/controls/control-base/component', 'cornerstone/mixins/controls/placeholder'], function (exports, _cornerstoneComponentsControlsControlBaseComponent, _cornerstoneMixinsControlsPlaceholder) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend(_cornerstoneMixinsControlsPlaceholder['default'], {
    classNameBindings: ['monospace:cs-monospace-input']
  });
});
// import Ember from 'ember';
define("cornerstone/components/controls/control-text/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 4,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-text/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "input", [], ["value", ["subexpr", "@mut", [["get", "control.keyValue", ["loc", [null, [3, 16], [3, 32]]], 0, 0, 0, 0]], [], [], 0, 0], "placeholder", ["subexpr", "@mut", [["get", "placeholder", ["loc", [null, [3, 45], [3, 56]]], 0, 0, 0, 0]], [], [], 0, 0], "class", ["subexpr", "if", [["get", "control.options.monospace", ["loc", [null, [3, 67], [3, 92]]], 0, 0, 0, 0], "cs-input-code"], [], ["loc", [null, [3, 63], [3, 109]]], 0, 0]], ["loc", [null, [3, 2], [3, 111]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 6,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-text/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [4, 22]]]], ["content", "yield", ["loc", [null, [5, 0], [5, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-textarea/component', ['exports', 'cornerstone/components/controls/control-base/component', 'cornerstone/mixins/controls/placeholder'], function (exports, _cornerstoneComponentsControlsControlBaseComponent, _cornerstoneMixinsControlsPlaceholder) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend(_cornerstoneMixinsControlsPlaceholder['default'], {
    classNameBindings: ['monospace:cs-monospace-input'],
    defaultHeight: 5
  });
});
// import Ember from 'ember';
define("cornerstone/components/controls/control-textarea/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 4,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-textarea/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "textarea", [], ["value", ["subexpr", "@mut", [["get", "value", ["loc", [null, [3, 19], [3, 24]]], 0, 0, 0, 0]], [], [], 0, 0], "placeholder", ["subexpr", "@mut", [["get", "placeholder", ["loc", [null, [3, 37], [3, 48]]], 0, 0, 0, 0]], [], [], 0, 0], "class", ["subexpr", "if", [["get", "control.options.monospace", ["loc", [null, [3, 59], [3, 84]]], 0, 0, 0, 0], "cs-input-code"], [], ["loc", [null, [3, 55], [3, 101]]], 0, 0]], ["loc", [null, [3, 2], [3, 103]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 5,
            "column": 9
          }
        },
        "moduleName": "cornerstone/components/controls/control-textarea/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [4, 22]]]], ["content", "yield", ["loc", [null, [5, 0], [5, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-toggle/component', ['exports', 'ember', 'cornerstone/components/controls/control-base/component'], function (exports, _ember, _cornerstoneComponentsControlsControlBaseComponent) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend({

    state: _ember['default'].computed('value', function () {
      return this.normalize(this.get('value'));
    }),

    toggleStateClass: _ember['default'].computed('state', function () {
      return this.get('state') ? 'on' : 'off';
    }),

    // Detect various forms of boolean storage and play along

    normalize: function normalize(value) {

      if ('1' === value || 'true' === value) {
        return true;
      }

      if ('' === value || 'false' === value) {
        return false;
      }

      return !!value;
    },

    invert: function invert(value) {

      if ('true' === value) {
        return 'false';
      }

      if ('false' === value) {
        return 'true';
      }

      if ('1' === value) {
        return '';
      }

      if ('' === value) {
        return '1';
      }

      return !value;
    },

    actions: {
      toggle: function toggle() {
        this.set('value', this.invert(this.get('value')));
      }
    }
  });
});
define("cornerstone/components/controls/control-toggle/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 4,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-toggle/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "forms/cs-toggle", [], ["value", ["subexpr", "@mut", [["get", "value", ["loc", [null, [3, 26], [3, 31]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [3, 2], [3, 33]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 5,
            "column": 9
          }
        },
        "moduleName": "cornerstone/components/controls/control-toggle/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [4, 22]]]], ["content", "yield", ["loc", [null, [5, 0], [5, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-unit-slider/component', ['exports', 'cornerstone/components/controls/control-base/component'], function (exports, _cornerstoneComponentsControlsControlBaseComponent) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend({});
});
// import Ember from 'ember';
define("cornerstone/components/controls/control-unit-slider/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 4,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-unit-slider/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "forms/unit-slider", [], ["value", ["subexpr", "@mut", [["get", "value", ["loc", [null, [3, 28], [3, 33]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "control.options", ["loc", [null, [3, 42], [3, 57]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [3, 2], [3, 59]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 5,
            "column": 9
          }
        },
        "moduleName": "cornerstone/components/controls/control-unit-slider/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [4, 22]]]], ["content", "yield", ["loc", [null, [5, 0], [5, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-unit/component', ['exports', 'cornerstone/components/controls/control-base/component'], function (exports, _cornerstoneComponentsControlsControlBaseComponent) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend({});
});
// import Ember from 'ember';
define("cornerstone/components/controls/control-unit/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 7,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-unit/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "forms/unit-input", [], ["value", ["subexpr", "@mut", [["get", "value", ["loc", [null, [4, 10], [4, 15]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "control.options", ["loc", [null, [5, 12], [5, 27]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [3, 2], [6, 4]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 8,
            "column": 9
          }
        },
        "moduleName": "cornerstone/components/controls/control-unit/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [7, 22]]]], ["content", "yield", ["loc", [null, [8, 0], [8, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/input-list-item/component', ['exports', 'cornerstone/components/controls/control-base/component'], function (exports, _cornerstoneComponentsControlsControlBaseComponent) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend({
    level: 2,
    tagName: 'li',
    control: {
      type: 'aggregate'
    }
  });
});
// import Ember from 'ember';
define("cornerstone/components/controls/input-list-item/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 3,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/input-list-item/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("div");
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element0 = dom.childAt(fragment, [2]);
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createAttrMorph(element0, 'class');
        morphs[2] = dom.createMorphAt(element0, 0, 0);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["attribute", "class", ["concat", [["get", "containerClass", ["loc", [null, [2, 14], [2, 28]]], 0, 0, 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["content", "yield", ["loc", [null, [2, 32], [2, 41]]], 0, 0, 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
define('cornerstone/components/controls/input-list/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    tagName: 'ul',
    classNames: ['cs-control-input-list'],

    level: _ember['default'].computed('parentLevel', function () {
      return this.getWithDefault('parentLevel', 1) + 1;
    })
  });
});
define("cornerstone/components/controls/input-list/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 3,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/input-list/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["content", "yield", ["loc", [null, [2, 2], [2, 11]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 4,
                "column": 2
              },
              "end": {
                "line": 6,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/controls/input-list/template.hbs"
          },
          isEmpty: false,
          arity: 1,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("    ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            return morphs;
          },
          statements: [["inline", "component", [["subexpr", "locate-component", [["subexpr", "concat", ["controls/control-", ["get", "control.type", ["loc", [null, [5, 62], [5, 74]]], 0, 0, 0, 0]], [], ["loc", [null, [5, 34], [5, 76]]], 0, 0], "controls/input-list-item"], [], ["loc", [null, [5, 16], [5, 104]]], 0, 0]], ["control", ["subexpr", "@mut", [["get", "control", ["loc", [null, [5, 113], [5, 120]]], 0, 0, 0, 0]], [], [], 0, 0], "level", ["subexpr", "@mut", [["get", "level", ["loc", [null, [5, 127], [5, 132]]], 0, 0, 0, 0]], [], [], 0, 0], "tagName", "li"], ["loc", [null, [5, 4], [5, 147]]], 0, 0]],
          locals: ["control"],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 3,
              "column": 0
            },
            "end": {
              "line": 7,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/input-list/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "each", [["get", "controls", ["loc", [null, [4, 10], [4, 18]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [4, 2], [6, 11]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 7,
            "column": 7
          }
        },
        "moduleName": "cornerstone/components/controls/input-list/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["block", "if", [["get", "hasBlock", ["loc", [null, [1, 6], [1, 14]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [1, 0], [7, 7]]]]],
      locals: [],
      templates: [child0, child1]
    };
  })());
});
define('cornerstone/components/controls/manage-presets/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({

    classNames: ['cs-control cs-control-manage-presets'],
    showHeader: true,
    label: 'Element Presets',
    actions: {
      apply: function apply() {
        var _this = this;

        var selected = this.get('selected');
        if (!selected) {
          return;
        }

        this.get('ui').confirm({
          message: this.get('i18n').t('app.inspector.apply-preset-warning'),
          accept: function accept() {
            _this.sendAction('onApply', selected);
          },
          acceptClass: 'sad'
        });
      },
      save: function save() {
        this.sendAction('onSave', this.get('name'));
        this.set('name', '');
      }
    }
  });
});
define("cornerstone/components/controls/manage-presets/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 4,
                "column": 4
              },
              "end": {
                "line": 12,
                "column": 4
              }
            },
            "moduleName": "cornerstone/components/controls/manage-presets/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("      ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n      ");
            dom.appendChild(el0, el1);
            var el1 = dom.createElement("button");
            var el2 = dom.createTextNode("Apply");
            dom.appendChild(el1, el2);
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var element0 = dom.childAt(fragment, [3]);
            var morphs = new Array(3);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            morphs[1] = dom.createAttrMorph(element0, 'class');
            morphs[2] = dom.createElementMorph(element0);
            return morphs;
          },
          statements: [["inline", "forms/styled-select", [], ["placeholder", "No presets", "value", ["subexpr", "@mut", [["get", "value", ["loc", [null, [7, 14], [7, 19]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "presets", ["loc", [null, [8, 16], [8, 23]]], 0, 0, 0, 0]], [], [], 0, 0], "value", ["subexpr", "@mut", [["get", "selected", ["loc", [null, [9, 14], [9, 22]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [5, 6], [10, 8]]], 0, 0], ["attribute", "class", ["concat", ["cs-control-manage-presets-apply ", ["subexpr", "if", [["get", "ui.deleteConfirm", ["loc", [null, [11, 58], [11, 74]]], 0, 0, 0, 0], "cs-danger"], [], ["loc", [null, [11, 53], [11, 88]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["apply"], ["allowedKeys", "shift"], ["loc", [null, [11, 90], [11, 128]]], 0, 0]],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 3,
              "column": 2
            },
            "end": {
              "line": 17,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/controls/manage-presets/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "controls/input-list-item", [], ["label", "Apply<br>Preset"], 0, null, ["loc", [null, [4, 4], [12, 33]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 19,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/manage-presets/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "cs-control-input");
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(2);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(dom.childAt(fragment, [2]), 1, 1);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", ["partials/controls/control-header"], [], ["loc", [null, [1, 0], [1, 46]]], 0, 0], ["block", "controls/input-list", [], [], 0, null, ["loc", [null, [3, 2], [17, 26]]]]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/cs-islands/component', ['exports', 'ember'], function (exports, _ember) {
  var $ = _ember['default'].$;
  var assert = _ember['default'].assert;
  var Component = _ember['default'].Component;
  var getOwner = _ember['default'].getOwner;
  exports['default'] = _ember['default'].Component.extend({
    tagName: '',

    init: function init() {
      this._super.apply(this, arguments);
      this.renderComponent = getRenderComponentFor(this);
      this.componentsToRender = queryIslandComponents();
      this.renderedComponents = [];
    },

    didInsertElement: function didInsertElement() {
      this.renderedComponents = this.componentsToRender.map(this.renderComponent);
    },

    didDestroyElement: function didDestroyElement() {
      this.renderedComponents.forEach(function (renderedComponent) {
        renderedComponent.destroy();
      });
    }
  });

  function componentAttributes(element) {
    var attrs = undefined;
    var attrsJSON = element.getAttribute('data-attrs');

    if (attrsJSON) {
      attrs = JSON.parse(attrsJSON);
    } else {
      attrs = {};
    }

    attrs.innerContent = element.innerHTML;
    return attrs;
  }

  function getRenderComponentFor(emberObject) {
    var owner = getOwner(emberObject);

    return function renderComponent(_ref) {
      var name = _ref.name;
      var attrs = _ref.attrs;
      var element = _ref.element;

      var component = lookupComponent(owner, name);
      assert('ember-islands could not find a component named "' + name + '" in your Ember appliction.', component);

      // Work around for #replaceIn bug
      $(element).empty();
      var componentInstance = component.create(attrs);
      componentInstance.appendTo(element);
      _ember['default'].run.scheduleOnce('afterRender', function () {
        $(element).contents().unwrap();
      });

      return componentInstance;
    };
  }

  function queryIslandComponents() {
    var components = [];

    $('[data-cs-component]').each(function () {
      var name = this.getAttribute('data-cs-component');
      var attrs = componentAttributes(this);
      components.push({ attrs: attrs, name: name, element: this });
    });

    return components;
  }

  function lookupComponent(owner, name) {
    var componentLookupKey = 'component:' + name;
    var layoutLookupKey = 'template:components/' + name;
    var layout = owner.lookup(layoutLookupKey);

    if (layout) {
      owner.inject(componentLookupKey, 'layout', layoutLookupKey);
    }

    var component = owner._lookupFactory(componentLookupKey);

    if (layout && !component) {
      owner.register(componentLookupKey, Component);
      component = owner._lookupFactory(componentLookupKey);
    }

    return component;
  }
});
// Ember Islands, modified per https://github.com/mitchlloyd/ember-islands/issues/7#issuecomment-241179736
define("cornerstone/components/cs-islands/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 2,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/cs-islands/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["content", "yield", ["loc", [null, [1, 0], [1, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
define('cornerstone/components/debug/module-data/component', ['exports', 'ember', 'cornerstone/mixins/debug/component'], function (exports, _ember, _cornerstoneMixinsDebugComponent) {
  exports['default'] = _ember['default'].Component.extend(_cornerstoneMixinsDebugComponent['default'], {
    tagName: 'pre',
    classNames: ['cs-debug-module-data'],
    storeAttsFind: '',
    storeAttsReplace: '',

    attsObserver: _ember['default'].observer('module.attsUpdated', function () {
      this.rerender();
    }),

    actions: {
      storeAtts: function storeAtts() {
        var atts = this.get('module').getCleanAtts();
        this.set('ui.debugStoredType', atts._type);
        delete atts._type;
        delete atts._region;
        this.set('ui.debugStoredAtts', atts);
      },
      restoreAtts: function restoreAtts() {
        var atts = this.get('ui.debugStoredAtts');

        var find = this.getWithDefault('storeAttsFind', '');
        var replace = this.getWithDefault('storeAttsReplace', '');

        var defaults = Object.keys(this.get('module.definition.defaults'));
        for (var key in atts) {
          if (atts.hasOwnProperty(key) && 0 === key.indexOf(find)) {
            var newKey = '' === replace ? key : key.replace(find, replace);
            if (defaults.includes(newKey)) {
              this.set('module.atts.' + newKey, atts[key]);
            }
          }
        }
      }
    }

  });
});
define("cornerstone/components/debug/module-data/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 7,
              "column": 0
            },
            "end": {
              "line": 9,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/debug/module-data/template.hbs"
        },
        isEmpty: false,
        arity: 2,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode(": ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(2);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
          dom.insertBoundary(fragment, 0);
          return morphs;
        },
        statements: [["content", "key", ["loc", [null, [8, 0], [8, 7]]], 0, 0, 0, 0], ["content", "value", ["loc", [null, [8, 9], [8, 18]]], 0, 0, 0, 0]],
        locals: ["key", "value"],
        templates: []
      };
    })();
    var child1 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 10,
              "column": 0
            },
            "end": {
              "line": 12,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/debug/module-data/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "input", [], ["value", ["subexpr", "@mut", [["get", "module.atts.content", ["loc", [null, [11, 16], [11, 35]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [11, 2], [11, 37]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 14,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/debug/module-data/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("button");
        var el2 = dom.createTextNode("Store");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("span");
        var el2 = dom.createTextNode("Storing: ");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("button");
        var el2 = dom.createTextNode("Restore");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element0 = dom.childAt(fragment, [0]);
        var element1 = dom.childAt(fragment, [8]);
        var morphs = new Array(9);
        morphs[0] = dom.createElementMorph(element0);
        morphs[1] = dom.createMorphAt(dom.childAt(fragment, [2]), 1, 1);
        morphs[2] = dom.createMorphAt(fragment, 4, 4, contextualElement);
        morphs[3] = dom.createMorphAt(fragment, 6, 6, contextualElement);
        morphs[4] = dom.createElementMorph(element1);
        morphs[5] = dom.createMorphAt(fragment, 10, 10, contextualElement);
        morphs[6] = dom.createMorphAt(fragment, 12, 12, contextualElement);
        morphs[7] = dom.createMorphAt(fragment, 13, 13, contextualElement);
        morphs[8] = dom.createMorphAt(fragment, 14, 14, contextualElement);
        return morphs;
      },
      statements: [["element", "action", ["storeAtts"], [], ["loc", [null, [1, 8], [1, 30]]], 0, 0], ["content", "ui.debugStoredType", ["loc", [null, [2, 15], [2, 37]]], 0, 0, 0, 0], ["inline", "input", [], ["placeholder", "Find: toggle_", "value", ["subexpr", "@mut", [["get", "storeAttsFind", ["loc", [null, [3, 42], [3, 55]]], 0, 0, 0, 0]], [], [], 0, 0], "enter", ["subexpr", "action", ["storeAtts"], [], ["loc", [null, [3, 62], [3, 82]]], 0, 0]], ["loc", [null, [3, 0], [3, 85]]], 0, 0], ["inline", "input", [], ["placeholder", "Replace: toggle_", "value", ["subexpr", "@mut", [["get", "storeAttsReplace", ["loc", [null, [4, 45], [4, 61]]], 0, 0, 0, 0]], [], [], 0, 0], "enter", ["subexpr", "action", ["storeAtts"], [], ["loc", [null, [4, 68], [4, 88]]], 0, 0]], ["loc", [null, [4, 0], [4, 91]]], 0, 0], ["element", "action", ["restoreAtts"], [], ["loc", [null, [5, 8], [5, 32]]], 0, 0], ["content", "module.id", ["loc", [null, [6, 0], [6, 13]]], 0, 0, 0, 0], ["block", "each-in", [["get", "module.atts", ["loc", [null, [7, 11], [7, 22]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [7, 0], [9, 12]]]], ["block", "if", [["subexpr", "eq", [["get", "module.atts._type", ["loc", [null, [10, 10], [10, 27]]], 0, 0, 0, 0], "text"], [], ["loc", [null, [10, 6], [10, 35]]], 0, 0]], [], 1, null, ["loc", [null, [10, 0], [12, 7]]]], ["content", "yield", ["loc", [null, [13, 0], [13, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0, child1]
    };
  })());
});
define('cornerstone/components/debug/module-preview/component', ['exports', 'ember', 'npm:Faker'], function (exports, _ember, _npmFaker) {
  exports['default'] = _ember['default'].Component.extend({
    tagName: ['li'],
    classNames: ['cs-module-preview'],
    xfr: _ember['default'].inject.service(),
    store: _ember['default'].inject.service(),

    childrenSorting: ['order'],
    sortedChildren: _ember['default'].computed.sort('entity.children', 'childrenSorting'),
    init: function init() {
      this._super.apply(this, arguments);
      // this.set('entity', this.get('store').peekRecord('element', this.get('entityId') ) );
      //this.updateObservers();
    },

    actions: {
      test: function test() {
        this.rerender();
      },
      addChild: function addChild() {
        this.get('entity').addChild({
          first_name: _npmFaker['default'].Name.firstName(),
          last_name: _npmFaker['default'].Name.lastName() // this.get('xfr.agent.xfrOrigin'),
        });
      },
      deleteItem: function deleteItem() {
        this.get('entity').selfDestruct();
      },
      dupe: function dupe() {
        this.get('entity').duplicate();
      },
      moveUp: function moveUp() {
        this.get('entity.updatePosition')(this.get('entity.order') - 1);
      },
      moveDown: function moveDown() {
        this.get('entity.updatePosition')(this.get('entity.order') + 1);
      }
    }
  });
});
define("cornerstone/components/debug/module-preview/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 10,
              "column": 0
            },
            "end": {
              "line": 12,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/debug/module-preview/template.hbs"
        },
        isEmpty: false,
        arity: 1,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "debug/module-preview", [], ["entity", ["subexpr", "@mut", [["get", "child", ["loc", [null, [11, 32], [11, 37]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [11, 2], [11, 39]]], 0, 0]],
        locals: ["child"],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 14,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/debug/module-preview/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("ul");
        dom.setAttribute(el1, "class", "children");
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(2);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(dom.childAt(fragment, [2]), 1, 1);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "debug/module-data", [], ["module", ["subexpr", "@mut", [["get", "entity", ["loc", [null, [8, 32], [8, 38]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [8, 5], [8, 40]]], 0, 0], ["block", "each", [["get", "sortedChildren", ["loc", [null, [10, 8], [10, 22]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [10, 0], [12, 9]]]]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/ember-selectize', ['exports', 'ember-cli-selectize/components/ember-selectize'], function (exports, _emberCliSelectizeComponentsEmberSelectize) {
  exports['default'] = _emberCliSelectizeComponentsEmberSelectize['default'];
});
define('cornerstone/components/flash-message', ['exports', 'ember-cli-flash/components/flash-message'], function (exports, _emberCliFlashComponentsFlashMessage) {
  Object.defineProperty(exports, 'default', {
    enumerable: true,
    get: function get() {
      return _emberCliFlashComponentsFlashMessage['default'];
    }
  });
});
define('cornerstone/components/forms/checkbox-list/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({});
});
define("cornerstone/components/forms/checkbox-list/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 3,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/forms/checkbox-list/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["content", "yield", ["loc", [null, [2, 2], [2, 11]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 5,
                  "column": 4
                },
                "end": {
                  "line": 7,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/forms/checkbox-list/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "forms/rc-checkbox", [], ["value", ["subexpr", "mut", [["subexpr", "get", [["get", "proxy", ["loc", [null, [6, 42], [6, 47]]], 0, 0, 0, 0], ["get", "checkbox.keyPath", ["loc", [null, [6, 48], [6, 64]]], 0, 0, 0, 0]], [], ["loc", [null, [6, 37], [6, 65]]], 0, 0]], [], ["loc", [null, [6, 32], [6, 66]]], 0, 0], "label", ["subexpr", "@mut", [["get", "checkbox.label", ["loc", [null, [6, 73], [6, 87]]], 0, 0, 0, 0]], [], [], 0, 0], "half", ["subexpr", "@mut", [["get", "checkbox.half", ["loc", [null, [6, 93], [6, 106]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [6, 6], [6, 108]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 4,
                "column": 2
              },
              "end": {
                "line": 8,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/forms/checkbox-list/template.hbs"
          },
          isEmpty: false,
          arity: 1,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
            dom.insertBoundary(fragment, 0);
            dom.insertBoundary(fragment, null);
            return morphs;
          },
          statements: [["block", "if", [["get", "checkbox.keyPath", ["loc", [null, [5, 10], [5, 26]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [5, 4], [7, 11]]]]],
          locals: ["checkbox"],
          templates: [child0]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 3,
              "column": 0
            },
            "end": {
              "line": 9,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/forms/checkbox-list/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "each", [["get", "checkboxes", ["loc", [null, [4, 10], [4, 20]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [4, 2], [8, 11]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 10,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/forms/checkbox-list/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["block", "if", [["get", "hasBlock", ["loc", [null, [1, 6], [1, 14]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [1, 0], [9, 7]]]]],
      locals: [],
      templates: [child0, child1]
    };
  })());
});
define('cornerstone/components/forms/choose-choice/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    tagName: 'li',
    classNameBindings: ['class', 'selected:cs-active'],

    selected: _ember['default'].computed('choose.value', 'value', function () {

      if (this.get('choose.multi')) {
        return this.getWithDefault('choose.value', '').split(this.getWithDefault('choose.delimiter', ' ')).includes(this.get('value'));
      } else {
        return this.get('choose.value') === this.get('value');
      }
    }),

    click: function click() {
      this.get('choose').send('select', this.get('value'));
    }

  });
});
define("cornerstone/components/forms/choose-choice/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 2
            },
            "end": {
              "line": 4,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/forms/choose-choice/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["content", "yield", ["loc", [null, [3, 4], [3, 13]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 5,
                "column": 4
              },
              "end": {
                "line": 7,
                "column": 4
              }
            },
            "moduleName": "cornerstone/components/forms/choose-choice/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("      ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            return morphs;
          },
          statements: [["inline", "icon", [["get", "icon", ["loc", [null, [6, 13], [6, 17]]], 0, 0, 0, 0]], [], ["loc", [null, [6, 6], [6, 19]]], 0, 0]],
          locals: [],
          templates: []
        };
      })();
      var child1 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 7,
                "column": 4
              },
              "end": {
                "line": 9,
                "column": 4
              }
            },
            "moduleName": "cornerstone/components/forms/choose-choice/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("      ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createUnsafeMorphAt(fragment, 1, 1, contextualElement);
            return morphs;
          },
          statements: [["content", "label", ["loc", [null, [8, 6], [8, 17]]], 0, 0, 0, 0]],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 4,
              "column": 2
            },
            "end": {
              "line": 10,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/forms/choose-choice/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "if", [["get", "icon", ["loc", [null, [5, 10], [5, 14]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [5, 4], [9, 11]]]]],
        locals: [],
        templates: [child0, child1]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 11,
            "column": 7
          }
        },
        "moduleName": "cornerstone/components/forms/choose-choice/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("abbr");
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element0 = dom.childAt(fragment, [0]);
        var morphs = new Array(2);
        morphs[0] = dom.createAttrMorph(element0, 'title');
        morphs[1] = dom.createMorphAt(element0, 1, 1);
        return morphs;
      },
      statements: [["attribute", "title", ["concat", [["get", "tooltip", ["loc", [null, [1, 15], [1, 22]]], 0, 0, 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["block", "if", [["get", "hasBlock", ["loc", [null, [2, 8], [2, 16]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [2, 2], [10, 9]]]]],
      locals: [],
      templates: [child0, child1]
    };
  })());
});
define('cornerstone/components/forms/choose-icon/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({

    classNames: ['cs-icons-outer'],
    rendered: false,
    ready: false,
    searchQuery: '',
    scrollReset: 0,

    init: function init() {
      var _this = this;

      this._super.apply(this, arguments);
      this.get('ui').getFaIcons().then(function (icons) {
        if (_this.isDestroyed) {
          return;
        }
        var reduced = [];
        for (var key in icons) {
          reduced.push({
            id: icons[key][0],
            title: icons[key].length > 1 ? icons[key].join(', ') : icons[key][0]
          });
        }

        _this.set('icons', reduced);
        _this.set('ready', true);
      });
    },

    observeScrollToSelectedOn: _ember['default'].observer('scrollToSelectedOn', function () {
      this.get('scrollToSelectedOn');
      this.scrollToSelected();
    }),

    loaded: _ember['default'].computed('ready', 'rendered', function () {
      return this.get('ready') && this.get('rendered');
    }),

    afterLoad: _ember['default'].observer('loaded', function () {
      this.scrollToSelected();
    }),

    scrollToSelected: function scrollToSelected() {
      var _this2 = this;

      if (!this.get('loaded')) {
        return;
      }

      _ember['default'].run.scheduleOnce('afterRender', function () {
        var value = _this2.get('value');
        if (_ember['default'].isPresent(value)) {
          _this2.set('scrollTo', {
            selector: 'li[data-choice=' + value + ']',
            offset: 1
          });
        } else {
          _this2.incrementProperty('scrollReset');
        }
      });
    },

    didInsertElement: function didInsertElement() {
      var _this3 = this;

      _ember['default'].run.scheduleOnce('afterRender', function () {
        _this3.set('rendered', true);
      });
    },

    actions: {
      select: function select(icon) {
        this.set('value', icon);
      }
    },

    onSearchQuery: _ember['default'].observer('searchQuery', function () {
      _ember['default'].run.debounce(this, this.searchUpdate, 25);
    }),

    searchUpdate: function searchUpdate() {
      var _this4 = this;

      _ember['default'].run.scheduleOnce('afterRender', function () {

        var $ul = _this4.$('ul.cs-choose');
        var query = _this4.get('searchQuery');

        $ul.find('li').show();
        if ('' !== query) {
          $ul.find('li:not([title*="' + query + '"])').hide();
          _this4.incrementProperty('scrollReset');
        } else {
          _this4.scrollToSelected();
        }
      });
    }

  });
});
define("cornerstone/components/forms/choose-icon/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 6,
                  "column": 8
                },
                "end": {
                  "line": 12,
                  "column": 8
                }
              },
              "moduleName": "cornerstone/components/forms/choose-icon/template.hbs"
            },
            isEmpty: false,
            arity: 1,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("          ");
              dom.appendChild(el0, el1);
              var el1 = dom.createElement("li");
              var el2 = dom.createComment("");
              dom.appendChild(el1, el2);
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var element0 = dom.childAt(fragment, [1]);
              var morphs = new Array(5);
              morphs[0] = dom.createAttrMorph(element0, 'data-choice');
              morphs[1] = dom.createAttrMorph(element0, 'title');
              morphs[2] = dom.createAttrMorph(element0, 'class');
              morphs[3] = dom.createElementMorph(element0);
              morphs[4] = dom.createMorphAt(element0, 0, 0);
              return morphs;
            },
            statements: [["attribute", "data-choice", ["concat", [["get", "icon.id", ["loc", [null, [8, 27], [8, 34]]], 0, 0, 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["attribute", "title", ["concat", [["get", "icon.title", ["loc", [null, [9, 21], [9, 31]]], 0, 0, 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["attribute", "class", ["concat", [["subexpr", "if", [["subexpr", "eq", [["get", "icon.id", ["loc", [null, [10, 28], [10, 35]]], 0, 0, 0, 0], ["get", "value", ["loc", [null, [10, 36], [10, 41]]], 0, 0, 0, 0]], [], ["loc", [null, [10, 24], [10, 42]]], 0, 0], "cs-active"], [], ["loc", [null, [10, 19], [10, 57]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["select", ["get", "icon.id", ["loc", [null, [7, 32], [7, 39]]], 0, 0, 0, 0]], [], ["loc", [null, [7, 14], [7, 41]]], 0, 0], ["inline", "fa-icon", [["get", "icon.id", ["loc", [null, [11, 21], [11, 28]]], 0, 0, 0, 0]], [], ["loc", [null, [11, 11], [11, 30]]], 0, 0]],
            locals: ["icon"],
            templates: []
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 4,
                "column": 4
              },
              "end": {
                "line": 14,
                "column": 4
              }
            },
            "moduleName": "cornerstone/components/forms/choose-icon/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("      ");
            dom.appendChild(el0, el1);
            var el1 = dom.createElement("ul");
            dom.setAttribute(el1, "class", "cs-choose cols-6 single");
            var el2 = dom.createTextNode("\n");
            dom.appendChild(el1, el2);
            var el2 = dom.createComment("");
            dom.appendChild(el1, el2);
            var el2 = dom.createTextNode("      ");
            dom.appendChild(el1, el2);
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1]), 1, 1);
            return morphs;
          },
          statements: [["block", "each", [["get", "icons", ["loc", [null, [6, 16], [6, 21]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [6, 8], [12, 17]]]]],
          locals: [],
          templates: [child0]
        };
      })();
      var child1 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 14,
                "column": 4
              },
              "end": {
                "line": 16,
                "column": 4
              }
            },
            "moduleName": "cornerstone/components/forms/choose-icon/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("      ");
            dom.appendChild(el0, el1);
            var el1 = dom.createElement("div");
            dom.setAttribute(el1, "class", "cs-icons-loading");
            var el2 = dom.createTextNode("…");
            dom.appendChild(el1, el2);
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes() {
            return [];
          },
          statements: [],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 3,
              "column": 2
            },
            "end": {
              "line": 17,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/forms/choose-icon/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "if", [["get", "loaded", ["loc", [null, [4, 10], [4, 16]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [4, 4], [16, 11]]]]],
        locals: [],
        templates: [child0, child1]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 19,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/forms/choose-icon/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "cs-icons-inner");
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(2);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(dom.childAt(fragment, [2]), 1, 1);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "common/search-bar", [], ["query", ["subexpr", "@mut", [["get", "searchQuery", ["loc", [null, [1, 26], [1, 37]]], 0, 0, 0, 0]], [], [], 0, 0], "placeholder", "Search Icons", "focusOnShortcut", false], ["loc", [null, [1, 0], [1, 88]]], 0, 0], ["block", "common/scroll-box", [], ["scrollTo", ["subexpr", "@mut", [["get", "scrollTo", ["loc", [null, [3, 32], [3, 40]]], 0, 0, 0, 0]], [], [], 0, 0], "resetScrollOn", ["subexpr", "@mut", [["get", "scrollReset", ["loc", [null, [3, 55], [3, 66]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [3, 2], [17, 24]]]]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/forms/choose-multi/component', ['exports', 'ember', 'cornerstone/components/forms/choose-single/component'], function (exports, _ember, _cornerstoneComponentsFormsChooseSingleComponent) {
  exports['default'] = _cornerstoneComponentsFormsChooseSingleComponent['default'].extend({

    multi: true,
    assignDefaultMulti: true,

    actions: {
      select: function select(choice) {
        var delimiter = this.getWithDefault('delimiter', ' ');

        var selected = this.getWithDefault('value', '').split(delimiter);
        var offValue = this.get('offValue');

        // Remove offValue

        if (!_ember['default'].isNone(offValue)) {
          var offValueIndex = selected.indexOf(offValue);
          if (-1 !== offValueIndex) {
            selected.splice(offValueIndex, 1);
          }
        }

        // Add/Remove choice
        var choiceIndex = selected.indexOf(choice);
        if (-1 === choiceIndex) {
          selected.push(choice);
        } else {
          selected.splice(choiceIndex, 1);
        }

        if (!_ember['default'].isNone(offValue) && selected.length < 1) {
          selected.push(offValue);
        }

        selected.sort();
        this.set('value', selected.join(delimiter));
      }
    }

  });
});
define("cornerstone/components/forms/choose-multi/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 3,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/forms/choose-multi/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "yield", [["get", "this", ["loc", [null, [2, 10], [2, 14]]], 0, 0, 0, 0]], [], ["loc", [null, [2, 2], [2, 17]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 4,
                "column": 2
              },
              "end": {
                "line": 11,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/forms/choose-multi/template.hbs"
          },
          isEmpty: false,
          arity: 1,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("    ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            return morphs;
          },
          statements: [["inline", "forms/choose-choice", [], ["choose", ["subexpr", "@mut", [["get", "this", ["loc", [null, [6, 13], [6, 17]]], 0, 0, 0, 0]], [], [], 0, 0], "value", ["subexpr", "@mut", [["get", "choice.value", ["loc", [null, [7, 12], [7, 24]]], 0, 0, 0, 0]], [], [], 0, 0], "icon", ["subexpr", "@mut", [["get", "choice.icon", ["loc", [null, [8, 11], [8, 22]]], 0, 0, 0, 0]], [], [], 0, 0], "label", ["subexpr", "@mut", [["get", "choice.label", ["loc", [null, [9, 12], [9, 24]]], 0, 0, 0, 0]], [], [], 0, 0], "tooltip", ["subexpr", "@mut", [["get", "choice.tooltip", ["loc", [null, [10, 14], [10, 28]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [5, 4], [10, 30]]], 0, 0]],
          locals: ["choice"],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 3,
              "column": 0
            },
            "end": {
              "line": 12,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/forms/choose-multi/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "each", [["get", "choices", ["loc", [null, [4, 10], [4, 17]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [4, 2], [11, 11]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 12,
            "column": 7
          }
        },
        "moduleName": "cornerstone/components/forms/choose-multi/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["block", "if", [["get", "hasBlock", ["loc", [null, [1, 6], [1, 14]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [1, 0], [12, 7]]]]],
      locals: [],
      templates: [child0, child1]
    };
  })());
});
define('cornerstone/components/forms/choose-single/component', ['exports', 'ember', 'cornerstone/mixins/forms/visibility-observation', 'cornerstone/mixins/forms/assign-default'], function (exports, _ember, _cornerstoneMixinsFormsVisibilityObservation, _cornerstoneMixinsFormsAssignDefault) {
  exports['default'] = _ember['default'].Component.extend(_cornerstoneMixinsFormsVisibilityObservation['default'], _cornerstoneMixinsFormsAssignDefault['default'], {

    tagName: 'ul',
    classNames: ['cs-choose'],
    classNameBindings: ['condensed:cs-choose-condensed', 'cols'],
    assignDefaultOptionsPath: 'choices',

    init: function init() {
      this._super.apply(this, arguments);
      if (_ember['default'].isPresent(this.get('offValue'))) {
        this.set('assignDefaultSourcePath', 'offValue');
      }
    },

    // delimiter: null, // If delimiter is null, treat as an array - otherwise make a string

    condensed: true,
    cols: _ember['default'].computed('choices', 'foundCols', function () {
      var number = !this.get('choices') ? this.get('foundCols') : this.get('choices.length');
      return 'cols-' + number;
    }),

    didRender: function didRender() {

      if (!this.get('choices')) {
        _ember['default'].run.scheduleOnce('afterRender', (function () {
          this.set('foundCols', this.$('li').length);
        }).bind(this));
      }
    },

    actions: {
      isVisible: function isVisible() {
        this.send('assignDefaultOption');
      },
      select: function select(choice) {

        var offValue = this.get('offValue');

        if (_ember['default'].isPresent(offValue) && choice === this.get('value')) {
          choice = offValue;
        }

        this.set('value', choice);
      }
    }

  });
});
define("cornerstone/components/forms/choose-single/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 3,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/forms/choose-single/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "yield", [["get", "this", ["loc", [null, [2, 10], [2, 14]]], 0, 0, 0, 0]], [], ["loc", [null, [2, 2], [2, 17]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 4,
                "column": 2
              },
              "end": {
                "line": 6,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/forms/choose-single/template.hbs"
          },
          isEmpty: false,
          arity: 1,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("    ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            return morphs;
          },
          statements: [["inline", "forms/choose-choice", [], ["choose", ["subexpr", "@mut", [["get", "this", ["loc", [null, [5, 33], [5, 37]]], 0, 0, 0, 0]], [], [], 0, 0], "value", ["subexpr", "@mut", [["get", "choice.value", ["loc", [null, [5, 44], [5, 56]]], 0, 0, 0, 0]], [], [], 0, 0], "icon", ["subexpr", "@mut", [["get", "choice.icon", ["loc", [null, [5, 62], [5, 73]]], 0, 0, 0, 0]], [], [], 0, 0], "label", ["subexpr", "@mut", [["get", "choice.label", ["loc", [null, [5, 80], [5, 92]]], 0, 0, 0, 0]], [], [], 0, 0], "tooltip", ["subexpr", "@mut", [["get", "choice.tooltip", ["loc", [null, [5, 101], [5, 115]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [5, 4], [5, 117]]], 0, 0]],
          locals: ["choice"],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 3,
              "column": 0
            },
            "end": {
              "line": 7,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/forms/choose-single/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "each", [["get", "choices", ["loc", [null, [4, 10], [4, 17]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [4, 2], [6, 11]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 8,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/forms/choose-single/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["block", "if", [["get", "hasBlock", ["loc", [null, [1, 6], [1, 14]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [1, 0], [7, 7]]]]],
      locals: [],
      templates: [child0, child1]
    };
  })());
});
define('cornerstone/components/forms/color-input/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({

    colorService: _ember['default'].inject.service('templates/colors'),

    onInit: _ember['default'].on('init', function () {
      var _this = this;

      if (!this.get('usePalette')) {
        this.set('ready', true);
        return;
      }
      this.get('colorService.paletteItemsPromise').then(function (items) {
        _this.set('paletteItems', items);
        _this.set('ready', true);

        if (_this.get('selected')) {
          _this.get('updating', false);
          _this.set('value', _this.get('colorService').lookupColor(_this.get('selected')));
          if (_this.get('picker')) {
            _this.get('picker').send('stateChange');
          }
        }
      });
    }),

    classNames: ['cs-form-color-input'],

    valueObserver: _ember['default'].observer('value', function () {
      if (!this.get('updating')) {
        var value = this.get('value');
        this.$input.val(value);

        this.$('.huebert-picker-control-output-value').val(value);
        this.$input.trigger('change', { ember: true });
      }
      this.set('updating', false);
    }),

    selectedObserver: _ember['default'].observer('selected', function () {
      if (!this.get('updating')) {
        this.set('value', this.get('colorService').lookupColor(this.get('selected')));
      }
    }),

    colorValue: _ember['default'].computed('value', 'colorService.paletteItems.[]', function () {
      if (!this.get('usePalette')) {
        return this.get('value');
      }
      return this.get('colorService').lookupColor(this.get('value'));
    }),

    huebertValueObserver: _ember['default'].observer('huebertValue', function () {
      this.set('updating', true);
      this.set('selected', this.get('huebertValue'));
      this.set('value', this.get('huebertValue'));
    }),

    didInsertElement: function didInsertElement() {
      this.set('canRender', true);
      this.renderWhenReady();
    },

    observeReady: _ember['default'].observer('ready', function () {
      this.renderWhenReady();
    }),

    renderWhenReady: function renderWhenReady() {
      var _this2 = this;

      if (!this.get('canRender') || this.get('isRendered')) {
        return;
      }

      this.set('isRendered', true);

      this.$input = this.$('input[type=text]');
      this.$input.val(this.get('value'));

      this.$input.on('change', function (e, params) {
        if (params && params.ember) {
          return;
        }
        _this2.set('huebertValue', _this2.$input.val());
      });

      _ember['default'].run.scheduleOnce('afterRender', function () {
        var opts = {
          outputFormat: _this2.getWithDefault('options.output_format', null),
          label: _this2.getWithDefault('options.label', null),
          canToggle: !_this2.getWithDefault('inline', false),
          scrollEvent: 'ps-scroll-x ps-scroll-y'
        };
        _this2.$input.huebert(opts);

        _this2.$('.huebert-picker-control-slider-a').after(_this2.$('.cs-form-color-input-palette'));
      });
    },

    actions: {
      select: function select(item) {
        this.set('selected', 'global-color:' + _ember['default'].get(item, 'id'));
        this.set('value', _ember['default'].get(item, 'value'));
      }
    }
  });
});
define('cornerstone/components/forms/color-input/palette-item/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({

    classNames: ['cs-form-color-input-palette-item'],
    classNameBindings: ['active:cs-active'],
    attributeBindings: ['style', 'title'],
    title: _ember['default'].computed.alias('item.label'),
    colorStyle: _ember['default'].computed('item.value', function () {
      return _ember['default'].String.htmlSafe('background-color: ' + this.getWithDefault('item.value', 'transparent') + ';');
    }),

    active: _ember['default'].computed('item.id', 'selected', function () {
      return 'global-color:' + this.get('item.id') === this.getWithDefault('selected', null);
    }),

    didInsertElement: function didInsertElement() {
      var _this = this;

      this.$().on('click', function () {
        return _this.sendAction('select');
      });
    }

  });
});
define("cornerstone/components/forms/color-input/palette-item/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 3,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/forms/color-input/palette-item/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("div");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element0 = dom.childAt(fragment, [0]);
        var morphs = new Array(2);
        morphs[0] = dom.createAttrMorph(element0, 'style');
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        return morphs;
      },
      statements: [["attribute", "style", ["get", "colorStyle", ["loc", [null, [1, 13], [1, 23]]], 0, 0, 0, 0], 0, 0, 0, 0], ["content", "yield", ["loc", [null, [2, 0], [2, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
define("cornerstone/components/forms/color-input/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 3,
              "column": 2
            },
            "end": {
              "line": 9,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/forms/color-input/template.hbs"
        },
        isEmpty: false,
        arity: 1,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "forms/color-input/palette-item", [], ["item", ["subexpr", "@mut", [["get", "item", ["loc", [null, [5, 11], [5, 15]]], 0, 0, 0, 0]], [], [], 0, 0], "selected", ["subexpr", "@mut", [["get", "selected", ["loc", [null, [6, 15], [6, 23]]], 0, 0, 0, 0]], [], [], 0, 0], "select", ["subexpr", "action", ["select", ["get", "item", ["loc", [null, [7, 30], [7, 34]]], 0, 0, 0, 0]], [], ["loc", [null, [7, 13], [7, 35]]], 0, 0]], ["loc", [null, [4, 4], [8, 6]]], 0, 0]],
        locals: ["item"],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 12,
            "column": 9
          }
        },
        "moduleName": "cornerstone/components/forms/color-input/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("input");
        dom.setAttribute(el1, "type", "text");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("div");
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element0 = dom.childAt(fragment, [2]);
        var morphs = new Array(3);
        morphs[0] = dom.createAttrMorph(element0, 'class');
        morphs[1] = dom.createMorphAt(element0, 1, 1);
        morphs[2] = dom.createMorphAt(fragment, 4, 4, contextualElement);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["attribute", "class", ["concat", ["cs-form-color-input-palette ", ["subexpr", "unless", [["get", "paletteItems", ["loc", [null, [2, 49], [2, 61]]], 0, 0, 0, 0], "cs-hide"], [], ["loc", [null, [2, 40], [2, 73]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["block", "each", [["get", "paletteItems", ["loc", [null, [3, 10], [3, 22]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [3, 2], [9, 11]]]], ["content", "yield", ["loc", [null, [12, 0], [12, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/forms/color-picker/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({

    colorService: _ember['default'].inject.service('templates/colors'),

    classNames: ['cs-form-color-picker'],

    onInit: _ember['default'].on('init', function () {
      var _this = this;

      if (!this.get('usePalette')) {
        this.set('ready', true);
        return;
      }

      this.get('colorService.paletteItemsPromise').then(function (items) {
        _this.incrementProperty('swatchUpdate');
      });
    }),

    swatchColor: _ember['default'].computed('value', 'colorService.paletteItems.[]', function () {
      if (!this.get('usePalette')) {
        return this.get('value');
      }
      return this.get('colorService').lookupColor(this.get('value'));
    }),

    label: _ember['default'].computed('options.label', function () {
      return this.getWithDefault('options.label', 'Select Color');
    }),

    content: _ember['default'].computed('value', 'swatchUpdate', function () {
      return _ember['default'].String.htmlSafe('<div class="cs-picker-swatch-content" style="background-color: ' + this.get('swatchColor') + ';"></div>');
    }),

    swatchUpdate: 0,
    actions: {
      stateChange: function stateChange() {
        this.incrementProperty('swatchUpdate');
      }
    }

  });
});
define("cornerstone/components/forms/color-picker/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 7,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/forms/color-picker/template.hbs"
        },
        isEmpty: false,
        arity: 1,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "forms/color-input", [], ["inline", true, "selected", ["subexpr", "@mut", [["get", "value", ["loc", [null, [6, 43], [6, 48]]], 0, 0, 0, 0]], [], [], 0, 0], "usePalette", ["subexpr", "@mut", [["get", "usePalette", ["loc", [null, [6, 60], [6, 70]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [6, 2], [6, 73]]], 0, 0]],
        locals: ["picker"],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 8,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/forms/color-picker/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["block", "common/cs-picker", [], ["onStateChange", ["subexpr", "action", ["stateChange"], [], ["loc", [null, [2, 16], [2, 38]]], 0, 0], "label", ["subexpr", "@mut", [["get", "label", ["loc", [null, [3, 8], [3, 13]]], 0, 0, 0, 0]], [], [], 0, 0], "content", ["subexpr", "@mut", [["get", "content", ["loc", [null, [4, 10], [4, 17]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [1, 0], [7, 21]]]]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/forms/cs-toggle/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({

    tagName: 'ul',
    classNames: ['cs-toggle'],
    classNameBindings: ['state:on:off'],

    state: _ember['default'].computed('value', function () {
      return this.normalize(this.get('value'));
    }),

    // Detect various forms of boolean storage and play along

    normalize: function normalize(value) {

      if ('1' === value || 'true' === value) {
        return true;
      }

      if ('' === value || 'false' === value) {
        return false;
      }

      return !!value;
    },

    invert: function invert(value) {

      if ('true' === value) {
        return 'false';
      }

      if ('false' === value) {
        return 'true';
      }

      if ('1' === value) {
        return '';
      }

      if ('' === value) {
        return '1';
      }

      return !value;
    },

    click: function click() {
      this.send('toggle');
    },

    actions: {
      toggle: function toggle() {
        var _this = this;

        var $el = this.$();
        var on = $el.hasClass('on');
        $el.toggleClass('on', !on).toggleClass('off', !!on);

        _ember['default'].run.next(function () {
          _this.set('value', _this.invert(_this.get('value')));
        });
      }
    }

  });
});
define("cornerstone/components/forms/cs-toggle/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 3,
            "column": 37
          }
        },
        "moduleName": "cornerstone/components/forms/cs-toggle/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("li");
        dom.setAttribute(el1, "class", "on");
        var el2 = dom.createElement("span");
        var el3 = dom.createTextNode("On");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("li");
        dom.setAttribute(el1, "class", "off");
        var el2 = dom.createElement("span");
        var el3 = dom.createTextNode("Off");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["content", "yield", ["loc", [null, [1, 0], [1, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
define('cornerstone/components/forms/expandable-text-editor/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({

    classNames: ['cs-expandable-rich-text'],

    content: _ember['default'].computed('value', 'placeholder', function () {
      var content = this.getWithDefault('value', this.getWithDefault('placeholder', ''));
      return _ember['default'].String.htmlSafe('<input type="text" value="' + content + '" disabled>');
    })

  });
});
define("cornerstone/components/forms/expandable-text-editor/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 13,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/forms/expandable-text-editor/template.hbs"
        },
        isEmpty: false,
        arity: 1,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "forms/text-editor", [], ["value", ["subexpr", "@mut", [["get", "value", ["loc", [null, [8, 10], [8, 15]]], 0, 0, 0, 0]], [], [], 0, 0], "placeholder", ["subexpr", "@mut", [["get", "placeholder", ["loc", [null, [9, 16], [9, 27]]], 0, 0, 0, 0]], [], [], 0, 0], "picker", ["subexpr", "@mut", [["get", "picker", ["loc", [null, [10, 11], [10, 17]]], 0, 0, 0, 0]], [], [], 0, 0], "mode", ["subexpr", "@mut", [["get", "mode", ["loc", [null, [11, 9], [11, 13]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [7, 2], [12, 4]]], 0, 0]],
        locals: ["picker"],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 15,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/forms/expandable-text-editor/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(2);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 1, 1, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["block", "common/cs-picker", [], ["modalMode", "remove", "modalClass", "cs-picker-modal-expandable-text-editor", "label", ["subexpr", "fa-icon", ["pencil"], [], ["loc", [null, [4, 8], [4, 26]]], 0, 0], "content", ["subexpr", "@mut", [["get", "content", ["loc", [null, [5, 10], [5, 17]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [1, 0], [13, 21]]]], ["content", "yield", ["loc", [null, [14, 0], [14, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/forms/icon-picker/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({

    classNames: ['cs-form-icon-picker'],

    label: _ember['default'].computed('options.label', function () {
      return this.getWithDefault('options.label', 'Select Icon');
    })

  });
});
define("cornerstone/components/forms/icon-picker/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 3,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/forms/icon-picker/template.hbs"
        },
        isEmpty: false,
        arity: 1,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "forms/choose-icon", [], ["value", ["subexpr", "@mut", [["get", "value", ["loc", [null, [2, 28], [2, 33]]], 0, 0, 0, 0]], [], [], 0, 0], "scrollToSelectedOn", ["subexpr", "@mut", [["get", "picker.open", ["loc", [null, [2, 53], [2, 64]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [2, 2], [2, 66]]], 0, 0]],
        locals: ["picker"],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 5,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/forms/icon-picker/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(2);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 1, 1, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["block", "common/cs-picker", [], ["label", ["subexpr", "@mut", [["get", "label", ["loc", [null, [1, 26], [1, 31]]], 0, 0, 0, 0]], [], [], 0, 0], "content", ["subexpr", "fa-icon", [["get", "value", ["loc", [null, [1, 49], [1, 54]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 40], [1, 55]]], 0, 0]], 0, null, ["loc", [null, [1, 0], [3, 21]]]], ["content", "yield", ["loc", [null, [4, 0], [4, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/forms/image-upload/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({

    wpMedia: _ember['default'].inject.service(),

    classNames: ['cs-image'],
    classNameBindings: ['pattern', 'empty', 'class'],
    attributeBindings: ['style'],

    pattern: _ember['default'].computed.alias('options.pattern'),

    empty: _ember['default'].computed('value', function () {
      return !this.get('value');
    }),

    style: _ember['default'].computed('value', function () {
      var value = this.get('value');
      return _ember['default'].String.htmlSafe(!value ? '' : 'background-image: url(' + value + ');');
    }),

    didInsertElement: function didInsertElement() {
      this.detectDimensions();
    },

    dimensionUpdate: _ember['default'].observer('value', function () {
      this.detectDimensions();
    }),

    detectDimensions: function detectDimensions() {
      var _this = this;

      var src = this.get('value');

      if (!src) {
        this.sendAction('onDimensionChange', { width: '', height: '' });
        return;
      }

      var $img = _ember['default'].$('<img src="' + this.get('value') + '" style="opacity:0;position:absolute;pointer-events:none;">');

      $img.on('load', function () {

        _this.sendAction('onDimensionChange', {
          width: $img[0].width,
          height: $img[0].height
        });

        _ember['default'].run.next(function () {
          $img.remove();
        });
      });

      this.$().append($img);
    },

    actions: {
      add: function add() {
        this.get('wpMedia').request(this, 'value');
      },
      remove: function remove() {
        this.set('value', '');
      }
    }

  });
});
define("cornerstone/components/forms/image-upload/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 3,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/forms/image-upload/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("span");
        dom.setAttribute(el1, "class", "add");
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("span");
        dom.setAttribute(el1, "class", "remove");
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element0 = dom.childAt(fragment, [0]);
        var element1 = dom.childAt(fragment, [2]);
        var morphs = new Array(4);
        morphs[0] = dom.createElementMorph(element0);
        morphs[1] = dom.createMorphAt(element0, 0, 0);
        morphs[2] = dom.createElementMorph(element1);
        morphs[3] = dom.createMorphAt(element1, 0, 0);
        return morphs;
      },
      statements: [["element", "action", ["add"], [], ["loc", [null, [1, 6], [1, 22]]], 0, 0], ["inline", "fa-icon", ["plus-circle"], [], ["loc", [null, [1, 35], [1, 60]]], 0, 0], ["element", "action", ["remove"], [], ["loc", [null, [2, 6], [2, 25]]], 0, 0], ["inline", "fa-icon", ["times-circle"], [], ["loc", [null, [2, 41], [2, 67]]], 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
define('cornerstone/components/forms/inline-edit/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({

    tagName: 'span',

    classNames: ['cs-inline-edit'],
    classNameBindings: ['class', 'usingPlaceholder:cs-inline-edit-placeholder', 'invalid:cs-inline-edit-invalid', 'disabled:cs-inline-edit-disabled'],

    disabled: _ember['default'].computed.not('enabled'),
    enabled: true,

    label: _ember['default'].computed('value', function () {
      var label = this.get('value');
      if (!label) {
        label = this.getWithDefault('placeholder', 'Double click to edit.');
      }
      return label;
    }),

    usingPlaceholder: _ember['default'].computed('value', function () {
      return !this.get('value');
    }),

    inputClass: _ember['default'].computed('editing', function () {
      return this.get('editing') ? '' : 'cs-hide';
    }),

    click: function click() {
      if (this.get('blockClickThrough')) {
        return false;
      }
    },

    didRender: function didRender() {
      var _this = this;

      var aborted = false;

      var $input = this.$('input');
      $input.val(this.get('value'));

      $input.on('keydown', function (e) {

        if (13 === e.keyCode) {
          _this.send('doneEditing');
          e.preventDefault();
        }

        if (27 === e.keyCode) {
          aborted = true;
          _this.set('editing', false);
          e.preventDefault();
        }
      });

      $input.on('blur', function () {
        if (!aborted) {
          _this.send('doneEditing');
        }
      });
    },

    doubleClick: function doubleClick() {
      var _this2 = this;

      if (this.get('editing') || !this.get('enabled')) {
        return;
      }
      this.set('editing', true);
      _ember['default'].run.scheduleOnce('afterRender', function () {
        _this2.$('input').focus();
      });
    },

    actions: {
      doneEditing: function doneEditing() {
        if (this.get('editing')) {
          this.set('value', this.$('input').val());
          this.sendAction();
        }
        this.set('editing', false);
      }
    }
  });
});
define("cornerstone/components/forms/inline-edit/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 3,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/forms/inline-edit/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("input");
          dom.setAttribute(el1, "type", "text");
          dom.setAttribute(el1, "name", "");
          dom.setAttribute(el1, "value", "");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes() {
          return [];
        },
        statements: [],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 3,
              "column": 0
            },
            "end": {
              "line": 5,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/forms/inline-edit/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createUnsafeMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["content", "label", ["loc", [null, [4, 2], [4, 13]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 6,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/forms/inline-edit/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["block", "if", [["get", "editing", ["loc", [null, [1, 6], [1, 13]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [1, 0], [5, 7]]]]],
      locals: [],
      templates: [child0, child1]
    };
  })());
});
define('cornerstone/components/forms/radio-list/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({});
});
define("cornerstone/components/forms/radio-list/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 3,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/forms/radio-list/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["content", "yield", ["loc", [null, [2, 2], [2, 11]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 4,
                "column": 2
              },
              "end": {
                "line": 6,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/forms/radio-list/template.hbs"
          },
          isEmpty: false,
          arity: 1,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("    ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            return morphs;
          },
          statements: [["inline", "forms/rc-choice", [], ["value", ["subexpr", "get", [["get", "proxy", ["loc", [null, [5, 33], [5, 38]]], 0, 0, 0, 0], ["get", "checkbox.key", ["loc", [null, [5, 39], [5, 51]]], 0, 0, 0, 0]], [], ["loc", [null, [5, 28], [5, 52]]], 0, 0], "optVal", ["subexpr", "@mut", [["get", "checkbox.value", ["loc", [null, [5, 60], [5, 74]]], 0, 0, 0, 0]], [], [], 0, 0], "label", ["subexpr", "@mut", [["get", "checkbox.label", ["loc", [null, [5, 81], [5, 95]]], 0, 0, 0, 0]], [], [], 0, 0], "half", ["subexpr", "@mut", [["get", "checkbox.half", ["loc", [null, [5, 101], [5, 114]]], 0, 0, 0, 0]], [], [], 0, 0], "mode", "radio"], ["loc", [null, [5, 4], [5, 129]]], 0, 0]],
          locals: ["checkbox"],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 3,
              "column": 0
            },
            "end": {
              "line": 7,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/forms/radio-list/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "each", [["get", "checkboxes", ["loc", [null, [4, 10], [4, 20]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [4, 2], [6, 11]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 8,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/forms/radio-list/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["block", "if", [["get", "hasBlock", ["loc", [null, [1, 6], [1, 14]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [1, 0], [7, 7]]]]],
      locals: [],
      templates: [child0, child1]
    };
  })());
});
define('cornerstone/components/forms/ratio-input/component', ['exports', 'ember'], function (exports, _ember) {

  function normalizeRatioValue(value, index) {
    var parts = (value || '').split(':');
    return 'undefined' !== typeof index ? parts[index] : parts;
  }

  function computeRatioComponent(index) {
    return _ember['default'].computed('value', {
      get: function get() {
        return normalizeRatioValue(this.get('value'), index);
      },
      set: function set(key, value) {
        value = value.replace(/\:/g, '');
        var parts = normalizeRatioValue(this.get('value'));
        parts[index] = value;
        var update = parts.join(':');
        this.set('value', ':' === update ? '' : update);
        return value;
      }
    });
  }

  exports['default'] = _ember['default'].Component.extend({
    tagName: 'ul',
    classNames: ['cs-form-ratio-input'],

    valueA: computeRatioComponent(0),
    valueB: computeRatioComponent(1),

    placeholderA: _ember['default'].computed('placeholder', function () {
      return normalizeRatioValue(this.get('placeholder') || '', 0);
    }),

    placeholderB: _ember['default'].computed('placeholder', function () {
      return normalizeRatioValue(this.get('placeholder') || '', 1);
    })

  });
});
define("cornerstone/components/forms/ratio-input/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 3,
            "column": 56
          }
        },
        "moduleName": "cornerstone/components/forms/ratio-input/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("li");
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("li");
        var el2 = dom.createTextNode(":");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("li");
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(2);
        morphs[0] = dom.createMorphAt(dom.childAt(fragment, [0]), 0, 0);
        morphs[1] = dom.createMorphAt(dom.childAt(fragment, [4]), 0, 0);
        return morphs;
      },
      statements: [["inline", "input", [], ["value", ["subexpr", "@mut", [["get", "valueA", ["loc", [null, [1, 18], [1, 24]]], 0, 0, 0, 0]], [], [], 0, 0], "placeholder", ["subexpr", "@mut", [["get", "placeholderA", ["loc", [null, [1, 37], [1, 49]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [1, 4], [1, 51]]], 0, 0], ["inline", "input", [], ["value", ["subexpr", "@mut", [["get", "valueB", ["loc", [null, [3, 18], [3, 24]]], 0, 0, 0, 0]], [], [], 0, 0], "placeholder", ["subexpr", "@mut", [["get", "placeholderB", ["loc", [null, [3, 37], [3, 49]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [3, 4], [3, 51]]], 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
define('cornerstone/components/forms/rc-checkbox/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    half: false,
    tagName: 'label',
    classNames: ['cs-rc', 'cs-rc-checkbox'],
    classNameBindings: ['half:cs-rc-1-2']
  });
});
define("cornerstone/components/forms/rc-checkbox/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 4,
              "column": 2
            },
            "end": {
              "line": 6,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/forms/rc-checkbox/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["content", "yield", ["loc", [null, [5, 4], [5, 13]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 6,
              "column": 2
            },
            "end": {
              "line": 8,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/forms/rc-checkbox/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["content", "label", ["loc", [null, [7, 4], [7, 13]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 10,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/forms/rc-checkbox/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("span");
        dom.setAttribute(el1, "class", "cs-rc-indicator");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("span");
        dom.setAttribute(el1, "class", "cs-rc-label");
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(2);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(dom.childAt(fragment, [4]), 1, 1);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "input", [], ["type", "checkbox", "checked", ["subexpr", "@mut", [["get", "value", ["loc", [null, [1, 32], [1, 37]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [1, 0], [1, 39]]], 0, 0], ["block", "if", [["get", "hasBlock", ["loc", [null, [4, 8], [4, 16]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [4, 2], [8, 9]]]]],
      locals: [],
      templates: [child0, child1]
    };
  })());
});
define('cornerstone/components/forms/rc-choice/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    half: false,
    tagName: 'label',
    classNames: ['cs-rc'],
    classNameBindings: ['modeClass', 'half:cs-rc-1-2'],
    mode: 'checkbox',

    modeClass: _ember['default'].computed('mode', function () {
      return 'radio' === this.get('mode') ? 'cs-rc-radio' : 'cs-rc-checkbox';
    }),

    castArrayVal: _ember['default'].computed('arrayVal', function () {
      var arrayVal = this.get('arrayVal');
      return _ember['default'].isArray(arrayVal) ? arrayVal : _ember['default'].A([arrayVal]);
    }),

    isChecked: _ember['default'].computed({
      get: function get() {
        var _this = this;

        var mode = this.get('mode');

        if ('radio' === mode) {
          return this.get('value') === this.get('optVal');
        }

        if ('array' === mode) {
          var _ret = (function () {

            var val = _this.get('value');
            return {
              v: _this.get('castArrayVal').every(function (arrayVal) {
                return val.includes(arrayVal);
              })
            };
          })();

          if (typeof _ret === 'object') return _ret.v;
        }

        return this.get('value');
      },

      set: function set(key, value) {
        var _this2 = this;

        var mode = this.get('mode');

        if ('radio' === mode) {
          this.set('value', this.get('optVal'));
          return value;
        }

        if ('array' === mode) {

          if (value) {
            this.get('castArrayVal').forEach(function (val) {
              _this2.get('value').addObject(val);
            });
          } else {
            this.get('castArrayVal').forEach(function (val) {
              _this2.get('value').removeObject(val);
            });
          }

          return value;
        }

        this.set('value', value);

        return value;
      }
    })

  });
});
define("cornerstone/components/forms/rc-choice/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 4,
              "column": 2
            },
            "end": {
              "line": 6,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/forms/rc-choice/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["content", "yield", ["loc", [null, [5, 4], [5, 13]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 6,
              "column": 2
            },
            "end": {
              "line": 8,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/forms/rc-choice/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["content", "label", ["loc", [null, [7, 4], [7, 13]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 10,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/forms/rc-choice/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("span");
        dom.setAttribute(el1, "class", "cs-rc-indicator");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("span");
        dom.setAttribute(el1, "class", "cs-rc-label");
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(2);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(dom.childAt(fragment, [4]), 1, 1);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "input", [], ["type", "checkbox", "checked", ["subexpr", "@mut", [["get", "isChecked", ["loc", [null, [1, 32], [1, 41]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [1, 0], [1, 43]]], 0, 0], ["block", "if", [["get", "hasBlock", ["loc", [null, [4, 8], [4, 16]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [4, 2], [8, 9]]]]],
      locals: [],
      templates: [child0, child1]
    };
  })());
});
define('cornerstone/components/forms/select-base/component', ['exports', 'ember', 'cornerstone/mixins/forms/visibility-observation', 'cornerstone/mixins/forms/assign-default'], function (exports, _ember, _cornerstoneMixinsFormsVisibilityObservation, _cornerstoneMixinsFormsAssignDefault) {
  exports['default'] = _ember['default'].Component.extend(_cornerstoneMixinsFormsVisibilityObservation['default'], _cornerstoneMixinsFormsAssignDefault['default'], {

    assignDefaultOptionsPath: 'computedOptions',

    store: _ember['default'].inject.service(),

    init: function init() {
      this._super.apply(this, arguments);
      this.processDynamicContent();
    },

    processDynamicContent: function processDynamicContent() {
      var _this = this;

      var options = this.get('options');

      if ('string' === typeof options) {
        this.set('loadingDynamic', true);
        this.get('store').findRecord('fragment', 'app-choices::' + options).then(function (record) {
          _this.setDynamicContent(_ember['default'].get(record, 'value'));
        });
      } else if (options.then) {
        this.set('loadingDynamic', true);
        options.then(function (response) {
          _this.setDynamicContent(response);
        });
      }
    },

    setDynamicContent: function setDynamicContent(value) {
      var _this2 = this;

      if (this.isDestroyed) {
        return;
      }
      this.set('dynamicContent', value);
      this.set('loadingDynamic', false);
      _ember['default'].run.scheduleOnce('afterRender', function () {
        _this2.send('assignDefaultOption');
      });
    },

    observerDynamicOptions: _ember['default'].observer('options', function () {
      this.processDynamicContent();
    }),

    computedOptions: _ember['default'].computed('options.[]', 'dynamicContent.[]', function () {

      var options = this.get('dynamicContent');
      if (!options) {
        options = this.getWithDefault('options', _ember['default'].A());
      }

      if (!_ember['default'].isArray(options)) {
        return _ember['default'].A();
      }

      return options.map(function (choice) {

        if ('string' === typeof choice) {
          return { value: choice, label: choice };
        }

        if (!choice.value && 0 !== choice.value) {
          return null;
        }

        var option = { value: choice.value, label: choice.label ? choice.label : choice.value };

        if (_ember['default'].isPresent(choice.group)) {
          option.group = choice.group;
        }

        return choice;
      }).filter(_ember['default'].isPresent);
    }),

    computedOptionsChange: _ember['default'].observer('computedOptions.[]', function () {
      var _this3 = this;

      if (this.get('allowInvalidOption')) {
        return;
      }
      _ember['default'].run.next(this, function () {
        _this3.send('assignDefaultOption');
      });
    }),

    actions: {
      isVisible: function isVisible() {
        if (!this.get('loadingDynamic')) {
          this.send('assignDefaultOption');
        }
      }
    }
  });
});
define("cornerstone/components/forms/select-base/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 5,
              "column": 2
            },
            "end": {
              "line": 7,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/forms/select-base/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "forms/styled-select/styled-option", [], ["selected", true, "disabled", true, "label", ["subexpr", "@mut", [["get", "placeholderText", ["loc", [null, [6, 74], [6, 89]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [6, 4], [6, 91]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 8,
              "column": 2
            },
            "end": {
              "line": 10,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/forms/select-base/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "yield", [["get", "this", ["loc", [null, [9, 12], [9, 16]]], 0, 0, 0, 0]], [], ["loc", [null, [9, 4], [9, 18]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child2 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 11,
                "column": 4
              },
              "end": {
                "line": 13,
                "column": 4
              }
            },
            "moduleName": "cornerstone/components/forms/select-base/template.hbs"
          },
          isEmpty: false,
          arity: 1,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("      ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            return morphs;
          },
          statements: [["inline", "forms/styled-select/styled-option", [], ["select", ["subexpr", "@mut", [["get", "this", ["loc", [null, [12, 49], [12, 53]]], 0, 0, 0, 0]], [], [], 0, 0], "option", ["subexpr", "@mut", [["get", "option", ["loc", [null, [12, 61], [12, 67]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [12, 6], [12, 70]]], 0, 0]],
          locals: ["option"],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 10,
              "column": 2
            },
            "end": {
              "line": 14,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/forms/select-base/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "each", [["get", "computedOptions", ["loc", [null, [11, 12], [11, 27]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [11, 4], [13, 13]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 15,
            "column": 9
          }
        },
        "moduleName": "cornerstone/components/forms/select-base/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("div");
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("span");
        var el3 = dom.createComment("");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("select");
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element0 = dom.childAt(fragment, [0]);
        var element1 = dom.childAt(fragment, [2]);
        var morphs = new Array(6);
        morphs[0] = dom.createAttrMorph(element0, 'class');
        morphs[1] = dom.createUnsafeMorphAt(dom.childAt(element0, [1]), 0, 0);
        morphs[2] = dom.createAttrMorph(element1, 'disabled');
        morphs[3] = dom.createElementMorph(element1);
        morphs[4] = dom.createMorphAt(element1, 1, 1);
        morphs[5] = dom.createMorphAt(element1, 2, 2);
        return morphs;
      },
      statements: [["attribute", "class", ["concat", ["cs-styled-select-label ", ["subexpr", "if", [["get", "showPlaceholder", ["loc", [null, [1, 40], [1, 55]]], 0, 0, 0, 0], "cs-styled-select-placeholder"], [], ["loc", [null, [1, 35], [1, 88]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["content", "label", ["loc", [null, [2, 8], [2, 19]]], 0, 0, 0, 0], ["attribute", "disabled", ["get", "disabled", ["loc", [null, [4, 19], [4, 27]]], 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["change"], ["on", "change"], ["loc", [null, [4, 30], [4, 61]]], 0, 0], ["block", "if", [["get", "showPlaceholder", ["loc", [null, [5, 8], [5, 23]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [5, 2], [7, 9]]]], ["block", "if", [["get", "hasBlock", ["loc", [null, [8, 8], [8, 16]]], 0, 0, 0, 0]], [], 1, 2, ["loc", [null, [8, 2], [14, 9]]]]],
      locals: [],
      templates: [child0, child1, child2]
    };
  })());
});
define('cornerstone/components/forms/select-multi/component', ['exports', 'ember', 'cornerstone/components/forms/select-base/component'], function (exports, _ember, _cornerstoneComponentsFormsSelectBaseComponent) {
  exports['default'] = _cornerstoneComponentsFormsSelectBaseComponent['default'].extend({
    classNames: ['cs-select', 'cs-select-multi'],
    selection: _ember['default'].computed('value', function () {
      return this.getWithDefault('value', _ember['default'].A()).map(function (value) {
        return { value: value };
      });
    }),
    actions: {
      add: function add(item) {
        this.get('value').addObject(item.value);
      },
      remove: function remove(item) {
        this.get('value').removeObject(item.value);
      }
    }
  });
});
define("cornerstone/components/forms/select-multi/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 12,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/forms/select-multi/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "ember-selectize", [], ["content", ["subexpr", "@mut", [["get", "computedOptions", ["loc", [null, [2, 10], [2, 25]]], 0, 0, 0, 0]], [], [], 0, 0], "optionValuePath", "content.value", "optionLabelPath", "content.label", "selection", ["subexpr", "@mut", [["get", "selection", ["loc", [null, [5, 12], [5, 21]]], 0, 0, 0, 0]], [], [], 0, 0], "multiple", true, "placeholder", ["subexpr", "@mut", [["get", "placeholder", ["loc", [null, [7, 14], [7, 25]]], 0, 0, 0, 0]], [], [], 0, 0], "optionGroupPath", "group", "add-item", ["subexpr", "action", ["add"], [], ["loc", [null, [9, 11], [9, 25]]], 0, 0], "remove-item", ["subexpr", "action", ["remove"], [], ["loc", [null, [10, 14], [10, 31]]], 0, 0]], ["loc", [null, [1, 0], [11, 2]]], 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
define('cornerstone/components/forms/select-single/component', ['exports', 'cornerstone/components/forms/select-base/component'], function (exports, _cornerstoneComponentsFormsSelectBaseComponent) {
  exports['default'] = _cornerstoneComponentsFormsSelectBaseComponent['default'].extend({
    classNames: ['cs-select', 'cs-select-single']
  });
});
// import Ember from 'ember';
define("cornerstone/components/forms/select-single/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 9,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/forms/select-single/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "ember-selectize", [], ["content", ["subexpr", "@mut", [["get", "computedOptions", ["loc", [null, [2, 10], [2, 25]]], 0, 0, 0, 0]], [], [], 0, 0], "optionValuePath", "content.value", "optionLabelPath", "content.label", "value", ["subexpr", "@mut", [["get", "value", ["loc", [null, [5, 8], [5, 13]]], 0, 0, 0, 0]], [], [], 0, 0], "placeholder", ["subexpr", "@mut", [["get", "placeholder", ["loc", [null, [6, 14], [6, 25]]], 0, 0, 0, 0]], [], [], 0, 0], "optionGroupPath", "group"], ["loc", [null, [1, 0], [8, 2]]], 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
define('cornerstone/components/forms/styled-select/component', ['exports', 'ember', 'cornerstone/components/forms/select-base/component'], function (exports, _ember, _cornerstoneComponentsFormsSelectBaseComponent) {
  exports['default'] = _cornerstoneComponentsFormsSelectBaseComponent['default'].extend({

    classNames: ['cs-styled-select'],
    classNameBindings: ['focused:cs-active'],
    focused: false,
    hasRendered: false,

    didInsertElement: function didInsertElement() {
      var _this = this;

      this.$('select').on('focus', function () {
        _this.set('focused', true);
      }).on('blur', function () {
        _this.set('focused', false);
      });

      _ember['default'].run.next(function () {
        _this.set('hasRendered', true);
      });
    },

    placeholderText: _ember['default'].computed('placeholder', 'value', function () {
      var placeholder = this.get('placeholder');
      if (_ember['default'].isNone(placeholder)) {
        return this.get('value');
      }
      return placeholder;
    }),

    label: _ember['default'].computed('selectedOption', 'loadingDynamic', function () {

      if (this.get('loadingDynamic')) {
        return 'Loading&hellip;';
      }

      if (this.get('showPlaceholder') || !this.get('selectedOption')) {
        return this.get('placeholderText');
      }

      var selected = this.getWithDefault('selectedOption', {});
      return _ember['default'].getWithDefault(selected, 'label', _ember['default'].getWithDefault(selected, 'value', this.get('selectedOption')));
    }),

    selectedOption: _ember['default'].computed('value', 'computedOptions.[]', function () {

      var current = this.get('value');
      if (_ember['default'].isNone(current)) {
        this.send('assignDefaultOption');
        current = this.get('value');
      }

      return this.get('computedOptions').find(function (option) {
        // Try `option.value`, then `option`
        // Not checking strictly because it's ok to accept values that are "close enough" in this case
        return current == _ember['default'].getWithDefault(option, 'value', option); // eslint-disable-line eqeqeq
      });
    }),

    showPlaceholder: _ember['default'].computed.none('selectedOption'),

    actions: {
      change: function change() {

        var options = this.get('computedOptions');

        var index = this.$('select')[0].selectedIndex;

        if (this.get('showPlaceholder')) {
          index--;
        }

        // Try `option.value`, then `option`
        this.set('value', _ember['default'].getWithDefault(options[index], 'value', options[index]));
      }
    }
  });
});
define('cornerstone/components/forms/styled-select/styled-option/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    tagName: 'option',
    attributeBindings: ['value', 'selected', 'disabled'],

    // Return first available path in this order: option.value, option.label, option
    value: _ember['default'].computed('option', 'option.value', function () {
      var option = this.getWithDefault('option', {});
      return _ember['default'].getWithDefault(option, 'value', _ember['default'].getWithDefault(option, 'label', this.get('option')));
    }),

    // Return first available path in this order: option.label, option.value, option
    label: _ember['default'].computed('option', 'option.label', function () {
      var option = this.getWithDefault('option', {});
      return _ember['default'].getWithDefault(option, 'label', _ember['default'].getWithDefault(option, 'value', this.get('option')));
    }),

    selected: _ember['default'].computed('select.value', function () {
      // Not checking strictly because it's ok to accept values that are "close enough" in this case
      return this.get('select.value') == this.get('value'); // eslint-disable-line eqeqeq
    })
  });
});
define("cornerstone/components/forms/styled-select/styled-option/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 1,
            "column": 11
          }
        },
        "moduleName": "cornerstone/components/forms/styled-select/styled-option/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createUnsafeMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["content", "label", ["loc", [null, [1, 0], [1, 11]]], 0, 0, 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
define("cornerstone/components/forms/styled-select/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 5,
              "column": 2
            },
            "end": {
              "line": 7,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/forms/styled-select/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "forms/styled-select/styled-option", [], ["selected", true, "disabled", true, "label", ["subexpr", "@mut", [["get", "placeholderText", ["loc", [null, [6, 74], [6, 89]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [6, 4], [6, 91]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 8,
              "column": 2
            },
            "end": {
              "line": 10,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/forms/styled-select/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "yield", [["get", "this", ["loc", [null, [9, 12], [9, 16]]], 0, 0, 0, 0]], [], ["loc", [null, [9, 4], [9, 18]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child2 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 12,
                  "column": 6
                },
                "end": {
                  "line": 14,
                  "column": 6
                }
              },
              "moduleName": "cornerstone/components/forms/styled-select/template.hbs"
            },
            isEmpty: false,
            arity: 1,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("        ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "forms/styled-select/styled-option", [], ["select", ["subexpr", "@mut", [["get", "this", ["loc", [null, [13, 51], [13, 55]]], 0, 0, 0, 0]], [], [], 0, 0], "option", ["subexpr", "@mut", [["get", "option", ["loc", [null, [13, 63], [13, 69]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [13, 8], [13, 72]]], 0, 0]],
            locals: ["option"],
            templates: []
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 11,
                "column": 4
              },
              "end": {
                "line": 15,
                "column": 4
              }
            },
            "moduleName": "cornerstone/components/forms/styled-select/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
            dom.insertBoundary(fragment, 0);
            dom.insertBoundary(fragment, null);
            return morphs;
          },
          statements: [["block", "each", [["get", "computedOptions", ["loc", [null, [12, 14], [12, 29]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [12, 6], [14, 15]]]]],
          locals: [],
          templates: [child0]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 10,
              "column": 2
            },
            "end": {
              "line": 16,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/forms/styled-select/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "if", [["get", "hasRendered", ["loc", [null, [11, 10], [11, 21]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [11, 4], [15, 11]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 18,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/forms/styled-select/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("div");
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("span");
        var el3 = dom.createComment("");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("select");
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element0 = dom.childAt(fragment, [0]);
        var element1 = dom.childAt(fragment, [2]);
        var morphs = new Array(6);
        morphs[0] = dom.createAttrMorph(element0, 'class');
        morphs[1] = dom.createUnsafeMorphAt(dom.childAt(element0, [1]), 0, 0);
        morphs[2] = dom.createAttrMorph(element1, 'disabled');
        morphs[3] = dom.createElementMorph(element1);
        morphs[4] = dom.createMorphAt(element1, 1, 1);
        morphs[5] = dom.createMorphAt(element1, 2, 2);
        return morphs;
      },
      statements: [["attribute", "class", ["concat", ["cs-styled-select-label ", ["subexpr", "if", [["get", "showPlaceholder", ["loc", [null, [1, 40], [1, 55]]], 0, 0, 0, 0], "cs-styled-select-placeholder"], [], ["loc", [null, [1, 35], [1, 88]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["content", "label", ["loc", [null, [2, 8], [2, 19]]], 0, 0, 0, 0], ["attribute", "disabled", ["get", "disabled", ["loc", [null, [4, 19], [4, 27]]], 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["change"], ["on", "change"], ["loc", [null, [4, 30], [4, 61]]], 0, 0], ["block", "if", [["get", "showPlaceholder", ["loc", [null, [5, 8], [5, 23]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [5, 2], [7, 9]]]], ["block", "if", [["get", "hasBlock", ["loc", [null, [8, 8], [8, 16]]], 0, 0, 0, 0]], [], 1, 2, ["loc", [null, [8, 2], [16, 9]]]]],
      locals: [],
      templates: [child0, child1, child2]
    };
  })());
});
define('cornerstone/components/forms/text-editor/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({

    classNames: ['cs-text-editor'],
    classNameBindings: ['modeClass'],

    allModes: ['html', 'text'],

    editorWrapID: _ember['default'].computed('editorID', function () {
      return 'wp-' + this.get('editorID') + '-wrap';
    }),

    editorContainerID: _ember['default'].computed('editorID', function () {
      return 'wp-' + this.get('editorID') + '-editor-container';
    }),

    init: function init() {

      this._super.apply(this, arguments);

      var editorID = 'cswpeditor-' + _ember['default'].guidFor(this);
      this.set('editorID', editorID);

      window.tinyMCEPreInit.mceInit[editorID] = _ember['default'].copy(window.tinyMCEPreInit.mceInit['cswpeditor']);
      window.tinyMCEPreInit.mceInit[editorID].id = editorID;
      window.tinyMCEPreInit.mceInit[editorID].selector = '#' + editorID;
      window.tinyMCEPreInit.mceInit[editorID].resize = false;
      window.tinyMCEPreInit.mceInit[editorID].valid_elements = "*[*]";
      window.tinyMCEPreInit.mceInit[editorID].extended_valid_elements = "*[*]";
    },

    setupTinyMCE: function setupTinyMCE() {
      var _this = this;

      return new _ember['default'].RSVP.Promise(function (resolve, reject) {

        if (_this.get('tinyMCERendered') || 'undefined' === typeof window.tinymce) {
          return reject();
        }

        var editorID = _this.get('editorID');

        window.tinyMCEPreInit.mceInit[editorID].setup = _this.get('setupTinyMCE');

        var setup = function setup(editor) {

          _this.set('editorInstance', editor);

          editor.on('init', function () {

            if (!window.wpActiveEditor) {
              window.wpActiveEditor = editorID;
            }

            _this.set('tinyMCERendered', true);

            resolve(editor);
          });

          editor.addButton('cs_media', {
            icon: 'image',
            onclick: function onclick() {
              if (!window.wp || !window.wp.media || !window.wp.media.editor) {
                return;
              }
              window.wp.media.editor.open(_this.get('editorID'), {
                frame: 'post',
                state: 'insert',
                title: window.wp.media.view.l10n.addMedia,
                multiple: true
              });
            }
          });

          var update = function update() {
            if ('text' === _this.get('activeMode')) {
              _this.set('isUpdatingText', true);
              _this.set('value', _this.get('editorInstance').getContent());
              _this.set('isUpdatingText', false);
            }
          };

          editor.on('keyup change NodeChange', function () {
            _ember['default'].run.debounce(update, 150);
          });
        };

        window.tinymce.init(_ember['default'].assign({}, window.tinyMCEPreInit.mceInit[editorID], { setup: setup }));
      });
    },

    availableModes: _ember['default'].computed(function () {
      var all = this.get('allModes');
      var mode = this.get('mode');
      return all.includes(mode) ? [mode] : all;
    }),

    modeClass: _ember['default'].computed('activeMode', function () {
      return 'cs-text-editor-mode-' + this.get('activeMode');
    }),

    pickerOpen: _ember['default'].observer('picker.open', function () {
      // if ( this.get('picker.open') ) {
      //   Ember.run.scheduleOnce('afterRender', () => {
      //     this.renderTinyMCE();
      //   });
      // }
    }),

    onInit: _ember['default'].on('init', function () {
      this.set('activeMode', this.get('availableModes.firstObject'));
    }),

    observeValue: _ember['default'].observer('value', function () {
      var editorInstance = this.get('editorInstance');
      if (!editorInstance || this.isDestroyed || this.get('isUpdatingText')) {
        return;
      }
      editorInstance.setContent(this.get('value'), { format: 'raw' });
      this.set('isUpdatingText', false);
    }),

    didInsertElement: function didInsertElement() {
      var _this2 = this;

      _ember['default'].run.scheduleOnce('afterRender', function () {
        if (_this2.get('availableModes').includes('text')) {
          _this2.$('.cs-text-editor-text textarea').val(_this2.get('value'));
          _this2.setupTinyMCE().then(function () {
            _this2.send('focus');
          });
        } else {
          _this2.send('focus');
        }
      });
    },

    prepareEditorContent: function prepareEditorContent(html) {
      return html;
    },
    cleanEditorUpdate: function cleanEditorUpdate(html) {
      return html;
    },

    actions: {
      focus: function focus() {
        var _this3 = this;

        _ember['default'].run.later(function () {
          if ('text' === _this3.get('activeMode')) {
            _this3.send('focusTextEditor');
          } else {
            _this3.$('textarea').focus();
          }
        }, 10);
      },
      switchTo: function switchTo(mode) {
        this.set('activeMode', mode);
        this.send('focus');
      },
      focusTextEditor: function focusTextEditor() {
        var editorInstance = this.get('editorInstance');
        if (editorInstance) {
          editorInstance.focus();
          editorInstance.selection.select(editorInstance.getBody(), true);
          editorInstance.selection.collapse(false);
        }
      }
    }
  });
});
define("cornerstone/components/forms/text-editor/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 2
            },
            "end": {
              "line": 4,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/forms/text-editor/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("button");
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element1 = dom.childAt(fragment, [1]);
          var morphs = new Array(3);
          morphs[0] = dom.createAttrMorph(element1, 'class');
          morphs[1] = dom.createElementMorph(element1);
          morphs[2] = dom.createMorphAt(element1, 0, 0);
          return morphs;
        },
        statements: [["attribute", "class", ["concat", [["subexpr", "if", [["subexpr", "eq", [["get", "activeMode", ["loc", [null, [3, 57], [3, 67]]], 0, 0, 0, 0], "html"], [], ["loc", [null, [3, 53], [3, 75]]], 0, 0], "cs-active"], [], ["loc", [null, [3, 48], [3, 89]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["switchTo", "html"], [], ["loc", [null, [3, 12], [3, 40]]], 0, 0], ["inline", "fa-icon", ["code"], [], ["loc", [null, [3, 91], [3, 109]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 5,
              "column": 2
            },
            "end": {
              "line": 7,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/forms/text-editor/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("button");
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element0 = dom.childAt(fragment, [1]);
          var morphs = new Array(3);
          morphs[0] = dom.createAttrMorph(element0, 'class');
          morphs[1] = dom.createElementMorph(element0);
          morphs[2] = dom.createMorphAt(element0, 0, 0);
          return morphs;
        },
        statements: [["attribute", "class", ["concat", [["subexpr", "if", [["subexpr", "eq", [["get", "activeMode", ["loc", [null, [6, 57], [6, 67]]], 0, 0, 0, 0], "text"], [], ["loc", [null, [6, 53], [6, 75]]], 0, 0], "cs-active"], [], ["loc", [null, [6, 48], [6, 89]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["switchTo", "text"], [], ["loc", [null, [6, 12], [6, 40]]], 0, 0], ["inline", "cs-icon", ["interface/action-btn-fonts"], [], ["loc", [null, [6, 91], [6, 131]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 22,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/forms/text-editor/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "cs-text-editor-switcher");
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n\n\n\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "cs-text-editor-text");
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("div");
        dom.setAttribute(el2, "class", "wp-core-ui wp-editor-wrap tmce-active");
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("div");
        dom.setAttribute(el3, "class", "wp-editor-container");
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("textarea");
        dom.setAttribute(el4, "class", "cs-wp-editor wp-editor-area");
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n    ");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n  ");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element2 = dom.childAt(fragment, [0]);
        var element3 = dom.childAt(fragment, [2, 1]);
        var element4 = dom.childAt(element3, [1]);
        var element5 = dom.childAt(element4, [1]);
        var morphs = new Array(7);
        morphs[0] = dom.createMorphAt(element2, 1, 1);
        morphs[1] = dom.createMorphAt(element2, 2, 2);
        morphs[2] = dom.createAttrMorph(element3, 'id');
        morphs[3] = dom.createAttrMorph(element4, 'id');
        morphs[4] = dom.createAttrMorph(element5, 'id');
        morphs[5] = dom.createMorphAt(fragment, 4, 4, contextualElement);
        morphs[6] = dom.createMorphAt(fragment, 6, 6, contextualElement);
        return morphs;
      },
      statements: [["block", "if", [["subexpr", "contains", ["html", ["get", "availableModes", ["loc", [null, [2, 25], [2, 39]]], 0, 0, 0, 0]], [], ["loc", [null, [2, 8], [2, 40]]], 0, 0]], [], 0, null, ["loc", [null, [2, 2], [4, 9]]]], ["block", "if", [["subexpr", "contains", ["text", ["get", "availableModes", ["loc", [null, [5, 25], [5, 39]]], 0, 0, 0, 0]], [], ["loc", [null, [5, 8], [5, 40]]], 0, 0]], [], 1, null, ["loc", [null, [5, 2], [7, 9]]]], ["attribute", "id", ["get", "editorWrapID", ["loc", [null, [13, 12], [13, 24]]], 0, 0, 0, 0], 0, 0, 0, 0], ["attribute", "id", ["get", "editorContainerID", ["loc", [null, [14, 14], [14, 31]]], 0, 0, 0, 0], 0, 0, 0, 0], ["attribute", "id", ["get", "editorID", ["loc", [null, [15, 57], [15, 65]]], 0, 0, 0, 0], 0, 0, 0, 0], ["inline", "textarea", [], ["value", ["subexpr", "@mut", [["get", "value", ["loc", [null, [20, 17], [20, 22]]], 0, 0, 0, 0]], [], [], 0, 0], "class", "cs-text-editor-html"], ["loc", [null, [20, 0], [20, 52]]], 0, 0], ["content", "yield", ["loc", [null, [21, 0], [21, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0, child1]
    };
  })());
});
define('cornerstone/components/forms/unit-input/component', ['exports', 'ember', 'cornerstone/util/string-like', 'cornerstone/util/split-on-whitespace'], function (exports, _ember, _cornerstoneUtilStringLike, _cornerstoneUtilSplitOnWhitespace) {
  exports['default'] = _ember['default'].Component.extend({

    classNames: ['cs-unit-input'],
    classNameBindings: ['invalidInput:cs-unit-input-invalid', 'choicesDisabled:cs-unit-input-hide-switcher'],
    open: false,
    isFocused: false,

    unitMode: _ember['default'].computed('options.unit_mode', function () {
      return this.getWithDefault('options.unit_mode', 'distance');
    }),

    distanceUnits: ['none', 'px', 'em', 'rem', 'vh', 'vw', '%'],
    angleUnits: ['deg', 'rad'],
    timeUnits: ['s', 'ms'],

    solitaryInput: _ember['default'].computed.lte('allowedUnits.length', 1),
    isUnitless: _ember['default'].computed.equal('unitMode', 'unitless'),

    choicesDisabled: _ember['default'].computed('solitaryInput', 'options.disabled', 'usingKeyword', 'isUnitless', function () {
      return this.get('options.disabled') || this.get('solitaryInput') || this.get('usingKeyword') || this.get('isUnitless');
    }),

    init: function init() {

      this._super.apply(this, arguments);

      var parent = this.get('parent');

      if (_ember['default'].isPresent(parent)) {
        parent.set('unitInput', this);
      }

      this.set('usingKeyword', this.isKeywordValid(this.get('value')));
    },

    focusChange: _ember['default'].observer('isFocused', function () {
      this.fallback();
    }),

    fallbackWhenInvalid: _ember['default'].computed('value', function () {
      this.fallback();
    }),

    fallback: function fallback() {
      if (!this.get('isFocused') && (this.get('invalidInput') || '' === this.get('value'))) {
        this.set('value', this.getWithDefault('options.fallback_value', '0' + this.get('allowedUnits')[0]));
        this.notifyPropertyChange('rawValue');
      }
    },

    valToString: function valToString() {
      var val = arguments.length <= 0 || arguments[0] === undefined ? '' : arguments[0];

      return String(val);
    },

    detectUnit: function detectUnit(source) {
      var selected = undefined;
      var current = this.valToString(source);
      var matches = current.match(/-?\d*(?:\.\d+)?/);
      var prev = this.get('previousUnit');

      if (matches) {
        selected = current.replace(matches[0], '');
      }

      if (prev && '' === current) {
        selected = prev;
      }

      var allowed = this.get('allowedUnits');

      return allowed.includes(selected) ? selected : allowed[0];
    },

    stripUnit: function stripUnit(value, fallback) {

      var matches = this.valToString(value).match(/-?\d*(?:\.\d+)?/);
      var parsed = fallback;

      if (matches) {
        parsed = parseFloat(matches[0]);
      }

      return isNaN(parsed) ? fallback : parsed;
    },

    unit: _ember['default'].computed('value', 'allowedUnits', {
      get: function get() {
        if (this.get('isUnitless')) {
          return '';
        }
        var value = this.get('value');
        return this.isKeywordValid(value) ? '' : this.detectUnit(value);
      },
      set: function set(key, value) {

        var raw = this.get('rawValue');
        if (this.isKeywordValid(raw)) {
          return '';
        }

        var number = this.stripUnit(raw, 0);

        this.set('value', 'none' === value ? number : '' + number + value);
        this.set('previousUnit', value);

        return value;
      }
    }),

    observeUsingKeyword: _ember['default'].observer('value', function () {
      this.set('usingKeyword', this.isKeywordValid(this.get('value')));
    }),

    rawValue: _ember['default'].computed('value', {
      get: function get() {
        var value = this.get('value');
        return this.isKeywordValid(value) ? value : this.stripUnit(value, undefined);
      },
      set: function set(key, value) {

        if (this.isKeywordValid(value)) {
          this.set('value', value);
          this.set('invalidInput', false);
          return value;
        }

        var matches = this.valToString(value).match(/^-?\d*(?:\.\d+)?$/);
        if (matches && !isNaN(parseFloat(value))) {
          var unit = this.get('usingKeyword') ? this.detectUnit(value) : this.get('unit');

          if ('none' === unit) {
            this.set('value', matches[0]);
          } else {
            this.set('value', '' + matches[0] + unit);
          }

          this.set('invalidInput', false);
        } else if ('' === value && '' === this.get('options.fallback_value')) {
          this.set('value', '');
          this.set('invalidInput', false);
        } else {
          this.set('invalidInput', true);
        }

        return value;
      }
    }),

    rawNumeric: _ember['default'].computed('value', function () {
      var value = this.get('value');
      return this.isKeywordValid(value) ? false : this.stripUnit(value, false);
    }),

    allowedUnits: _ember['default'].computed('options.available_units', 'unitMode', function () {

      if (this.get('isUnitless')) {
        return [''];
      }

      var baseUnits = this.get('angle' === this.get('unitMode') ? 'angleUnits' : 'time' === this.get('unitMode') ? 'timeUnits' : 'distanceUnits');
      var allowed = this.get('options.available_units');

      if (allowed) {
        baseUnits = baseUnits.filter(function (item) {
          return allowed.includes(item);
        });
      }

      return baseUnits;
    }),

    isKeywordValid: function isKeywordValid(word) {

      // Bail if we find any unqualified spaces
      if ((0, _cornerstoneUtilSplitOnWhitespace['default'])(word).length > 1) {
        return false;
      }

      return !!this.getWithDefault('options.valid_keywords', []).find(function (keyword) {
        if ('calc' === keyword) {
          keyword = 'calc%';
        }
        return (0, _cornerstoneUtilStringLike['default'])(word, keyword);
      });
    },

    actions: {

      focus: function focus() {
        this.set('isFocused', true);
      },

      blur: function blur() {
        this.set('isFocused', false);
      },

      selectUnit: function selectUnit(unit) {
        this.set('unit', unit);
        this.set('open', false);
      },

      toggle: function toggle() {

        if (this.get('open')) {
          this.set('open', false);
          return;
        }

        if (!this.get('solitaryInput')) {
          this.set('open', true);
        }
      },

      clickOutside: function clickOutside() {
        this.set('open', false);
      },

      detectUnitOnEnter: function detectUnitOnEnter() {

        var raw = this.get('rawValue');
        if (this.isKeywordValid(raw) || this.get('isUnitless')) {
          return;
        }

        var fallback = this.get('options.fallback_value');
        if ('' === raw && fallback) {
          this.set('rawValue', fallback);
        } else {
          var detected = this.detectUnit(raw);

          if (detected === this.get('unit')) {
            this.set('rawValue', this.stripUnit(raw, 0));
          } else {
            this.set('unit', detected);
          }
        }
      }
    }

  });
});
define("cornerstone/components/forms/unit-input/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 3,
              "column": 2
            },
            "end": {
              "line": 5,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/forms/unit-input/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("button");
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element1 = dom.childAt(fragment, [1]);
          var morphs = new Array(3);
          morphs[0] = dom.createAttrMorph(element1, 'class');
          morphs[1] = dom.createElementMorph(element1);
          morphs[2] = dom.createMorphAt(element1, 0, 0);
          return morphs;
        },
        statements: [["attribute", "class", ["concat", ["cs-unit-input-unit ", ["subexpr", "if", [["get", "open", ["loc", [null, [4, 43], [4, 47]]], 0, 0, 0, 0], "cs-active"], [], ["loc", [null, [4, 38], [4, 61]]], 0, 0], " ", ["subexpr", "if", [["get", "choicesDisabled", ["loc", [null, [4, 67], [4, 82]]], 0, 0, 0, 0], "cs-solitary"], [], ["loc", [null, [4, 62], [4, 98]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["toggle"], [], ["loc", [null, [4, 100], [4, 119]]], 0, 0], ["content", "unit", ["loc", [null, [4, 120], [4, 128]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 8,
                  "column": 6
                },
                "end": {
                  "line": 10,
                  "column": 6
                }
              },
              "moduleName": "cornerstone/components/forms/unit-input/template.hbs"
            },
            isEmpty: false,
            arity: 1,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("        ");
              dom.appendChild(el0, el1);
              var el1 = dom.createElement("button");
              var el2 = dom.createComment("");
              dom.appendChild(el1, el2);
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var element0 = dom.childAt(fragment, [1]);
              var morphs = new Array(3);
              morphs[0] = dom.createAttrMorph(element0, 'class');
              morphs[1] = dom.createElementMorph(element0);
              morphs[2] = dom.createMorphAt(element0, 0, 0);
              return morphs;
            },
            statements: [["attribute", "class", ["concat", ["cs-unit-input-choice ", ["subexpr", "if", [["subexpr", "eq", [["get", "selectedUnit", ["loc", [null, [9, 53], [9, 65]]], 0, 0, 0, 0], ["get", "unitChoice", ["loc", [null, [9, 66], [9, 76]]], 0, 0, 0, 0]], [], ["loc", [null, [9, 49], [9, 77]]], 0, 0], "cs-active"], [], ["loc", [null, [9, 44], [9, 91]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["selectUnit", ["get", "unitChoice", ["loc", [null, [9, 115], [9, 125]]], 0, 0, 0, 0]], [], ["loc", [null, [9, 93], [9, 127]]], 0, 0], ["content", "unitChoice", ["loc", [null, [9, 128], [9, 142]]], 0, 0, 0, 0]],
            locals: ["unitChoice"],
            templates: []
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 7,
                "column": 4
              },
              "end": {
                "line": 11,
                "column": 4
              }
            },
            "moduleName": "cornerstone/components/forms/unit-input/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
            dom.insertBoundary(fragment, 0);
            dom.insertBoundary(fragment, null);
            return morphs;
          },
          statements: [["block", "each", [["get", "allowedUnits", ["loc", [null, [8, 14], [8, 26]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [8, 6], [10, 15]]]]],
          locals: [],
          templates: [child0]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 6,
              "column": 2
            },
            "end": {
              "line": 12,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/forms/unit-input/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "common/floating-container", [], ["outsideClick", "clickOutside", "open", ["subexpr", "@mut", [["get", "open", ["loc", [null, [7, 66], [7, 70]]], 0, 0, 0, 0]], [], [], 0, 0], "class", "cs-unit-input-choices"], 0, null, ["loc", [null, [7, 4], [11, 34]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 15,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/forms/unit-input/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "cs-unit-input-selection");
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element2 = dom.childAt(fragment, [2]);
        var morphs = new Array(4);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(element2, 1, 1);
        morphs[2] = dom.createMorphAt(element2, 2, 2);
        morphs[3] = dom.createMorphAt(fragment, 4, 4, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "input", [], ["value", ["subexpr", "@mut", [["get", "rawValue", ["loc", [null, [1, 14], [1, 22]]], 0, 0, 0, 0]], [], [], 0, 0], "enter", "detectUnitOnEnter", "placeholder", ["subexpr", "@mut", [["get", "placeholder", ["loc", [null, [1, 61], [1, 72]]], 0, 0, 0, 0]], [], [], 0, 0], "disabled", ["subexpr", "@mut", [["get", "options.disabled", ["loc", [null, [1, 82], [1, 98]]], 0, 0, 0, 0]], [], [], 0, 0], "focus-out", "blur", "focus-in", "focus"], ["loc", [null, [1, 0], [1, 134]]], 0, 0], ["block", "if", [["get", "unit", ["loc", [null, [3, 8], [3, 12]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [3, 2], [5, 9]]]], ["block", "unless", [["get", "choicesDisabled", ["loc", [null, [6, 12], [6, 27]]], 0, 0, 0, 0]], [], 1, null, ["loc", [null, [6, 2], [12, 13]]]], ["content", "yield", ["loc", [null, [14, 0], [14, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0, child1]
    };
  })());
});
define('cornerstone/components/forms/unit-slider/component', ['exports', 'ember', 'npm:nouislider', 'jquery'], function (exports, _ember, _npmNouislider, _jquery) {
  exports['default'] = _ember['default'].Component.extend({

    defaultsRanges: {

      // Distance
      none: { min: 0, max: 3, step: 0.001 },
      px: { min: 0, max: 1500, step: 1 },
      em: { min: -0.15, max: 0.5, step: 0.001 },
      rem: { min: -0.15, max: 0.5, step: 0.001 },
      vh: { min: 0, max: 100, step: 1 },
      vw: { min: 0, max: 100, step: 1 },
      '%': { min: 0, max: 100, step: 1 },

      // Angles
      deg: { min: 0, max: 360, step: 1 },
      rad: { min: 0, max: 6.2832, step: 0.0001 }

    },

    unitInputOptions: _ember['default'].computed('options', function () {
      var options = this.getWithDefault('options', {});
      return {
        disabled: options.disabled,
        available_units: options.available_units,
        valid_keywords: options.valid_keywords,
        unit_mode: options.unit_mode,
        fallback_value: options.fallback_value
      };
    }),

    rangeVal: _ember['default'].computed('unitInput.unit', function () {

      var range = { step: 0.1, min: 0, max: 100 };

      var step = undefined,
          min = undefined,
          max = undefined;

      if ('unitless' === this.get('options.unit_mode')) {
        step = parseFloat(this.get('options.step'));
        min = parseFloat(this.get('options.min'));
        max = parseFloat(this.get('options.max'));
      } else {
        var defaults = this.get('defaultsRanges');
        var mapped = this.get('options.ranges');
        var unit = this.get('unitInput.unit');

        if (defaults[unit]) {
          step = defaults[unit].step;
          min = defaults[unit].min;
          max = defaults[unit].max;
        }

        if (mapped && mapped[unit]) {
          step = parseFloat(mapped[unit].step);
          min = parseFloat(mapped[unit].min);
          max = parseFloat(mapped[unit].max);
        }
      }

      if (!isNaN(step)) {
        range.step = step;
      }

      if (!isNaN(min)) {
        range.min = min;
      }

      if (!isNaN(max)) {
        range.max = max;
      }

      return range;
    }),

    classNames: ['cs-unit-slider'],

    rangeUpdate: _ember['default'].observer('unitInput.unit', function () {
      var unit = this.get('unitInput.unit');

      if (unit === this.get('currentRangeUnit')) {
        return;
      }

      this.set('currentRangeUnit', unit);

      var range = this.get('rangeVal');
      var sliderEl = this.get('sliderEl');

      if (!range || !sliderEl || !sliderEl.noUiSlider) {
        return;
      }

      sliderEl.noUiSlider.updateOptions({
        step: range.step,
        range: {
          'min': range.min,
          'max': range.max
        }
      });
    }),

    didInsertElement: function didInsertElement() {
      var _this = this;

      this.set('sliderEl', this.$('.cs-unit-slider-target')[0]);

      _ember['default'].run.later(function () {

        var el = _this.get('sliderEl');

        if (!el || _this.isDestroyed) {
          return;
        }

        var range = _this.get('rangeVal');

        var num = _this.get('unitInput.rawNumeric');

        _npmNouislider['default'].create(_this.get('sliderEl'), {
          start: isNaN(num) ? 0 : num,
          step: range.step,
          connect: 'lower',
          range: {
            'min': range.min,
            'max': range.max
          }
        });

        el.noUiSlider.on('change', (function () {
          if (this.isDestroyed) {
            return;
          }
          this.set('isSliding', false);
          this.sliderChanged(el.noUiSlider.get(), 'change', el.noUiSlider);
        }).bind(_this));

        el.noUiSlider.on('slide', (function () {
          if (this.isDestroyed) {
            return;
          }
          this.set('isSliding', true);
          this.sliderChanged(el.noUiSlider.get(), 'slide', el.noUiSlider);
        }).bind(_this));

        _this.notifyPropertyChange('canSlide');
        _this.get('unitInput.previousUnit');

        (0, _jquery['default'])(el).removeClass('cs-unit-slider-target-waiting');
      }, 3);
    },

    sliderChanged: function sliderChanged(val) {
      this.set('unitInput.rawValue', String(parseFloat(val)));
    },

    canSlide: _ember['default'].computed('options.disabled', 'unitInput.rawNumeric', 'unitInput.usingKeyword', function () {
      return !(this.get('options.disabled') || isNaN(this.get('unitInput.rawNumeric')) || this.get('unitInput.usingKeyword'));
    }),

    observeCanSlide: _ember['default'].observer('canSlide', function () {

      var sliderEl = this.get('sliderEl');

      if (!sliderEl) {
        return;
      }

      if (!this.get('canSlide')) {
        sliderEl.noUiSlider.set(0);
      }
    }),

    updateSlider: _ember['default'].observer('unitInput.rawNumeric', function () {

      var sliderEl = this.get('sliderEl');

      if (!sliderEl || !this.get('canSlide') || this.get('isSliding')) {
        return;
      }

      sliderEl.noUiSlider.set(this.get('unitInput.rawNumeric'));
    })

  });
});
define("cornerstone/components/forms/unit-slider/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 6,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/forms/unit-slider/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "cs-unit-slider-target-container");
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("div");
        dom.setAttribute(el2, "class", "cs-unit-slider-target cs-unit-slider-target-waiting");
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(2);
        morphs[0] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 4, 4, contextualElement);
        return morphs;
      },
      statements: [["inline", "forms/unit-input", [], ["value", ["subexpr", "@mut", [["get", "value", ["loc", [null, [4, 25], [4, 30]]], 0, 0, 0, 0]], [], [], 0, 0], "parent", ["subexpr", "@mut", [["get", "this", ["loc", [null, [4, 38], [4, 42]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "unitInputOptions", ["loc", [null, [4, 51], [4, 67]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [4, 0], [4, 70]]], 0, 0], ["content", "yield", ["loc", [null, [5, 0], [5, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
define('cornerstone/components/global/bar-button/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    tagName: 'button',
    classNames: ['cs-bar-btn'],
    classNameBindings: ['class', 'active:cs-active'],

    active: false,

    click: function click() {
      this.sendAction();
    }

  });
});
define("cornerstone/components/global/bar-button/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 1,
            "column": 9
          }
        },
        "moduleName": "cornerstone/components/global/bar-button/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["content", "yield", ["loc", [null, [1, 0], [1, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
define('cornerstone/components/global/bar-nav/component', ['exports', 'cornerstone/components/common/floating-container/component'], function (exports, _cornerstoneComponentsCommonFloatingContainerComponent) {
  exports['default'] = _cornerstoneComponentsCommonFloatingContainerComponent['default'].extend({
    open: false,
    tagName: 'nav',
    classNames: ['cs-bar-nav'],

    outsideClickHandler: function outsideClickHandler() {
      this.set('open', false);
    },

    click: function click() {
      this.toggleProperty('open');
    }

  });
});
// import Ember from 'ember';
define("cornerstone/components/global/bar-nav/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 6,
              "column": 6
            },
            "end": {
              "line": 6,
              "column": 89
            }
          },
          "moduleName": "cornerstone/components/global/bar-nav/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["inline", "t", ["app.home.title"], [], ["loc", [null, [6, 67], [6, 89]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 9,
                "column": 41
              },
              "end": {
                "line": 9,
                "column": 89
              }
            },
            "moduleName": "cornerstone/components/global/bar-nav/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
            dom.insertBoundary(fragment, 0);
            dom.insertBoundary(fragment, null);
            return morphs;
          },
          statements: [["inline", "t", ["app.options.title"], [], ["loc", [null, [9, 64], [9, 89]]], 0, 0]],
          locals: [],
          templates: []
        };
      })();
      var child1 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 10,
                "column": 9
              },
              "end": {
                "line": 10,
                "column": 61
              }
            },
            "moduleName": "cornerstone/components/global/bar-nav/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
            dom.insertBoundary(fragment, 0);
            dom.insertBoundary(fragment, null);
            return morphs;
          },
          statements: [["inline", "t", ["app.templates.title"], [], ["loc", [null, [10, 34], [10, 61]]], 0, 0]],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 8,
              "column": 2
            },
            "end": {
              "line": 11,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/global/bar-nav/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("li");
          dom.setAttribute(el1, "class", "cs-bar-nav-items-divider");
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("li");
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(2);
          morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1]), 0, 0);
          morphs[1] = dom.createMorphAt(dom.childAt(fragment, [3]), 0, 0);
          return morphs;
        },
        statements: [["block", "link-to", ["options"], [], 0, null, ["loc", [null, [9, 41], [9, 101]]]], ["block", "link-to", ["templates"], [], 1, null, ["loc", [null, [10, 9], [10, 73]]]]],
        locals: [],
        templates: [child0, child1]
      };
    })();
    var child2 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 14,
                "column": 41
              },
              "end": {
                "line": 14,
                "column": 89
              }
            },
            "moduleName": "cornerstone/components/global/bar-nav/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
            dom.insertBoundary(fragment, 0);
            dom.insertBoundary(fragment, null);
            return morphs;
          },
          statements: [["inline", "t", ["app.headers.title"], [], ["loc", [null, [14, 64], [14, 89]]], 0, 0]],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 13,
              "column": 2
            },
            "end": {
              "line": 15,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/global/bar-nav/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("li");
          dom.setAttribute(el1, "class", "cs-bar-nav-items-divider");
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1]), 0, 0);
          return morphs;
        },
        statements: [["block", "link-to", ["headers"], [], 0, null, ["loc", [null, [14, 41], [14, 101]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    var child3 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 18,
                "column": 8
              },
              "end": {
                "line": 18,
                "column": 56
              }
            },
            "moduleName": "cornerstone/components/global/bar-nav/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
            dom.insertBoundary(fragment, 0);
            dom.insertBoundary(fragment, null);
            return morphs;
          },
          statements: [["inline", "t", ["app.builder.title"], [], ["loc", [null, [18, 31], [18, 56]]], 0, 0]],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 17,
              "column": 2
            },
            "end": {
              "line": 19,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/global/bar-nav/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("li");
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1]), 0, 0);
          return morphs;
        },
        statements: [["block", "link-to", ["content"], [], 0, null, ["loc", [null, [18, 8], [18, 68]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    var child4 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 22,
                "column": 8
              },
              "end": {
                "line": 22,
                "column": 56
              }
            },
            "moduleName": "cornerstone/components/global/bar-nav/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
            dom.insertBoundary(fragment, 0);
            dom.insertBoundary(fragment, null);
            return morphs;
          },
          statements: [["inline", "t", ["app.footers.title"], [], ["loc", [null, [22, 31], [22, 56]]], 0, 0]],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 21,
              "column": 2
            },
            "end": {
              "line": 23,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/global/bar-nav/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("li");
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1]), 0, 0);
          return morphs;
        },
        statements: [["block", "link-to", ["footers"], [], 0, null, ["loc", [null, [22, 8], [22, 68]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 30,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/global/bar-nav/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("a");
        dom.setAttribute(el1, "class", "cs-bar-nav-toggle");
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("span");
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("ul");
        dom.setAttribute(el1, "class", "cs-bar-nav-items");
        var el2 = dom.createTextNode("\n\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("li");
        var el3 = dom.createComment("");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("li");
        dom.setAttribute(el2, "class", "cs-bar-nav-items-divider");
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createComment("");
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n  ");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element0 = dom.childAt(fragment, [2]);
        var morphs = new Array(6);
        morphs[0] = dom.createMorphAt(dom.childAt(element0, [1]), 0, 0);
        morphs[1] = dom.createMorphAt(element0, 3, 3);
        morphs[2] = dom.createMorphAt(element0, 5, 5);
        morphs[3] = dom.createMorphAt(element0, 7, 7);
        morphs[4] = dom.createMorphAt(element0, 9, 9);
        morphs[5] = dom.createMorphAt(dom.childAt(element0, [11]), 1, 1);
        return morphs;
      },
      statements: [["block", "link-to", ["application"], ["class", "cs-bar-home-nav-item-home"], 0, null, ["loc", [null, [6, 6], [6, 101]]]], ["block", "if", [["get", "currentUser.canManageOptions", ["loc", [null, [8, 8], [8, 36]]], 0, 0, 0, 0]], [], 1, null, ["loc", [null, [8, 2], [11, 9]]]], ["block", "if", [["get", "currentUser.canUseRegions", ["loc", [null, [13, 8], [13, 33]]], 0, 0, 0, 0]], [], 2, null, ["loc", [null, [13, 2], [15, 9]]]], ["block", "if", [["get", "currentUser.canUseBuilder", ["loc", [null, [17, 8], [17, 33]]], 0, 0, 0, 0]], [], 3, null, ["loc", [null, [17, 2], [19, 9]]]], ["block", "if", [["get", "currentUser.canUseRegions", ["loc", [null, [21, 8], [21, 33]]], 0, 0, 0, 0]], [], 4, null, ["loc", [null, [21, 2], [23, 9]]]], ["inline", "common/link-out", [], ["class", "abc", "href", ["subexpr", "@mut", [["get", "ui.dashboardUrl", ["loc", [null, [26, 39], [26, 54]]], 0, 0, 0, 0]], [], [], 0, 0], "content", ["subexpr", "t", ["app.exit-to-dashboard"], [], ["loc", [null, [26, 63], [26, 90]]], 0, 0]], ["loc", [null, [26, 4], [26, 92]]], 0, 0]],
      locals: [],
      templates: [child0, child1, child2, child3, child4]
    };
  })());
});
define('cornerstone/components/global/code-editor/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    classNames: ['cs-global-code-editor'],
    classNameBindings: ['active:cs-active'],
    value: '',
    orientation: _ember['default'].computed.alias('ui.workspaceOrientation'),

    updateActive: _ember['default'].observer('active', function () {
      this.$('textarea').csCodeEditorToggle(this.get('active'));
    }),

    updateOrientation: _ember['default'].observer('orientation', function () {
      this.$('textarea').csCodeEditorOrient(this.get('orientation'));
    }),

    updateValue: _ember['default'].observer('value', function () {

      if (!this.set('updating')) {
        //console.log('updating', this.get('value'), this.get('editor').doc.getValue());
        // TODO: Push update into code editor
      }

      this.set('updating', false);
    }),

    didInsertElement: function didInsertElement() {
      var _this = this;

      this._super.apply(this, arguments);

      var $el = this.$('textarea');
      $el.val(this.get('value'));
      var runButton = !!this.get('run');

      $el.csCodeEditor({
        startOpen: this.get('active'),
        label: this.get('title'),
        orientation: this.get('orientation'),
        runButton: runButton,
        change: function change(cm) {

          var previous = _this.get('value');
          var current = cm.doc.getValue();

          if (previous !== current) {
            _this.set('value', current);
            _this.set('updating', true);
          }
        }
      });
      this.set('editor', $el.csCodeEditorInstance);

      $el.on('csCodeEditor.toggled', function (e, state) {
        if (state !== _this.get('active')) {
          _this.set('active', state);
        }
      });

      if (runButton) {
        $el.on('csCodeEditor.run', function () {
          _this.sendAction('run');
        });
      }
    },

    willDestroyElement: function willDestroyElement() {}
  });
});
define("cornerstone/components/global/code-editor/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 2,
            "column": 21
          }
        },
        "moduleName": "cornerstone/components/global/code-editor/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("textarea");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["content", "yield", ["loc", [null, [1, 0], [1, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
define('cornerstone/components/global/cs-bar/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    classNames: ['cs-bar']
  });
});
define("cornerstone/components/global/cs-bar/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 8,
                "column": 4
              },
              "end": {
                "line": 10,
                "column": 4
              }
            },
            "moduleName": "cornerstone/components/global/cs-bar/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("      ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            return morphs;
          },
          statements: [["inline", "cs-icon", ["interface/action-btn-responsive"], [], ["loc", [null, [9, 6], [9, 51]]], 0, 0]],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 7,
              "column": 2
            },
            "end": {
              "line": 11,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/global/cs-bar/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "global/bar-button", [], ["class", "cs-action-toggle-preview-sizer", "active", ["subexpr", "@mut", [["get", "ui.showPreviewSizer", ["loc", [null, [8, 71], [8, 90]]], 0, 0, 0, 0]], [], [], 0, 0], "action", ["subexpr", "action", ["toggle", "showPreviewSizer"], ["target", ["get", "ui", ["loc", [null, [8, 141], [8, 143]]], 0, 0, 0, 0]], ["loc", [null, [8, 98], [8, 144]]], 0, 0]], 0, null, ["loc", [null, [8, 4], [10, 26]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    var child1 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 13,
              "column": 2
            },
            "end": {
              "line": 15,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/global/cs-bar/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("a");
          dom.setAttribute(el1, "class", "cs-bar-btn cs-action-toggle-view-site");
          dom.setAttribute(el1, "target", "_blank");
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element1 = dom.childAt(fragment, [1]);
          var morphs = new Array(2);
          morphs[0] = dom.createAttrMorph(element1, 'href');
          morphs[1] = dom.createMorphAt(element1, 0, 0);
          return morphs;
        },
        statements: [["attribute", "href", ["concat", [["get", "ui.viewSiteURL", ["loc", [null, [14, 15], [14, 29]]], 0, 0, 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["inline", "cs-icon", ["interface/action-btn-view-site"], [], ["loc", [null, [14, 95], [14, 139]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child2 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 18,
                "column": 4
              },
              "end": {
                "line": 20,
                "column": 4
              }
            },
            "moduleName": "cornerstone/components/global/cs-bar/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("      ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            return morphs;
          },
          statements: [["inline", "cs-icon", ["interface/action-btn-collapse"], [], ["loc", [null, [19, 6], [19, 49]]], 0, 0]],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 17,
              "column": 2
            },
            "end": {
              "line": 21,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/global/cs-bar/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "global/bar-button", [], ["class", ["subexpr", "concat", ["cs-action-toggle-collapse cs-action-toggle-collapse-", ["get", "ui.windowOrientation", ["loc", [null, [18, 94], [18, 114]]], 0, 0, 0, 0]], [], ["loc", [null, [18, 31], [18, 115]]], 0, 0], "active", ["subexpr", "@mut", [["get", "ui.isCollapsed", ["loc", [null, [18, 123], [18, 137]]], 0, 0, 0, 0]], [], [], 0, 0], "action", ["subexpr", "action", ["toggle", "isCollapsed"], ["target", ["get", "ui", ["loc", [null, [18, 183], [18, 185]]], 0, 0, 0, 0]], ["loc", [null, [18, 145], [18, 186]]], 0, 0]], 0, null, ["loc", [null, [18, 4], [20, 26]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    var child3 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 24,
                "column": 4
              },
              "end": {
                "line": 26,
                "column": 4
              }
            },
            "moduleName": "cornerstone/components/global/cs-bar/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("      ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            return morphs;
          },
          statements: [["inline", "cs-icon", ["interface/action-btn-cheatsheet"], [], ["loc", [null, [25, 6], [25, 51]]], 0, 0]],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 23,
              "column": 2
            },
            "end": {
              "line": 27,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/global/cs-bar/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "global/bar-button", [], ["class", "cs-action-toggle-cheatsheet", "active", ["subexpr", "@mut", [["get", "ui.showCheatsheet", ["loc", [null, [24, 68], [24, 85]]], 0, 0, 0, 0]], [], [], 0, 0], "action", ["subexpr", "action", ["toggle", "showCheatsheet"], ["target", ["get", "ui", ["loc", [null, [24, 134], [24, 136]]], 0, 0, 0, 0]], ["loc", [null, [24, 93], [24, 137]]], 0, 0]], 0, null, ["loc", [null, [24, 4], [26, 26]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    var child4 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 30,
                "column": 4
              },
              "end": {
                "line": 32,
                "column": 4
              }
            },
            "moduleName": "cornerstone/components/global/cs-bar/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("      ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            return morphs;
          },
          statements: [["inline", "fa-icon", ["bug"], [], ["loc", [null, [31, 6], [31, 23]]], 0, 0]],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 29,
              "column": 2
            },
            "end": {
              "line": 33,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/global/cs-bar/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "global/bar-button", [], ["active", ["subexpr", "@mut", [["get", "ui.debug", ["loc", [null, [30, 32], [30, 40]]], 0, 0, 0, 0]], [], [], 0, 0], "action", ["subexpr", "action", ["toggle", "debug"], ["target", ["get", "ui", ["loc", [null, [30, 80], [30, 82]]], 0, 0, 0, 0]], ["loc", [null, [30, 48], [30, 83]]], 0, 0]], 0, null, ["loc", [null, [30, 4], [32, 26]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    var child5 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 35,
              "column": 2
            },
            "end": {
              "line": 37,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/global/cs-bar/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("button");
          dom.setAttribute(el1, "class", "cs-bar-btn cs-action-save");
          var el2 = dom.createTextNode("SAVE");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element0 = dom.childAt(fragment, [1]);
          var morphs = new Array(2);
          morphs[0] = dom.createAttrMorph(element0, 'disabled');
          morphs[1] = dom.createElementMorph(element0);
          return morphs;
        },
        statements: [["attribute", "disabled", ["get", "ui.saving", ["loc", [null, [36, 98], [36, 107]]], 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["save"], ["target", ["get", "ui.primaryRoute", ["loc", [null, [36, 69], [36, 84]]], 0, 0, 0, 0]], ["loc", [null, [36, 46], [36, 86]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 39,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/global/cs-bar/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("nav");
        dom.setAttribute(el1, "class", "cs-bar-btns");
        var el2 = dom.createTextNode("\n\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element2 = dom.childAt(fragment, [2]);
        var morphs = new Array(8);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(element2, 2, 2);
        morphs[2] = dom.createMorphAt(element2, 4, 4);
        morphs[3] = dom.createMorphAt(element2, 6, 6);
        morphs[4] = dom.createMorphAt(element2, 8, 8);
        morphs[5] = dom.createMorphAt(element2, 10, 10);
        morphs[6] = dom.createMorphAt(element2, 12, 12);
        morphs[7] = dom.createMorphAt(element2, 14, 14);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["content", "global/bar-nav", ["loc", [null, [1, 0], [1, 18]]], 0, 0, 0, 0], ["content", "yield", ["loc", [null, [5, 2], [5, 11]]], 0, 0, 0, 0], ["block", "if", [["get", "ui.routeEnabledPreviewSizer", ["loc", [null, [7, 8], [7, 35]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [7, 2], [11, 9]]]], ["block", "if", [["get", "ui.canViewSite", ["loc", [null, [13, 8], [13, 22]]], 0, 0, 0, 0]], [], 1, null, ["loc", [null, [13, 2], [15, 9]]]], ["block", "if", [["get", "ui.routeEnabledCollapse", ["loc", [null, [17, 8], [17, 31]]], 0, 0, 0, 0]], [], 2, null, ["loc", [null, [17, 2], [21, 9]]]], ["block", "if", [["get", "ui.routeEnabledCheatsheet", ["loc", [null, [23, 8], [23, 33]]], 0, 0, 0, 0]], [], 3, null, ["loc", [null, [23, 2], [27, 9]]]], ["block", "if", [["get", "ui.devTools", ["loc", [null, [29, 8], [29, 19]]], 0, 0, 0, 0]], [], 4, null, ["loc", [null, [29, 2], [33, 9]]]], ["block", "if", [["get", "ui.routeEnabledSave", ["loc", [null, [35, 8], [35, 27]]], 0, 0, 0, 0]], [], 5, null, ["loc", [null, [35, 2], [37, 9]]]]],
      locals: [],
      templates: [child0, child1, child2, child3, child4, child5]
    };
  })());
});
define('cornerstone/components/global/cs-canvas/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    classNames: ['cs-canvas']
  });
});
define("cornerstone/components/global/cs-canvas/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 2,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/global/cs-canvas/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["content", "yield", ["loc", [null, [1, 0], [1, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
define('cornerstone/components/global/cs-window/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    orientation: _ember['default'].computed.alias('ui.windowOrientation'),
    collapse: _ember['default'].computed.alias('ui.isCollapsed'),
    classNames: ['cs-window'],
    classNameBindings: ['screenClass', 'orientation', 'collapse'],
    screenClass: _ember['default'].computed('screen', function () {
      var screen = this.get('screen');
      if (!screen) {
        return '';
      }
      return 'cs-window-' + _ember['default'].String.dasherize(this.get('screen'));
    })
  });
});
define("cornerstone/components/global/cs-window/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 2,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/global/cs-window/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["content", "yield", ["loc", [null, [1, 0], [1, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
define('cornerstone/components/global/entry-preloader/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    classNames: ['cs-entry-preloader'],
    showing: true,
    classNameBindings: ['showing:cs-active'],

    firstLoad: _ember['default'].observer('ui.transitioning', function () {

      if (!this.get('ui.transitioning ')) {
        this.set('showing', false);
        _ember['default'].run.cancel(this.scheduleRemoval);
      }
    }),

    didInsertElement: function didInsertElement() {

      this.scheduleRemoval = _ember['default'].run.later(this, (function () {
        this.set('showing', false);
      }).bind(this), this.get('ui.transitioning') ? 50000 : 500);
    }
  });
});
define("cornerstone/components/global/entry-preloader/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 2,
            "column": 9
          }
        },
        "moduleName": "cornerstone/components/global/entry-preloader/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(2);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["inline", "common/loading-indicator", [], ["style", "font-size: 150px;"], ["loc", [null, [1, 0], [1, 54]]], 0, 0], ["content", "yield", ["loc", [null, [2, 0], [2, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
define('cornerstone/components/global/launch-screen/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    isVisible: _ember['default'].computed.not('preview.isPreview'),
    preview: _ember['default'].inject.service()
  });
});
define("cornerstone/components/global/launch-screen/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          var child0 = (function () {
            var child0 = (function () {
              return {
                meta: {
                  "revision": "Ember@2.8.0",
                  "loc": {
                    "source": null,
                    "start": {
                      "line": 8,
                      "column": 14
                    },
                    "end": {
                      "line": 8,
                      "column": 117
                    }
                  },
                  "moduleName": "cornerstone/components/global/launch-screen/template.hbs"
                },
                isEmpty: false,
                arity: 0,
                cachedFragment: null,
                hasRendered: false,
                buildFragment: function buildFragment(dom) {
                  var el0 = dom.createDocumentFragment();
                  var el1 = dom.createElement("span");
                  var el2 = dom.createComment("");
                  dom.appendChild(el1, el2);
                  var el2 = dom.createComment("");
                  dom.appendChild(el1, el2);
                  dom.appendChild(el0, el1);
                  return el0;
                },
                buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                  var element4 = dom.childAt(fragment, [0]);
                  var morphs = new Array(2);
                  morphs[0] = dom.createMorphAt(element4, 0, 0);
                  morphs[1] = dom.createMorphAt(element4, 1, 1);
                  return morphs;
                },
                statements: [["inline", "cs-icon", ["interface/global-nav-options"], [], ["loc", [null, [8, 43], [8, 85]]], 0, 0], ["inline", "t", ["app.options.title"], [], ["loc", [null, [8, 85], [8, 110]]], 0, 0]],
                locals: [],
                templates: []
              };
            })();
            var child1 = (function () {
              return {
                meta: {
                  "revision": "Ember@2.8.0",
                  "loc": {
                    "source": null,
                    "start": {
                      "line": 9,
                      "column": 14
                    },
                    "end": {
                      "line": 9,
                      "column": 123
                    }
                  },
                  "moduleName": "cornerstone/components/global/launch-screen/template.hbs"
                },
                isEmpty: false,
                arity: 0,
                cachedFragment: null,
                hasRendered: false,
                buildFragment: function buildFragment(dom) {
                  var el0 = dom.createDocumentFragment();
                  var el1 = dom.createElement("span");
                  var el2 = dom.createComment("");
                  dom.appendChild(el1, el2);
                  var el2 = dom.createComment("");
                  dom.appendChild(el1, el2);
                  dom.appendChild(el0, el1);
                  return el0;
                },
                buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                  var element3 = dom.childAt(fragment, [0]);
                  var morphs = new Array(2);
                  morphs[0] = dom.createMorphAt(element3, 0, 0);
                  morphs[1] = dom.createMorphAt(element3, 1, 1);
                  return morphs;
                },
                statements: [["inline", "cs-icon", ["interface/global-nav-templates"], [], ["loc", [null, [9, 45], [9, 89]]], 0, 0], ["inline", "t", ["app.templates.title"], [], ["loc", [null, [9, 89], [9, 116]]], 0, 0]],
                locals: [],
                templates: []
              };
            })();
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 7,
                    "column": 8
                  },
                  "end": {
                    "line": 10,
                    "column": 8
                  }
                },
                "moduleName": "cornerstone/components/global/launch-screen/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("          ");
                dom.appendChild(el0, el1);
                var el1 = dom.createElement("li");
                var el2 = dom.createComment("");
                dom.appendChild(el1, el2);
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n          ");
                dom.appendChild(el0, el1);
                var el1 = dom.createElement("li");
                var el2 = dom.createComment("");
                dom.appendChild(el1, el2);
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(2);
                morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1]), 0, 0);
                morphs[1] = dom.createMorphAt(dom.childAt(fragment, [3]), 0, 0);
                return morphs;
              },
              statements: [["block", "link-to", ["options"], [], 0, null, ["loc", [null, [8, 14], [8, 129]]]], ["block", "link-to", ["templates"], [], 1, null, ["loc", [null, [9, 14], [9, 135]]]]],
              locals: [],
              templates: [child0, child1]
            };
          })();
          var child1 = (function () {
            var child0 = (function () {
              return {
                meta: {
                  "revision": "Ember@2.8.0",
                  "loc": {
                    "source": null,
                    "start": {
                      "line": 13,
                      "column": 14
                    },
                    "end": {
                      "line": 13,
                      "column": 117
                    }
                  },
                  "moduleName": "cornerstone/components/global/launch-screen/template.hbs"
                },
                isEmpty: false,
                arity: 0,
                cachedFragment: null,
                hasRendered: false,
                buildFragment: function buildFragment(dom) {
                  var el0 = dom.createDocumentFragment();
                  var el1 = dom.createElement("span");
                  var el2 = dom.createComment("");
                  dom.appendChild(el1, el2);
                  var el2 = dom.createComment("");
                  dom.appendChild(el1, el2);
                  dom.appendChild(el0, el1);
                  return el0;
                },
                buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                  var element2 = dom.childAt(fragment, [0]);
                  var morphs = new Array(2);
                  morphs[0] = dom.createMorphAt(element2, 0, 0);
                  morphs[1] = dom.createMorphAt(element2, 1, 1);
                  return morphs;
                },
                statements: [["inline", "cs-icon", ["interface/global-nav-headers"], [], ["loc", [null, [13, 43], [13, 85]]], 0, 0], ["inline", "t", ["app.headers.title"], [], ["loc", [null, [13, 85], [13, 110]]], 0, 0]],
                locals: [],
                templates: []
              };
            })();
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 12,
                    "column": 8
                  },
                  "end": {
                    "line": 14,
                    "column": 8
                  }
                },
                "moduleName": "cornerstone/components/global/launch-screen/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("          ");
                dom.appendChild(el0, el1);
                var el1 = dom.createElement("li");
                var el2 = dom.createComment("");
                dom.appendChild(el1, el2);
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1]), 0, 0);
                return morphs;
              },
              statements: [["block", "link-to", ["headers"], [], 0, null, ["loc", [null, [13, 14], [13, 129]]]]],
              locals: [],
              templates: [child0]
            };
          })();
          var child2 = (function () {
            var child0 = (function () {
              return {
                meta: {
                  "revision": "Ember@2.8.0",
                  "loc": {
                    "source": null,
                    "start": {
                      "line": 17,
                      "column": 14
                    },
                    "end": {
                      "line": 17,
                      "column": 115
                    }
                  },
                  "moduleName": "cornerstone/components/global/launch-screen/template.hbs"
                },
                isEmpty: false,
                arity: 0,
                cachedFragment: null,
                hasRendered: false,
                buildFragment: function buildFragment(dom) {
                  var el0 = dom.createDocumentFragment();
                  var el1 = dom.createElement("span");
                  var el2 = dom.createComment("");
                  dom.appendChild(el1, el2);
                  var el2 = dom.createComment("");
                  dom.appendChild(el1, el2);
                  dom.appendChild(el0, el1);
                  return el0;
                },
                buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                  var element1 = dom.childAt(fragment, [0]);
                  var morphs = new Array(2);
                  morphs[0] = dom.createMorphAt(element1, 0, 0);
                  morphs[1] = dom.createMorphAt(element1, 1, 1);
                  return morphs;
                },
                statements: [["inline", "cs-icon", ["interface/global-nav-pages"], [], ["loc", [null, [17, 43], [17, 83]]], 0, 0], ["inline", "t", ["app.builder.title"], [], ["loc", [null, [17, 83], [17, 108]]], 0, 0]],
                locals: [],
                templates: []
              };
            })();
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 16,
                    "column": 8
                  },
                  "end": {
                    "line": 18,
                    "column": 8
                  }
                },
                "moduleName": "cornerstone/components/global/launch-screen/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("          ");
                dom.appendChild(el0, el1);
                var el1 = dom.createElement("li");
                var el2 = dom.createComment("");
                dom.appendChild(el1, el2);
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1]), 0, 0);
                return morphs;
              },
              statements: [["block", "link-to", ["content"], [], 0, null, ["loc", [null, [17, 14], [17, 127]]]]],
              locals: [],
              templates: [child0]
            };
          })();
          var child3 = (function () {
            var child0 = (function () {
              return {
                meta: {
                  "revision": "Ember@2.8.0",
                  "loc": {
                    "source": null,
                    "start": {
                      "line": 21,
                      "column": 14
                    },
                    "end": {
                      "line": 21,
                      "column": 117
                    }
                  },
                  "moduleName": "cornerstone/components/global/launch-screen/template.hbs"
                },
                isEmpty: false,
                arity: 0,
                cachedFragment: null,
                hasRendered: false,
                buildFragment: function buildFragment(dom) {
                  var el0 = dom.createDocumentFragment();
                  var el1 = dom.createElement("span");
                  var el2 = dom.createComment("");
                  dom.appendChild(el1, el2);
                  var el2 = dom.createComment("");
                  dom.appendChild(el1, el2);
                  dom.appendChild(el0, el1);
                  return el0;
                },
                buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                  var element0 = dom.childAt(fragment, [0]);
                  var morphs = new Array(2);
                  morphs[0] = dom.createMorphAt(element0, 0, 0);
                  morphs[1] = dom.createMorphAt(element0, 1, 1);
                  return morphs;
                },
                statements: [["inline", "cs-icon", ["interface/global-nav-footers"], [], ["loc", [null, [21, 43], [21, 85]]], 0, 0], ["inline", "t", ["app.footers.title"], [], ["loc", [null, [21, 85], [21, 110]]], 0, 0]],
                locals: [],
                templates: []
              };
            })();
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 20,
                    "column": 8
                  },
                  "end": {
                    "line": 22,
                    "column": 8
                  }
                },
                "moduleName": "cornerstone/components/global/launch-screen/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("          ");
                dom.appendChild(el0, el1);
                var el1 = dom.createElement("li");
                var el2 = dom.createComment("");
                dom.appendChild(el1, el2);
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1]), 0, 0);
                return morphs;
              },
              statements: [["block", "link-to", ["footers"], [], 0, null, ["loc", [null, [21, 14], [21, 129]]]]],
              locals: [],
              templates: [child0]
            };
          })();
          var child4 = (function () {
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 27,
                    "column": 14
                  },
                  "end": {
                    "line": 29,
                    "column": 14
                  }
                },
                "moduleName": "cornerstone/components/global/launch-screen/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("                ");
                dom.appendChild(el0, el1);
                var el1 = dom.createElement("span");
                var el2 = dom.createComment("");
                dom.appendChild(el1, el2);
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1]), 0, 0);
                return morphs;
              },
              statements: [["inline", "t", ["app.exit-to-dashboard"], [], ["loc", [null, [28, 22], [28, 51]]], 0, 0]],
              locals: [],
              templates: []
            };
          })();
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 4,
                  "column": 4
                },
                "end": {
                  "line": 35,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/global/launch-screen/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createElement("ul");
              dom.setAttribute(el1, "class", "cs-welcome-nav");
              var el2 = dom.createTextNode("\n\n");
              dom.appendChild(el1, el2);
              var el2 = dom.createComment("");
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n");
              dom.appendChild(el1, el2);
              var el2 = dom.createComment("");
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n");
              dom.appendChild(el1, el2);
              var el2 = dom.createComment("");
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n");
              dom.appendChild(el1, el2);
              var el2 = dom.createComment("");
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("li");
              var el3 = dom.createTextNode("\n          ");
              dom.appendChild(el2, el3);
              var el3 = dom.createElement("ul");
              var el4 = dom.createTextNode("\n            ");
              dom.appendChild(el3, el4);
              var el4 = dom.createElement("li");
              var el5 = dom.createTextNode("\n");
              dom.appendChild(el4, el5);
              var el5 = dom.createComment("");
              dom.appendChild(el4, el5);
              var el5 = dom.createTextNode("            ");
              dom.appendChild(el4, el5);
              dom.appendChild(el3, el4);
              var el4 = dom.createTextNode("\n          ");
              dom.appendChild(el3, el4);
              dom.appendChild(el2, el3);
              var el3 = dom.createTextNode("\n        ");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n\n      ");
              dom.appendChild(el1, el2);
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var element5 = dom.childAt(fragment, [1]);
              var morphs = new Array(5);
              morphs[0] = dom.createMorphAt(element5, 1, 1);
              morphs[1] = dom.createMorphAt(element5, 3, 3);
              morphs[2] = dom.createMorphAt(element5, 5, 5);
              morphs[3] = dom.createMorphAt(element5, 7, 7);
              morphs[4] = dom.createMorphAt(dom.childAt(element5, [9, 1, 1]), 1, 1);
              return morphs;
            },
            statements: [["block", "if", [["get", "currentUser.canManageOptions", ["loc", [null, [7, 14], [7, 42]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [7, 8], [10, 15]]]], ["block", "if", [["get", "currentUser.canUseRegions", ["loc", [null, [12, 14], [12, 39]]], 0, 0, 0, 0]], [], 1, null, ["loc", [null, [12, 8], [14, 15]]]], ["block", "if", [["get", "currentUser.canUseBuilder", ["loc", [null, [16, 14], [16, 39]]], 0, 0, 0, 0]], [], 2, null, ["loc", [null, [16, 8], [18, 15]]]], ["block", "if", [["get", "currentUser.canUseRegions", ["loc", [null, [20, 14], [20, 39]]], 0, 0, 0, 0]], [], 3, null, ["loc", [null, [20, 8], [22, 15]]]], ["block", "common/link-out", [], ["href", ["subexpr", "@mut", [["get", "ui.dashboardUrl", ["loc", [null, [27, 38], [27, 53]]], 0, 0, 0, 0]], [], [], 0, 0]], 4, null, ["loc", [null, [27, 14], [29, 34]]]]],
            locals: [],
            templates: [child0, child1, child2, child3, child4]
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 3,
                "column": 2
              },
              "end": {
                "line": 36,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/global/launch-screen/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
            dom.insertBoundary(fragment, 0);
            dom.insertBoundary(fragment, null);
            return morphs;
          },
          statements: [["block", "common/welcome-message", [], ["title", ["subexpr", "t", ["app.welcome-app"], [], ["loc", [null, [4, 36], [4, 57]]], 0, 0]], 0, null, ["loc", [null, [4, 4], [35, 31]]]]],
          locals: [],
          templates: [child0]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 37,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/global/launch-screen/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "global/cs-canvas", [], [], 0, null, ["loc", [null, [3, 2], [36, 23]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 38,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/global/launch-screen/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["block", "global/cs-window", [], ["screen", "index"], 0, null, ["loc", [null, [1, 0], [37, 21]]]]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/global/notification-item/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    classNames: ['cs-notification-item'],
    classNameBindings: ['typeClass', 'active:cs-active', 'exiting:cs-fade'],

    active: false,
    title: _ember['default'].computed.readOnly('flash.title'),
    message: _ember['default'].computed.readOnly('flash.message'),
    exiting: _ember['default'].computed.readOnly('flash.exiting'),
    canClose: _ember['default'].computed.readOnly('flash.canClose'),

    typeClass: _ember['default'].computed('flash.type', function () {

      var flashType = _ember['default'].String.dasherize(this.getWithDefault('flash.type', 'notice'));

      return 'cs-notification-item-' + flashType;
    }),

    didInsertElement: function didInsertElement() {
      var self = this;
      this.set('readiness', _ember['default'].run.next(this, function () {
        self.set('active', true);
      }));
    },

    willDestroy: function willDestroy() {
      this._super();
      this.teardown();
      _ember['default'].run.cancel(this.get('readiness'));
    },

    teardown: function teardown() {
      var flash = this.getWithDefault('flash', false);

      if (flash) {
        flash.destroyMessage();
      }
    },

    actions: {
      close: function close() {
        this.teardown();
      }
    }

  });
});
define("cornerstone/components/global/notification-item/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 3,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/global/notification-item/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "yield", [["get", "this", ["loc", [null, [2, 10], [2, 14]]], 0, 0, 0, 0], ["get", "flash", ["loc", [null, [2, 15], [2, 20]]], 0, 0, 0, 0]], [], ["loc", [null, [2, 2], [2, 22]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 4,
                "column": 2
              },
              "end": {
                "line": 6,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/global/notification-item/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("    ");
            dom.appendChild(el0, el1);
            var el1 = dom.createElement("div");
            dom.setAttribute(el1, "class", "cs-notification-item-close");
            var el2 = dom.createTextNode("×");
            dom.appendChild(el1, el2);
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var element0 = dom.childAt(fragment, [1]);
            var morphs = new Array(1);
            morphs[0] = dom.createElementMorph(element0);
            return morphs;
          },
          statements: [["element", "action", ["close"], [], ["loc", [null, [5, 43], [5, 61]]], 0, 0]],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 3,
              "column": 0
            },
            "end": {
              "line": 9,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/global/notification-item/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("div");
          dom.setAttribute(el1, "class", "cs-notification-item-title");
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("div");
          dom.setAttribute(el1, "class", "cs-notification-item-message");
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(3);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          morphs[1] = dom.createMorphAt(dom.childAt(fragment, [2]), 0, 0);
          morphs[2] = dom.createMorphAt(dom.childAt(fragment, [4]), 0, 0);
          dom.insertBoundary(fragment, 0);
          return morphs;
        },
        statements: [["block", "if", [["get", "canClose", ["loc", [null, [4, 8], [4, 16]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [4, 2], [6, 9]]]], ["content", "title", ["loc", [null, [7, 42], [7, 51]]], 0, 0, 0, 0], ["content", "flash.message", ["loc", [null, [8, 44], [8, 61]]], 0, 0, 0, 0]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 9,
            "column": 7
          }
        },
        "moduleName": "cornerstone/components/global/notification-item/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["block", "if", [["get", "hasBlock", ["loc", [null, [1, 6], [1, 14]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [1, 0], [9, 7]]]]],
      locals: [],
      templates: [child0, child1]
    };
  })());
});
define('cornerstone/components/global/notification-queue/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    flashMessages: _ember['default'].inject.service(),
    classNames: ['cs-notification-queue'],

    didRender: function didRender() {
      var scrollbarWidth = this.get('ui.scrollBarWidth');
      if (scrollbarWidth > 0) {
        this.$().css({ right: scrollbarWidth });
      }
    }
  });
});
define("cornerstone/components/global/notification-queue/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 3,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/global/notification-queue/template.hbs"
        },
        isEmpty: false,
        arity: 1,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "global/notification-item", [], ["flash", ["subexpr", "@mut", [["get", "flash", ["loc", [null, [2, 35], [2, 40]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [2, 2], [2, 42]]], 0, 0]],
        locals: ["flash"],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 3,
            "column": 9
          }
        },
        "moduleName": "cornerstone/components/global/notification-queue/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["block", "each", [["get", "flashMessages.queue", ["loc", [null, [1, 8], [1, 27]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [1, 0], [3, 9]]]]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/global/progress-bar/component', ['exports', 'ember', 'npm:nprogress'], function (exports, _ember, _npmNprogress) {
  exports['default'] = _ember['default'].Component.extend({

    classNames: ['cs-progress-bar-container'],
    saving: false,
    classNameBindings: ['saving:cs-saving', 'transitioning:cs-transitioning'],
    transitioning: false,
    ready: false,

    uiUpdate: _ember['default'].observer('saving', 'transitioning', function () {

      var start = false;

      if (this.get('saving')) {
        start = true;
      }

      if (this.get('transitioning')) {
        start = true;
      }

      _ember['default'].run.scheduleOnce('afterRender', start ? _npmNprogress['default'].start : _npmNprogress['default'].done);
    }),

    didInsertElement: function didInsertElement() {
      _npmNprogress['default'].configure({
        showSpinner: false,
        speed: 850,
        minimum: 0.925,
        parent: '.cs-progress-bar-container',
        barSelector: '.cs-progress-bar',
        template: '<div class="cs-progress-bar"><div class="cs-progress-bar-peg"></div></div></div>'
      });
    }

  });
});
define("cornerstone/components/global/progress-bar/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 2,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/global/progress-bar/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["content", "yield", ["loc", [null, [1, 0], [1, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
define('cornerstone/components/global/top-level/component', ['exports', 'ember', 'jquery'], function (exports, _ember, _jquery) {
  exports['default'] = _ember['default'].Component.extend({
    browser: _ember['default'].inject.service(),
    ui: _ember['default'].inject.service(),
    classNames: ['cs-app'],
    classNameBindings: ['routeNameClass', 'browser.browserClass', 'ui.transitioning:cs-transitioning'],

    routeNameClass: _ember['default'].computed('ui.currentRouteName', function () {
      var routeClass = this.getWithDefault('ui.currentRouteName', 'unknown').replace(new RegExp(/\./, 'g'), '-');
      return 'cs-route-' + routeClass;
    }),

    didInsertElement: function didInsertElement() {
      authCheck();
      this.set('ui.topLevelEl', this.get('element'));
    }
  });

  function authCheck() {

    var wrap, next;

    function show() {
      var parent = (0, _jquery['default'])('#wp-auth-check'),
          form = (0, _jquery['default'])('#wp-auth-check-form'),
          noframe = wrap.find('.wp-auth-fallback-expired'),
          frame,
          loaded = false;

      if (form.length) {
        // Add unload confirmation to counter (frame-busting) JS redirects
        (0, _jquery['default'])(window).on('beforeunload.wp-auth-check', function (e) {
          e.originalEvent.returnValue = 'Your session has expired. You can log in again from this page or go to the login page.';
        });

        frame = (0, _jquery['default'])('<iframe id="wp-auth-check-frame" frameborder="0">').attr('title', noframe.text());
        frame.on('load', function () {
          var height, body;

          loaded = true;
          // Remove the spinner to avoid unnecessary CPU/GPU usage.
          form.removeClass('loading');

          try {
            body = (0, _jquery['default'])(this).contents().find('body');
            height = body.height();
          } catch (e) {
            wrap.addClass('fallback');
            parent.css('max-height', '');
            form.remove();
            noframe.focus();
            return;
          }

          if (height) {
            if (body && body.hasClass('interim-login-success')) {
              hide();
            } else {
              parent.css('max-height', height + 40 + 'px');
            }
          } else if (!body || !body.length) {
            // Catch "silent" iframe origin exceptions in WebKit after another page is loaded in the iframe
            wrap.addClass('fallback');
            parent.css('max-height', '');
            form.remove();
            noframe.focus();
          }
        }).attr('src', form.data('src'));

        form.append(frame);
      }

      (0, _jquery['default'])('body').addClass('modal-open');
      wrap.removeClass('hidden');

      if (frame) {
        frame.focus();
        // WebKit doesn't throw an error if the iframe fails to load because of "X-Frame-Options: DENY" header.
        // Wait for 10 sec. and switch to the fallback text.
        setTimeout(function () {
          if (!loaded) {
            wrap.addClass('fallback');
            form.remove();
            noframe.focus();
          }
        }, 10000);
      } else {
        noframe.focus();
      }
    }

    function hide() {
      (0, _jquery['default'])(window).off('beforeunload.wp-auth-check');
      (0, _jquery['default'])(document).off('heartbeat-tick.wp-auth-check');
      window.wp.heartbeat.connectNow();

      wrap.fadeOut(200, function () {
        wrap.addClass('hidden').css('display', '');
        (0, _jquery['default'])('#wp-auth-check-frame').remove();
        (0, _jquery['default'])('body').removeClass('modal-open');
      });
    }

    function schedule() {
      var interval = 180; // Check auth every 3 minutes
      next = new Date().getTime() + interval * 1000;
    }

    (0, _jquery['default'])(document).on('heartbeat-tick.wp-auth-check', function (e, data) {
      if ('wp-auth-check' in data) {
        schedule();
        if (!data['wp-auth-check'] && wrap.hasClass('hidden')) {
          show();
        } else if (data['wp-auth-check'] && !wrap.hasClass('hidden')) {
          hide();
        }
      }
    }).on('heartbeat-send.wp-auth-check', function (e, data) {

      if (new Date().getTime() > next) {
        data['wp-auth-check'] = true;
      }
    }).ready(function () {
      schedule();
      wrap = (0, _jquery['default'])('#wp-auth-check-wrap');
      wrap.find('.wp-auth-check-close').on('click', function () {
        hide();
      });
    });
  }
});
define("cornerstone/components/global/top-level/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 2,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/global/top-level/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["content", "yield", ["loc", [null, [1, 0], [1, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
define('cornerstone/components/global/unauthorized-screen/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({});
});
define("cornerstone/components/global/unauthorized-screen/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 3,
            "column": 9
          }
        },
        "moduleName": "cornerstone/components/global/unauthorized-screen/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("h3");
        dom.setAttribute(el1, "class", "cs-unauthorized");
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("iframe");
        dom.setAttribute(el1, "width", "420");
        dom.setAttribute(el1, "height", "315");
        dom.setAttribute(el1, "src", "https://www.youtube.com/v/06A5zpyJG9c?version=3&autoplay=1&loop=1&playlist=06A5zpyJG9c");
        dom.setAttribute(el1, "frameborder", "0");
        dom.setAttribute(el1, "loop", "1");
        dom.setAttribute(el1, "allowfullscreen", "");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(2);
        morphs[0] = dom.createMorphAt(dom.childAt(fragment, [0]), 0, 0);
        morphs[1] = dom.createMorphAt(fragment, 4, 4, contextualElement);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["inline", "t", ["app.unauthorized"], [], ["loc", [null, [1, 28], [1, 52]]], 0, 0], ["content", "yield", ["loc", [null, [3, 0], [3, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
define('cornerstone/components/options/launch-footers/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({

    service: _ember['default'].inject.service('options'),
    radio: _ember['default'].inject.service('global/radio'),

    store: _ember['default'].inject.service(),
    classNames: ['cs-workspace-intro'],
    classicMode: _ember['default'].computed.alias('service.virtualValues.classicFooters'),

    actions: {
      switchBack: function switchBack() {
        var _this = this;

        this.get('ui').confirm({
          message: this.get('i18n').t('app.options.confirm-footer-switch-back'),
          accept: function accept() {

            var assignments = _this.get('store').peekRecord('option', 'cornerstone_footer_assignments');
            var value = assignments.get('value');
            delete value.global;

            var ui = _this.get('ui');
            ui.beginSaveProgress();
            assignments.set('value', value);
            assignments.save().then(function () {
              ui.notify('Footer Assignment removed!', 'success');
              ui.endSaveProgress();
              _this.set('classicMode', true);
              _this.get('radio').trigger('option.value.changed');
            });
          },
          acceptClass: 'sad',
          acceptBtn: this.get('i18n').t('app.confirm-yep'),
          declineBtn: this.get('i18n').t('app.confirm-nope')
        });
      }
    }
  });
});
define("cornerstone/components/options/launch-footers/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 3,
                "column": 4
              },
              "end": {
                "line": 6,
                "column": 4
              }
            },
            "moduleName": "cornerstone/components/options/launch-footers/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("      ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n      ");
            dom.appendChild(el0, el1);
            var el1 = dom.createElement("span");
            var el2 = dom.createComment("");
            dom.appendChild(el1, el2);
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(2);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            morphs[1] = dom.createMorphAt(dom.childAt(fragment, [3]), 0, 0);
            return morphs;
          },
          statements: [["inline", "fa-icon", ["external-link"], [], ["loc", [null, [4, 6], [4, 33]]], 0, 0], ["inline", "t", ["app.options.launch-footers"], [], ["loc", [null, [5, 12], [5, 46]]], 0, 0]],
          locals: [],
          templates: []
        };
      })();
      var child1 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 8,
                "column": 2
              },
              "end": {
                "line": 11,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/options/launch-footers/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("    ");
            dom.appendChild(el0, el1);
            var el1 = dom.createElement("p");
            var el2 = dom.createTextNode("You are currently using ");
            dom.appendChild(el1, el2);
            var el2 = dom.createElement("strong");
            var el3 = dom.createTextNode("Original Footers");
            dom.appendChild(el2, el3);
            dom.appendChild(el1, el2);
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n    ");
            dom.appendChild(el0, el1);
            var el1 = dom.createElement("p");
            var el2 = dom.createTextNode("Assign a global header in the builder to use ");
            dom.appendChild(el1, el2);
            var el2 = dom.createElement("strong");
            var el3 = dom.createTextNode("Pro Footers");
            dom.appendChild(el2, el3);
            dom.appendChild(el1, el2);
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes() {
            return [];
          },
          statements: [],
          locals: [],
          templates: []
        };
      })();
      var child2 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 11,
                "column": 2
              },
              "end": {
                "line": 14,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/options/launch-footers/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("    ");
            dom.appendChild(el0, el1);
            var el1 = dom.createElement("p");
            var el2 = dom.createTextNode("You are currently using ");
            dom.appendChild(el1, el2);
            var el2 = dom.createElement("strong");
            var el3 = dom.createTextNode("Pro Footers");
            dom.appendChild(el2, el3);
            dom.appendChild(el1, el2);
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n    ");
            dom.appendChild(el0, el1);
            var el1 = dom.createElement("a");
            var el2 = dom.createTextNode("Switch back to ");
            dom.appendChild(el1, el2);
            var el2 = dom.createElement("strong");
            var el3 = dom.createTextNode("Original Footers");
            dom.appendChild(el2, el3);
            dom.appendChild(el1, el2);
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var element0 = dom.childAt(fragment, [3]);
            var morphs = new Array(1);
            morphs[0] = dom.createElementMorph(element0);
            return morphs;
          },
          statements: [["element", "action", ["switchBack"], [], ["loc", [null, [13, 7], [13, 30]]], 0, 0]],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 15,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/options/launch-footers/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("div");
          dom.setAttribute(el1, "class", "cs-workspace-actions");
          var el2 = dom.createTextNode("\n");
          dom.appendChild(el1, el2);
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("  ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(2);
          morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1]), 1, 1);
          morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "link-to", ["footers"], [], 0, null, ["loc", [null, [3, 4], [6, 16]]]], ["block", "if", [["get", "classicMode", ["loc", [null, [8, 8], [8, 19]]], 0, 0, 0, 0]], [], 1, 2, ["loc", [null, [8, 2], [14, 9]]]]],
        locals: [],
        templates: [child0, child1, child2]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 16,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/options/launch-footers/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["block", "if", [["get", "ui.isPro", ["loc", [null, [1, 6], [1, 14]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [1, 0], [15, 7]]]]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/options/launch-headers/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({

    service: _ember['default'].inject.service('options'),
    radio: _ember['default'].inject.service('global/radio'),

    store: _ember['default'].inject.service(),
    classNames: ['cs-workspace-intro'],
    classicMode: _ember['default'].computed.alias('service.virtualValues.classicHeaders'),

    actions: {
      switchBack: function switchBack() {
        var _this = this;

        this.get('ui').confirm({
          message: this.get('i18n').t('app.options.confirm-header-switch-back'),
          accept: function accept() {

            var assignments = _this.get('store').peekRecord('option', 'cornerstone_header_assignments');
            var value = assignments.get('value');
            delete value.global;

            var ui = _this.get('ui');
            ui.beginSaveProgress();
            assignments.set('value', value);
            assignments.save().then(function () {
              ui.notify('Header Assignment removed!', 'success');
              ui.endSaveProgress();
              _this.set('classicMode', true);
              _this.get('radio').trigger('option.value.changed');
            });
          },
          acceptClass: 'sad',
          acceptBtn: this.get('i18n').t('app.confirm-yep'),
          declineBtn: this.get('i18n').t('app.confirm-nope')
        });
      }
    }
  });
});
define("cornerstone/components/options/launch-headers/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 3,
                "column": 4
              },
              "end": {
                "line": 6,
                "column": 4
              }
            },
            "moduleName": "cornerstone/components/options/launch-headers/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("      ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n      ");
            dom.appendChild(el0, el1);
            var el1 = dom.createElement("span");
            var el2 = dom.createComment("");
            dom.appendChild(el1, el2);
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(2);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            morphs[1] = dom.createMorphAt(dom.childAt(fragment, [3]), 0, 0);
            return morphs;
          },
          statements: [["inline", "fa-icon", ["external-link"], [], ["loc", [null, [4, 6], [4, 33]]], 0, 0], ["inline", "t", ["app.options.launch-headers"], [], ["loc", [null, [5, 12], [5, 46]]], 0, 0]],
          locals: [],
          templates: []
        };
      })();
      var child1 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 8,
                "column": 2
              },
              "end": {
                "line": 11,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/options/launch-headers/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("    ");
            dom.appendChild(el0, el1);
            var el1 = dom.createElement("p");
            var el2 = dom.createTextNode("You are currently using ");
            dom.appendChild(el1, el2);
            var el2 = dom.createElement("strong");
            var el3 = dom.createTextNode("Original Headers");
            dom.appendChild(el2, el3);
            dom.appendChild(el1, el2);
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n    ");
            dom.appendChild(el0, el1);
            var el1 = dom.createElement("p");
            var el2 = dom.createTextNode("Assign a global header in the builder to use ");
            dom.appendChild(el1, el2);
            var el2 = dom.createElement("strong");
            var el3 = dom.createTextNode("Pro Headers");
            dom.appendChild(el2, el3);
            dom.appendChild(el1, el2);
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes() {
            return [];
          },
          statements: [],
          locals: [],
          templates: []
        };
      })();
      var child2 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 11,
                "column": 2
              },
              "end": {
                "line": 14,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/options/launch-headers/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("    ");
            dom.appendChild(el0, el1);
            var el1 = dom.createElement("p");
            var el2 = dom.createTextNode("You are currently using ");
            dom.appendChild(el1, el2);
            var el2 = dom.createElement("strong");
            var el3 = dom.createTextNode("Pro Headers");
            dom.appendChild(el2, el3);
            dom.appendChild(el1, el2);
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n    ");
            dom.appendChild(el0, el1);
            var el1 = dom.createElement("a");
            var el2 = dom.createTextNode("Switch back to ");
            dom.appendChild(el1, el2);
            var el2 = dom.createElement("strong");
            var el3 = dom.createTextNode("Original Headers");
            dom.appendChild(el2, el3);
            dom.appendChild(el1, el2);
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var element0 = dom.childAt(fragment, [3]);
            var morphs = new Array(1);
            morphs[0] = dom.createElementMorph(element0);
            return morphs;
          },
          statements: [["element", "action", ["switchBack"], [], ["loc", [null, [13, 7], [13, 30]]], 0, 0]],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 15,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/options/launch-headers/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("div");
          dom.setAttribute(el1, "class", "cs-workspace-actions");
          var el2 = dom.createTextNode("\n");
          dom.appendChild(el1, el2);
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("  ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(2);
          morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1]), 1, 1);
          morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "link-to", ["headers"], [], 0, null, ["loc", [null, [3, 4], [6, 16]]]], ["block", "if", [["get", "classicMode", ["loc", [null, [8, 8], [8, 19]]], 0, 0, 0, 0]], [], 1, 2, ["loc", [null, [8, 2], [14, 9]]]]],
        locals: [],
        templates: [child0, child1, child2]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 16,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/options/launch-headers/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["block", "if", [["get", "ui.isPro", ["loc", [null, [1, 6], [1, 14]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [1, 0], [15, 7]]]]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/options/option-search-result/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({

    isVisible: _ember['default'].computed.alias('control.isVisible'),

    classNames: ['cs-workspace-sections-search-result'],

    nav: _ember['default'].computed('control.section', function () {

      var section = this.get('control.section');
      if (!section) {
        return false;
      }

      var parent = section.get('parent');
      var nav = {
        id: false,
        route: 'options.section',
        label: '&nbsp'
      };

      if (section.get('panel')) {
        nav.id = section.get('id');
        nav.label = section.get('title');
      } else {
        nav.id = parent.get('id');
        nav.sub = section.get('id');
        var labelItems = [parent.get('title'), section.get('title')];

        if (this.get('ui.isRTL')) {
          labelItems.reverse();
          nav.label = labelItems.join(' &larr; ');
        } else {
          nav.label = labelItems.join(' &rarr; ');
        }
      }

      if (!nav.id || 'root' === nav.id) {
        return false;
      }

      return nav;
    }),

    actions: {
      targetSubHeading: function targetSubHeading(subSection) {
        this.get('ui').oneTimeValue('options/search-goto-sub-heading', subSection);
      }
    }

  });
});
define("cornerstone/components/options/option-search-result/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 2,
                "column": 11
              },
              "end": {
                "line": 2,
                "column": 145
              }
            },
            "moduleName": "cornerstone/components/options/option-search-result/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createUnsafeMorphAt(fragment, 0, 0, contextualElement);
            dom.insertBoundary(fragment, 0);
            dom.insertBoundary(fragment, null);
            return morphs;
          },
          statements: [["content", "nav.label", ["loc", [null, [2, 130], [2, 145]]], 0, 0, 0, 0]],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 2,
              "column": 157
            }
          },
          "moduleName": "cornerstone/components/options/option-search-result/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "link-to", [["get", "nav.route", ["loc", [null, [2, 22], [2, 31]]], 0, 0, 0, 0], ["get", "nav.id", ["loc", [null, [2, 32], [2, 38]]], 0, 0, 0, 0]], ["class", "cs-workspace-section-sub-heading", "invokeAction", ["subexpr", "action", ["targetSubHeading", ["get", "nav.sub", ["loc", [null, [2, 120], [2, 127]]], 0, 0, 0, 0]], [], ["loc", [null, [2, 93], [2, 128]]], 0, 0]], 0, null, ["loc", [null, [2, 11], [2, 157]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    var child1 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 157
            },
            "end": {
              "line": 2,
              "column": 171
            }
          },
          "moduleName": "cornerstone/components/options/option-search-result/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode(" ");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes() {
          return [];
        },
        statements: [],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 3,
            "column": 115
          }
        },
        "moduleName": "cornerstone/components/options/option-search-result/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 4, 4, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["content", "yield", ["loc", [null, [1, 0], [1, 9]]], 0, 0, 0, 0], ["block", "if", [["get", "nav", ["loc", [null, [2, 6], [2, 9]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [2, 0], [2, 178]]]], ["inline", "component", [["subexpr", "locate-component", [["subexpr", "concat", ["controls/control-", ["get", "control.type", ["loc", [null, [3, 58], [3, 70]]], 0, 0, 0, 0]], [], ["loc", [null, [3, 30], [3, 72]]], 0, 0], "controls/control-base"], [], ["loc", [null, [3, 12], [3, 97]]], 0, 0]], ["control", ["subexpr", "@mut", [["get", "control", ["loc", [null, [3, 106], [3, 113]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [3, 0], [3, 115]]], 0, 0]],
      locals: [],
      templates: [child0, child1]
    };
  })());
});
define('cornerstone/components/options/option-section/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({

    classNames: ['cs-workspace-sections'],
    classNameBindings: ['name'],
    isVisible: _ember['default'].computed.alias('section.isVisible'),

    name: _ember['default'].computed.alias('section.id'),
    title: _ember['default'].computed.alias('section.title'),
    descriptionComponentPath: _ember['default'].computed('description', function () {
      var description = this.getWithDefault('description', '');
      if (0 === description.indexOf('component:')) {
        var parts = description.split(':');
        return parts[1];
      }
      return false;
    }),

    description: _ember['default'].computed.alias('section.description'),

    didInsertElement: function didInsertElement() {
      var openTo = this.get('openTo');
      if (openTo) {
        _ember['default'].run.scheduleOnce('afterRender', (function () {
          this.set('scrollTo', {
            selector: '.cs-workspace-sections.' + openTo,
            offset: 1
          });
        }).bind(this));
      }
    },

    isRoot: _ember['default'].computed('name', function () {
      return 'root' === this.get('name');
    }),

    breadcrumbs: _ember['default'].computed('section.parent', function () {

      var breadcrumbs = [];
      var parent = this.get('section.parent');

      while (parent && 'root' !== parent.get('id')) {

        breadcrumbs.push({
          route: 'options.section',
          id: parent.get('id'),
          label: parent.get('title')
        });

        parent = parent.get('parent');
      }

      breadcrumbs.reverse();
      breadcrumbs.unshift({
        route: 'options',
        label: this.get('i18n').t('app.options.title')
      });
      // breadcrumbs.push({ label: this.get('title') });

      return breadcrumbs;
    }),

    backUp: _ember['default'].computed('breadcrumbs', function () {
      var breadcrumbs = this.get('breadcrumbs');
      return breadcrumbs.objectAt(breadcrumbs.length - 1); // Set to -2 to restore THIS as a breadcrumb
    })

  });
});
define("cornerstone/components/options/option-section/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          var child0 = (function () {
            var child0 = (function () {
              return {
                meta: {
                  "revision": "Ember@2.8.0",
                  "loc": {
                    "source": null,
                    "start": {
                      "line": 6,
                      "column": 10
                    },
                    "end": {
                      "line": 6,
                      "column": 91
                    }
                  },
                  "moduleName": "cornerstone/components/options/option-section/template.hbs"
                },
                isEmpty: false,
                arity: 0,
                cachedFragment: null,
                hasRendered: false,
                buildFragment: function buildFragment(dom) {
                  var el0 = dom.createDocumentFragment();
                  var el1 = dom.createTextNode("◀");
                  dom.appendChild(el0, el1);
                  return el0;
                },
                buildRenderNodes: function buildRenderNodes() {
                  return [];
                },
                statements: [],
                locals: [],
                templates: []
              };
            })();
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 5,
                    "column": 8
                  },
                  "end": {
                    "line": 7,
                    "column": 8
                  }
                },
                "moduleName": "cornerstone/components/options/option-section/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("          ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                return morphs;
              },
              statements: [["block", "link-to", [["get", "backUp.route", ["loc", [null, [6, 21], [6, 33]]], 0, 0, 0, 0], ["get", "backUp.id", ["loc", [null, [6, 34], [6, 43]]], 0, 0, 0, 0]], ["class", "cs-workspace-section-nav-back"], 0, null, ["loc", [null, [6, 10], [6, 103]]]]],
              locals: [],
              templates: [child0]
            };
          })();
          var child1 = (function () {
            var child0 = (function () {
              return {
                meta: {
                  "revision": "Ember@2.8.0",
                  "loc": {
                    "source": null,
                    "start": {
                      "line": 8,
                      "column": 10
                    },
                    "end": {
                      "line": 8,
                      "column": 81
                    }
                  },
                  "moduleName": "cornerstone/components/options/option-section/template.hbs"
                },
                isEmpty: false,
                arity: 0,
                cachedFragment: null,
                hasRendered: false,
                buildFragment: function buildFragment(dom) {
                  var el0 = dom.createDocumentFragment();
                  var el1 = dom.createTextNode("◀");
                  dom.appendChild(el0, el1);
                  return el0;
                },
                buildRenderNodes: function buildRenderNodes() {
                  return [];
                },
                statements: [],
                locals: [],
                templates: []
              };
            })();
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 7,
                    "column": 8
                  },
                  "end": {
                    "line": 9,
                    "column": 8
                  }
                },
                "moduleName": "cornerstone/components/options/option-section/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("          ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                return morphs;
              },
              statements: [["block", "link-to", [["get", "backUp.route", ["loc", [null, [8, 21], [8, 33]]], 0, 0, 0, 0]], ["class", "cs-workspace-section-nav-back"], 0, null, ["loc", [null, [8, 10], [8, 93]]]]],
              locals: [],
              templates: [child0]
            };
          })();
          var child2 = (function () {
            var child0 = (function () {
              var child0 = (function () {
                var child0 = (function () {
                  return {
                    meta: {
                      "revision": "Ember@2.8.0",
                      "loc": {
                        "source": null,
                        "start": {
                          "line": 12,
                          "column": 98
                        },
                        "end": {
                          "line": 12,
                          "column": 162
                        }
                      },
                      "moduleName": "cornerstone/components/options/option-section/template.hbs"
                    },
                    isEmpty: false,
                    arity: 0,
                    cachedFragment: null,
                    hasRendered: false,
                    buildFragment: function buildFragment(dom) {
                      var el0 = dom.createDocumentFragment();
                      var el1 = dom.createComment("");
                      dom.appendChild(el0, el1);
                      return el0;
                    },
                    buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                      var morphs = new Array(1);
                      morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
                      dom.insertBoundary(fragment, 0);
                      dom.insertBoundary(fragment, null);
                      return morphs;
                    },
                    statements: [["content", "breadcrumb.label", ["loc", [null, [12, 142], [12, 162]]], 0, 0, 0, 0]],
                    locals: [],
                    templates: []
                  };
                })();
                return {
                  meta: {
                    "revision": "Ember@2.8.0",
                    "loc": {
                      "source": null,
                      "start": {
                        "line": 12,
                        "column": 73
                      },
                      "end": {
                        "line": 12,
                        "column": 179
                      }
                    },
                    "moduleName": "cornerstone/components/options/option-section/template.hbs"
                  },
                  isEmpty: false,
                  arity: 0,
                  cachedFragment: null,
                  hasRendered: false,
                  buildFragment: function buildFragment(dom) {
                    var el0 = dom.createDocumentFragment();
                    var el1 = dom.createElement("li");
                    var el2 = dom.createComment("");
                    dom.appendChild(el1, el2);
                    dom.appendChild(el0, el1);
                    return el0;
                  },
                  buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                    var morphs = new Array(1);
                    morphs[0] = dom.createMorphAt(dom.childAt(fragment, [0]), 0, 0);
                    return morphs;
                  },
                  statements: [["block", "link-to", [["get", "breadcrumb.route", ["loc", [null, [12, 109], [12, 125]]], 0, 0, 0, 0], ["get", "breadcrumb.id", ["loc", [null, [12, 126], [12, 139]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [12, 98], [12, 174]]]]],
                  locals: [],
                  templates: [child0]
                };
              })();
              var child1 = (function () {
                var child0 = (function () {
                  return {
                    meta: {
                      "revision": "Ember@2.8.0",
                      "loc": {
                        "source": null,
                        "start": {
                          "line": 12,
                          "column": 191
                        },
                        "end": {
                          "line": 12,
                          "column": 241
                        }
                      },
                      "moduleName": "cornerstone/components/options/option-section/template.hbs"
                    },
                    isEmpty: false,
                    arity: 0,
                    cachedFragment: null,
                    hasRendered: false,
                    buildFragment: function buildFragment(dom) {
                      var el0 = dom.createDocumentFragment();
                      var el1 = dom.createComment("");
                      dom.appendChild(el0, el1);
                      return el0;
                    },
                    buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                      var morphs = new Array(1);
                      morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
                      dom.insertBoundary(fragment, 0);
                      dom.insertBoundary(fragment, null);
                      return morphs;
                    },
                    statements: [["content", "breadcrumb.label", ["loc", [null, [12, 221], [12, 241]]], 0, 0, 0, 0]],
                    locals: [],
                    templates: []
                  };
                })();
                return {
                  meta: {
                    "revision": "Ember@2.8.0",
                    "loc": {
                      "source": null,
                      "start": {
                        "line": 12,
                        "column": 179
                      },
                      "end": {
                        "line": 12,
                        "column": 258
                      }
                    },
                    "moduleName": "cornerstone/components/options/option-section/template.hbs"
                  },
                  isEmpty: false,
                  arity: 0,
                  cachedFragment: null,
                  hasRendered: false,
                  buildFragment: function buildFragment(dom) {
                    var el0 = dom.createDocumentFragment();
                    var el1 = dom.createElement("li");
                    var el2 = dom.createComment("");
                    dom.appendChild(el1, el2);
                    dom.appendChild(el0, el1);
                    return el0;
                  },
                  buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                    var morphs = new Array(1);
                    morphs[0] = dom.createMorphAt(dom.childAt(fragment, [0]), 0, 0);
                    return morphs;
                  },
                  statements: [["block", "link-to", [["get", "breadcrumb.route", ["loc", [null, [12, 202], [12, 218]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [12, 191], [12, 253]]]]],
                  locals: [],
                  templates: [child0]
                };
              })();
              return {
                meta: {
                  "revision": "Ember@2.8.0",
                  "loc": {
                    "source": null,
                    "start": {
                      "line": 12,
                      "column": 49
                    },
                    "end": {
                      "line": 12,
                      "column": 265
                    }
                  },
                  "moduleName": "cornerstone/components/options/option-section/template.hbs"
                },
                isEmpty: false,
                arity: 0,
                cachedFragment: null,
                hasRendered: false,
                buildFragment: function buildFragment(dom) {
                  var el0 = dom.createDocumentFragment();
                  var el1 = dom.createComment("");
                  dom.appendChild(el0, el1);
                  return el0;
                },
                buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                  var morphs = new Array(1);
                  morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
                  dom.insertBoundary(fragment, 0);
                  dom.insertBoundary(fragment, null);
                  return morphs;
                },
                statements: [["block", "if", [["get", "breadcrumb.id", ["loc", [null, [12, 79], [12, 92]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [12, 73], [12, 265]]]]],
                locals: [],
                templates: [child0, child1]
              };
            })();
            var child1 = (function () {
              return {
                meta: {
                  "revision": "Ember@2.8.0",
                  "loc": {
                    "source": null,
                    "start": {
                      "line": 12,
                      "column": 265
                    },
                    "end": {
                      "line": 12,
                      "column": 315
                    }
                  },
                  "moduleName": "cornerstone/components/options/option-section/template.hbs"
                },
                isEmpty: false,
                arity: 0,
                cachedFragment: null,
                hasRendered: false,
                buildFragment: function buildFragment(dom) {
                  var el0 = dom.createDocumentFragment();
                  var el1 = dom.createElement("li");
                  var el2 = dom.createElement("span");
                  var el3 = dom.createComment("");
                  dom.appendChild(el2, el3);
                  dom.appendChild(el1, el2);
                  dom.appendChild(el0, el1);
                  return el0;
                },
                buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                  var morphs = new Array(1);
                  morphs[0] = dom.createMorphAt(dom.childAt(fragment, [0, 0]), 0, 0);
                  return morphs;
                },
                statements: [["content", "breadcrumb.label", ["loc", [null, [12, 283], [12, 303]]], 0, 0, 0, 0]],
                locals: [],
                templates: []
              };
            })();
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 12,
                    "column": 12
                  },
                  "end": {
                    "line": 12,
                    "column": 322
                  }
                },
                "moduleName": "cornerstone/components/options/option-section/template.hbs"
              },
              isEmpty: false,
              arity: 1,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
                dom.insertBoundary(fragment, 0);
                dom.insertBoundary(fragment, null);
                return morphs;
              },
              statements: [["block", "if", [["get", "breadcrumb.route", ["loc", [null, [12, 55], [12, 71]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [12, 49], [12, 322]]]]],
              locals: ["breadcrumb"],
              templates: [child0, child1]
            };
          })();
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 3,
                  "column": 4
                },
                "end": {
                  "line": 17,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/options/option-section/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createElement("div");
              dom.setAttribute(el1, "class", "cs-workspace-section-nav");
              var el2 = dom.createTextNode("\n");
              dom.appendChild(el1, el2);
              var el2 = dom.createComment("");
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("div");
              dom.setAttribute(el2, "class", "cs-workspace-section-nav-info");
              var el3 = dom.createTextNode("\n          ");
              dom.appendChild(el2, el3);
              var el3 = dom.createElement("ul");
              dom.setAttribute(el3, "class", "cs-workspace-section-nav-info-breadcrumbs");
              var el4 = dom.createTextNode("\n            ");
              dom.appendChild(el3, el4);
              var el4 = dom.createComment("");
              dom.appendChild(el3, el4);
              var el4 = dom.createTextNode("\n          ");
              dom.appendChild(el3, el4);
              dom.appendChild(el2, el3);
              var el3 = dom.createTextNode("\n          ");
              dom.appendChild(el2, el3);
              var el3 = dom.createElement("h3");
              dom.setAttribute(el3, "class", "cs-workspace-section-nav-info-title");
              var el4 = dom.createComment("");
              dom.appendChild(el3, el4);
              dom.appendChild(el2, el3);
              var el3 = dom.createTextNode("\n        ");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n      ");
              dom.appendChild(el1, el2);
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var element0 = dom.childAt(fragment, [1]);
              var element1 = dom.childAt(element0, [3]);
              var morphs = new Array(3);
              morphs[0] = dom.createMorphAt(element0, 1, 1);
              morphs[1] = dom.createMorphAt(dom.childAt(element1, [1]), 1, 1);
              morphs[2] = dom.createUnsafeMorphAt(dom.childAt(element1, [3]), 0, 0);
              return morphs;
            },
            statements: [["block", "if", [["get", "backUp.id", ["loc", [null, [5, 14], [5, 23]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [5, 8], [9, 15]]]], ["block", "each", [["get", "breadcrumbs", ["loc", [null, [12, 20], [12, 31]]], 0, 0, 0, 0]], [], 2, null, ["loc", [null, [12, 12], [12, 331]]]], ["content", "title", ["loc", [null, [14, 58], [14, 69]]], 0, 0, 0, 0]],
            locals: [],
            templates: [child0, child1, child2]
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 2,
                "column": 2
              },
              "end": {
                "line": 18,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/options/option-section/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
            dom.insertBoundary(fragment, 0);
            dom.insertBoundary(fragment, null);
            return morphs;
          },
          statements: [["block", "workspace/workspace-header", [], [], 0, null, ["loc", [null, [3, 4], [17, 35]]]]],
          locals: [],
          templates: [child0]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 19,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/options/option-section/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "if", [["get", "section.panel", ["loc", [null, [2, 8], [2, 21]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [2, 2], [18, 9]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    var child1 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 22,
                "column": 2
              },
              "end": {
                "line": 24,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/options/option-section/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("    ");
            dom.appendChild(el0, el1);
            var el1 = dom.createElement("h4");
            dom.setAttribute(el1, "class", "cs-workspace-section-sub-heading");
            var el2 = dom.createComment("");
            dom.appendChild(el1, el2);
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createUnsafeMorphAt(dom.childAt(fragment, [1]), 0, 0);
            return morphs;
          },
          statements: [["content", "title", ["loc", [null, [23, 49], [23, 60]]], 0, 0, 0, 0]],
          locals: [],
          templates: []
        };
      })();
      var child1 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 26,
                "column": 2
              },
              "end": {
                "line": 28,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/options/option-section/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("    ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            return morphs;
          },
          statements: [["inline", "component", [["get", "descriptionComponentPath", ["loc", [null, [27, 16], [27, 40]]], 0, 0, 0, 0]], [], ["loc", [null, [27, 4], [27, 42]]], 0, 0]],
          locals: [],
          templates: []
        };
      })();
      var child2 = (function () {
        var child0 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 29,
                  "column": 4
                },
                "end": {
                  "line": 31,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/options/option-section/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createElement("p");
              dom.setAttribute(el1, "class", "cs-workspace-section-description");
              var el2 = dom.createElement("span");
              var el3 = dom.createTextNode("Info:");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createComment("");
              dom.appendChild(el1, el2);
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createUnsafeMorphAt(dom.childAt(fragment, [1]), 1, 1);
              return morphs;
            },
            statements: [["content", "description", ["loc", [null, [30, 68], [30, 85]]], 0, 0, 0, 0]],
            locals: [],
            templates: []
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 28,
                "column": 2
              },
              "end": {
                "line": 32,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/options/option-section/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
            dom.insertBoundary(fragment, 0);
            dom.insertBoundary(fragment, null);
            return morphs;
          },
          statements: [["block", "if", [["get", "description", ["loc", [null, [29, 10], [29, 21]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [29, 4], [31, 11]]]]],
          locals: [],
          templates: [child0]
        };
      })();
      var child3 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 34,
                "column": 2
              },
              "end": {
                "line": 36,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/options/option-section/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("    ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            return morphs;
          },
          statements: [["inline", "common/control-list", [], ["controls", ["subexpr", "@mut", [["get", "section.controls", ["loc", [null, [35, 35], [35, 51]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [35, 4], [35, 53]]], 0, 0]],
          locals: [],
          templates: []
        };
      })();
      var child4 = (function () {
        var child0 = (function () {
          var child0 = (function () {
            var child0 = (function () {
              return {
                meta: {
                  "revision": "Ember@2.8.0",
                  "loc": {
                    "source": null,
                    "start": {
                      "line": 42,
                      "column": 8
                    },
                    "end": {
                      "line": 44,
                      "column": 8
                    }
                  },
                  "moduleName": "cornerstone/components/options/option-section/template.hbs"
                },
                isEmpty: false,
                arity: 0,
                cachedFragment: null,
                hasRendered: false,
                buildFragment: function buildFragment(dom) {
                  var el0 = dom.createDocumentFragment();
                  var el1 = dom.createTextNode("          ");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createComment("");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createTextNode("\n");
                  dom.appendChild(el0, el1);
                  return el0;
                },
                buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                  var morphs = new Array(1);
                  morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                  return morphs;
                },
                statements: [["content", "child.title", ["loc", [null, [43, 10], [43, 25]]], 0, 0, 0, 0]],
                locals: [],
                templates: []
              };
            })();
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 41,
                    "column": 6
                  },
                  "end": {
                    "line": 45,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/options/option-section/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
                dom.insertBoundary(fragment, 0);
                dom.insertBoundary(fragment, null);
                return morphs;
              },
              statements: [["block", "link-to", ["options.section", ["get", "child.id", ["loc", [null, [42, 37], [42, 45]]], 0, 0, 0, 0]], ["class", "cs-workspace-section-goto"], 0, null, ["loc", [null, [42, 8], [44, 20]]]]],
              locals: [],
              templates: [child0]
            };
          })();
          var child1 = (function () {
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 45,
                    "column": 6
                  },
                  "end": {
                    "line": 47,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/options/option-section/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                return morphs;
              },
              statements: [["inline", "options/option-section", [], ["section", ["subexpr", "@mut", [["get", "child", ["loc", [null, [46, 41], [46, 46]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [46, 8], [46, 48]]], 0, 0]],
              locals: [],
              templates: []
            };
          })();
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 40,
                  "column": 4
                },
                "end": {
                  "line": 48,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/options/option-section/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
              dom.insertBoundary(fragment, 0);
              dom.insertBoundary(fragment, null);
              return morphs;
            },
            statements: [["block", "if", [["get", "child.panel", ["loc", [null, [41, 12], [41, 23]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [41, 6], [47, 13]]]]],
            locals: [],
            templates: [child0, child1]
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 39,
                "column": 2
              },
              "end": {
                "line": 49,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/options/option-section/template.hbs"
          },
          isEmpty: false,
          arity: 1,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
            dom.insertBoundary(fragment, 0);
            dom.insertBoundary(fragment, null);
            return morphs;
          },
          statements: [["block", "unless", [["get", "child.isHidden", ["loc", [null, [40, 14], [40, 28]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [40, 4], [48, 15]]]]],
          locals: ["child"],
          templates: [child0]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 20,
              "column": 0
            },
            "end": {
              "line": 51,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/options/option-section/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(4);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
          morphs[2] = dom.createMorphAt(fragment, 5, 5, contextualElement);
          morphs[3] = dom.createMorphAt(fragment, 7, 7, contextualElement);
          return morphs;
        },
        statements: [["block", "unless", [["get", "section.panel", ["loc", [null, [22, 12], [22, 25]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [22, 2], [24, 13]]]], ["block", "if", [["get", "descriptionComponentPath", ["loc", [null, [26, 8], [26, 32]]], 0, 0, 0, 0]], [], 1, 2, ["loc", [null, [26, 2], [32, 9]]]], ["block", "if", [["get", "section.controls", ["loc", [null, [34, 8], [34, 24]]], 0, 0, 0, 0]], [], 3, null, ["loc", [null, [34, 2], [36, 9]]]], ["block", "each", [["get", "section.children", ["loc", [null, [39, 10], [39, 26]]], 0, 0, 0, 0]], [], 4, null, ["loc", [null, [39, 2], [49, 11]]]]],
        locals: [],
        templates: [child0, child1, child2, child3, child4]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 52,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/options/option-section/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(2);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 1, 1, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["block", "unless", [["get", "isRoot", ["loc", [null, [1, 10], [1, 16]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [1, 0], [19, 11]]]], ["block", "component", [["subexpr", "if", [["get", "section.panel", ["loc", [null, [20, 17], [20, 30]]], 0, 0, 0, 0], "workspace/workspace-content", "common/scroll-box"], [], ["loc", [null, [20, 13], [20, 81]]], 0, 0]], ["enabled", ["subexpr", "@mut", [["get", "section.panel", ["loc", [null, [20, 90], [20, 103]]], 0, 0, 0, 0]], [], [], 0, 0], "scrollTo", ["subexpr", "@mut", [["get", "scrollTo", ["loc", [null, [20, 113], [20, 121]]], 0, 0, 0, 0]], [], [], 0, 0]], 1, null, ["loc", [null, [20, 0], [51, 14]]]]],
      locals: [],
      templates: [child0, child1]
    };
  })());
});
define('cornerstone/components/preview/bar-module/component', ['exports', 'ember', 'npm:in-view'], function (exports, _ember, _npmInView) {
  exports['default'] = _ember['default'].Component.extend({

    preview: _ember['default'].inject.service('preview'),
    radio: _ember['default'].inject.service('global/radio'),

    observer: _ember['default'].computed('model.title', function () {
      return JSON.stringify({
        title: this.get('model.title'),
        mode: 'inspect',
        action: { type: 'inspect', id: this.get('model.id') }
      });
    }),

    onInit: _ember['default'].on('init', function () {
      this.set('remoteQuery', this.get('remoteQuery').bind(this));
      this.get('radio').on('element:remote:query', this.get('remoteQuery'));
    }),

    remoteQuery: function remoteQuery(data) {
      if (this.get('model.id') !== data.element) {
        return;
      }

      if (data.type.includes('observer:')) {
        this.get('radio').trigger('preview:' + data.type, this.get('element'));
      }
    },

    renderService: _ember['default'].inject.service('preview/bar-modules'),

    didInsertElement: function didInsertElement() {

      if (this.get('model.id') === this.get('preview.scrollToNewElement')) {

        if (!_npmInView['default'].is(this.get('element'))) {
          this.get('preview').scrollToElement(this.get('element'));
        }

        this.set('preview.scrollToNewElement', null);
      }

      if (_ember['default'].$('style#bar-module-' + this.get('model.id')).length <= 0) {
        this.updateStyle();
      }

      _ember['default'].$(document.body).trigger('cs-preview', {
        type: this.get('model.atts._type'),
        id: this.get('model.id')
      });
    },

    didRender: function didRender() {
      var _this = this;

      this.$('[data-x-toggle]').on('click', function () {
        _this.$().trigger('click');
      });

      this.$('a[href]').on('click', function (e) {
        e.preventDefault();
      });
    },

    observeMarkupUpdate: _ember['default'].observer('model.updateMarkup', 'model.updateAll', function () {
      _ember['default'].run.debounce(this, this.updateMarkup, 115);
    }),

    observeStyleUpdate: _ember['default'].observer('model.updateStyle', 'model.updateAll', function () {
      _ember['default'].run.debounce(this, this.updateStyle, 15);
    }),

    updateMarkup: function updateMarkup() {
      this.get('renderService').updateMarkup(this.get('model'));
    },

    updateStyle: function updateStyle() {
      var _this2 = this;

      var templateFunction = this.get('model.definition.styleTemplate');
      if (!templateFunction) {
        return;
      }

      _ember['default'].run.scheduleOnce('afterRender', function () {

        _ember['default'].$('style#bar-module-' + _this2.get('model.id')).remove();
        var data = _this2.get('model').getCleanAtts();
        var classPrefix = 'footer' === data._region ? 'fm' : 'hm';
        var css = templateFunction(data, classPrefix);
        var $style = _ember['default'].$('<style id="bar-module-' + _this2.get('model.id') + '">' + css + '</style>');

        // TODO: This selector should be passed through a config somehow
        _ember['default'].$('style#x-generated-css').after($style);
      });
    },

    willDestroyElement: function willDestroyElement() {
      this.get('radio').off('element:remote:query', this.get('remoteQuery'));
      _ember['default'].$('style#bar-module-' + this.get('model.id')).remove();
    }

  });
});
define("cornerstone/components/preview/bar-module/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 1,
            "column": 59
          }
        },
        "moduleName": "cornerstone/components/preview/bar-module/template.hbs"
      },
      isEmpty: true,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        return el0;
      },
      buildRenderNodes: function buildRenderNodes() {
        return [];
      },
      statements: [],
      locals: [],
      templates: []
    };
  })());
});
define('cornerstone/components/preview/bar-region/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    tagName: '',
    renderService: _ember['default'].inject.service('preview/bar-modules')
  });
});
define("cornerstone/components/preview/bar-region/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 9,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/preview/bar-region/template.hbs"
        },
        isEmpty: false,
        arity: 1,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "component", [["subexpr", "dynamic-bar-module", [["subexpr", "bar-module-markup", [["subexpr", "get", [["get", "renderService.cache", ["loc", [null, [5, 30], [5, 49]]], 0, 0, 0, 0], ["subexpr", "concat", ["markup-", ["get", "bar.id", ["loc", [null, [5, 68], [5, 74]]], 0, 0, 0, 0]], [], ["loc", [null, [5, 50], [5, 75]]], 0, 0]], [], ["loc", [null, [5, 25], [5, 77]]], 0, 0], ["get", "bar", ["loc", [null, [5, 78], [5, 81]]], 0, 0, 0, 0]], [], ["loc", [null, [5, 6], [5, 83]]], 0, 0]], ["model", ["get", "bar", ["loc", [null, [6, 12], [6, 15]]], 0, 0, 0, 0]], ["loc", [null, [4, 4], [7, 5]]], 0, 0]], [], ["loc", [null, [3, 2], [8, 4]]], 0, 0]],
        locals: ["bar"],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
         